/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.Compute;
import com.oracle.bmc.core.ComputePaginators;
import com.oracle.bmc.core.ComputeWaiters;
import com.oracle.bmc.core.internal.http.AttachBootVolumeConverter;
import com.oracle.bmc.core.internal.http.AttachVnicConverter;
import com.oracle.bmc.core.internal.http.AttachVolumeConverter;
import com.oracle.bmc.core.internal.http.CaptureConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.ChangeDedicatedVmHostCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeImageCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInstanceCompartmentConverter;
import com.oracle.bmc.core.internal.http.CreateAppCatalogSubscriptionConverter;
import com.oracle.bmc.core.internal.http.CreateDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.CreateImageConverter;
import com.oracle.bmc.core.internal.http.CreateInstanceConsoleConnectionConverter;
import com.oracle.bmc.core.internal.http.DeleteAppCatalogSubscriptionConverter;
import com.oracle.bmc.core.internal.http.DeleteConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.DeleteDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.DeleteImageConverter;
import com.oracle.bmc.core.internal.http.DeleteInstanceConsoleConnectionConverter;
import com.oracle.bmc.core.internal.http.DetachBootVolumeConverter;
import com.oracle.bmc.core.internal.http.DetachVnicConverter;
import com.oracle.bmc.core.internal.http.DetachVolumeConverter;
import com.oracle.bmc.core.internal.http.ExportImageConverter;
import com.oracle.bmc.core.internal.http.GetAppCatalogListingAgreementsConverter;
import com.oracle.bmc.core.internal.http.GetAppCatalogListingConverter;
import com.oracle.bmc.core.internal.http.GetAppCatalogListingResourceVersionConverter;
import com.oracle.bmc.core.internal.http.GetBootVolumeAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetConsoleHistoryContentConverter;
import com.oracle.bmc.core.internal.http.GetConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.GetDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.GetImageConverter;
import com.oracle.bmc.core.internal.http.GetInstanceConsoleConnectionConverter;
import com.oracle.bmc.core.internal.http.GetInstanceConverter;
import com.oracle.bmc.core.internal.http.GetVnicAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetVolumeAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetWindowsInstanceInitialCredentialsConverter;
import com.oracle.bmc.core.internal.http.InstanceActionConverter;
import com.oracle.bmc.core.internal.http.LaunchInstanceConverter;
import com.oracle.bmc.core.internal.http.ListAppCatalogListingResourceVersionsConverter;
import com.oracle.bmc.core.internal.http.ListAppCatalogListingsConverter;
import com.oracle.bmc.core.internal.http.ListAppCatalogSubscriptionsConverter;
import com.oracle.bmc.core.internal.http.ListBootVolumeAttachmentsConverter;
import com.oracle.bmc.core.internal.http.ListConsoleHistoriesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostInstanceShapesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostInstancesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostShapesConverter;
import com.oracle.bmc.core.internal.http.ListDedicatedVmHostsConverter;
import com.oracle.bmc.core.internal.http.ListImagesConverter;
import com.oracle.bmc.core.internal.http.ListInstanceConsoleConnectionsConverter;
import com.oracle.bmc.core.internal.http.ListInstanceDevicesConverter;
import com.oracle.bmc.core.internal.http.ListInstancesConverter;
import com.oracle.bmc.core.internal.http.ListShapesConverter;
import com.oracle.bmc.core.internal.http.ListVnicAttachmentsConverter;
import com.oracle.bmc.core.internal.http.ListVolumeAttachmentsConverter;
import com.oracle.bmc.core.internal.http.TerminateInstanceConverter;
import com.oracle.bmc.core.internal.http.UpdateConsoleHistoryConverter;
import com.oracle.bmc.core.internal.http.UpdateDedicatedVmHostConverter;
import com.oracle.bmc.core.internal.http.UpdateImageConverter;
import com.oracle.bmc.core.internal.http.UpdateInstanceConverter;
import com.oracle.bmc.core.requests.AttachBootVolumeRequest;
import com.oracle.bmc.core.requests.AttachVnicRequest;
import com.oracle.bmc.core.requests.AttachVolumeRequest;
import com.oracle.bmc.core.requests.CaptureConsoleHistoryRequest;
import com.oracle.bmc.core.requests.ChangeDedicatedVmHostCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeImageCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceCompartmentRequest;
import com.oracle.bmc.core.requests.CreateAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.CreateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.CreateImageRequest;
import com.oracle.bmc.core.requests.CreateInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DeleteAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.DeleteConsoleHistoryRequest;
import com.oracle.bmc.core.requests.DeleteDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.DeleteImageRequest;
import com.oracle.bmc.core.requests.DeleteInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DetachBootVolumeRequest;
import com.oracle.bmc.core.requests.DetachVnicRequest;
import com.oracle.bmc.core.requests.DetachVolumeRequest;
import com.oracle.bmc.core.requests.ExportImageRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingAgreementsRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingResourceVersionRequest;
import com.oracle.bmc.core.requests.GetBootVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryContentRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryRequest;
import com.oracle.bmc.core.requests.GetDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.GetImageRequest;
import com.oracle.bmc.core.requests.GetInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.GetInstanceRequest;
import com.oracle.bmc.core.requests.GetVnicAttachmentRequest;
import com.oracle.bmc.core.requests.GetVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetWindowsInstanceInitialCredentialsRequest;
import com.oracle.bmc.core.requests.InstanceActionRequest;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingResourceVersionsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogSubscriptionsRequest;
import com.oracle.bmc.core.requests.ListBootVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.ListConsoleHistoriesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstanceShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstancesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostsRequest;
import com.oracle.bmc.core.requests.ListImagesRequest;
import com.oracle.bmc.core.requests.ListInstanceConsoleConnectionsRequest;
import com.oracle.bmc.core.requests.ListInstanceDevicesRequest;
import com.oracle.bmc.core.requests.ListInstancesRequest;
import com.oracle.bmc.core.requests.ListShapesRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.core.requests.ListVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.TerminateInstanceRequest;
import com.oracle.bmc.core.requests.UpdateConsoleHistoryRequest;
import com.oracle.bmc.core.requests.UpdateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.UpdateImageRequest;
import com.oracle.bmc.core.requests.UpdateInstanceRequest;
import com.oracle.bmc.core.responses.AttachBootVolumeResponse;
import com.oracle.bmc.core.responses.AttachVnicResponse;
import com.oracle.bmc.core.responses.AttachVolumeResponse;
import com.oracle.bmc.core.responses.CaptureConsoleHistoryResponse;
import com.oracle.bmc.core.responses.ChangeDedicatedVmHostCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeImageCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceCompartmentResponse;
import com.oracle.bmc.core.responses.CreateAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.CreateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.CreateImageResponse;
import com.oracle.bmc.core.responses.CreateInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DeleteAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.DeleteConsoleHistoryResponse;
import com.oracle.bmc.core.responses.DeleteDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.DeleteImageResponse;
import com.oracle.bmc.core.responses.DeleteInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DetachBootVolumeResponse;
import com.oracle.bmc.core.responses.DetachVnicResponse;
import com.oracle.bmc.core.responses.DetachVolumeResponse;
import com.oracle.bmc.core.responses.ExportImageResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingAgreementsResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResourceVersionResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResponse;
import com.oracle.bmc.core.responses.GetBootVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryContentResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryResponse;
import com.oracle.bmc.core.responses.GetDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.GetImageResponse;
import com.oracle.bmc.core.responses.GetInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.GetInstanceResponse;
import com.oracle.bmc.core.responses.GetVnicAttachmentResponse;
import com.oracle.bmc.core.responses.GetVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetWindowsInstanceInitialCredentialsResponse;
import com.oracle.bmc.core.responses.InstanceActionResponse;
import com.oracle.bmc.core.responses.LaunchInstanceResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingResourceVersionsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogSubscriptionsResponse;
import com.oracle.bmc.core.responses.ListBootVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.ListConsoleHistoriesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstanceShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstancesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostsResponse;
import com.oracle.bmc.core.responses.ListImagesResponse;
import com.oracle.bmc.core.responses.ListInstanceConsoleConnectionsResponse;
import com.oracle.bmc.core.responses.ListInstanceDevicesResponse;
import com.oracle.bmc.core.responses.ListInstancesResponse;
import com.oracle.bmc.core.responses.ListShapesResponse;
import com.oracle.bmc.core.responses.ListVnicAttachmentsResponse;
import com.oracle.bmc.core.responses.ListVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.TerminateInstanceResponse;
import com.oracle.bmc.core.responses.UpdateConsoleHistoryResponse;
import com.oracle.bmc.core.responses.UpdateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.UpdateImageResponse;
import com.oracle.bmc.core.responses.UpdateInstanceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.workrequests.WorkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeClient
implements Compute {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTE").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ComputeWaiters waiters;
    private final ComputePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ExecutorService executorService;
    private final RetryConfiguration retryConfiguration;

    public ComputeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ComputeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ComputeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Compute-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new ComputeWaiters(executorService, this);
        this.paginators = new ComputePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AttachBootVolumeResponse attachBootVolume(AttachBootVolumeRequest request) {
        LOG.trace("Called attachBootVolume");
        AttachBootVolumeRequest interceptedRequest = AttachBootVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachBootVolumeResponse> transformer = AttachBootVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getAttachBootVolumeDetails(), retriedRequest);
                return (AttachBootVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AttachVnicResponse attachVnic(AttachVnicRequest request) {
        LOG.trace("Called attachVnic");
        AttachVnicRequest interceptedRequest = AttachVnicConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachVnicConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachVnicResponse> transformer = AttachVnicConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getAttachVnicDetails(), retriedRequest);
                return (AttachVnicResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AttachVolumeResponse attachVolume(AttachVolumeRequest request) {
        LOG.trace("Called attachVolume");
        AttachVolumeRequest interceptedRequest = AttachVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachVolumeResponse> transformer = AttachVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getAttachVolumeDetails(), retriedRequest);
                return (AttachVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CaptureConsoleHistoryResponse captureConsoleHistory(CaptureConsoleHistoryRequest request) {
        LOG.trace("Called captureConsoleHistory");
        CaptureConsoleHistoryRequest interceptedRequest = CaptureConsoleHistoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CaptureConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CaptureConsoleHistoryResponse> transformer = CaptureConsoleHistoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCaptureConsoleHistoryDetails(), retriedRequest);
                return (CaptureConsoleHistoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeDedicatedVmHostCompartmentResponse changeDedicatedVmHostCompartment(ChangeDedicatedVmHostCompartmentRequest request) {
        LOG.trace("Called changeDedicatedVmHostCompartment");
        ChangeDedicatedVmHostCompartmentRequest interceptedRequest = ChangeDedicatedVmHostCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDedicatedVmHostCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDedicatedVmHostCompartmentResponse> transformer = ChangeDedicatedVmHostCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeDedicatedVmHostCompartmentDetails(), retriedRequest);
                return (ChangeDedicatedVmHostCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeImageCompartmentResponse changeImageCompartment(ChangeImageCompartmentRequest request) {
        LOG.trace("Called changeImageCompartment");
        ChangeImageCompartmentRequest interceptedRequest = ChangeImageCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeImageCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeImageCompartmentResponse> transformer = ChangeImageCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeImageCompartmentDetails(), retriedRequest);
                return (ChangeImageCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeInstanceCompartmentResponse changeInstanceCompartment(ChangeInstanceCompartmentRequest request) {
        LOG.trace("Called changeInstanceCompartment");
        ChangeInstanceCompartmentRequest interceptedRequest = ChangeInstanceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeInstanceCompartmentResponse> transformer = ChangeInstanceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeInstanceCompartmentDetails(), retriedRequest);
                return (ChangeInstanceCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAppCatalogSubscriptionResponse createAppCatalogSubscription(CreateAppCatalogSubscriptionRequest request) {
        LOG.trace("Called createAppCatalogSubscription");
        CreateAppCatalogSubscriptionRequest interceptedRequest = CreateAppCatalogSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAppCatalogSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAppCatalogSubscriptionResponse> transformer = CreateAppCatalogSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAppCatalogSubscriptionDetails(), retriedRequest);
                return (CreateAppCatalogSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDedicatedVmHostResponse createDedicatedVmHost(CreateDedicatedVmHostRequest request) {
        LOG.trace("Called createDedicatedVmHost");
        CreateDedicatedVmHostRequest interceptedRequest = CreateDedicatedVmHostConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDedicatedVmHostResponse> transformer = CreateDedicatedVmHostConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateDedicatedVmHostDetails(), retriedRequest);
                return (CreateDedicatedVmHostResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateImageResponse createImage(CreateImageRequest request) {
        LOG.trace("Called createImage");
        CreateImageRequest interceptedRequest = CreateImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateImageResponse> transformer = CreateImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateImageDetails(), retriedRequest);
                return (CreateImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateInstanceConsoleConnectionResponse createInstanceConsoleConnection(CreateInstanceConsoleConnectionRequest request) {
        LOG.trace("Called createInstanceConsoleConnection");
        CreateInstanceConsoleConnectionRequest interceptedRequest = CreateInstanceConsoleConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateInstanceConsoleConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateInstanceConsoleConnectionResponse> transformer = CreateInstanceConsoleConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateInstanceConsoleConnectionDetails(), retriedRequest);
                return (CreateInstanceConsoleConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAppCatalogSubscriptionResponse deleteAppCatalogSubscription(DeleteAppCatalogSubscriptionRequest request) {
        LOG.trace("Called deleteAppCatalogSubscription");
        DeleteAppCatalogSubscriptionRequest interceptedRequest = DeleteAppCatalogSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAppCatalogSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAppCatalogSubscriptionResponse> transformer = DeleteAppCatalogSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteAppCatalogSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteConsoleHistoryResponse deleteConsoleHistory(DeleteConsoleHistoryRequest request) {
        LOG.trace("Called deleteConsoleHistory");
        DeleteConsoleHistoryRequest interceptedRequest = DeleteConsoleHistoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConsoleHistoryResponse> transformer = DeleteConsoleHistoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteConsoleHistoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDedicatedVmHostResponse deleteDedicatedVmHost(DeleteDedicatedVmHostRequest request) {
        LOG.trace("Called deleteDedicatedVmHost");
        DeleteDedicatedVmHostRequest interceptedRequest = DeleteDedicatedVmHostConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDedicatedVmHostResponse> transformer = DeleteDedicatedVmHostConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteDedicatedVmHostResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteImageResponse deleteImage(DeleteImageRequest request) {
        LOG.trace("Called deleteImage");
        DeleteImageRequest interceptedRequest = DeleteImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteImageResponse> transformer = DeleteImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteInstanceConsoleConnectionResponse deleteInstanceConsoleConnection(DeleteInstanceConsoleConnectionRequest request) {
        LOG.trace("Called deleteInstanceConsoleConnection");
        DeleteInstanceConsoleConnectionRequest interceptedRequest = DeleteInstanceConsoleConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteInstanceConsoleConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteInstanceConsoleConnectionResponse> transformer = DeleteInstanceConsoleConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteInstanceConsoleConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetachBootVolumeResponse detachBootVolume(DetachBootVolumeRequest request) {
        LOG.trace("Called detachBootVolume");
        DetachBootVolumeRequest interceptedRequest = DetachBootVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachBootVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachBootVolumeResponse> transformer = DetachBootVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DetachBootVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetachVnicResponse detachVnic(DetachVnicRequest request) {
        LOG.trace("Called detachVnic");
        DetachVnicRequest interceptedRequest = DetachVnicConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachVnicConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachVnicResponse> transformer = DetachVnicConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DetachVnicResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetachVolumeResponse detachVolume(DetachVolumeRequest request) {
        LOG.trace("Called detachVolume");
        DetachVolumeRequest interceptedRequest = DetachVolumeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachVolumeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachVolumeResponse> transformer = DetachVolumeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DetachVolumeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ExportImageResponse exportImage(ExportImageRequest request) {
        LOG.trace("Called exportImage");
        ExportImageRequest interceptedRequest = ExportImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ExportImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ExportImageResponse> transformer = ExportImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getExportImageDetails(), retriedRequest);
                return (ExportImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAppCatalogListingResponse getAppCatalogListing(GetAppCatalogListingRequest request) {
        LOG.trace("Called getAppCatalogListing");
        GetAppCatalogListingRequest interceptedRequest = GetAppCatalogListingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAppCatalogListingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAppCatalogListingResponse> transformer = GetAppCatalogListingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAppCatalogListingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAppCatalogListingAgreementsResponse getAppCatalogListingAgreements(GetAppCatalogListingAgreementsRequest request) {
        LOG.trace("Called getAppCatalogListingAgreements");
        GetAppCatalogListingAgreementsRequest interceptedRequest = GetAppCatalogListingAgreementsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAppCatalogListingAgreementsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAppCatalogListingAgreementsResponse> transformer = GetAppCatalogListingAgreementsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAppCatalogListingAgreementsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAppCatalogListingResourceVersionResponse getAppCatalogListingResourceVersion(GetAppCatalogListingResourceVersionRequest request) {
        LOG.trace("Called getAppCatalogListingResourceVersion");
        GetAppCatalogListingResourceVersionRequest interceptedRequest = GetAppCatalogListingResourceVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAppCatalogListingResourceVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAppCatalogListingResourceVersionResponse> transformer = GetAppCatalogListingResourceVersionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAppCatalogListingResourceVersionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBootVolumeAttachmentResponse getBootVolumeAttachment(GetBootVolumeAttachmentRequest request) {
        LOG.trace("Called getBootVolumeAttachment");
        GetBootVolumeAttachmentRequest interceptedRequest = GetBootVolumeAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBootVolumeAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBootVolumeAttachmentResponse> transformer = GetBootVolumeAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetBootVolumeAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConsoleHistoryResponse getConsoleHistory(GetConsoleHistoryRequest request) {
        LOG.trace("Called getConsoleHistory");
        GetConsoleHistoryRequest interceptedRequest = GetConsoleHistoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConsoleHistoryResponse> transformer = GetConsoleHistoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetConsoleHistoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConsoleHistoryContentResponse getConsoleHistoryContent(GetConsoleHistoryContentRequest request) {
        LOG.trace("Called getConsoleHistoryContent");
        GetConsoleHistoryContentRequest interceptedRequest = GetConsoleHistoryContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConsoleHistoryContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConsoleHistoryContentResponse> transformer = GetConsoleHistoryContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetConsoleHistoryContentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDedicatedVmHostResponse getDedicatedVmHost(GetDedicatedVmHostRequest request) {
        LOG.trace("Called getDedicatedVmHost");
        GetDedicatedVmHostRequest interceptedRequest = GetDedicatedVmHostConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDedicatedVmHostResponse> transformer = GetDedicatedVmHostConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDedicatedVmHostResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetImageResponse getImage(GetImageRequest request) {
        LOG.trace("Called getImage");
        GetImageRequest interceptedRequest = GetImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetImageResponse> transformer = GetImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInstanceResponse getInstance(GetInstanceRequest request) {
        LOG.trace("Called getInstance");
        GetInstanceRequest interceptedRequest = GetInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstanceResponse> transformer = GetInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInstanceConsoleConnectionResponse getInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request) {
        LOG.trace("Called getInstanceConsoleConnection");
        GetInstanceConsoleConnectionRequest interceptedRequest = GetInstanceConsoleConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstanceConsoleConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstanceConsoleConnectionResponse> transformer = GetInstanceConsoleConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetInstanceConsoleConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVnicAttachmentResponse getVnicAttachment(GetVnicAttachmentRequest request) {
        LOG.trace("Called getVnicAttachment");
        GetVnicAttachmentRequest interceptedRequest = GetVnicAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVnicAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVnicAttachmentResponse> transformer = GetVnicAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVnicAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVolumeAttachmentResponse getVolumeAttachment(GetVolumeAttachmentRequest request) {
        LOG.trace("Called getVolumeAttachment");
        GetVolumeAttachmentRequest interceptedRequest = GetVolumeAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVolumeAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVolumeAttachmentResponse> transformer = GetVolumeAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVolumeAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWindowsInstanceInitialCredentialsResponse getWindowsInstanceInitialCredentials(GetWindowsInstanceInitialCredentialsRequest request) {
        LOG.trace("Called getWindowsInstanceInitialCredentials");
        GetWindowsInstanceInitialCredentialsRequest interceptedRequest = GetWindowsInstanceInitialCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWindowsInstanceInitialCredentialsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWindowsInstanceInitialCredentialsResponse> transformer = GetWindowsInstanceInitialCredentialsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetWindowsInstanceInitialCredentialsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public InstanceActionResponse instanceAction(InstanceActionRequest request) {
        LOG.trace("Called instanceAction");
        InstanceActionRequest interceptedRequest = InstanceActionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstanceActionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstanceActionResponse> transformer = InstanceActionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (InstanceActionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public LaunchInstanceResponse launchInstance(LaunchInstanceRequest request) {
        LOG.trace("Called launchInstance");
        LaunchInstanceRequest interceptedRequest = LaunchInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = LaunchInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, LaunchInstanceResponse> transformer = LaunchInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getLaunchInstanceDetails(), retriedRequest);
                return (LaunchInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAppCatalogListingResourceVersionsResponse listAppCatalogListingResourceVersions(ListAppCatalogListingResourceVersionsRequest request) {
        LOG.trace("Called listAppCatalogListingResourceVersions");
        ListAppCatalogListingResourceVersionsRequest interceptedRequest = ListAppCatalogListingResourceVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAppCatalogListingResourceVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAppCatalogListingResourceVersionsResponse> transformer = ListAppCatalogListingResourceVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAppCatalogListingResourceVersionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAppCatalogListingsResponse listAppCatalogListings(ListAppCatalogListingsRequest request) {
        LOG.trace("Called listAppCatalogListings");
        ListAppCatalogListingsRequest interceptedRequest = ListAppCatalogListingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAppCatalogListingsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAppCatalogListingsResponse> transformer = ListAppCatalogListingsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAppCatalogListingsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAppCatalogSubscriptionsResponse listAppCatalogSubscriptions(ListAppCatalogSubscriptionsRequest request) {
        LOG.trace("Called listAppCatalogSubscriptions");
        ListAppCatalogSubscriptionsRequest interceptedRequest = ListAppCatalogSubscriptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAppCatalogSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAppCatalogSubscriptionsResponse> transformer = ListAppCatalogSubscriptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAppCatalogSubscriptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBootVolumeAttachmentsResponse listBootVolumeAttachments(ListBootVolumeAttachmentsRequest request) {
        LOG.trace("Called listBootVolumeAttachments");
        ListBootVolumeAttachmentsRequest interceptedRequest = ListBootVolumeAttachmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBootVolumeAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBootVolumeAttachmentsResponse> transformer = ListBootVolumeAttachmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListBootVolumeAttachmentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConsoleHistoriesResponse listConsoleHistories(ListConsoleHistoriesRequest request) {
        LOG.trace("Called listConsoleHistories");
        ListConsoleHistoriesRequest interceptedRequest = ListConsoleHistoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConsoleHistoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConsoleHistoriesResponse> transformer = ListConsoleHistoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListConsoleHistoriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDedicatedVmHostInstanceShapesResponse listDedicatedVmHostInstanceShapes(ListDedicatedVmHostInstanceShapesRequest request) {
        LOG.trace("Called listDedicatedVmHostInstanceShapes");
        ListDedicatedVmHostInstanceShapesRequest interceptedRequest = ListDedicatedVmHostInstanceShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDedicatedVmHostInstanceShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDedicatedVmHostInstanceShapesResponse> transformer = ListDedicatedVmHostInstanceShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDedicatedVmHostInstanceShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDedicatedVmHostInstancesResponse listDedicatedVmHostInstances(ListDedicatedVmHostInstancesRequest request) {
        LOG.trace("Called listDedicatedVmHostInstances");
        ListDedicatedVmHostInstancesRequest interceptedRequest = ListDedicatedVmHostInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDedicatedVmHostInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDedicatedVmHostInstancesResponse> transformer = ListDedicatedVmHostInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDedicatedVmHostInstancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDedicatedVmHostShapesResponse listDedicatedVmHostShapes(ListDedicatedVmHostShapesRequest request) {
        LOG.trace("Called listDedicatedVmHostShapes");
        ListDedicatedVmHostShapesRequest interceptedRequest = ListDedicatedVmHostShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDedicatedVmHostShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDedicatedVmHostShapesResponse> transformer = ListDedicatedVmHostShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDedicatedVmHostShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDedicatedVmHostsResponse listDedicatedVmHosts(ListDedicatedVmHostsRequest request) {
        LOG.trace("Called listDedicatedVmHosts");
        ListDedicatedVmHostsRequest interceptedRequest = ListDedicatedVmHostsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDedicatedVmHostsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDedicatedVmHostsResponse> transformer = ListDedicatedVmHostsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDedicatedVmHostsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListImagesResponse listImages(ListImagesRequest request) {
        LOG.trace("Called listImages");
        ListImagesRequest interceptedRequest = ListImagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListImagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListImagesResponse> transformer = ListImagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListImagesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstanceConsoleConnectionsResponse listInstanceConsoleConnections(ListInstanceConsoleConnectionsRequest request) {
        LOG.trace("Called listInstanceConsoleConnections");
        ListInstanceConsoleConnectionsRequest interceptedRequest = ListInstanceConsoleConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstanceConsoleConnectionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstanceConsoleConnectionsResponse> transformer = ListInstanceConsoleConnectionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListInstanceConsoleConnectionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstanceDevicesResponse listInstanceDevices(ListInstanceDevicesRequest request) {
        LOG.trace("Called listInstanceDevices");
        ListInstanceDevicesRequest interceptedRequest = ListInstanceDevicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstanceDevicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstanceDevicesResponse> transformer = ListInstanceDevicesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListInstanceDevicesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        LOG.trace("Called listInstances");
        ListInstancesRequest interceptedRequest = ListInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstancesResponse> transformer = ListInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListInstancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListShapesResponse listShapes(ListShapesRequest request) {
        LOG.trace("Called listShapes");
        ListShapesRequest interceptedRequest = ListShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListShapesResponse> transformer = ListShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVnicAttachmentsResponse listVnicAttachments(ListVnicAttachmentsRequest request) {
        LOG.trace("Called listVnicAttachments");
        ListVnicAttachmentsRequest interceptedRequest = ListVnicAttachmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVnicAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVnicAttachmentsResponse> transformer = ListVnicAttachmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVnicAttachmentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVolumeAttachmentsResponse listVolumeAttachments(ListVolumeAttachmentsRequest request) {
        LOG.trace("Called listVolumeAttachments");
        ListVolumeAttachmentsRequest interceptedRequest = ListVolumeAttachmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVolumeAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVolumeAttachmentsResponse> transformer = ListVolumeAttachmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVolumeAttachmentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TerminateInstanceResponse terminateInstance(TerminateInstanceRequest request) {
        LOG.trace("Called terminateInstance");
        TerminateInstanceRequest interceptedRequest = TerminateInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TerminateInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TerminateInstanceResponse> transformer = TerminateInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (TerminateInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateConsoleHistoryResponse updateConsoleHistory(UpdateConsoleHistoryRequest request) {
        LOG.trace("Called updateConsoleHistory");
        UpdateConsoleHistoryRequest interceptedRequest = UpdateConsoleHistoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConsoleHistoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConsoleHistoryResponse> transformer = UpdateConsoleHistoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateConsoleHistoryDetails(), retriedRequest);
                return (UpdateConsoleHistoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDedicatedVmHostResponse updateDedicatedVmHost(UpdateDedicatedVmHostRequest request) {
        LOG.trace("Called updateDedicatedVmHost");
        UpdateDedicatedVmHostRequest interceptedRequest = UpdateDedicatedVmHostConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDedicatedVmHostConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDedicatedVmHostResponse> transformer = UpdateDedicatedVmHostConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateDedicatedVmHostDetails(), retriedRequest);
                return (UpdateDedicatedVmHostResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateImageResponse updateImage(UpdateImageRequest request) {
        LOG.trace("Called updateImage");
        UpdateImageRequest interceptedRequest = UpdateImageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateImageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateImageResponse> transformer = UpdateImageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateImageDetails(), retriedRequest);
                return (UpdateImageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateInstanceResponse updateInstance(UpdateInstanceRequest request) {
        LOG.trace("Called updateInstance");
        UpdateInstanceRequest interceptedRequest = UpdateInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateInstanceResponse> transformer = UpdateInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateInstanceDetails(), retriedRequest);
                return (UpdateInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ComputeWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ComputeWaiters newWaiters(WorkRequest workRequestClient) {
        return new ComputeWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public ComputePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ComputeClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ComputeClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

