/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.ComputeManagementAsync;
import com.oracle.bmc.core.internal.http.AttachLoadBalancerConverter;
import com.oracle.bmc.core.internal.http.ChangeClusterNetworkCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInstanceConfigurationCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInstancePoolCompartmentConverter;
import com.oracle.bmc.core.internal.http.CreateClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.CreateInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.CreateInstancePoolConverter;
import com.oracle.bmc.core.internal.http.DeleteInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.DetachLoadBalancerConverter;
import com.oracle.bmc.core.internal.http.GetClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.GetInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.GetInstancePoolConverter;
import com.oracle.bmc.core.internal.http.GetInstancePoolLoadBalancerAttachmentConverter;
import com.oracle.bmc.core.internal.http.LaunchInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.ListClusterNetworkInstancesConverter;
import com.oracle.bmc.core.internal.http.ListClusterNetworksConverter;
import com.oracle.bmc.core.internal.http.ListInstanceConfigurationsConverter;
import com.oracle.bmc.core.internal.http.ListInstancePoolInstancesConverter;
import com.oracle.bmc.core.internal.http.ListInstancePoolsConverter;
import com.oracle.bmc.core.internal.http.ResetInstancePoolConverter;
import com.oracle.bmc.core.internal.http.SoftresetInstancePoolConverter;
import com.oracle.bmc.core.internal.http.StartInstancePoolConverter;
import com.oracle.bmc.core.internal.http.StopInstancePoolConverter;
import com.oracle.bmc.core.internal.http.TerminateClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.TerminateInstancePoolConverter;
import com.oracle.bmc.core.internal.http.UpdateClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.UpdateInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.UpdateInstancePoolConverter;
import com.oracle.bmc.core.requests.AttachLoadBalancerRequest;
import com.oracle.bmc.core.requests.ChangeClusterNetworkCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceConfigurationCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstancePoolCompartmentRequest;
import com.oracle.bmc.core.requests.CreateClusterNetworkRequest;
import com.oracle.bmc.core.requests.CreateInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.CreateInstancePoolRequest;
import com.oracle.bmc.core.requests.DeleteInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.DetachLoadBalancerRequest;
import com.oracle.bmc.core.requests.GetClusterNetworkRequest;
import com.oracle.bmc.core.requests.GetInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.GetInstancePoolLoadBalancerAttachmentRequest;
import com.oracle.bmc.core.requests.GetInstancePoolRequest;
import com.oracle.bmc.core.requests.LaunchInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.ListClusterNetworkInstancesRequest;
import com.oracle.bmc.core.requests.ListClusterNetworksRequest;
import com.oracle.bmc.core.requests.ListInstanceConfigurationsRequest;
import com.oracle.bmc.core.requests.ListInstancePoolInstancesRequest;
import com.oracle.bmc.core.requests.ListInstancePoolsRequest;
import com.oracle.bmc.core.requests.ResetInstancePoolRequest;
import com.oracle.bmc.core.requests.SoftresetInstancePoolRequest;
import com.oracle.bmc.core.requests.StartInstancePoolRequest;
import com.oracle.bmc.core.requests.StopInstancePoolRequest;
import com.oracle.bmc.core.requests.TerminateClusterNetworkRequest;
import com.oracle.bmc.core.requests.TerminateInstancePoolRequest;
import com.oracle.bmc.core.requests.UpdateClusterNetworkRequest;
import com.oracle.bmc.core.requests.UpdateInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.UpdateInstancePoolRequest;
import com.oracle.bmc.core.responses.AttachLoadBalancerResponse;
import com.oracle.bmc.core.responses.ChangeClusterNetworkCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceConfigurationCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstancePoolCompartmentResponse;
import com.oracle.bmc.core.responses.CreateClusterNetworkResponse;
import com.oracle.bmc.core.responses.CreateInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.CreateInstancePoolResponse;
import com.oracle.bmc.core.responses.DeleteInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.DetachLoadBalancerResponse;
import com.oracle.bmc.core.responses.GetClusterNetworkResponse;
import com.oracle.bmc.core.responses.GetInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.GetInstancePoolLoadBalancerAttachmentResponse;
import com.oracle.bmc.core.responses.GetInstancePoolResponse;
import com.oracle.bmc.core.responses.LaunchInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.ListClusterNetworkInstancesResponse;
import com.oracle.bmc.core.responses.ListClusterNetworksResponse;
import com.oracle.bmc.core.responses.ListInstanceConfigurationsResponse;
import com.oracle.bmc.core.responses.ListInstancePoolInstancesResponse;
import com.oracle.bmc.core.responses.ListInstancePoolsResponse;
import com.oracle.bmc.core.responses.ResetInstancePoolResponse;
import com.oracle.bmc.core.responses.SoftresetInstancePoolResponse;
import com.oracle.bmc.core.responses.StartInstancePoolResponse;
import com.oracle.bmc.core.responses.StopInstancePoolResponse;
import com.oracle.bmc.core.responses.TerminateClusterNetworkResponse;
import com.oracle.bmc.core.responses.TerminateInstancePoolResponse;
import com.oracle.bmc.core.responses.UpdateClusterNetworkResponse;
import com.oracle.bmc.core.responses.UpdateInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.UpdateInstancePoolResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeManagementAsyncClient
implements ComputeManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTEMANAGEMENT").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ComputeManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ComputeManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ComputeManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AttachLoadBalancerResponse> attachLoadBalancer(AttachLoadBalancerRequest request, AsyncHandler<AttachLoadBalancerRequest, AttachLoadBalancerResponse> handler) {
        LOG.trace("Called async attachLoadBalancer");
        final AttachLoadBalancerRequest interceptedRequest = AttachLoadBalancerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachLoadBalancerResponse> transformer = AttachLoadBalancerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AttachLoadBalancerRequest, AttachLoadBalancerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachLoadBalancerRequest, AttachLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AttachLoadBalancerRequest, AttachLoadBalancerResponse> onSuccess = new SuccessConsumer<AttachLoadBalancerRequest, AttachLoadBalancerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AttachLoadBalancerRequest> onError = new ErrorConsumer<AttachLoadBalancerRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getAttachLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AttachLoadBalancerRequest, AttachLoadBalancerResponse> onSuccess = handler == null ? null : new SuccessConsumer<AttachLoadBalancerRequest, AttachLoadBalancerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AttachLoadBalancerRequest> onError = handler == null ? null : new ErrorConsumer<AttachLoadBalancerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAttachLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AttachLoadBalancerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getAttachLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AttachLoadBalancerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeClusterNetworkCompartmentResponse> changeClusterNetworkCompartment(ChangeClusterNetworkCompartmentRequest request, AsyncHandler<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse> handler) {
        LOG.trace("Called async changeClusterNetworkCompartment");
        final ChangeClusterNetworkCompartmentRequest interceptedRequest = ChangeClusterNetworkCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeClusterNetworkCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeClusterNetworkCompartmentResponse> transformer = ChangeClusterNetworkCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse> onSuccess = new SuccessConsumer<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeClusterNetworkCompartmentRequest> onError = new ErrorConsumer<ChangeClusterNetworkCompartmentRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeClusterNetworkCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeClusterNetworkCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeClusterNetworkCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeClusterNetworkCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeClusterNetworkCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeClusterNetworkCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeClusterNetworkCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeInstanceConfigurationCompartmentResponse> changeInstanceConfigurationCompartment(ChangeInstanceConfigurationCompartmentRequest request, AsyncHandler<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse> handler) {
        LOG.trace("Called async changeInstanceConfigurationCompartment");
        final ChangeInstanceConfigurationCompartmentRequest interceptedRequest = ChangeInstanceConfigurationCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeInstanceConfigurationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeInstanceConfigurationCompartmentResponse> transformer = ChangeInstanceConfigurationCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse> onSuccess = new SuccessConsumer<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeInstanceConfigurationCompartmentRequest> onError = new ErrorConsumer<ChangeInstanceConfigurationCompartmentRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeInstanceConfigurationCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeInstanceConfigurationCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeInstanceConfigurationCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeInstanceConfigurationCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeInstanceConfigurationCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeInstanceConfigurationCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeInstanceConfigurationCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeInstancePoolCompartmentResponse> changeInstancePoolCompartment(ChangeInstancePoolCompartmentRequest request, AsyncHandler<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse> handler) {
        LOG.trace("Called async changeInstancePoolCompartment");
        final ChangeInstancePoolCompartmentRequest interceptedRequest = ChangeInstancePoolCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeInstancePoolCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeInstancePoolCompartmentResponse> transformer = ChangeInstancePoolCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse> onSuccess = new SuccessConsumer<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeInstancePoolCompartmentRequest> onError = new ErrorConsumer<ChangeInstancePoolCompartmentRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeInstancePoolCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeInstancePoolCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeInstancePoolCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeInstancePoolCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeInstancePoolCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getChangeInstancePoolCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeInstancePoolCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateClusterNetworkResponse> createClusterNetwork(CreateClusterNetworkRequest request, AsyncHandler<CreateClusterNetworkRequest, CreateClusterNetworkResponse> handler) {
        LOG.trace("Called async createClusterNetwork");
        final CreateClusterNetworkRequest interceptedRequest = CreateClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateClusterNetworkResponse> transformer = CreateClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateClusterNetworkRequest, CreateClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateClusterNetworkRequest, CreateClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateClusterNetworkRequest, CreateClusterNetworkResponse> onSuccess = new SuccessConsumer<CreateClusterNetworkRequest, CreateClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateClusterNetworkRequest> onError = new ErrorConsumer<CreateClusterNetworkRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateClusterNetworkRequest, CreateClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateClusterNetworkRequest, CreateClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<CreateClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateInstanceConfigurationResponse> createInstanceConfiguration(CreateInstanceConfigurationRequest request, AsyncHandler<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse> handler) {
        LOG.trace("Called async createInstanceConfiguration");
        final CreateInstanceConfigurationRequest interceptedRequest = CreateInstanceConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateInstanceConfigurationResponse> transformer = CreateInstanceConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse> onSuccess = new SuccessConsumer<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateInstanceConfigurationRequest> onError = new ErrorConsumer<CreateInstanceConfigurationRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateInstanceConfiguration(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateInstanceConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<CreateInstanceConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateInstanceConfiguration(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateInstanceConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateInstanceConfiguration(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateInstanceConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateInstancePoolResponse> createInstancePool(CreateInstancePoolRequest request, AsyncHandler<CreateInstancePoolRequest, CreateInstancePoolResponse> handler) {
        LOG.trace("Called async createInstancePool");
        final CreateInstancePoolRequest interceptedRequest = CreateInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateInstancePoolResponse> transformer = CreateInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateInstancePoolRequest, CreateInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateInstancePoolRequest, CreateInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateInstancePoolRequest, CreateInstancePoolResponse> onSuccess = new SuccessConsumer<CreateInstancePoolRequest, CreateInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateInstancePoolRequest> onError = new ErrorConsumer<CreateInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateInstancePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateInstancePoolRequest, CreateInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateInstancePoolRequest, CreateInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<CreateInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateInstancePoolDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getCreateInstancePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateInstancePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteInstanceConfigurationResponse> deleteInstanceConfiguration(DeleteInstanceConfigurationRequest request, AsyncHandler<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse> handler) {
        LOG.trace("Called async deleteInstanceConfiguration");
        final DeleteInstanceConfigurationRequest interceptedRequest = DeleteInstanceConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteInstanceConfigurationResponse> transformer = DeleteInstanceConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse> onSuccess = new SuccessConsumer<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteInstanceConfigurationRequest> onError = new ErrorConsumer<DeleteInstanceConfigurationRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteInstanceConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<DeleteInstanceConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteInstanceConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteInstanceConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DetachLoadBalancerResponse> detachLoadBalancer(DetachLoadBalancerRequest request, AsyncHandler<DetachLoadBalancerRequest, DetachLoadBalancerResponse> handler) {
        LOG.trace("Called async detachLoadBalancer");
        final DetachLoadBalancerRequest interceptedRequest = DetachLoadBalancerConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachLoadBalancerResponse> transformer = DetachLoadBalancerConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DetachLoadBalancerRequest, DetachLoadBalancerResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachLoadBalancerRequest, DetachLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DetachLoadBalancerRequest, DetachLoadBalancerResponse> onSuccess = new SuccessConsumer<DetachLoadBalancerRequest, DetachLoadBalancerResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DetachLoadBalancerRequest> onError = new ErrorConsumer<DetachLoadBalancerRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getDetachLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DetachLoadBalancerRequest, DetachLoadBalancerResponse> onSuccess = handler == null ? null : new SuccessConsumer<DetachLoadBalancerRequest, DetachLoadBalancerResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DetachLoadBalancerRequest> onError = handler == null ? null : new ErrorConsumer<DetachLoadBalancerRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getDetachLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DetachLoadBalancerResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getDetachLoadBalancerDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DetachLoadBalancerResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetClusterNetworkResponse> getClusterNetwork(GetClusterNetworkRequest request, AsyncHandler<GetClusterNetworkRequest, GetClusterNetworkResponse> handler) {
        LOG.trace("Called async getClusterNetwork");
        final GetClusterNetworkRequest interceptedRequest = GetClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetClusterNetworkResponse> transformer = GetClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetClusterNetworkRequest, GetClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetClusterNetworkRequest, GetClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetClusterNetworkRequest, GetClusterNetworkResponse> onSuccess = new SuccessConsumer<GetClusterNetworkRequest, GetClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetClusterNetworkRequest> onError = new ErrorConsumer<GetClusterNetworkRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetClusterNetworkRequest, GetClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetClusterNetworkRequest, GetClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<GetClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetInstanceConfigurationResponse> getInstanceConfiguration(GetInstanceConfigurationRequest request, AsyncHandler<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse> handler) {
        LOG.trace("Called async getInstanceConfiguration");
        final GetInstanceConfigurationRequest interceptedRequest = GetInstanceConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetInstanceConfigurationResponse> transformer = GetInstanceConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse> onSuccess = new SuccessConsumer<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetInstanceConfigurationRequest> onError = new ErrorConsumer<GetInstanceConfigurationRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetInstanceConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<GetInstanceConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetInstanceConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetInstanceConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetInstancePoolResponse> getInstancePool(GetInstancePoolRequest request, AsyncHandler<GetInstancePoolRequest, GetInstancePoolResponse> handler) {
        LOG.trace("Called async getInstancePool");
        final GetInstancePoolRequest interceptedRequest = GetInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetInstancePoolResponse> transformer = GetInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetInstancePoolRequest, GetInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetInstancePoolRequest, GetInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetInstancePoolRequest, GetInstancePoolResponse> onSuccess = new SuccessConsumer<GetInstancePoolRequest, GetInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetInstancePoolRequest> onError = new ErrorConsumer<GetInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetInstancePoolRequest, GetInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetInstancePoolRequest, GetInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<GetInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetInstancePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetInstancePoolLoadBalancerAttachmentResponse> getInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, AsyncHandler<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> handler) {
        LOG.trace("Called async getInstancePoolLoadBalancerAttachment");
        final GetInstancePoolLoadBalancerAttachmentRequest interceptedRequest = GetInstancePoolLoadBalancerAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetInstancePoolLoadBalancerAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetInstancePoolLoadBalancerAttachmentResponse> transformer = GetInstancePoolLoadBalancerAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> onSuccess = new SuccessConsumer<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetInstancePoolLoadBalancerAttachmentRequest> onError = new ErrorConsumer<GetInstancePoolLoadBalancerAttachmentRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetInstancePoolLoadBalancerAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<GetInstancePoolLoadBalancerAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetInstancePoolLoadBalancerAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetInstancePoolLoadBalancerAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<LaunchInstanceConfigurationResponse> launchInstanceConfiguration(LaunchInstanceConfigurationRequest request, AsyncHandler<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> handler) {
        LOG.trace("Called async launchInstanceConfiguration");
        final LaunchInstanceConfigurationRequest interceptedRequest = LaunchInstanceConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = LaunchInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, LaunchInstanceConfigurationResponse> transformer = LaunchInstanceConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> onSuccess = new SuccessConsumer<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<LaunchInstanceConfigurationRequest> onError = new ErrorConsumer<LaunchInstanceConfigurationRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getInstanceConfiguration(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<LaunchInstanceConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<LaunchInstanceConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getInstanceConfiguration(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, LaunchInstanceConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest.getInstanceConfiguration(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, LaunchInstanceConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListClusterNetworkInstancesResponse> listClusterNetworkInstances(ListClusterNetworkInstancesRequest request, AsyncHandler<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse> handler) {
        LOG.trace("Called async listClusterNetworkInstances");
        final ListClusterNetworkInstancesRequest interceptedRequest = ListClusterNetworkInstancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListClusterNetworkInstancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListClusterNetworkInstancesResponse> transformer = ListClusterNetworkInstancesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse> onSuccess = new SuccessConsumer<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListClusterNetworkInstancesRequest> onError = new ErrorConsumer<ListClusterNetworkInstancesRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListClusterNetworkInstancesRequest> onError = handler == null ? null : new ErrorConsumer<ListClusterNetworkInstancesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListClusterNetworkInstancesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListClusterNetworkInstancesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListClusterNetworksResponse> listClusterNetworks(ListClusterNetworksRequest request, AsyncHandler<ListClusterNetworksRequest, ListClusterNetworksResponse> handler) {
        LOG.trace("Called async listClusterNetworks");
        final ListClusterNetworksRequest interceptedRequest = ListClusterNetworksConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListClusterNetworksConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListClusterNetworksResponse> transformer = ListClusterNetworksConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListClusterNetworksRequest, ListClusterNetworksResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListClusterNetworksRequest, ListClusterNetworksResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListClusterNetworksRequest, ListClusterNetworksResponse> onSuccess = new SuccessConsumer<ListClusterNetworksRequest, ListClusterNetworksResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListClusterNetworksRequest> onError = new ErrorConsumer<ListClusterNetworksRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListClusterNetworksRequest, ListClusterNetworksResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListClusterNetworksRequest, ListClusterNetworksResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListClusterNetworksRequest> onError = handler == null ? null : new ErrorConsumer<ListClusterNetworksRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListClusterNetworksResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListClusterNetworksResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListInstanceConfigurationsResponse> listInstanceConfigurations(ListInstanceConfigurationsRequest request, AsyncHandler<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse> handler) {
        LOG.trace("Called async listInstanceConfigurations");
        final ListInstanceConfigurationsRequest interceptedRequest = ListInstanceConfigurationsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListInstanceConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListInstanceConfigurationsResponse> transformer = ListInstanceConfigurationsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse> onSuccess = new SuccessConsumer<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListInstanceConfigurationsRequest> onError = new ErrorConsumer<ListInstanceConfigurationsRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListInstanceConfigurationsRequest> onError = handler == null ? null : new ErrorConsumer<ListInstanceConfigurationsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListInstanceConfigurationsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListInstanceConfigurationsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListInstancePoolInstancesResponse> listInstancePoolInstances(ListInstancePoolInstancesRequest request, AsyncHandler<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse> handler) {
        LOG.trace("Called async listInstancePoolInstances");
        final ListInstancePoolInstancesRequest interceptedRequest = ListInstancePoolInstancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListInstancePoolInstancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListInstancePoolInstancesResponse> transformer = ListInstancePoolInstancesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse> onSuccess = new SuccessConsumer<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListInstancePoolInstancesRequest> onError = new ErrorConsumer<ListInstancePoolInstancesRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListInstancePoolInstancesRequest> onError = handler == null ? null : new ErrorConsumer<ListInstancePoolInstancesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListInstancePoolInstancesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListInstancePoolInstancesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListInstancePoolsResponse> listInstancePools(ListInstancePoolsRequest request, AsyncHandler<ListInstancePoolsRequest, ListInstancePoolsResponse> handler) {
        LOG.trace("Called async listInstancePools");
        final ListInstancePoolsRequest interceptedRequest = ListInstancePoolsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListInstancePoolsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListInstancePoolsResponse> transformer = ListInstancePoolsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListInstancePoolsRequest, ListInstancePoolsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListInstancePoolsRequest, ListInstancePoolsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListInstancePoolsRequest, ListInstancePoolsResponse> onSuccess = new SuccessConsumer<ListInstancePoolsRequest, ListInstancePoolsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListInstancePoolsRequest> onError = new ErrorConsumer<ListInstancePoolsRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListInstancePoolsRequest, ListInstancePoolsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListInstancePoolsRequest, ListInstancePoolsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListInstancePoolsRequest> onError = handler == null ? null : new ErrorConsumer<ListInstancePoolsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListInstancePoolsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListInstancePoolsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ResetInstancePoolResponse> resetInstancePool(ResetInstancePoolRequest request, AsyncHandler<ResetInstancePoolRequest, ResetInstancePoolResponse> handler) {
        LOG.trace("Called async resetInstancePool");
        final ResetInstancePoolRequest interceptedRequest = ResetInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ResetInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ResetInstancePoolResponse> transformer = ResetInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ResetInstancePoolRequest, ResetInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ResetInstancePoolRequest, ResetInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ResetInstancePoolRequest, ResetInstancePoolResponse> onSuccess = new SuccessConsumer<ResetInstancePoolRequest, ResetInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ResetInstancePoolRequest> onError = new ErrorConsumer<ResetInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ResetInstancePoolRequest, ResetInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<ResetInstancePoolRequest, ResetInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ResetInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<ResetInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ResetInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ResetInstancePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<SoftresetInstancePoolResponse> softresetInstancePool(SoftresetInstancePoolRequest request, AsyncHandler<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse> handler) {
        LOG.trace("Called async softresetInstancePool");
        final SoftresetInstancePoolRequest interceptedRequest = SoftresetInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = SoftresetInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, SoftresetInstancePoolResponse> transformer = SoftresetInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse> onSuccess = new SuccessConsumer<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<SoftresetInstancePoolRequest> onError = new ErrorConsumer<SoftresetInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<SoftresetInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<SoftresetInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, SoftresetInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, SoftresetInstancePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StartInstancePoolResponse> startInstancePool(StartInstancePoolRequest request, AsyncHandler<StartInstancePoolRequest, StartInstancePoolResponse> handler) {
        LOG.trace("Called async startInstancePool");
        final StartInstancePoolRequest interceptedRequest = StartInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StartInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StartInstancePoolResponse> transformer = StartInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StartInstancePoolRequest, StartInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StartInstancePoolRequest, StartInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StartInstancePoolRequest, StartInstancePoolResponse> onSuccess = new SuccessConsumer<StartInstancePoolRequest, StartInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StartInstancePoolRequest> onError = new ErrorConsumer<StartInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StartInstancePoolRequest, StartInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<StartInstancePoolRequest, StartInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StartInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<StartInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StartInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StartInstancePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StopInstancePoolResponse> stopInstancePool(StopInstancePoolRequest request, AsyncHandler<StopInstancePoolRequest, StopInstancePoolResponse> handler) {
        LOG.trace("Called async stopInstancePool");
        final StopInstancePoolRequest interceptedRequest = StopInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StopInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StopInstancePoolResponse> transformer = StopInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StopInstancePoolRequest, StopInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StopInstancePoolRequest, StopInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StopInstancePoolRequest, StopInstancePoolResponse> onSuccess = new SuccessConsumer<StopInstancePoolRequest, StopInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StopInstancePoolRequest> onError = new ErrorConsumer<StopInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StopInstancePoolRequest, StopInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<StopInstancePoolRequest, StopInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StopInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<StopInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StopInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StopInstancePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<TerminateClusterNetworkResponse> terminateClusterNetwork(TerminateClusterNetworkRequest request, AsyncHandler<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> handler) {
        LOG.trace("Called async terminateClusterNetwork");
        final TerminateClusterNetworkRequest interceptedRequest = TerminateClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = TerminateClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, TerminateClusterNetworkResponse> transformer = TerminateClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> onSuccess = new SuccessConsumer<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<TerminateClusterNetworkRequest> onError = new ErrorConsumer<TerminateClusterNetworkRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<TerminateClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<TerminateClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, TerminateClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, TerminateClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<TerminateInstancePoolResponse> terminateInstancePool(TerminateInstancePoolRequest request, AsyncHandler<TerminateInstancePoolRequest, TerminateInstancePoolResponse> handler) {
        LOG.trace("Called async terminateInstancePool");
        final TerminateInstancePoolRequest interceptedRequest = TerminateInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = TerminateInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, TerminateInstancePoolResponse> transformer = TerminateInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<TerminateInstancePoolRequest, TerminateInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<TerminateInstancePoolRequest, TerminateInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<TerminateInstancePoolRequest, TerminateInstancePoolResponse> onSuccess = new SuccessConsumer<TerminateInstancePoolRequest, TerminateInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<TerminateInstancePoolRequest> onError = new ErrorConsumer<TerminateInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<TerminateInstancePoolRequest, TerminateInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<TerminateInstancePoolRequest, TerminateInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<TerminateInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<TerminateInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, TerminateInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, TerminateInstancePoolResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateClusterNetworkResponse> updateClusterNetwork(UpdateClusterNetworkRequest request, AsyncHandler<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse> handler) {
        LOG.trace("Called async updateClusterNetwork");
        final UpdateClusterNetworkRequest interceptedRequest = UpdateClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateClusterNetworkResponse> transformer = UpdateClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse> onSuccess = new SuccessConsumer<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateClusterNetworkRequest> onError = new ErrorConsumer<UpdateClusterNetworkRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<UpdateClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateInstanceConfigurationResponse> updateInstanceConfiguration(UpdateInstanceConfigurationRequest request, AsyncHandler<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse> handler) {
        LOG.trace("Called async updateInstanceConfiguration");
        final UpdateInstanceConfigurationRequest interceptedRequest = UpdateInstanceConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateInstanceConfigurationResponse> transformer = UpdateInstanceConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse> onSuccess = new SuccessConsumer<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateInstanceConfigurationRequest> onError = new ErrorConsumer<UpdateInstanceConfigurationRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInstanceConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateInstanceConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<UpdateInstanceConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateInstanceConfigurationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateInstanceConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInstanceConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateInstanceConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateInstancePoolResponse> updateInstancePool(UpdateInstancePoolRequest request, AsyncHandler<UpdateInstancePoolRequest, UpdateInstancePoolResponse> handler) {
        LOG.trace("Called async updateInstancePool");
        final UpdateInstancePoolRequest interceptedRequest = UpdateInstancePoolConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateInstancePoolResponse> transformer = UpdateInstancePoolConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateInstancePoolRequest, UpdateInstancePoolResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateInstancePoolRequest, UpdateInstancePoolResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateInstancePoolRequest, UpdateInstancePoolResponse> onSuccess = new SuccessConsumer<UpdateInstancePoolRequest, UpdateInstancePoolResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateInstancePoolRequest> onError = new ErrorConsumer<UpdateInstancePoolRequest>(this, interceptedRequest);
                    ComputeManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInstancePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateInstancePoolRequest, UpdateInstancePoolResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateInstancePoolRequest, UpdateInstancePoolResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateInstancePoolRequest> onError = handler == null ? null : new ErrorConsumer<UpdateInstancePoolRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateInstancePoolDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateInstancePoolResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ComputeManagementAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInstancePoolDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateInstancePoolResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public ComputeManagementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ComputeManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

