/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.ComputeManagement;
import com.oracle.bmc.core.ComputeManagementPaginators;
import com.oracle.bmc.core.ComputeManagementWaiters;
import com.oracle.bmc.core.internal.http.AttachLoadBalancerConverter;
import com.oracle.bmc.core.internal.http.ChangeClusterNetworkCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInstanceConfigurationCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInstancePoolCompartmentConverter;
import com.oracle.bmc.core.internal.http.CreateClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.CreateInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.CreateInstancePoolConverter;
import com.oracle.bmc.core.internal.http.DeleteInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.DetachLoadBalancerConverter;
import com.oracle.bmc.core.internal.http.GetClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.GetInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.GetInstancePoolConverter;
import com.oracle.bmc.core.internal.http.GetInstancePoolLoadBalancerAttachmentConverter;
import com.oracle.bmc.core.internal.http.LaunchInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.ListClusterNetworkInstancesConverter;
import com.oracle.bmc.core.internal.http.ListClusterNetworksConverter;
import com.oracle.bmc.core.internal.http.ListInstanceConfigurationsConverter;
import com.oracle.bmc.core.internal.http.ListInstancePoolInstancesConverter;
import com.oracle.bmc.core.internal.http.ListInstancePoolsConverter;
import com.oracle.bmc.core.internal.http.ResetInstancePoolConverter;
import com.oracle.bmc.core.internal.http.SoftresetInstancePoolConverter;
import com.oracle.bmc.core.internal.http.StartInstancePoolConverter;
import com.oracle.bmc.core.internal.http.StopInstancePoolConverter;
import com.oracle.bmc.core.internal.http.TerminateClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.TerminateInstancePoolConverter;
import com.oracle.bmc.core.internal.http.UpdateClusterNetworkConverter;
import com.oracle.bmc.core.internal.http.UpdateInstanceConfigurationConverter;
import com.oracle.bmc.core.internal.http.UpdateInstancePoolConverter;
import com.oracle.bmc.core.requests.AttachLoadBalancerRequest;
import com.oracle.bmc.core.requests.ChangeClusterNetworkCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceConfigurationCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstancePoolCompartmentRequest;
import com.oracle.bmc.core.requests.CreateClusterNetworkRequest;
import com.oracle.bmc.core.requests.CreateInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.CreateInstancePoolRequest;
import com.oracle.bmc.core.requests.DeleteInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.DetachLoadBalancerRequest;
import com.oracle.bmc.core.requests.GetClusterNetworkRequest;
import com.oracle.bmc.core.requests.GetInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.GetInstancePoolLoadBalancerAttachmentRequest;
import com.oracle.bmc.core.requests.GetInstancePoolRequest;
import com.oracle.bmc.core.requests.LaunchInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.ListClusterNetworkInstancesRequest;
import com.oracle.bmc.core.requests.ListClusterNetworksRequest;
import com.oracle.bmc.core.requests.ListInstanceConfigurationsRequest;
import com.oracle.bmc.core.requests.ListInstancePoolInstancesRequest;
import com.oracle.bmc.core.requests.ListInstancePoolsRequest;
import com.oracle.bmc.core.requests.ResetInstancePoolRequest;
import com.oracle.bmc.core.requests.SoftresetInstancePoolRequest;
import com.oracle.bmc.core.requests.StartInstancePoolRequest;
import com.oracle.bmc.core.requests.StopInstancePoolRequest;
import com.oracle.bmc.core.requests.TerminateClusterNetworkRequest;
import com.oracle.bmc.core.requests.TerminateInstancePoolRequest;
import com.oracle.bmc.core.requests.UpdateClusterNetworkRequest;
import com.oracle.bmc.core.requests.UpdateInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.UpdateInstancePoolRequest;
import com.oracle.bmc.core.responses.AttachLoadBalancerResponse;
import com.oracle.bmc.core.responses.ChangeClusterNetworkCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceConfigurationCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstancePoolCompartmentResponse;
import com.oracle.bmc.core.responses.CreateClusterNetworkResponse;
import com.oracle.bmc.core.responses.CreateInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.CreateInstancePoolResponse;
import com.oracle.bmc.core.responses.DeleteInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.DetachLoadBalancerResponse;
import com.oracle.bmc.core.responses.GetClusterNetworkResponse;
import com.oracle.bmc.core.responses.GetInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.GetInstancePoolLoadBalancerAttachmentResponse;
import com.oracle.bmc.core.responses.GetInstancePoolResponse;
import com.oracle.bmc.core.responses.LaunchInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.ListClusterNetworkInstancesResponse;
import com.oracle.bmc.core.responses.ListClusterNetworksResponse;
import com.oracle.bmc.core.responses.ListInstanceConfigurationsResponse;
import com.oracle.bmc.core.responses.ListInstancePoolInstancesResponse;
import com.oracle.bmc.core.responses.ListInstancePoolsResponse;
import com.oracle.bmc.core.responses.ResetInstancePoolResponse;
import com.oracle.bmc.core.responses.SoftresetInstancePoolResponse;
import com.oracle.bmc.core.responses.StartInstancePoolResponse;
import com.oracle.bmc.core.responses.StopInstancePoolResponse;
import com.oracle.bmc.core.responses.TerminateClusterNetworkResponse;
import com.oracle.bmc.core.responses.TerminateInstancePoolResponse;
import com.oracle.bmc.core.responses.UpdateClusterNetworkResponse;
import com.oracle.bmc.core.responses.UpdateInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.UpdateInstancePoolResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.workrequests.WorkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeManagementClient
implements ComputeManagement {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeManagementClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTEMANAGEMENT").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ComputeManagementWaiters waiters;
    private final ComputeManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ExecutorService executorService;
    private final RetryConfiguration retryConfiguration;

    public ComputeManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ComputeManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ComputeManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ComputeManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ComputeManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ComputeManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ComputeManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ComputeManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ComputeManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new ComputeManagementWaiters(executorService, this);
        this.paginators = new ComputeManagementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AttachLoadBalancerResponse attachLoadBalancer(AttachLoadBalancerRequest request) {
        LOG.trace("Called attachLoadBalancer");
        AttachLoadBalancerRequest interceptedRequest = AttachLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachLoadBalancerResponse> transformer = AttachLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getAttachLoadBalancerDetails(), retriedRequest);
                return (AttachLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeClusterNetworkCompartmentResponse changeClusterNetworkCompartment(ChangeClusterNetworkCompartmentRequest request) {
        LOG.trace("Called changeClusterNetworkCompartment");
        ChangeClusterNetworkCompartmentRequest interceptedRequest = ChangeClusterNetworkCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeClusterNetworkCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeClusterNetworkCompartmentResponse> transformer = ChangeClusterNetworkCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeClusterNetworkCompartmentDetails(), retriedRequest);
                return (ChangeClusterNetworkCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeInstanceConfigurationCompartmentResponse changeInstanceConfigurationCompartment(ChangeInstanceConfigurationCompartmentRequest request) {
        LOG.trace("Called changeInstanceConfigurationCompartment");
        ChangeInstanceConfigurationCompartmentRequest interceptedRequest = ChangeInstanceConfigurationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeInstanceConfigurationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeInstanceConfigurationCompartmentResponse> transformer = ChangeInstanceConfigurationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeInstanceConfigurationCompartmentDetails(), retriedRequest);
                return (ChangeInstanceConfigurationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeInstancePoolCompartmentResponse changeInstancePoolCompartment(ChangeInstancePoolCompartmentRequest request) {
        LOG.trace("Called changeInstancePoolCompartment");
        ChangeInstancePoolCompartmentRequest interceptedRequest = ChangeInstancePoolCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeInstancePoolCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeInstancePoolCompartmentResponse> transformer = ChangeInstancePoolCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeInstancePoolCompartmentDetails(), retriedRequest);
                return (ChangeInstancePoolCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateClusterNetworkResponse createClusterNetwork(CreateClusterNetworkRequest request) {
        LOG.trace("Called createClusterNetwork");
        CreateClusterNetworkRequest interceptedRequest = CreateClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateClusterNetworkResponse> transformer = CreateClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateClusterNetworkDetails(), retriedRequest);
                return (CreateClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateInstanceConfigurationResponse createInstanceConfiguration(CreateInstanceConfigurationRequest request) {
        LOG.trace("Called createInstanceConfiguration");
        CreateInstanceConfigurationRequest interceptedRequest = CreateInstanceConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateInstanceConfigurationResponse> transformer = CreateInstanceConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateInstanceConfiguration(), retriedRequest);
                return (CreateInstanceConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateInstancePoolResponse createInstancePool(CreateInstancePoolRequest request) {
        LOG.trace("Called createInstancePool");
        CreateInstancePoolRequest interceptedRequest = CreateInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateInstancePoolResponse> transformer = CreateInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateInstancePoolDetails(), retriedRequest);
                return (CreateInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteInstanceConfigurationResponse deleteInstanceConfiguration(DeleteInstanceConfigurationRequest request) {
        LOG.trace("Called deleteInstanceConfiguration");
        DeleteInstanceConfigurationRequest interceptedRequest = DeleteInstanceConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteInstanceConfigurationResponse> transformer = DeleteInstanceConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteInstanceConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetachLoadBalancerResponse detachLoadBalancer(DetachLoadBalancerRequest request) {
        LOG.trace("Called detachLoadBalancer");
        DetachLoadBalancerRequest interceptedRequest = DetachLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachLoadBalancerResponse> transformer = DetachLoadBalancerConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getDetachLoadBalancerDetails(), retriedRequest);
                return (DetachLoadBalancerResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetClusterNetworkResponse getClusterNetwork(GetClusterNetworkRequest request) {
        LOG.trace("Called getClusterNetwork");
        GetClusterNetworkRequest interceptedRequest = GetClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetClusterNetworkResponse> transformer = GetClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInstanceConfigurationResponse getInstanceConfiguration(GetInstanceConfigurationRequest request) {
        LOG.trace("Called getInstanceConfiguration");
        GetInstanceConfigurationRequest interceptedRequest = GetInstanceConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstanceConfigurationResponse> transformer = GetInstanceConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetInstanceConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInstancePoolResponse getInstancePool(GetInstancePoolRequest request) {
        LOG.trace("Called getInstancePool");
        GetInstancePoolRequest interceptedRequest = GetInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstancePoolResponse> transformer = GetInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInstancePoolLoadBalancerAttachmentResponse getInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request) {
        LOG.trace("Called getInstancePoolLoadBalancerAttachment");
        GetInstancePoolLoadBalancerAttachmentRequest interceptedRequest = GetInstancePoolLoadBalancerAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInstancePoolLoadBalancerAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInstancePoolLoadBalancerAttachmentResponse> transformer = GetInstancePoolLoadBalancerAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetInstancePoolLoadBalancerAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public LaunchInstanceConfigurationResponse launchInstanceConfiguration(LaunchInstanceConfigurationRequest request) {
        LOG.trace("Called launchInstanceConfiguration");
        LaunchInstanceConfigurationRequest interceptedRequest = LaunchInstanceConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = LaunchInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, LaunchInstanceConfigurationResponse> transformer = LaunchInstanceConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getInstanceConfiguration(), retriedRequest);
                return (LaunchInstanceConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListClusterNetworkInstancesResponse listClusterNetworkInstances(ListClusterNetworkInstancesRequest request) {
        LOG.trace("Called listClusterNetworkInstances");
        ListClusterNetworkInstancesRequest interceptedRequest = ListClusterNetworkInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListClusterNetworkInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListClusterNetworkInstancesResponse> transformer = ListClusterNetworkInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListClusterNetworkInstancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListClusterNetworksResponse listClusterNetworks(ListClusterNetworksRequest request) {
        LOG.trace("Called listClusterNetworks");
        ListClusterNetworksRequest interceptedRequest = ListClusterNetworksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListClusterNetworksConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListClusterNetworksResponse> transformer = ListClusterNetworksConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListClusterNetworksResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstanceConfigurationsResponse listInstanceConfigurations(ListInstanceConfigurationsRequest request) {
        LOG.trace("Called listInstanceConfigurations");
        ListInstanceConfigurationsRequest interceptedRequest = ListInstanceConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstanceConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstanceConfigurationsResponse> transformer = ListInstanceConfigurationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListInstanceConfigurationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstancePoolInstancesResponse listInstancePoolInstances(ListInstancePoolInstancesRequest request) {
        LOG.trace("Called listInstancePoolInstances");
        ListInstancePoolInstancesRequest interceptedRequest = ListInstancePoolInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstancePoolInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstancePoolInstancesResponse> transformer = ListInstancePoolInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListInstancePoolInstancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInstancePoolsResponse listInstancePools(ListInstancePoolsRequest request) {
        LOG.trace("Called listInstancePools");
        ListInstancePoolsRequest interceptedRequest = ListInstancePoolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInstancePoolsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInstancePoolsResponse> transformer = ListInstancePoolsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListInstancePoolsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ResetInstancePoolResponse resetInstancePool(ResetInstancePoolRequest request) {
        LOG.trace("Called resetInstancePool");
        ResetInstancePoolRequest interceptedRequest = ResetInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ResetInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ResetInstancePoolResponse> transformer = ResetInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (ResetInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SoftresetInstancePoolResponse softresetInstancePool(SoftresetInstancePoolRequest request) {
        LOG.trace("Called softresetInstancePool");
        SoftresetInstancePoolRequest interceptedRequest = SoftresetInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SoftresetInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SoftresetInstancePoolResponse> transformer = SoftresetInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (SoftresetInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartInstancePoolResponse startInstancePool(StartInstancePoolRequest request) {
        LOG.trace("Called startInstancePool");
        StartInstancePoolRequest interceptedRequest = StartInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartInstancePoolResponse> transformer = StartInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StartInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopInstancePoolResponse stopInstancePool(StopInstancePoolRequest request) {
        LOG.trace("Called stopInstancePool");
        StopInstancePoolRequest interceptedRequest = StopInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopInstancePoolResponse> transformer = StopInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StopInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TerminateClusterNetworkResponse terminateClusterNetwork(TerminateClusterNetworkRequest request) {
        LOG.trace("Called terminateClusterNetwork");
        TerminateClusterNetworkRequest interceptedRequest = TerminateClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TerminateClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TerminateClusterNetworkResponse> transformer = TerminateClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (TerminateClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TerminateInstancePoolResponse terminateInstancePool(TerminateInstancePoolRequest request) {
        LOG.trace("Called terminateInstancePool");
        TerminateInstancePoolRequest interceptedRequest = TerminateInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TerminateInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TerminateInstancePoolResponse> transformer = TerminateInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (TerminateInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateClusterNetworkResponse updateClusterNetwork(UpdateClusterNetworkRequest request) {
        LOG.trace("Called updateClusterNetwork");
        UpdateClusterNetworkRequest interceptedRequest = UpdateClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateClusterNetworkResponse> transformer = UpdateClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateClusterNetworkDetails(), retriedRequest);
                return (UpdateClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateInstanceConfigurationResponse updateInstanceConfiguration(UpdateInstanceConfigurationRequest request) {
        LOG.trace("Called updateInstanceConfiguration");
        UpdateInstanceConfigurationRequest interceptedRequest = UpdateInstanceConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateInstanceConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateInstanceConfigurationResponse> transformer = UpdateInstanceConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateInstanceConfigurationDetails(), retriedRequest);
                return (UpdateInstanceConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateInstancePoolResponse updateInstancePool(UpdateInstancePoolRequest request) {
        LOG.trace("Called updateInstancePool");
        UpdateInstancePoolRequest interceptedRequest = UpdateInstancePoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateInstancePoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateInstancePoolResponse> transformer = UpdateInstancePoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateInstancePoolDetails(), retriedRequest);
                return (UpdateInstancePoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ComputeManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ComputeManagementWaiters newWaiters(WorkRequest workRequestClient) {
        return new ComputeManagementWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public ComputeManagementPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ComputeManagementClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ComputeManagementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

