/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.core.ComputeManagement;
import com.oracle.bmc.core.model.ClusterNetworkSummary;
import com.oracle.bmc.core.model.InstanceConfigurationSummary;
import com.oracle.bmc.core.model.InstancePoolSummary;
import com.oracle.bmc.core.model.InstanceSummary;
import com.oracle.bmc.core.requests.ListClusterNetworkInstancesRequest;
import com.oracle.bmc.core.requests.ListClusterNetworksRequest;
import com.oracle.bmc.core.requests.ListInstanceConfigurationsRequest;
import com.oracle.bmc.core.requests.ListInstancePoolInstancesRequest;
import com.oracle.bmc.core.requests.ListInstancePoolsRequest;
import com.oracle.bmc.core.responses.ListClusterNetworkInstancesResponse;
import com.oracle.bmc.core.responses.ListClusterNetworksResponse;
import com.oracle.bmc.core.responses.ListInstanceConfigurationsResponse;
import com.oracle.bmc.core.responses.ListInstancePoolInstancesResponse;
import com.oracle.bmc.core.responses.ListInstancePoolsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ComputeManagementPaginators {
    private final ComputeManagement client;

    public Iterable<ListClusterNetworkInstancesResponse> listClusterNetworkInstancesResponseIterator(final ListClusterNetworkInstancesRequest request) {
        return new ResponseIterable<ListClusterNetworkInstancesRequest.Builder, ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse>(new Supplier<ListClusterNetworkInstancesRequest.Builder>(){

            public ListClusterNetworkInstancesRequest.Builder get() {
                return ListClusterNetworkInstancesRequest.builder().copy(request);
            }
        }, new Function<ListClusterNetworkInstancesResponse, String>(){

            public String apply(ListClusterNetworkInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListClusterNetworkInstancesRequest.Builder>, ListClusterNetworkInstancesRequest>(){

            public ListClusterNetworkInstancesRequest apply(RequestBuilderAndToken<ListClusterNetworkInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse>(){

            public ListClusterNetworkInstancesResponse apply(ListClusterNetworkInstancesRequest request) {
                return ComputeManagementPaginators.this.client.listClusterNetworkInstances(request);
            }
        });
    }

    public Iterable<InstanceSummary> listClusterNetworkInstancesRecordIterator(final ListClusterNetworkInstancesRequest request) {
        return new ResponseRecordIterable<ListClusterNetworkInstancesRequest.Builder, ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse, InstanceSummary>(new Supplier<ListClusterNetworkInstancesRequest.Builder>(){

            public ListClusterNetworkInstancesRequest.Builder get() {
                return ListClusterNetworkInstancesRequest.builder().copy(request);
            }
        }, new Function<ListClusterNetworkInstancesResponse, String>(){

            public String apply(ListClusterNetworkInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListClusterNetworkInstancesRequest.Builder>, ListClusterNetworkInstancesRequest>(){

            public ListClusterNetworkInstancesRequest apply(RequestBuilderAndToken<ListClusterNetworkInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse>(){

            public ListClusterNetworkInstancesResponse apply(ListClusterNetworkInstancesRequest request) {
                return ComputeManagementPaginators.this.client.listClusterNetworkInstances(request);
            }
        }, new Function<ListClusterNetworkInstancesResponse, List<InstanceSummary>>(){

            public List<InstanceSummary> apply(ListClusterNetworkInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListClusterNetworksResponse> listClusterNetworksResponseIterator(final ListClusterNetworksRequest request) {
        return new ResponseIterable<ListClusterNetworksRequest.Builder, ListClusterNetworksRequest, ListClusterNetworksResponse>(new Supplier<ListClusterNetworksRequest.Builder>(){

            public ListClusterNetworksRequest.Builder get() {
                return ListClusterNetworksRequest.builder().copy(request);
            }
        }, new Function<ListClusterNetworksResponse, String>(){

            public String apply(ListClusterNetworksResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListClusterNetworksRequest.Builder>, ListClusterNetworksRequest>(){

            public ListClusterNetworksRequest apply(RequestBuilderAndToken<ListClusterNetworksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListClusterNetworksRequest, ListClusterNetworksResponse>(){

            public ListClusterNetworksResponse apply(ListClusterNetworksRequest request) {
                return ComputeManagementPaginators.this.client.listClusterNetworks(request);
            }
        });
    }

    public Iterable<ClusterNetworkSummary> listClusterNetworksRecordIterator(final ListClusterNetworksRequest request) {
        return new ResponseRecordIterable<ListClusterNetworksRequest.Builder, ListClusterNetworksRequest, ListClusterNetworksResponse, ClusterNetworkSummary>(new Supplier<ListClusterNetworksRequest.Builder>(){

            public ListClusterNetworksRequest.Builder get() {
                return ListClusterNetworksRequest.builder().copy(request);
            }
        }, new Function<ListClusterNetworksResponse, String>(){

            public String apply(ListClusterNetworksResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListClusterNetworksRequest.Builder>, ListClusterNetworksRequest>(){

            public ListClusterNetworksRequest apply(RequestBuilderAndToken<ListClusterNetworksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListClusterNetworksRequest, ListClusterNetworksResponse>(){

            public ListClusterNetworksResponse apply(ListClusterNetworksRequest request) {
                return ComputeManagementPaginators.this.client.listClusterNetworks(request);
            }
        }, new Function<ListClusterNetworksResponse, List<ClusterNetworkSummary>>(){

            public List<ClusterNetworkSummary> apply(ListClusterNetworksResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListInstanceConfigurationsResponse> listInstanceConfigurationsResponseIterator(final ListInstanceConfigurationsRequest request) {
        return new ResponseIterable<ListInstanceConfigurationsRequest.Builder, ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse>(new Supplier<ListInstanceConfigurationsRequest.Builder>(){

            public ListInstanceConfigurationsRequest.Builder get() {
                return ListInstanceConfigurationsRequest.builder().copy(request);
            }
        }, new Function<ListInstanceConfigurationsResponse, String>(){

            public String apply(ListInstanceConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstanceConfigurationsRequest.Builder>, ListInstanceConfigurationsRequest>(){

            public ListInstanceConfigurationsRequest apply(RequestBuilderAndToken<ListInstanceConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse>(){

            public ListInstanceConfigurationsResponse apply(ListInstanceConfigurationsRequest request) {
                return ComputeManagementPaginators.this.client.listInstanceConfigurations(request);
            }
        });
    }

    public Iterable<InstanceConfigurationSummary> listInstanceConfigurationsRecordIterator(final ListInstanceConfigurationsRequest request) {
        return new ResponseRecordIterable<ListInstanceConfigurationsRequest.Builder, ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse, InstanceConfigurationSummary>(new Supplier<ListInstanceConfigurationsRequest.Builder>(){

            public ListInstanceConfigurationsRequest.Builder get() {
                return ListInstanceConfigurationsRequest.builder().copy(request);
            }
        }, new Function<ListInstanceConfigurationsResponse, String>(){

            public String apply(ListInstanceConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstanceConfigurationsRequest.Builder>, ListInstanceConfigurationsRequest>(){

            public ListInstanceConfigurationsRequest apply(RequestBuilderAndToken<ListInstanceConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse>(){

            public ListInstanceConfigurationsResponse apply(ListInstanceConfigurationsRequest request) {
                return ComputeManagementPaginators.this.client.listInstanceConfigurations(request);
            }
        }, new Function<ListInstanceConfigurationsResponse, List<InstanceConfigurationSummary>>(){

            public List<InstanceConfigurationSummary> apply(ListInstanceConfigurationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListInstancePoolInstancesResponse> listInstancePoolInstancesResponseIterator(final ListInstancePoolInstancesRequest request) {
        return new ResponseIterable<ListInstancePoolInstancesRequest.Builder, ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse>(new Supplier<ListInstancePoolInstancesRequest.Builder>(){

            public ListInstancePoolInstancesRequest.Builder get() {
                return ListInstancePoolInstancesRequest.builder().copy(request);
            }
        }, new Function<ListInstancePoolInstancesResponse, String>(){

            public String apply(ListInstancePoolInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstancePoolInstancesRequest.Builder>, ListInstancePoolInstancesRequest>(){

            public ListInstancePoolInstancesRequest apply(RequestBuilderAndToken<ListInstancePoolInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse>(){

            public ListInstancePoolInstancesResponse apply(ListInstancePoolInstancesRequest request) {
                return ComputeManagementPaginators.this.client.listInstancePoolInstances(request);
            }
        });
    }

    public Iterable<InstanceSummary> listInstancePoolInstancesRecordIterator(final ListInstancePoolInstancesRequest request) {
        return new ResponseRecordIterable<ListInstancePoolInstancesRequest.Builder, ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse, InstanceSummary>(new Supplier<ListInstancePoolInstancesRequest.Builder>(){

            public ListInstancePoolInstancesRequest.Builder get() {
                return ListInstancePoolInstancesRequest.builder().copy(request);
            }
        }, new Function<ListInstancePoolInstancesResponse, String>(){

            public String apply(ListInstancePoolInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstancePoolInstancesRequest.Builder>, ListInstancePoolInstancesRequest>(){

            public ListInstancePoolInstancesRequest apply(RequestBuilderAndToken<ListInstancePoolInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse>(){

            public ListInstancePoolInstancesResponse apply(ListInstancePoolInstancesRequest request) {
                return ComputeManagementPaginators.this.client.listInstancePoolInstances(request);
            }
        }, new Function<ListInstancePoolInstancesResponse, List<InstanceSummary>>(){

            public List<InstanceSummary> apply(ListInstancePoolInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListInstancePoolsResponse> listInstancePoolsResponseIterator(final ListInstancePoolsRequest request) {
        return new ResponseIterable<ListInstancePoolsRequest.Builder, ListInstancePoolsRequest, ListInstancePoolsResponse>(new Supplier<ListInstancePoolsRequest.Builder>(){

            public ListInstancePoolsRequest.Builder get() {
                return ListInstancePoolsRequest.builder().copy(request);
            }
        }, new Function<ListInstancePoolsResponse, String>(){

            public String apply(ListInstancePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstancePoolsRequest.Builder>, ListInstancePoolsRequest>(){

            public ListInstancePoolsRequest apply(RequestBuilderAndToken<ListInstancePoolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstancePoolsRequest, ListInstancePoolsResponse>(){

            public ListInstancePoolsResponse apply(ListInstancePoolsRequest request) {
                return ComputeManagementPaginators.this.client.listInstancePools(request);
            }
        });
    }

    public Iterable<InstancePoolSummary> listInstancePoolsRecordIterator(final ListInstancePoolsRequest request) {
        return new ResponseRecordIterable<ListInstancePoolsRequest.Builder, ListInstancePoolsRequest, ListInstancePoolsResponse, InstancePoolSummary>(new Supplier<ListInstancePoolsRequest.Builder>(){

            public ListInstancePoolsRequest.Builder get() {
                return ListInstancePoolsRequest.builder().copy(request);
            }
        }, new Function<ListInstancePoolsResponse, String>(){

            public String apply(ListInstancePoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstancePoolsRequest.Builder>, ListInstancePoolsRequest>(){

            public ListInstancePoolsRequest apply(RequestBuilderAndToken<ListInstancePoolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstancePoolsRequest, ListInstancePoolsResponse>(){

            public ListInstancePoolsResponse apply(ListInstancePoolsRequest request) {
                return ComputeManagementPaginators.this.client.listInstancePools(request);
            }
        }, new Function<ListInstancePoolsResponse, List<InstancePoolSummary>>(){

            public List<InstancePoolSummary> apply(ListInstancePoolsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ComputeManagementPaginators(ComputeManagement client) {
        this.client = client;
    }
}

