/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.core.ComputeManagement;
import com.oracle.bmc.core.model.ClusterNetwork;
import com.oracle.bmc.core.model.InstancePool;
import com.oracle.bmc.core.model.InstancePoolLoadBalancerAttachment;
import com.oracle.bmc.core.requests.CreateClusterNetworkRequest;
import com.oracle.bmc.core.requests.GetClusterNetworkRequest;
import com.oracle.bmc.core.requests.GetInstancePoolLoadBalancerAttachmentRequest;
import com.oracle.bmc.core.requests.GetInstancePoolRequest;
import com.oracle.bmc.core.requests.LaunchInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.TerminateClusterNetworkRequest;
import com.oracle.bmc.core.responses.CreateClusterNetworkResponse;
import com.oracle.bmc.core.responses.GetClusterNetworkResponse;
import com.oracle.bmc.core.responses.GetInstancePoolLoadBalancerAttachmentResponse;
import com.oracle.bmc.core.responses.GetInstancePoolResponse;
import com.oracle.bmc.core.responses.LaunchInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.TerminateClusterNetworkResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class ComputeManagementWaiters {
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final ComputeManagement client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public ComputeManagementWaiters(@NonNull ExecutorService executorService, @NonNull ComputeManagement client) {
        this(executorService, client, null);
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
    }

    public ComputeManagementWaiters(@NonNull ExecutorService executorService, @NonNull ComputeManagement client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<CreateClusterNetworkRequest, CreateClusterNetworkResponse> forCreateClusterNetwork(CreateClusterNetworkRequest request) {
        return this.forCreateClusterNetwork(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateClusterNetworkRequest, CreateClusterNetworkResponse> forCreateClusterNetwork(final CreateClusterNetworkRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<CreateClusterNetworkRequest, CreateClusterNetworkResponse>(this.executorService, new Callable<CreateClusterNetworkResponse>(){

            @Override
            public CreateClusterNetworkResponse call() throws Exception {
                CreateClusterNetworkResponse response = ComputeManagementWaiters.this.client.createClusterNetwork(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeManagementWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(GetClusterNetworkRequest request, ClusterNetwork.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forClusterNetwork(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(GetClusterNetworkRequest request, ClusterNetwork.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forClusterNetwork(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(GetClusterNetworkRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ClusterNetwork.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forClusterNetwork(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetClusterNetworkRequest, GetClusterNetworkResponse> forClusterNetwork(BmcGenericWaiter waiter, GetClusterNetworkRequest request, ClusterNetwork.LifecycleState ... targetStates) {
        final HashSet<ClusterNetwork.LifecycleState> targetStatesSet = new HashSet<ClusterNetwork.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetClusterNetworkRequest, GetClusterNetworkResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetClusterNetworkRequest, GetClusterNetworkResponse>(){

            public GetClusterNetworkResponse apply(GetClusterNetworkRequest request) {
                return ComputeManagementWaiters.this.client.getClusterNetwork(request);
            }
        }, new Predicate<GetClusterNetworkResponse>(){

            public boolean apply(GetClusterNetworkResponse response) {
                return targetStatesSet.contains((Object)response.getClusterNetwork().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ClusterNetwork.LifecycleState.Terminated)), request);
    }

    public Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(GetInstancePoolRequest request, InstancePool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstancePool(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(GetInstancePoolRequest request, InstancePool.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstancePool(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(GetInstancePoolRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstancePool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstancePool(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetInstancePoolRequest, GetInstancePoolResponse> forInstancePool(BmcGenericWaiter waiter, GetInstancePoolRequest request, InstancePool.LifecycleState ... targetStates) {
        final HashSet<InstancePool.LifecycleState> targetStatesSet = new HashSet<InstancePool.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetInstancePoolRequest, GetInstancePoolResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetInstancePoolRequest, GetInstancePoolResponse>(){

            public GetInstancePoolResponse apply(GetInstancePoolRequest request) {
                return ComputeManagementWaiters.this.client.getInstancePool(request);
            }
        }, new Predicate<GetInstancePoolResponse>(){

            public boolean apply(GetInstancePoolResponse response) {
                return targetStatesSet.contains((Object)response.getInstancePool().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InstancePool.LifecycleState.Terminated)), request);
    }

    public Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, InstancePoolLoadBalancerAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstancePoolLoadBalancerAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, InstancePoolLoadBalancerAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstancePoolLoadBalancerAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstancePoolLoadBalancerAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstancePoolLoadBalancerAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> forInstancePoolLoadBalancerAttachment(BmcGenericWaiter waiter, GetInstancePoolLoadBalancerAttachmentRequest request, InstancePoolLoadBalancerAttachment.LifecycleState ... targetStates) {
        final HashSet<InstancePoolLoadBalancerAttachment.LifecycleState> targetStatesSet = new HashSet<InstancePoolLoadBalancerAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse>(){

            public GetInstancePoolLoadBalancerAttachmentResponse apply(GetInstancePoolLoadBalancerAttachmentRequest request) {
                return ComputeManagementWaiters.this.client.getInstancePoolLoadBalancerAttachment(request);
            }
        }, new Predicate<GetInstancePoolLoadBalancerAttachmentResponse>(){

            public boolean apply(GetInstancePoolLoadBalancerAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getInstancePoolLoadBalancerAttachment().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> forLaunchInstanceConfiguration(LaunchInstanceConfigurationRequest request) {
        return this.forLaunchInstanceConfiguration(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> forLaunchInstanceConfiguration(final LaunchInstanceConfigurationRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse>(this.executorService, new Callable<LaunchInstanceConfigurationResponse>(){

            @Override
            public LaunchInstanceConfigurationResponse call() throws Exception {
                LaunchInstanceConfigurationResponse response = ComputeManagementWaiters.this.client.launchInstanceConfiguration(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeManagementWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> forTerminateClusterNetwork(TerminateClusterNetworkRequest request) {
        return this.forTerminateClusterNetwork(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> forTerminateClusterNetwork(final TerminateClusterNetworkRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse>(this.executorService, new Callable<TerminateClusterNetworkResponse>(){

            @Override
            public TerminateClusterNetworkResponse call() throws Exception {
                TerminateClusterNetworkResponse response = ComputeManagementWaiters.this.client.terminateClusterNetwork(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeManagementWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }
}

