/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.core.Compute;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersionSummary;
import com.oracle.bmc.core.model.AppCatalogListingSummary;
import com.oracle.bmc.core.model.AppCatalogSubscriptionSummary;
import com.oracle.bmc.core.model.BootVolumeAttachment;
import com.oracle.bmc.core.model.ConsoleHistory;
import com.oracle.bmc.core.model.DedicatedVmHostInstanceShapeSummary;
import com.oracle.bmc.core.model.DedicatedVmHostInstanceSummary;
import com.oracle.bmc.core.model.DedicatedVmHostShapeSummary;
import com.oracle.bmc.core.model.DedicatedVmHostSummary;
import com.oracle.bmc.core.model.Device;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.InstanceConsoleConnection;
import com.oracle.bmc.core.model.Shape;
import com.oracle.bmc.core.model.VnicAttachment;
import com.oracle.bmc.core.model.VolumeAttachment;
import com.oracle.bmc.core.requests.ListAppCatalogListingResourceVersionsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogSubscriptionsRequest;
import com.oracle.bmc.core.requests.ListBootVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.ListConsoleHistoriesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstanceShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstancesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostsRequest;
import com.oracle.bmc.core.requests.ListImagesRequest;
import com.oracle.bmc.core.requests.ListInstanceConsoleConnectionsRequest;
import com.oracle.bmc.core.requests.ListInstanceDevicesRequest;
import com.oracle.bmc.core.requests.ListInstancesRequest;
import com.oracle.bmc.core.requests.ListShapesRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.core.requests.ListVolumeAttachmentsRequest;
import com.oracle.bmc.core.responses.ListAppCatalogListingResourceVersionsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogSubscriptionsResponse;
import com.oracle.bmc.core.responses.ListBootVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.ListConsoleHistoriesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstanceShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstancesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostsResponse;
import com.oracle.bmc.core.responses.ListImagesResponse;
import com.oracle.bmc.core.responses.ListInstanceConsoleConnectionsResponse;
import com.oracle.bmc.core.responses.ListInstanceDevicesResponse;
import com.oracle.bmc.core.responses.ListInstancesResponse;
import com.oracle.bmc.core.responses.ListShapesResponse;
import com.oracle.bmc.core.responses.ListVnicAttachmentsResponse;
import com.oracle.bmc.core.responses.ListVolumeAttachmentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ComputePaginators {
    private final Compute client;

    public Iterable<ListAppCatalogListingResourceVersionsResponse> listAppCatalogListingResourceVersionsResponseIterator(final ListAppCatalogListingResourceVersionsRequest request) {
        return new ResponseIterable<ListAppCatalogListingResourceVersionsRequest.Builder, ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse>(new Supplier<ListAppCatalogListingResourceVersionsRequest.Builder>(){

            public ListAppCatalogListingResourceVersionsRequest.Builder get() {
                return ListAppCatalogListingResourceVersionsRequest.builder().copy(request);
            }
        }, new Function<ListAppCatalogListingResourceVersionsResponse, String>(){

            public String apply(ListAppCatalogListingResourceVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAppCatalogListingResourceVersionsRequest.Builder>, ListAppCatalogListingResourceVersionsRequest>(){

            public ListAppCatalogListingResourceVersionsRequest apply(RequestBuilderAndToken<ListAppCatalogListingResourceVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse>(){

            public ListAppCatalogListingResourceVersionsResponse apply(ListAppCatalogListingResourceVersionsRequest request) {
                return ComputePaginators.this.client.listAppCatalogListingResourceVersions(request);
            }
        });
    }

    public Iterable<AppCatalogListingResourceVersionSummary> listAppCatalogListingResourceVersionsRecordIterator(final ListAppCatalogListingResourceVersionsRequest request) {
        return new ResponseRecordIterable<ListAppCatalogListingResourceVersionsRequest.Builder, ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse, AppCatalogListingResourceVersionSummary>(new Supplier<ListAppCatalogListingResourceVersionsRequest.Builder>(){

            public ListAppCatalogListingResourceVersionsRequest.Builder get() {
                return ListAppCatalogListingResourceVersionsRequest.builder().copy(request);
            }
        }, new Function<ListAppCatalogListingResourceVersionsResponse, String>(){

            public String apply(ListAppCatalogListingResourceVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAppCatalogListingResourceVersionsRequest.Builder>, ListAppCatalogListingResourceVersionsRequest>(){

            public ListAppCatalogListingResourceVersionsRequest apply(RequestBuilderAndToken<ListAppCatalogListingResourceVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse>(){

            public ListAppCatalogListingResourceVersionsResponse apply(ListAppCatalogListingResourceVersionsRequest request) {
                return ComputePaginators.this.client.listAppCatalogListingResourceVersions(request);
            }
        }, new Function<ListAppCatalogListingResourceVersionsResponse, List<AppCatalogListingResourceVersionSummary>>(){

            public List<AppCatalogListingResourceVersionSummary> apply(ListAppCatalogListingResourceVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAppCatalogListingsResponse> listAppCatalogListingsResponseIterator(final ListAppCatalogListingsRequest request) {
        return new ResponseIterable<ListAppCatalogListingsRequest.Builder, ListAppCatalogListingsRequest, ListAppCatalogListingsResponse>(new Supplier<ListAppCatalogListingsRequest.Builder>(){

            public ListAppCatalogListingsRequest.Builder get() {
                return ListAppCatalogListingsRequest.builder().copy(request);
            }
        }, new Function<ListAppCatalogListingsResponse, String>(){

            public String apply(ListAppCatalogListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAppCatalogListingsRequest.Builder>, ListAppCatalogListingsRequest>(){

            public ListAppCatalogListingsRequest apply(RequestBuilderAndToken<ListAppCatalogListingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse>(){

            public ListAppCatalogListingsResponse apply(ListAppCatalogListingsRequest request) {
                return ComputePaginators.this.client.listAppCatalogListings(request);
            }
        });
    }

    public Iterable<AppCatalogListingSummary> listAppCatalogListingsRecordIterator(final ListAppCatalogListingsRequest request) {
        return new ResponseRecordIterable<ListAppCatalogListingsRequest.Builder, ListAppCatalogListingsRequest, ListAppCatalogListingsResponse, AppCatalogListingSummary>(new Supplier<ListAppCatalogListingsRequest.Builder>(){

            public ListAppCatalogListingsRequest.Builder get() {
                return ListAppCatalogListingsRequest.builder().copy(request);
            }
        }, new Function<ListAppCatalogListingsResponse, String>(){

            public String apply(ListAppCatalogListingsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAppCatalogListingsRequest.Builder>, ListAppCatalogListingsRequest>(){

            public ListAppCatalogListingsRequest apply(RequestBuilderAndToken<ListAppCatalogListingsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse>(){

            public ListAppCatalogListingsResponse apply(ListAppCatalogListingsRequest request) {
                return ComputePaginators.this.client.listAppCatalogListings(request);
            }
        }, new Function<ListAppCatalogListingsResponse, List<AppCatalogListingSummary>>(){

            public List<AppCatalogListingSummary> apply(ListAppCatalogListingsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAppCatalogSubscriptionsResponse> listAppCatalogSubscriptionsResponseIterator(final ListAppCatalogSubscriptionsRequest request) {
        return new ResponseIterable<ListAppCatalogSubscriptionsRequest.Builder, ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse>(new Supplier<ListAppCatalogSubscriptionsRequest.Builder>(){

            public ListAppCatalogSubscriptionsRequest.Builder get() {
                return ListAppCatalogSubscriptionsRequest.builder().copy(request);
            }
        }, new Function<ListAppCatalogSubscriptionsResponse, String>(){

            public String apply(ListAppCatalogSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAppCatalogSubscriptionsRequest.Builder>, ListAppCatalogSubscriptionsRequest>(){

            public ListAppCatalogSubscriptionsRequest apply(RequestBuilderAndToken<ListAppCatalogSubscriptionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse>(){

            public ListAppCatalogSubscriptionsResponse apply(ListAppCatalogSubscriptionsRequest request) {
                return ComputePaginators.this.client.listAppCatalogSubscriptions(request);
            }
        });
    }

    public Iterable<AppCatalogSubscriptionSummary> listAppCatalogSubscriptionsRecordIterator(final ListAppCatalogSubscriptionsRequest request) {
        return new ResponseRecordIterable<ListAppCatalogSubscriptionsRequest.Builder, ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse, AppCatalogSubscriptionSummary>(new Supplier<ListAppCatalogSubscriptionsRequest.Builder>(){

            public ListAppCatalogSubscriptionsRequest.Builder get() {
                return ListAppCatalogSubscriptionsRequest.builder().copy(request);
            }
        }, new Function<ListAppCatalogSubscriptionsResponse, String>(){

            public String apply(ListAppCatalogSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAppCatalogSubscriptionsRequest.Builder>, ListAppCatalogSubscriptionsRequest>(){

            public ListAppCatalogSubscriptionsRequest apply(RequestBuilderAndToken<ListAppCatalogSubscriptionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse>(){

            public ListAppCatalogSubscriptionsResponse apply(ListAppCatalogSubscriptionsRequest request) {
                return ComputePaginators.this.client.listAppCatalogSubscriptions(request);
            }
        }, new Function<ListAppCatalogSubscriptionsResponse, List<AppCatalogSubscriptionSummary>>(){

            public List<AppCatalogSubscriptionSummary> apply(ListAppCatalogSubscriptionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBootVolumeAttachmentsResponse> listBootVolumeAttachmentsResponseIterator(final ListBootVolumeAttachmentsRequest request) {
        return new ResponseIterable<ListBootVolumeAttachmentsRequest.Builder, ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse>(new Supplier<ListBootVolumeAttachmentsRequest.Builder>(){

            public ListBootVolumeAttachmentsRequest.Builder get() {
                return ListBootVolumeAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListBootVolumeAttachmentsResponse, String>(){

            public String apply(ListBootVolumeAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListBootVolumeAttachmentsRequest.Builder>, ListBootVolumeAttachmentsRequest>(){

            public ListBootVolumeAttachmentsRequest apply(RequestBuilderAndToken<ListBootVolumeAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse>(){

            public ListBootVolumeAttachmentsResponse apply(ListBootVolumeAttachmentsRequest request) {
                return ComputePaginators.this.client.listBootVolumeAttachments(request);
            }
        });
    }

    public Iterable<BootVolumeAttachment> listBootVolumeAttachmentsRecordIterator(final ListBootVolumeAttachmentsRequest request) {
        return new ResponseRecordIterable<ListBootVolumeAttachmentsRequest.Builder, ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse, BootVolumeAttachment>(new Supplier<ListBootVolumeAttachmentsRequest.Builder>(){

            public ListBootVolumeAttachmentsRequest.Builder get() {
                return ListBootVolumeAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListBootVolumeAttachmentsResponse, String>(){

            public String apply(ListBootVolumeAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListBootVolumeAttachmentsRequest.Builder>, ListBootVolumeAttachmentsRequest>(){

            public ListBootVolumeAttachmentsRequest apply(RequestBuilderAndToken<ListBootVolumeAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse>(){

            public ListBootVolumeAttachmentsResponse apply(ListBootVolumeAttachmentsRequest request) {
                return ComputePaginators.this.client.listBootVolumeAttachments(request);
            }
        }, new Function<ListBootVolumeAttachmentsResponse, List<BootVolumeAttachment>>(){

            public List<BootVolumeAttachment> apply(ListBootVolumeAttachmentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListConsoleHistoriesResponse> listConsoleHistoriesResponseIterator(final ListConsoleHistoriesRequest request) {
        return new ResponseIterable<ListConsoleHistoriesRequest.Builder, ListConsoleHistoriesRequest, ListConsoleHistoriesResponse>(new Supplier<ListConsoleHistoriesRequest.Builder>(){

            public ListConsoleHistoriesRequest.Builder get() {
                return ListConsoleHistoriesRequest.builder().copy(request);
            }
        }, new Function<ListConsoleHistoriesResponse, String>(){

            public String apply(ListConsoleHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListConsoleHistoriesRequest.Builder>, ListConsoleHistoriesRequest>(){

            public ListConsoleHistoriesRequest apply(RequestBuilderAndToken<ListConsoleHistoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse>(){

            public ListConsoleHistoriesResponse apply(ListConsoleHistoriesRequest request) {
                return ComputePaginators.this.client.listConsoleHistories(request);
            }
        });
    }

    public Iterable<ConsoleHistory> listConsoleHistoriesRecordIterator(final ListConsoleHistoriesRequest request) {
        return new ResponseRecordIterable<ListConsoleHistoriesRequest.Builder, ListConsoleHistoriesRequest, ListConsoleHistoriesResponse, ConsoleHistory>(new Supplier<ListConsoleHistoriesRequest.Builder>(){

            public ListConsoleHistoriesRequest.Builder get() {
                return ListConsoleHistoriesRequest.builder().copy(request);
            }
        }, new Function<ListConsoleHistoriesResponse, String>(){

            public String apply(ListConsoleHistoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListConsoleHistoriesRequest.Builder>, ListConsoleHistoriesRequest>(){

            public ListConsoleHistoriesRequest apply(RequestBuilderAndToken<ListConsoleHistoriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse>(){

            public ListConsoleHistoriesResponse apply(ListConsoleHistoriesRequest request) {
                return ComputePaginators.this.client.listConsoleHistories(request);
            }
        }, new Function<ListConsoleHistoriesResponse, List<ConsoleHistory>>(){

            public List<ConsoleHistory> apply(ListConsoleHistoriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDedicatedVmHostInstanceShapesResponse> listDedicatedVmHostInstanceShapesResponseIterator(final ListDedicatedVmHostInstanceShapesRequest request) {
        return new ResponseIterable<ListDedicatedVmHostInstanceShapesRequest.Builder, ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse>(new Supplier<ListDedicatedVmHostInstanceShapesRequest.Builder>(){

            public ListDedicatedVmHostInstanceShapesRequest.Builder get() {
                return ListDedicatedVmHostInstanceShapesRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostInstanceShapesResponse, String>(){

            public String apply(ListDedicatedVmHostInstanceShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostInstanceShapesRequest.Builder>, ListDedicatedVmHostInstanceShapesRequest>(){

            public ListDedicatedVmHostInstanceShapesRequest apply(RequestBuilderAndToken<ListDedicatedVmHostInstanceShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse>(){

            public ListDedicatedVmHostInstanceShapesResponse apply(ListDedicatedVmHostInstanceShapesRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHostInstanceShapes(request);
            }
        });
    }

    public Iterable<DedicatedVmHostInstanceShapeSummary> listDedicatedVmHostInstanceShapesRecordIterator(final ListDedicatedVmHostInstanceShapesRequest request) {
        return new ResponseRecordIterable<ListDedicatedVmHostInstanceShapesRequest.Builder, ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse, DedicatedVmHostInstanceShapeSummary>(new Supplier<ListDedicatedVmHostInstanceShapesRequest.Builder>(){

            public ListDedicatedVmHostInstanceShapesRequest.Builder get() {
                return ListDedicatedVmHostInstanceShapesRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostInstanceShapesResponse, String>(){

            public String apply(ListDedicatedVmHostInstanceShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostInstanceShapesRequest.Builder>, ListDedicatedVmHostInstanceShapesRequest>(){

            public ListDedicatedVmHostInstanceShapesRequest apply(RequestBuilderAndToken<ListDedicatedVmHostInstanceShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse>(){

            public ListDedicatedVmHostInstanceShapesResponse apply(ListDedicatedVmHostInstanceShapesRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHostInstanceShapes(request);
            }
        }, new Function<ListDedicatedVmHostInstanceShapesResponse, List<DedicatedVmHostInstanceShapeSummary>>(){

            public List<DedicatedVmHostInstanceShapeSummary> apply(ListDedicatedVmHostInstanceShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDedicatedVmHostInstancesResponse> listDedicatedVmHostInstancesResponseIterator(final ListDedicatedVmHostInstancesRequest request) {
        return new ResponseIterable<ListDedicatedVmHostInstancesRequest.Builder, ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse>(new Supplier<ListDedicatedVmHostInstancesRequest.Builder>(){

            public ListDedicatedVmHostInstancesRequest.Builder get() {
                return ListDedicatedVmHostInstancesRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostInstancesResponse, String>(){

            public String apply(ListDedicatedVmHostInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostInstancesRequest.Builder>, ListDedicatedVmHostInstancesRequest>(){

            public ListDedicatedVmHostInstancesRequest apply(RequestBuilderAndToken<ListDedicatedVmHostInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse>(){

            public ListDedicatedVmHostInstancesResponse apply(ListDedicatedVmHostInstancesRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHostInstances(request);
            }
        });
    }

    public Iterable<DedicatedVmHostInstanceSummary> listDedicatedVmHostInstancesRecordIterator(final ListDedicatedVmHostInstancesRequest request) {
        return new ResponseRecordIterable<ListDedicatedVmHostInstancesRequest.Builder, ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse, DedicatedVmHostInstanceSummary>(new Supplier<ListDedicatedVmHostInstancesRequest.Builder>(){

            public ListDedicatedVmHostInstancesRequest.Builder get() {
                return ListDedicatedVmHostInstancesRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostInstancesResponse, String>(){

            public String apply(ListDedicatedVmHostInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostInstancesRequest.Builder>, ListDedicatedVmHostInstancesRequest>(){

            public ListDedicatedVmHostInstancesRequest apply(RequestBuilderAndToken<ListDedicatedVmHostInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse>(){

            public ListDedicatedVmHostInstancesResponse apply(ListDedicatedVmHostInstancesRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHostInstances(request);
            }
        }, new Function<ListDedicatedVmHostInstancesResponse, List<DedicatedVmHostInstanceSummary>>(){

            public List<DedicatedVmHostInstanceSummary> apply(ListDedicatedVmHostInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDedicatedVmHostShapesResponse> listDedicatedVmHostShapesResponseIterator(final ListDedicatedVmHostShapesRequest request) {
        return new ResponseIterable<ListDedicatedVmHostShapesRequest.Builder, ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse>(new Supplier<ListDedicatedVmHostShapesRequest.Builder>(){

            public ListDedicatedVmHostShapesRequest.Builder get() {
                return ListDedicatedVmHostShapesRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostShapesResponse, String>(){

            public String apply(ListDedicatedVmHostShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostShapesRequest.Builder>, ListDedicatedVmHostShapesRequest>(){

            public ListDedicatedVmHostShapesRequest apply(RequestBuilderAndToken<ListDedicatedVmHostShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse>(){

            public ListDedicatedVmHostShapesResponse apply(ListDedicatedVmHostShapesRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHostShapes(request);
            }
        });
    }

    public Iterable<DedicatedVmHostShapeSummary> listDedicatedVmHostShapesRecordIterator(final ListDedicatedVmHostShapesRequest request) {
        return new ResponseRecordIterable<ListDedicatedVmHostShapesRequest.Builder, ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse, DedicatedVmHostShapeSummary>(new Supplier<ListDedicatedVmHostShapesRequest.Builder>(){

            public ListDedicatedVmHostShapesRequest.Builder get() {
                return ListDedicatedVmHostShapesRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostShapesResponse, String>(){

            public String apply(ListDedicatedVmHostShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostShapesRequest.Builder>, ListDedicatedVmHostShapesRequest>(){

            public ListDedicatedVmHostShapesRequest apply(RequestBuilderAndToken<ListDedicatedVmHostShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse>(){

            public ListDedicatedVmHostShapesResponse apply(ListDedicatedVmHostShapesRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHostShapes(request);
            }
        }, new Function<ListDedicatedVmHostShapesResponse, List<DedicatedVmHostShapeSummary>>(){

            public List<DedicatedVmHostShapeSummary> apply(ListDedicatedVmHostShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDedicatedVmHostsResponse> listDedicatedVmHostsResponseIterator(final ListDedicatedVmHostsRequest request) {
        return new ResponseIterable<ListDedicatedVmHostsRequest.Builder, ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse>(new Supplier<ListDedicatedVmHostsRequest.Builder>(){

            public ListDedicatedVmHostsRequest.Builder get() {
                return ListDedicatedVmHostsRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostsResponse, String>(){

            public String apply(ListDedicatedVmHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostsRequest.Builder>, ListDedicatedVmHostsRequest>(){

            public ListDedicatedVmHostsRequest apply(RequestBuilderAndToken<ListDedicatedVmHostsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse>(){

            public ListDedicatedVmHostsResponse apply(ListDedicatedVmHostsRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHosts(request);
            }
        });
    }

    public Iterable<DedicatedVmHostSummary> listDedicatedVmHostsRecordIterator(final ListDedicatedVmHostsRequest request) {
        return new ResponseRecordIterable<ListDedicatedVmHostsRequest.Builder, ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse, DedicatedVmHostSummary>(new Supplier<ListDedicatedVmHostsRequest.Builder>(){

            public ListDedicatedVmHostsRequest.Builder get() {
                return ListDedicatedVmHostsRequest.builder().copy(request);
            }
        }, new Function<ListDedicatedVmHostsResponse, String>(){

            public String apply(ListDedicatedVmHostsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDedicatedVmHostsRequest.Builder>, ListDedicatedVmHostsRequest>(){

            public ListDedicatedVmHostsRequest apply(RequestBuilderAndToken<ListDedicatedVmHostsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse>(){

            public ListDedicatedVmHostsResponse apply(ListDedicatedVmHostsRequest request) {
                return ComputePaginators.this.client.listDedicatedVmHosts(request);
            }
        }, new Function<ListDedicatedVmHostsResponse, List<DedicatedVmHostSummary>>(){

            public List<DedicatedVmHostSummary> apply(ListDedicatedVmHostsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListImagesResponse> listImagesResponseIterator(final ListImagesRequest request) {
        return new ResponseIterable<ListImagesRequest.Builder, ListImagesRequest, ListImagesResponse>(new Supplier<ListImagesRequest.Builder>(){

            public ListImagesRequest.Builder get() {
                return ListImagesRequest.builder().copy(request);
            }
        }, new Function<ListImagesResponse, String>(){

            public String apply(ListImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListImagesRequest.Builder>, ListImagesRequest>(){

            public ListImagesRequest apply(RequestBuilderAndToken<ListImagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListImagesRequest, ListImagesResponse>(){

            public ListImagesResponse apply(ListImagesRequest request) {
                return ComputePaginators.this.client.listImages(request);
            }
        });
    }

    public Iterable<Image> listImagesRecordIterator(final ListImagesRequest request) {
        return new ResponseRecordIterable<ListImagesRequest.Builder, ListImagesRequest, ListImagesResponse, Image>(new Supplier<ListImagesRequest.Builder>(){

            public ListImagesRequest.Builder get() {
                return ListImagesRequest.builder().copy(request);
            }
        }, new Function<ListImagesResponse, String>(){

            public String apply(ListImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListImagesRequest.Builder>, ListImagesRequest>(){

            public ListImagesRequest apply(RequestBuilderAndToken<ListImagesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListImagesRequest, ListImagesResponse>(){

            public ListImagesResponse apply(ListImagesRequest request) {
                return ComputePaginators.this.client.listImages(request);
            }
        }, new Function<ListImagesResponse, List<Image>>(){

            public List<Image> apply(ListImagesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListInstanceConsoleConnectionsResponse> listInstanceConsoleConnectionsResponseIterator(final ListInstanceConsoleConnectionsRequest request) {
        return new ResponseIterable<ListInstanceConsoleConnectionsRequest.Builder, ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse>(new Supplier<ListInstanceConsoleConnectionsRequest.Builder>(){

            public ListInstanceConsoleConnectionsRequest.Builder get() {
                return ListInstanceConsoleConnectionsRequest.builder().copy(request);
            }
        }, new Function<ListInstanceConsoleConnectionsResponse, String>(){

            public String apply(ListInstanceConsoleConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstanceConsoleConnectionsRequest.Builder>, ListInstanceConsoleConnectionsRequest>(){

            public ListInstanceConsoleConnectionsRequest apply(RequestBuilderAndToken<ListInstanceConsoleConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse>(){

            public ListInstanceConsoleConnectionsResponse apply(ListInstanceConsoleConnectionsRequest request) {
                return ComputePaginators.this.client.listInstanceConsoleConnections(request);
            }
        });
    }

    public Iterable<InstanceConsoleConnection> listInstanceConsoleConnectionsRecordIterator(final ListInstanceConsoleConnectionsRequest request) {
        return new ResponseRecordIterable<ListInstanceConsoleConnectionsRequest.Builder, ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse, InstanceConsoleConnection>(new Supplier<ListInstanceConsoleConnectionsRequest.Builder>(){

            public ListInstanceConsoleConnectionsRequest.Builder get() {
                return ListInstanceConsoleConnectionsRequest.builder().copy(request);
            }
        }, new Function<ListInstanceConsoleConnectionsResponse, String>(){

            public String apply(ListInstanceConsoleConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstanceConsoleConnectionsRequest.Builder>, ListInstanceConsoleConnectionsRequest>(){

            public ListInstanceConsoleConnectionsRequest apply(RequestBuilderAndToken<ListInstanceConsoleConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse>(){

            public ListInstanceConsoleConnectionsResponse apply(ListInstanceConsoleConnectionsRequest request) {
                return ComputePaginators.this.client.listInstanceConsoleConnections(request);
            }
        }, new Function<ListInstanceConsoleConnectionsResponse, List<InstanceConsoleConnection>>(){

            public List<InstanceConsoleConnection> apply(ListInstanceConsoleConnectionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListInstanceDevicesResponse> listInstanceDevicesResponseIterator(final ListInstanceDevicesRequest request) {
        return new ResponseIterable<ListInstanceDevicesRequest.Builder, ListInstanceDevicesRequest, ListInstanceDevicesResponse>(new Supplier<ListInstanceDevicesRequest.Builder>(){

            public ListInstanceDevicesRequest.Builder get() {
                return ListInstanceDevicesRequest.builder().copy(request);
            }
        }, new Function<ListInstanceDevicesResponse, String>(){

            public String apply(ListInstanceDevicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstanceDevicesRequest.Builder>, ListInstanceDevicesRequest>(){

            public ListInstanceDevicesRequest apply(RequestBuilderAndToken<ListInstanceDevicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstanceDevicesRequest, ListInstanceDevicesResponse>(){

            public ListInstanceDevicesResponse apply(ListInstanceDevicesRequest request) {
                return ComputePaginators.this.client.listInstanceDevices(request);
            }
        });
    }

    public Iterable<Device> listInstanceDevicesRecordIterator(final ListInstanceDevicesRequest request) {
        return new ResponseRecordIterable<ListInstanceDevicesRequest.Builder, ListInstanceDevicesRequest, ListInstanceDevicesResponse, Device>(new Supplier<ListInstanceDevicesRequest.Builder>(){

            public ListInstanceDevicesRequest.Builder get() {
                return ListInstanceDevicesRequest.builder().copy(request);
            }
        }, new Function<ListInstanceDevicesResponse, String>(){

            public String apply(ListInstanceDevicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstanceDevicesRequest.Builder>, ListInstanceDevicesRequest>(){

            public ListInstanceDevicesRequest apply(RequestBuilderAndToken<ListInstanceDevicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstanceDevicesRequest, ListInstanceDevicesResponse>(){

            public ListInstanceDevicesResponse apply(ListInstanceDevicesRequest request) {
                return ComputePaginators.this.client.listInstanceDevices(request);
            }
        }, new Function<ListInstanceDevicesResponse, List<Device>>(){

            public List<Device> apply(ListInstanceDevicesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListInstancesResponse> listInstancesResponseIterator(final ListInstancesRequest request) {
        return new ResponseIterable<ListInstancesRequest.Builder, ListInstancesRequest, ListInstancesResponse>(new Supplier<ListInstancesRequest.Builder>(){

            public ListInstancesRequest.Builder get() {
                return ListInstancesRequest.builder().copy(request);
            }
        }, new Function<ListInstancesResponse, String>(){

            public String apply(ListInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstancesRequest.Builder>, ListInstancesRequest>(){

            public ListInstancesRequest apply(RequestBuilderAndToken<ListInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstancesRequest, ListInstancesResponse>(){

            public ListInstancesResponse apply(ListInstancesRequest request) {
                return ComputePaginators.this.client.listInstances(request);
            }
        });
    }

    public Iterable<Instance> listInstancesRecordIterator(final ListInstancesRequest request) {
        return new ResponseRecordIterable<ListInstancesRequest.Builder, ListInstancesRequest, ListInstancesResponse, Instance>(new Supplier<ListInstancesRequest.Builder>(){

            public ListInstancesRequest.Builder get() {
                return ListInstancesRequest.builder().copy(request);
            }
        }, new Function<ListInstancesResponse, String>(){

            public String apply(ListInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInstancesRequest.Builder>, ListInstancesRequest>(){

            public ListInstancesRequest apply(RequestBuilderAndToken<ListInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInstancesRequest, ListInstancesResponse>(){

            public ListInstancesResponse apply(ListInstancesRequest request) {
                return ComputePaginators.this.client.listInstances(request);
            }
        }, new Function<ListInstancesResponse, List<Instance>>(){

            public List<Instance> apply(ListInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListShapesResponse> listShapesResponseIterator(final ListShapesRequest request) {
        return new ResponseIterable<ListShapesRequest.Builder, ListShapesRequest, ListShapesResponse>(new Supplier<ListShapesRequest.Builder>(){

            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, new Function<ListShapesResponse, String>(){

            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListShapesRequest, ListShapesResponse>(){

            public ListShapesResponse apply(ListShapesRequest request) {
                return ComputePaginators.this.client.listShapes(request);
            }
        });
    }

    public Iterable<Shape> listShapesRecordIterator(final ListShapesRequest request) {
        return new ResponseRecordIterable<ListShapesRequest.Builder, ListShapesRequest, ListShapesResponse, Shape>(new Supplier<ListShapesRequest.Builder>(){

            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, new Function<ListShapesResponse, String>(){

            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListShapesRequest, ListShapesResponse>(){

            public ListShapesResponse apply(ListShapesRequest request) {
                return ComputePaginators.this.client.listShapes(request);
            }
        }, new Function<ListShapesResponse, List<Shape>>(){

            public List<Shape> apply(ListShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVnicAttachmentsResponse> listVnicAttachmentsResponseIterator(final ListVnicAttachmentsRequest request) {
        return new ResponseIterable<ListVnicAttachmentsRequest.Builder, ListVnicAttachmentsRequest, ListVnicAttachmentsResponse>(new Supplier<ListVnicAttachmentsRequest.Builder>(){

            public ListVnicAttachmentsRequest.Builder get() {
                return ListVnicAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListVnicAttachmentsResponse, String>(){

            public String apply(ListVnicAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVnicAttachmentsRequest.Builder>, ListVnicAttachmentsRequest>(){

            public ListVnicAttachmentsRequest apply(RequestBuilderAndToken<ListVnicAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse>(){

            public ListVnicAttachmentsResponse apply(ListVnicAttachmentsRequest request) {
                return ComputePaginators.this.client.listVnicAttachments(request);
            }
        });
    }

    public Iterable<VnicAttachment> listVnicAttachmentsRecordIterator(final ListVnicAttachmentsRequest request) {
        return new ResponseRecordIterable<ListVnicAttachmentsRequest.Builder, ListVnicAttachmentsRequest, ListVnicAttachmentsResponse, VnicAttachment>(new Supplier<ListVnicAttachmentsRequest.Builder>(){

            public ListVnicAttachmentsRequest.Builder get() {
                return ListVnicAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListVnicAttachmentsResponse, String>(){

            public String apply(ListVnicAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVnicAttachmentsRequest.Builder>, ListVnicAttachmentsRequest>(){

            public ListVnicAttachmentsRequest apply(RequestBuilderAndToken<ListVnicAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse>(){

            public ListVnicAttachmentsResponse apply(ListVnicAttachmentsRequest request) {
                return ComputePaginators.this.client.listVnicAttachments(request);
            }
        }, new Function<ListVnicAttachmentsResponse, List<VnicAttachment>>(){

            public List<VnicAttachment> apply(ListVnicAttachmentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVolumeAttachmentsResponse> listVolumeAttachmentsResponseIterator(final ListVolumeAttachmentsRequest request) {
        return new ResponseIterable<ListVolumeAttachmentsRequest.Builder, ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse>(new Supplier<ListVolumeAttachmentsRequest.Builder>(){

            public ListVolumeAttachmentsRequest.Builder get() {
                return ListVolumeAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListVolumeAttachmentsResponse, String>(){

            public String apply(ListVolumeAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVolumeAttachmentsRequest.Builder>, ListVolumeAttachmentsRequest>(){

            public ListVolumeAttachmentsRequest apply(RequestBuilderAndToken<ListVolumeAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse>(){

            public ListVolumeAttachmentsResponse apply(ListVolumeAttachmentsRequest request) {
                return ComputePaginators.this.client.listVolumeAttachments(request);
            }
        });
    }

    public Iterable<VolumeAttachment> listVolumeAttachmentsRecordIterator(final ListVolumeAttachmentsRequest request) {
        return new ResponseRecordIterable<ListVolumeAttachmentsRequest.Builder, ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse, VolumeAttachment>(new Supplier<ListVolumeAttachmentsRequest.Builder>(){

            public ListVolumeAttachmentsRequest.Builder get() {
                return ListVolumeAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListVolumeAttachmentsResponse, String>(){

            public String apply(ListVolumeAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVolumeAttachmentsRequest.Builder>, ListVolumeAttachmentsRequest>(){

            public ListVolumeAttachmentsRequest apply(RequestBuilderAndToken<ListVolumeAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse>(){

            public ListVolumeAttachmentsResponse apply(ListVolumeAttachmentsRequest request) {
                return ComputePaginators.this.client.listVolumeAttachments(request);
            }
        }, new Function<ListVolumeAttachmentsResponse, List<VolumeAttachment>>(){

            public List<VolumeAttachment> apply(ListVolumeAttachmentsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ComputePaginators(Compute client) {
        this.client = client;
    }
}

