/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.core.Compute;
import com.oracle.bmc.core.model.BootVolumeAttachment;
import com.oracle.bmc.core.model.ConsoleHistory;
import com.oracle.bmc.core.model.DedicatedVmHost;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.InstanceConsoleConnection;
import com.oracle.bmc.core.model.VnicAttachment;
import com.oracle.bmc.core.model.VolumeAttachment;
import com.oracle.bmc.core.requests.ChangeDedicatedVmHostCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceCompartmentRequest;
import com.oracle.bmc.core.requests.CreateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.CreateImageRequest;
import com.oracle.bmc.core.requests.DeleteDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.ExportImageRequest;
import com.oracle.bmc.core.requests.GetBootVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryRequest;
import com.oracle.bmc.core.requests.GetDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.GetImageRequest;
import com.oracle.bmc.core.requests.GetInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.GetInstanceRequest;
import com.oracle.bmc.core.requests.GetVnicAttachmentRequest;
import com.oracle.bmc.core.requests.GetVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.responses.ChangeDedicatedVmHostCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceCompartmentResponse;
import com.oracle.bmc.core.responses.CreateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.CreateImageResponse;
import com.oracle.bmc.core.responses.DeleteDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.ExportImageResponse;
import com.oracle.bmc.core.responses.GetBootVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryResponse;
import com.oracle.bmc.core.responses.GetDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.GetImageResponse;
import com.oracle.bmc.core.responses.GetInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.GetInstanceResponse;
import com.oracle.bmc.core.responses.GetVnicAttachmentResponse;
import com.oracle.bmc.core.responses.GetVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.LaunchInstanceResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class ComputeWaiters {
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final Compute client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public ComputeWaiters(@NonNull ExecutorService executorService, @NonNull Compute client) {
        this(executorService, client, null);
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
    }

    public ComputeWaiters(@NonNull ExecutorService executorService, @NonNull Compute client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> forChangeDedicatedVmHostCompartment(ChangeDedicatedVmHostCompartmentRequest request) {
        return this.forChangeDedicatedVmHostCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> forChangeDedicatedVmHostCompartment(final ChangeDedicatedVmHostCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse>(this.executorService, new Callable<ChangeDedicatedVmHostCompartmentResponse>(){

            @Override
            public ChangeDedicatedVmHostCompartmentResponse call() throws Exception {
                ChangeDedicatedVmHostCompartmentResponse response = ComputeWaiters.this.client.changeDedicatedVmHostCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> forChangeInstanceCompartment(ChangeInstanceCompartmentRequest request) {
        return this.forChangeInstanceCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> forChangeInstanceCompartment(final ChangeInstanceCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse>(this.executorService, new Callable<ChangeInstanceCompartmentResponse>(){

            @Override
            public ChangeInstanceCompartmentResponse call() throws Exception {
                ChangeInstanceCompartmentResponse response = ComputeWaiters.this.client.changeInstanceCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> forCreateDedicatedVmHost(CreateDedicatedVmHostRequest request) {
        return this.forCreateDedicatedVmHost(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> forCreateDedicatedVmHost(final CreateDedicatedVmHostRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse>(this.executorService, new Callable<CreateDedicatedVmHostResponse>(){

            @Override
            public CreateDedicatedVmHostResponse call() throws Exception {
                CreateDedicatedVmHostResponse response = ComputeWaiters.this.client.createDedicatedVmHost(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<CreateImageRequest, CreateImageResponse> forCreateImage(CreateImageRequest request) {
        return this.forCreateImage(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateImageRequest, CreateImageResponse> forCreateImage(final CreateImageRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<CreateImageRequest, CreateImageResponse>(this.executorService, new Callable<CreateImageResponse>(){

            @Override
            public CreateImageResponse call() throws Exception {
                CreateImageResponse response = ComputeWaiters.this.client.createImage(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> forDeleteDedicatedVmHost(DeleteDedicatedVmHostRequest request) {
        return this.forDeleteDedicatedVmHost(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> forDeleteDedicatedVmHost(final DeleteDedicatedVmHostRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse>(this.executorService, new Callable<DeleteDedicatedVmHostResponse>(){

            @Override
            public DeleteDedicatedVmHostResponse call() throws Exception {
                DeleteDedicatedVmHostResponse response = ComputeWaiters.this.client.deleteDedicatedVmHost(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ExportImageRequest, ExportImageResponse> forExportImage(ExportImageRequest request) {
        return this.forExportImage(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ExportImageRequest, ExportImageResponse> forExportImage(final ExportImageRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ExportImageRequest, ExportImageResponse>(this.executorService, new Callable<ExportImageResponse>(){

            @Override
            public ExportImageResponse call() throws Exception {
                ExportImageResponse response = ComputeWaiters.this.client.exportImage(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(GetBootVolumeAttachmentRequest request, BootVolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(GetBootVolumeAttachmentRequest request, BootVolumeAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBootVolumeAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(GetBootVolumeAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BootVolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBootVolumeAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> forBootVolumeAttachment(BmcGenericWaiter waiter, GetBootVolumeAttachmentRequest request, BootVolumeAttachment.LifecycleState ... targetStates) {
        final HashSet<BootVolumeAttachment.LifecycleState> targetStatesSet = new HashSet<BootVolumeAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse>(){

            public GetBootVolumeAttachmentResponse apply(GetBootVolumeAttachmentRequest request) {
                return ComputeWaiters.this.client.getBootVolumeAttachment(request);
            }
        }, new Predicate<GetBootVolumeAttachmentResponse>(){

            public boolean apply(GetBootVolumeAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getBootVolumeAttachment().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(GetConsoleHistoryRequest request, ConsoleHistory.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConsoleHistory(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(GetConsoleHistoryRequest request, ConsoleHistory.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConsoleHistory(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(GetConsoleHistoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ConsoleHistory.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConsoleHistory(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetConsoleHistoryRequest, GetConsoleHistoryResponse> forConsoleHistory(BmcGenericWaiter waiter, GetConsoleHistoryRequest request, ConsoleHistory.LifecycleState ... targetStates) {
        final HashSet<ConsoleHistory.LifecycleState> targetStatesSet = new HashSet<ConsoleHistory.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetConsoleHistoryRequest, GetConsoleHistoryResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetConsoleHistoryRequest, GetConsoleHistoryResponse>(){

            public GetConsoleHistoryResponse apply(GetConsoleHistoryRequest request) {
                return ComputeWaiters.this.client.getConsoleHistory(request);
            }
        }, new Predicate<GetConsoleHistoryResponse>(){

            public boolean apply(GetConsoleHistoryResponse response) {
                return targetStatesSet.contains((Object)response.getConsoleHistory().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(GetDedicatedVmHostRequest request, DedicatedVmHost.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDedicatedVmHost(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(GetDedicatedVmHostRequest request, DedicatedVmHost.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDedicatedVmHost(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(GetDedicatedVmHostRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DedicatedVmHost.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDedicatedVmHost(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> forDedicatedVmHost(BmcGenericWaiter waiter, GetDedicatedVmHostRequest request, DedicatedVmHost.LifecycleState ... targetStates) {
        final HashSet<DedicatedVmHost.LifecycleState> targetStatesSet = new HashSet<DedicatedVmHost.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse>(){

            public GetDedicatedVmHostResponse apply(GetDedicatedVmHostRequest request) {
                return ComputeWaiters.this.client.getDedicatedVmHost(request);
            }
        }, new Predicate<GetDedicatedVmHostResponse>(){

            public boolean apply(GetDedicatedVmHostResponse response) {
                return targetStatesSet.contains((Object)response.getDedicatedVmHost().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DedicatedVmHost.LifecycleState.Deleted)), request);
    }

    public Waiter<GetImageRequest, GetImageResponse> forImage(GetImageRequest request, Image.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forImage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetImageRequest, GetImageResponse> forImage(GetImageRequest request, Image.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forImage(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetImageRequest, GetImageResponse> forImage(GetImageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Image.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forImage(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetImageRequest, GetImageResponse> forImage(BmcGenericWaiter waiter, GetImageRequest request, Image.LifecycleState ... targetStates) {
        final HashSet<Image.LifecycleState> targetStatesSet = new HashSet<Image.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetImageRequest, GetImageResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetImageRequest, GetImageResponse>(){

            public GetImageResponse apply(GetImageRequest request) {
                return ComputeWaiters.this.client.getImage(request);
            }
        }, new Predicate<GetImageResponse>(){

            public boolean apply(GetImageResponse response) {
                return targetStatesSet.contains((Object)response.getImage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Image.LifecycleState.Deleted)), request);
    }

    public Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(GetInstanceRequest request, Instance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(GetInstanceRequest request, Instance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstance(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(GetInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Instance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstance(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetInstanceRequest, GetInstanceResponse> forInstance(BmcGenericWaiter waiter, GetInstanceRequest request, Instance.LifecycleState ... targetStates) {
        final HashSet<Instance.LifecycleState> targetStatesSet = new HashSet<Instance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetInstanceRequest, GetInstanceResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetInstanceRequest, GetInstanceResponse>(){

            public GetInstanceResponse apply(GetInstanceRequest request) {
                return ComputeWaiters.this.client.getInstance(request);
            }
        }, new Predicate<GetInstanceResponse>(){

            public boolean apply(GetInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Instance.LifecycleState.Terminated)), request);
    }

    public Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, InstanceConsoleConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstanceConsoleConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, InstanceConsoleConnection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstanceConsoleConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstanceConsoleConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstanceConsoleConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> forInstanceConsoleConnection(BmcGenericWaiter waiter, GetInstanceConsoleConnectionRequest request, InstanceConsoleConnection.LifecycleState ... targetStates) {
        final HashSet<InstanceConsoleConnection.LifecycleState> targetStatesSet = new HashSet<InstanceConsoleConnection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse>(){

            public GetInstanceConsoleConnectionResponse apply(GetInstanceConsoleConnectionRequest request) {
                return ComputeWaiters.this.client.getInstanceConsoleConnection(request);
            }
        }, new Predicate<GetInstanceConsoleConnectionResponse>(){

            public boolean apply(GetInstanceConsoleConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getInstanceConsoleConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InstanceConsoleConnection.LifecycleState.Deleted)), request);
    }

    public Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(GetVnicAttachmentRequest request, VnicAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVnicAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(GetVnicAttachmentRequest request, VnicAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVnicAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(GetVnicAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VnicAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVnicAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVnicAttachmentRequest, GetVnicAttachmentResponse> forVnicAttachment(BmcGenericWaiter waiter, GetVnicAttachmentRequest request, VnicAttachment.LifecycleState ... targetStates) {
        final HashSet<VnicAttachment.LifecycleState> targetStatesSet = new HashSet<VnicAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVnicAttachmentRequest, GetVnicAttachmentResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVnicAttachmentRequest, GetVnicAttachmentResponse>(){

            public GetVnicAttachmentResponse apply(GetVnicAttachmentRequest request) {
                return ComputeWaiters.this.client.getVnicAttachment(request);
            }
        }, new Predicate<GetVnicAttachmentResponse>(){

            public boolean apply(GetVnicAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getVnicAttachment().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(GetVolumeAttachmentRequest request, VolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVolumeAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(GetVolumeAttachmentRequest request, VolumeAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVolumeAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(GetVolumeAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VolumeAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVolumeAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> forVolumeAttachment(BmcGenericWaiter waiter, GetVolumeAttachmentRequest request, VolumeAttachment.LifecycleState ... targetStates) {
        final HashSet<VolumeAttachment.LifecycleState> targetStatesSet = new HashSet<VolumeAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse>(){

            public GetVolumeAttachmentResponse apply(GetVolumeAttachmentRequest request) {
                return ComputeWaiters.this.client.getVolumeAttachment(request);
            }
        }, new Predicate<GetVolumeAttachmentResponse>(){

            public boolean apply(GetVolumeAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getVolumeAttachment().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<LaunchInstanceRequest, LaunchInstanceResponse> forLaunchInstance(LaunchInstanceRequest request) {
        return this.forLaunchInstance(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<LaunchInstanceRequest, LaunchInstanceResponse> forLaunchInstance(final LaunchInstanceRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<LaunchInstanceRequest, LaunchInstanceResponse>(this.executorService, new Callable<LaunchInstanceResponse>(){

            @Override
            public LaunchInstanceResponse call() throws Exception {
                LaunchInstanceResponse response = ComputeWaiters.this.client.launchInstance(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                ComputeWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }
}

