/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.VirtualNetworkAsync;
import com.oracle.bmc.core.internal.http.AddNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.AttachServiceIdConverter;
import com.oracle.bmc.core.internal.http.BulkAddVirtualCircuitPublicPrefixesConverter;
import com.oracle.bmc.core.internal.http.BulkDeleteVirtualCircuitPublicPrefixesConverter;
import com.oracle.bmc.core.internal.http.ChangeCpeCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeCrossConnectCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeCrossConnectGroupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeDhcpOptionsCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeDrgCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeIPSecConnectionCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInternetGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeLocalPeeringGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeNatGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeNetworkSecurityGroupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangePublicIpCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeRemotePeeringConnectionCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeRouteTableCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeSecurityListCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeServiceGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeSubnetCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVcnCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVirtualCircuitCompartmentConverter;
import com.oracle.bmc.core.internal.http.ConnectLocalPeeringGatewaysConverter;
import com.oracle.bmc.core.internal.http.ConnectRemotePeeringConnectionsConverter;
import com.oracle.bmc.core.internal.http.CreateCpeConverter;
import com.oracle.bmc.core.internal.http.CreateCrossConnectConverter;
import com.oracle.bmc.core.internal.http.CreateCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.CreateDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.CreateDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.CreateDrgConverter;
import com.oracle.bmc.core.internal.http.CreateIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.CreateInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateIpv6Converter;
import com.oracle.bmc.core.internal.http.CreateLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateNatGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.CreatePrivateIpConverter;
import com.oracle.bmc.core.internal.http.CreatePublicIpConverter;
import com.oracle.bmc.core.internal.http.CreateRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.CreateRouteTableConverter;
import com.oracle.bmc.core.internal.http.CreateSecurityListConverter;
import com.oracle.bmc.core.internal.http.CreateServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateSubnetConverter;
import com.oracle.bmc.core.internal.http.CreateVcnConverter;
import com.oracle.bmc.core.internal.http.CreateVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.DeleteCpeConverter;
import com.oracle.bmc.core.internal.http.DeleteCrossConnectConverter;
import com.oracle.bmc.core.internal.http.DeleteCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.DeleteDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.DeleteDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.DeleteDrgConverter;
import com.oracle.bmc.core.internal.http.DeleteIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.DeleteInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteIpv6Converter;
import com.oracle.bmc.core.internal.http.DeleteLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteNatGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.DeletePrivateIpConverter;
import com.oracle.bmc.core.internal.http.DeletePublicIpConverter;
import com.oracle.bmc.core.internal.http.DeleteRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.DeleteRouteTableConverter;
import com.oracle.bmc.core.internal.http.DeleteSecurityListConverter;
import com.oracle.bmc.core.internal.http.DeleteServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteSubnetConverter;
import com.oracle.bmc.core.internal.http.DeleteVcnConverter;
import com.oracle.bmc.core.internal.http.DeleteVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.DetachServiceIdConverter;
import com.oracle.bmc.core.internal.http.GetCpeConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectLetterOfAuthorityConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectStatusConverter;
import com.oracle.bmc.core.internal.http.GetDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.GetDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetDrgConverter;
import com.oracle.bmc.core.internal.http.GetFastConnectProviderServiceConverter;
import com.oracle.bmc.core.internal.http.GetFastConnectProviderServiceKeyConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionDeviceConfigConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionDeviceStatusConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionTunnelConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionTunnelSharedSecretConverter;
import com.oracle.bmc.core.internal.http.GetInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.GetIpv6Converter;
import com.oracle.bmc.core.internal.http.GetLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.GetNatGatewayConverter;
import com.oracle.bmc.core.internal.http.GetNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.GetPrivateIpConverter;
import com.oracle.bmc.core.internal.http.GetPublicIpByIpAddressConverter;
import com.oracle.bmc.core.internal.http.GetPublicIpByPrivateIpIdConverter;
import com.oracle.bmc.core.internal.http.GetPublicIpConverter;
import com.oracle.bmc.core.internal.http.GetRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.GetRouteTableConverter;
import com.oracle.bmc.core.internal.http.GetSecurityListConverter;
import com.oracle.bmc.core.internal.http.GetServiceConverter;
import com.oracle.bmc.core.internal.http.GetServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.GetSubnetConverter;
import com.oracle.bmc.core.internal.http.GetVcnConverter;
import com.oracle.bmc.core.internal.http.GetVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.GetVnicConverter;
import com.oracle.bmc.core.internal.http.ListAllowedPeerRegionsForRemotePeeringConverter;
import com.oracle.bmc.core.internal.http.ListCpesConverter;
import com.oracle.bmc.core.internal.http.ListCrossConnectGroupsConverter;
import com.oracle.bmc.core.internal.http.ListCrossConnectLocationsConverter;
import com.oracle.bmc.core.internal.http.ListCrossConnectsConverter;
import com.oracle.bmc.core.internal.http.ListCrossconnectPortSpeedShapesConverter;
import com.oracle.bmc.core.internal.http.ListDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.ListDrgAttachmentsConverter;
import com.oracle.bmc.core.internal.http.ListDrgsConverter;
import com.oracle.bmc.core.internal.http.ListFastConnectProviderServicesConverter;
import com.oracle.bmc.core.internal.http.ListFastConnectProviderVirtualCircuitBandwidthShapesConverter;
import com.oracle.bmc.core.internal.http.ListIPSecConnectionTunnelsConverter;
import com.oracle.bmc.core.internal.http.ListIPSecConnectionsConverter;
import com.oracle.bmc.core.internal.http.ListInternetGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListIpv6sConverter;
import com.oracle.bmc.core.internal.http.ListLocalPeeringGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListNatGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.ListNetworkSecurityGroupVnicsConverter;
import com.oracle.bmc.core.internal.http.ListNetworkSecurityGroupsConverter;
import com.oracle.bmc.core.internal.http.ListPrivateIpsConverter;
import com.oracle.bmc.core.internal.http.ListPublicIpsConverter;
import com.oracle.bmc.core.internal.http.ListRemotePeeringConnectionsConverter;
import com.oracle.bmc.core.internal.http.ListRouteTablesConverter;
import com.oracle.bmc.core.internal.http.ListSecurityListsConverter;
import com.oracle.bmc.core.internal.http.ListServiceGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListServicesConverter;
import com.oracle.bmc.core.internal.http.ListSubnetsConverter;
import com.oracle.bmc.core.internal.http.ListVcnsConverter;
import com.oracle.bmc.core.internal.http.ListVirtualCircuitBandwidthShapesConverter;
import com.oracle.bmc.core.internal.http.ListVirtualCircuitPublicPrefixesConverter;
import com.oracle.bmc.core.internal.http.ListVirtualCircuitsConverter;
import com.oracle.bmc.core.internal.http.RemoveNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.UpdateCpeConverter;
import com.oracle.bmc.core.internal.http.UpdateCrossConnectConverter;
import com.oracle.bmc.core.internal.http.UpdateCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.UpdateDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.UpdateDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.UpdateDrgConverter;
import com.oracle.bmc.core.internal.http.UpdateIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.UpdateIPSecConnectionTunnelConverter;
import com.oracle.bmc.core.internal.http.UpdateIPSecConnectionTunnelSharedSecretConverter;
import com.oracle.bmc.core.internal.http.UpdateInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateIpv6Converter;
import com.oracle.bmc.core.internal.http.UpdateLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateNatGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.UpdateNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.UpdatePrivateIpConverter;
import com.oracle.bmc.core.internal.http.UpdatePublicIpConverter;
import com.oracle.bmc.core.internal.http.UpdateRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.UpdateRouteTableConverter;
import com.oracle.bmc.core.internal.http.UpdateSecurityListConverter;
import com.oracle.bmc.core.internal.http.UpdateServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateSubnetConverter;
import com.oracle.bmc.core.internal.http.UpdateVcnConverter;
import com.oracle.bmc.core.internal.http.UpdateVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.UpdateVnicConverter;
import com.oracle.bmc.core.requests.AddNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.AttachServiceIdRequest;
import com.oracle.bmc.core.requests.BulkAddVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.BulkDeleteVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.ChangeCpeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCrossConnectCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCrossConnectGroupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDhcpOptionsCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDrgCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeIPSecConnectionCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInternetGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeLocalPeeringGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeNatGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeNetworkSecurityGroupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangePublicIpCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeRemotePeeringConnectionCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeRouteTableCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSecurityListCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeServiceGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSubnetCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVcnCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVirtualCircuitCompartmentRequest;
import com.oracle.bmc.core.requests.ConnectLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.requests.ConnectRemotePeeringConnectionsRequest;
import com.oracle.bmc.core.requests.CreateCpeRequest;
import com.oracle.bmc.core.requests.CreateCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.CreateCrossConnectRequest;
import com.oracle.bmc.core.requests.CreateDhcpOptionsRequest;
import com.oracle.bmc.core.requests.CreateDrgAttachmentRequest;
import com.oracle.bmc.core.requests.CreateDrgRequest;
import com.oracle.bmc.core.requests.CreateIPSecConnectionRequest;
import com.oracle.bmc.core.requests.CreateInternetGatewayRequest;
import com.oracle.bmc.core.requests.CreateIpv6Request;
import com.oracle.bmc.core.requests.CreateLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.CreateNatGatewayRequest;
import com.oracle.bmc.core.requests.CreateNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.CreatePrivateIpRequest;
import com.oracle.bmc.core.requests.CreatePublicIpRequest;
import com.oracle.bmc.core.requests.CreateRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.CreateRouteTableRequest;
import com.oracle.bmc.core.requests.CreateSecurityListRequest;
import com.oracle.bmc.core.requests.CreateServiceGatewayRequest;
import com.oracle.bmc.core.requests.CreateSubnetRequest;
import com.oracle.bmc.core.requests.CreateVcnRequest;
import com.oracle.bmc.core.requests.CreateVirtualCircuitRequest;
import com.oracle.bmc.core.requests.DeleteCpeRequest;
import com.oracle.bmc.core.requests.DeleteCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.DeleteCrossConnectRequest;
import com.oracle.bmc.core.requests.DeleteDhcpOptionsRequest;
import com.oracle.bmc.core.requests.DeleteDrgAttachmentRequest;
import com.oracle.bmc.core.requests.DeleteDrgRequest;
import com.oracle.bmc.core.requests.DeleteIPSecConnectionRequest;
import com.oracle.bmc.core.requests.DeleteInternetGatewayRequest;
import com.oracle.bmc.core.requests.DeleteIpv6Request;
import com.oracle.bmc.core.requests.DeleteLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.DeleteNatGatewayRequest;
import com.oracle.bmc.core.requests.DeleteNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.DeletePrivateIpRequest;
import com.oracle.bmc.core.requests.DeletePublicIpRequest;
import com.oracle.bmc.core.requests.DeleteRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.DeleteRouteTableRequest;
import com.oracle.bmc.core.requests.DeleteSecurityListRequest;
import com.oracle.bmc.core.requests.DeleteServiceGatewayRequest;
import com.oracle.bmc.core.requests.DeleteSubnetRequest;
import com.oracle.bmc.core.requests.DeleteVcnRequest;
import com.oracle.bmc.core.requests.DeleteVirtualCircuitRequest;
import com.oracle.bmc.core.requests.DetachServiceIdRequest;
import com.oracle.bmc.core.requests.GetCpeRequest;
import com.oracle.bmc.core.requests.GetCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.GetCrossConnectLetterOfAuthorityRequest;
import com.oracle.bmc.core.requests.GetCrossConnectRequest;
import com.oracle.bmc.core.requests.GetCrossConnectStatusRequest;
import com.oracle.bmc.core.requests.GetDhcpOptionsRequest;
import com.oracle.bmc.core.requests.GetDrgAttachmentRequest;
import com.oracle.bmc.core.requests.GetDrgRequest;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceKeyRequest;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionDeviceConfigRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionDeviceStatusRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelSharedSecretRequest;
import com.oracle.bmc.core.requests.GetInternetGatewayRequest;
import com.oracle.bmc.core.requests.GetIpv6Request;
import com.oracle.bmc.core.requests.GetLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.GetNatGatewayRequest;
import com.oracle.bmc.core.requests.GetNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.GetPrivateIpRequest;
import com.oracle.bmc.core.requests.GetPublicIpByIpAddressRequest;
import com.oracle.bmc.core.requests.GetPublicIpByPrivateIpIdRequest;
import com.oracle.bmc.core.requests.GetPublicIpRequest;
import com.oracle.bmc.core.requests.GetRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.GetRouteTableRequest;
import com.oracle.bmc.core.requests.GetSecurityListRequest;
import com.oracle.bmc.core.requests.GetServiceGatewayRequest;
import com.oracle.bmc.core.requests.GetServiceRequest;
import com.oracle.bmc.core.requests.GetSubnetRequest;
import com.oracle.bmc.core.requests.GetVcnRequest;
import com.oracle.bmc.core.requests.GetVirtualCircuitRequest;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.requests.ListAllowedPeerRegionsForRemotePeeringRequest;
import com.oracle.bmc.core.requests.ListCpesRequest;
import com.oracle.bmc.core.requests.ListCrossConnectGroupsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectLocationsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectsRequest;
import com.oracle.bmc.core.requests.ListCrossconnectPortSpeedShapesRequest;
import com.oracle.bmc.core.requests.ListDhcpOptionsRequest;
import com.oracle.bmc.core.requests.ListDrgAttachmentsRequest;
import com.oracle.bmc.core.requests.ListDrgsRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderServicesRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionTunnelsRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionsRequest;
import com.oracle.bmc.core.requests.ListInternetGatewaysRequest;
import com.oracle.bmc.core.requests.ListIpv6sRequest;
import com.oracle.bmc.core.requests.ListLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.requests.ListNatGatewaysRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupVnicsRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupsRequest;
import com.oracle.bmc.core.requests.ListPrivateIpsRequest;
import com.oracle.bmc.core.requests.ListPublicIpsRequest;
import com.oracle.bmc.core.requests.ListRemotePeeringConnectionsRequest;
import com.oracle.bmc.core.requests.ListRouteTablesRequest;
import com.oracle.bmc.core.requests.ListSecurityListsRequest;
import com.oracle.bmc.core.requests.ListServiceGatewaysRequest;
import com.oracle.bmc.core.requests.ListServicesRequest;
import com.oracle.bmc.core.requests.ListSubnetsRequest;
import com.oracle.bmc.core.requests.ListVcnsRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitsRequest;
import com.oracle.bmc.core.requests.RemoveNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.UpdateCpeRequest;
import com.oracle.bmc.core.requests.UpdateCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.UpdateCrossConnectRequest;
import com.oracle.bmc.core.requests.UpdateDhcpOptionsRequest;
import com.oracle.bmc.core.requests.UpdateDrgAttachmentRequest;
import com.oracle.bmc.core.requests.UpdateDrgRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionTunnelSharedSecretRequest;
import com.oracle.bmc.core.requests.UpdateInternetGatewayRequest;
import com.oracle.bmc.core.requests.UpdateIpv6Request;
import com.oracle.bmc.core.requests.UpdateLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.UpdateNatGatewayRequest;
import com.oracle.bmc.core.requests.UpdateNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.UpdateNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.UpdatePrivateIpRequest;
import com.oracle.bmc.core.requests.UpdatePublicIpRequest;
import com.oracle.bmc.core.requests.UpdateRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.UpdateRouteTableRequest;
import com.oracle.bmc.core.requests.UpdateSecurityListRequest;
import com.oracle.bmc.core.requests.UpdateServiceGatewayRequest;
import com.oracle.bmc.core.requests.UpdateSubnetRequest;
import com.oracle.bmc.core.requests.UpdateVcnRequest;
import com.oracle.bmc.core.requests.UpdateVirtualCircuitRequest;
import com.oracle.bmc.core.requests.UpdateVnicRequest;
import com.oracle.bmc.core.responses.AddNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.AttachServiceIdResponse;
import com.oracle.bmc.core.responses.BulkAddVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.BulkDeleteVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.ChangeCpeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCrossConnectCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCrossConnectGroupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDhcpOptionsCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDrgCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeIPSecConnectionCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInternetGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeLocalPeeringGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeNatGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeNetworkSecurityGroupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangePublicIpCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeRemotePeeringConnectionCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeRouteTableCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSecurityListCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeServiceGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSubnetCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVcnCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVirtualCircuitCompartmentResponse;
import com.oracle.bmc.core.responses.ConnectLocalPeeringGatewaysResponse;
import com.oracle.bmc.core.responses.ConnectRemotePeeringConnectionsResponse;
import com.oracle.bmc.core.responses.CreateCpeResponse;
import com.oracle.bmc.core.responses.CreateCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.CreateCrossConnectResponse;
import com.oracle.bmc.core.responses.CreateDhcpOptionsResponse;
import com.oracle.bmc.core.responses.CreateDrgAttachmentResponse;
import com.oracle.bmc.core.responses.CreateDrgResponse;
import com.oracle.bmc.core.responses.CreateIPSecConnectionResponse;
import com.oracle.bmc.core.responses.CreateInternetGatewayResponse;
import com.oracle.bmc.core.responses.CreateIpv6Response;
import com.oracle.bmc.core.responses.CreateLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.CreateNatGatewayResponse;
import com.oracle.bmc.core.responses.CreateNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.CreatePrivateIpResponse;
import com.oracle.bmc.core.responses.CreatePublicIpResponse;
import com.oracle.bmc.core.responses.CreateRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.CreateRouteTableResponse;
import com.oracle.bmc.core.responses.CreateSecurityListResponse;
import com.oracle.bmc.core.responses.CreateServiceGatewayResponse;
import com.oracle.bmc.core.responses.CreateSubnetResponse;
import com.oracle.bmc.core.responses.CreateVcnResponse;
import com.oracle.bmc.core.responses.CreateVirtualCircuitResponse;
import com.oracle.bmc.core.responses.DeleteCpeResponse;
import com.oracle.bmc.core.responses.DeleteCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.DeleteCrossConnectResponse;
import com.oracle.bmc.core.responses.DeleteDhcpOptionsResponse;
import com.oracle.bmc.core.responses.DeleteDrgAttachmentResponse;
import com.oracle.bmc.core.responses.DeleteDrgResponse;
import com.oracle.bmc.core.responses.DeleteIPSecConnectionResponse;
import com.oracle.bmc.core.responses.DeleteInternetGatewayResponse;
import com.oracle.bmc.core.responses.DeleteIpv6Response;
import com.oracle.bmc.core.responses.DeleteLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.DeleteNatGatewayResponse;
import com.oracle.bmc.core.responses.DeleteNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.DeletePrivateIpResponse;
import com.oracle.bmc.core.responses.DeletePublicIpResponse;
import com.oracle.bmc.core.responses.DeleteRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.DeleteRouteTableResponse;
import com.oracle.bmc.core.responses.DeleteSecurityListResponse;
import com.oracle.bmc.core.responses.DeleteServiceGatewayResponse;
import com.oracle.bmc.core.responses.DeleteSubnetResponse;
import com.oracle.bmc.core.responses.DeleteVcnResponse;
import com.oracle.bmc.core.responses.DeleteVirtualCircuitResponse;
import com.oracle.bmc.core.responses.DetachServiceIdResponse;
import com.oracle.bmc.core.responses.GetCpeResponse;
import com.oracle.bmc.core.responses.GetCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.GetCrossConnectLetterOfAuthorityResponse;
import com.oracle.bmc.core.responses.GetCrossConnectResponse;
import com.oracle.bmc.core.responses.GetCrossConnectStatusResponse;
import com.oracle.bmc.core.responses.GetDhcpOptionsResponse;
import com.oracle.bmc.core.responses.GetDrgAttachmentResponse;
import com.oracle.bmc.core.responses.GetDrgResponse;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceKeyResponse;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionDeviceConfigResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionDeviceStatusResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelSharedSecretResponse;
import com.oracle.bmc.core.responses.GetInternetGatewayResponse;
import com.oracle.bmc.core.responses.GetIpv6Response;
import com.oracle.bmc.core.responses.GetLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.GetNatGatewayResponse;
import com.oracle.bmc.core.responses.GetNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.GetPrivateIpResponse;
import com.oracle.bmc.core.responses.GetPublicIpByIpAddressResponse;
import com.oracle.bmc.core.responses.GetPublicIpByPrivateIpIdResponse;
import com.oracle.bmc.core.responses.GetPublicIpResponse;
import com.oracle.bmc.core.responses.GetRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.GetRouteTableResponse;
import com.oracle.bmc.core.responses.GetSecurityListResponse;
import com.oracle.bmc.core.responses.GetServiceGatewayResponse;
import com.oracle.bmc.core.responses.GetServiceResponse;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import com.oracle.bmc.core.responses.GetVcnResponse;
import com.oracle.bmc.core.responses.GetVirtualCircuitResponse;
import com.oracle.bmc.core.responses.GetVnicResponse;
import com.oracle.bmc.core.responses.ListAllowedPeerRegionsForRemotePeeringResponse;
import com.oracle.bmc.core.responses.ListCpesResponse;
import com.oracle.bmc.core.responses.ListCrossConnectGroupsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectLocationsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectsResponse;
import com.oracle.bmc.core.responses.ListCrossconnectPortSpeedShapesResponse;
import com.oracle.bmc.core.responses.ListDhcpOptionsResponse;
import com.oracle.bmc.core.responses.ListDrgAttachmentsResponse;
import com.oracle.bmc.core.responses.ListDrgsResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderServicesResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionTunnelsResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionsResponse;
import com.oracle.bmc.core.responses.ListInternetGatewaysResponse;
import com.oracle.bmc.core.responses.ListIpv6sResponse;
import com.oracle.bmc.core.responses.ListLocalPeeringGatewaysResponse;
import com.oracle.bmc.core.responses.ListNatGatewaysResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupVnicsResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupsResponse;
import com.oracle.bmc.core.responses.ListPrivateIpsResponse;
import com.oracle.bmc.core.responses.ListPublicIpsResponse;
import com.oracle.bmc.core.responses.ListRemotePeeringConnectionsResponse;
import com.oracle.bmc.core.responses.ListRouteTablesResponse;
import com.oracle.bmc.core.responses.ListSecurityListsResponse;
import com.oracle.bmc.core.responses.ListServiceGatewaysResponse;
import com.oracle.bmc.core.responses.ListServicesResponse;
import com.oracle.bmc.core.responses.ListSubnetsResponse;
import com.oracle.bmc.core.responses.ListVcnsResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitsResponse;
import com.oracle.bmc.core.responses.RemoveNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.UpdateCpeResponse;
import com.oracle.bmc.core.responses.UpdateCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.UpdateCrossConnectResponse;
import com.oracle.bmc.core.responses.UpdateDhcpOptionsResponse;
import com.oracle.bmc.core.responses.UpdateDrgAttachmentResponse;
import com.oracle.bmc.core.responses.UpdateDrgResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionTunnelSharedSecretResponse;
import com.oracle.bmc.core.responses.UpdateInternetGatewayResponse;
import com.oracle.bmc.core.responses.UpdateIpv6Response;
import com.oracle.bmc.core.responses.UpdateLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.UpdateNatGatewayResponse;
import com.oracle.bmc.core.responses.UpdateNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.UpdateNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.UpdatePrivateIpResponse;
import com.oracle.bmc.core.responses.UpdatePublicIpResponse;
import com.oracle.bmc.core.responses.UpdateRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.UpdateRouteTableResponse;
import com.oracle.bmc.core.responses.UpdateSecurityListResponse;
import com.oracle.bmc.core.responses.UpdateServiceGatewayResponse;
import com.oracle.bmc.core.responses.UpdateSubnetResponse;
import com.oracle.bmc.core.responses.UpdateVcnResponse;
import com.oracle.bmc.core.responses.UpdateVirtualCircuitResponse;
import com.oracle.bmc.core.responses.UpdateVnicResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkAsyncClient
implements VirtualNetworkAsync {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualNetworkAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VIRTUALNETWORK").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public VirtualNetworkAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public VirtualNetworkAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public VirtualNetworkAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public VirtualNetworkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public VirtualNetworkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public VirtualNetworkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public VirtualNetworkAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddNetworkSecurityGroupSecurityRulesResponse> addNetworkSecurityGroupSecurityRules(AddNetworkSecurityGroupSecurityRulesRequest request, AsyncHandler<AddNetworkSecurityGroupSecurityRulesRequest, AddNetworkSecurityGroupSecurityRulesResponse> handler) {
        LOG.trace("Called async addNetworkSecurityGroupSecurityRules");
        final AddNetworkSecurityGroupSecurityRulesRequest interceptedRequest = AddNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AddNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AddNetworkSecurityGroupSecurityRulesResponse> transformer = AddNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AddNetworkSecurityGroupSecurityRulesRequest, AddNetworkSecurityGroupSecurityRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AddNetworkSecurityGroupSecurityRulesRequest, AddNetworkSecurityGroupSecurityRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AddNetworkSecurityGroupSecurityRulesRequest, AddNetworkSecurityGroupSecurityRulesResponse> onSuccess = new SuccessConsumer<AddNetworkSecurityGroupSecurityRulesRequest, AddNetworkSecurityGroupSecurityRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AddNetworkSecurityGroupSecurityRulesRequest> onError = new ErrorConsumer<AddNetworkSecurityGroupSecurityRulesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getAddNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AddNetworkSecurityGroupSecurityRulesRequest, AddNetworkSecurityGroupSecurityRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<AddNetworkSecurityGroupSecurityRulesRequest, AddNetworkSecurityGroupSecurityRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AddNetworkSecurityGroupSecurityRulesRequest> onError = handler == null ? null : new ErrorConsumer<AddNetworkSecurityGroupSecurityRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAddNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AddNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getAddNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AddNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<AttachServiceIdResponse> attachServiceId(AttachServiceIdRequest request, AsyncHandler<AttachServiceIdRequest, AttachServiceIdResponse> handler) {
        LOG.trace("Called async attachServiceId");
        final AttachServiceIdRequest interceptedRequest = AttachServiceIdConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AttachServiceIdConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AttachServiceIdResponse> transformer = AttachServiceIdConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AttachServiceIdRequest, AttachServiceIdResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AttachServiceIdRequest, AttachServiceIdResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AttachServiceIdRequest, AttachServiceIdResponse> onSuccess = new SuccessConsumer<AttachServiceIdRequest, AttachServiceIdResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AttachServiceIdRequest> onError = new ErrorConsumer<AttachServiceIdRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getAttachServiceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AttachServiceIdRequest, AttachServiceIdResponse> onSuccess = handler == null ? null : new SuccessConsumer<AttachServiceIdRequest, AttachServiceIdResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AttachServiceIdRequest> onError = handler == null ? null : new ErrorConsumer<AttachServiceIdRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getAttachServiceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AttachServiceIdResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getAttachServiceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AttachServiceIdResponse>(responseFuture, transformer);
    }

    @Override
    public Future<BulkAddVirtualCircuitPublicPrefixesResponse> bulkAddVirtualCircuitPublicPrefixes(BulkAddVirtualCircuitPublicPrefixesRequest request, AsyncHandler<BulkAddVirtualCircuitPublicPrefixesRequest, BulkAddVirtualCircuitPublicPrefixesResponse> handler) {
        LOG.trace("Called async bulkAddVirtualCircuitPublicPrefixes");
        final BulkAddVirtualCircuitPublicPrefixesRequest interceptedRequest = BulkAddVirtualCircuitPublicPrefixesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = BulkAddVirtualCircuitPublicPrefixesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, BulkAddVirtualCircuitPublicPrefixesResponse> transformer = BulkAddVirtualCircuitPublicPrefixesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<BulkAddVirtualCircuitPublicPrefixesRequest, BulkAddVirtualCircuitPublicPrefixesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<BulkAddVirtualCircuitPublicPrefixesRequest, BulkAddVirtualCircuitPublicPrefixesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<BulkAddVirtualCircuitPublicPrefixesRequest, BulkAddVirtualCircuitPublicPrefixesResponse> onSuccess = new SuccessConsumer<BulkAddVirtualCircuitPublicPrefixesRequest, BulkAddVirtualCircuitPublicPrefixesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<BulkAddVirtualCircuitPublicPrefixesRequest> onError = new ErrorConsumer<BulkAddVirtualCircuitPublicPrefixesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getBulkAddVirtualCircuitPublicPrefixesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<BulkAddVirtualCircuitPublicPrefixesRequest, BulkAddVirtualCircuitPublicPrefixesResponse> onSuccess = handler == null ? null : new SuccessConsumer<BulkAddVirtualCircuitPublicPrefixesRequest, BulkAddVirtualCircuitPublicPrefixesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<BulkAddVirtualCircuitPublicPrefixesRequest> onError = handler == null ? null : new ErrorConsumer<BulkAddVirtualCircuitPublicPrefixesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getBulkAddVirtualCircuitPublicPrefixesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, BulkAddVirtualCircuitPublicPrefixesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getBulkAddVirtualCircuitPublicPrefixesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, BulkAddVirtualCircuitPublicPrefixesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<BulkDeleteVirtualCircuitPublicPrefixesResponse> bulkDeleteVirtualCircuitPublicPrefixes(BulkDeleteVirtualCircuitPublicPrefixesRequest request, AsyncHandler<BulkDeleteVirtualCircuitPublicPrefixesRequest, BulkDeleteVirtualCircuitPublicPrefixesResponse> handler) {
        LOG.trace("Called async bulkDeleteVirtualCircuitPublicPrefixes");
        final BulkDeleteVirtualCircuitPublicPrefixesRequest interceptedRequest = BulkDeleteVirtualCircuitPublicPrefixesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = BulkDeleteVirtualCircuitPublicPrefixesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, BulkDeleteVirtualCircuitPublicPrefixesResponse> transformer = BulkDeleteVirtualCircuitPublicPrefixesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<BulkDeleteVirtualCircuitPublicPrefixesRequest, BulkDeleteVirtualCircuitPublicPrefixesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<BulkDeleteVirtualCircuitPublicPrefixesRequest, BulkDeleteVirtualCircuitPublicPrefixesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest, BulkDeleteVirtualCircuitPublicPrefixesResponse> onSuccess = new SuccessConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest, BulkDeleteVirtualCircuitPublicPrefixesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest> onError = new ErrorConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getBulkDeleteVirtualCircuitPublicPrefixesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest, BulkDeleteVirtualCircuitPublicPrefixesResponse> onSuccess = handler == null ? null : new SuccessConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest, BulkDeleteVirtualCircuitPublicPrefixesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest> onError = handler == null ? null : new ErrorConsumer<BulkDeleteVirtualCircuitPublicPrefixesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getBulkDeleteVirtualCircuitPublicPrefixesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, BulkDeleteVirtualCircuitPublicPrefixesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getBulkDeleteVirtualCircuitPublicPrefixesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, BulkDeleteVirtualCircuitPublicPrefixesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeCpeCompartmentResponse> changeCpeCompartment(ChangeCpeCompartmentRequest request, AsyncHandler<ChangeCpeCompartmentRequest, ChangeCpeCompartmentResponse> handler) {
        LOG.trace("Called async changeCpeCompartment");
        final ChangeCpeCompartmentRequest interceptedRequest = ChangeCpeCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeCpeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeCpeCompartmentResponse> transformer = ChangeCpeCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeCpeCompartmentRequest, ChangeCpeCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeCpeCompartmentRequest, ChangeCpeCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeCpeCompartmentRequest, ChangeCpeCompartmentResponse> onSuccess = new SuccessConsumer<ChangeCpeCompartmentRequest, ChangeCpeCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeCpeCompartmentRequest> onError = new ErrorConsumer<ChangeCpeCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeCpeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeCpeCompartmentRequest, ChangeCpeCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeCpeCompartmentRequest, ChangeCpeCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeCpeCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeCpeCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCpeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeCpeCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeCpeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeCpeCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeCrossConnectCompartmentResponse> changeCrossConnectCompartment(ChangeCrossConnectCompartmentRequest request, AsyncHandler<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentResponse> handler) {
        LOG.trace("Called async changeCrossConnectCompartment");
        final ChangeCrossConnectCompartmentRequest interceptedRequest = ChangeCrossConnectCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeCrossConnectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeCrossConnectCompartmentResponse> transformer = ChangeCrossConnectCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentResponse> onSuccess = new SuccessConsumer<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeCrossConnectCompartmentRequest> onError = new ErrorConsumer<ChangeCrossConnectCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeCrossConnectCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeCrossConnectCompartmentRequest, ChangeCrossConnectCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeCrossConnectCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeCrossConnectCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCrossConnectCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeCrossConnectCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeCrossConnectCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeCrossConnectCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeCrossConnectGroupCompartmentResponse> changeCrossConnectGroupCompartment(ChangeCrossConnectGroupCompartmentRequest request, AsyncHandler<ChangeCrossConnectGroupCompartmentRequest, ChangeCrossConnectGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeCrossConnectGroupCompartment");
        final ChangeCrossConnectGroupCompartmentRequest interceptedRequest = ChangeCrossConnectGroupCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeCrossConnectGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeCrossConnectGroupCompartmentResponse> transformer = ChangeCrossConnectGroupCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeCrossConnectGroupCompartmentRequest, ChangeCrossConnectGroupCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeCrossConnectGroupCompartmentRequest, ChangeCrossConnectGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeCrossConnectGroupCompartmentRequest, ChangeCrossConnectGroupCompartmentResponse> onSuccess = new SuccessConsumer<ChangeCrossConnectGroupCompartmentRequest, ChangeCrossConnectGroupCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeCrossConnectGroupCompartmentRequest> onError = new ErrorConsumer<ChangeCrossConnectGroupCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeCrossConnectGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeCrossConnectGroupCompartmentRequest, ChangeCrossConnectGroupCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeCrossConnectGroupCompartmentRequest, ChangeCrossConnectGroupCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeCrossConnectGroupCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeCrossConnectGroupCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCrossConnectGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeCrossConnectGroupCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeCrossConnectGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeCrossConnectGroupCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeDhcpOptionsCompartmentResponse> changeDhcpOptionsCompartment(ChangeDhcpOptionsCompartmentRequest request, AsyncHandler<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentResponse> handler) {
        LOG.trace("Called async changeDhcpOptionsCompartment");
        final ChangeDhcpOptionsCompartmentRequest interceptedRequest = ChangeDhcpOptionsCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeDhcpOptionsCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeDhcpOptionsCompartmentResponse> transformer = ChangeDhcpOptionsCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentResponse> onSuccess = new SuccessConsumer<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeDhcpOptionsCompartmentRequest> onError = new ErrorConsumer<ChangeDhcpOptionsCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeDhcpOptionsCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeDhcpOptionsCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeDhcpOptionsCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeDhcpOptionsCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeDhcpOptionsCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeDhcpOptionsCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeDhcpOptionsCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeDrgCompartmentResponse> changeDrgCompartment(ChangeDrgCompartmentRequest request, AsyncHandler<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> handler) {
        LOG.trace("Called async changeDrgCompartment");
        final ChangeDrgCompartmentRequest interceptedRequest = ChangeDrgCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeDrgCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeDrgCompartmentResponse> transformer = ChangeDrgCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> onSuccess = new SuccessConsumer<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeDrgCompartmentRequest> onError = new ErrorConsumer<ChangeDrgCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeDrgCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeDrgCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeDrgCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeDrgCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeDrgCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeDrgCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeDrgCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeIPSecConnectionCompartmentResponse> changeIPSecConnectionCompartment(ChangeIPSecConnectionCompartmentRequest request, AsyncHandler<ChangeIPSecConnectionCompartmentRequest, ChangeIPSecConnectionCompartmentResponse> handler) {
        LOG.trace("Called async changeIPSecConnectionCompartment");
        final ChangeIPSecConnectionCompartmentRequest interceptedRequest = ChangeIPSecConnectionCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeIPSecConnectionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeIPSecConnectionCompartmentResponse> transformer = ChangeIPSecConnectionCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeIPSecConnectionCompartmentRequest, ChangeIPSecConnectionCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeIPSecConnectionCompartmentRequest, ChangeIPSecConnectionCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeIPSecConnectionCompartmentRequest, ChangeIPSecConnectionCompartmentResponse> onSuccess = new SuccessConsumer<ChangeIPSecConnectionCompartmentRequest, ChangeIPSecConnectionCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeIPSecConnectionCompartmentRequest> onError = new ErrorConsumer<ChangeIPSecConnectionCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeIPSecConnectionCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeIPSecConnectionCompartmentRequest, ChangeIPSecConnectionCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeIPSecConnectionCompartmentRequest, ChangeIPSecConnectionCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeIPSecConnectionCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeIPSecConnectionCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeIPSecConnectionCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeIPSecConnectionCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeIPSecConnectionCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeIPSecConnectionCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeInternetGatewayCompartmentResponse> changeInternetGatewayCompartment(ChangeInternetGatewayCompartmentRequest request, AsyncHandler<ChangeInternetGatewayCompartmentRequest, ChangeInternetGatewayCompartmentResponse> handler) {
        LOG.trace("Called async changeInternetGatewayCompartment");
        final ChangeInternetGatewayCompartmentRequest interceptedRequest = ChangeInternetGatewayCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeInternetGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeInternetGatewayCompartmentResponse> transformer = ChangeInternetGatewayCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeInternetGatewayCompartmentRequest, ChangeInternetGatewayCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeInternetGatewayCompartmentRequest, ChangeInternetGatewayCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeInternetGatewayCompartmentRequest, ChangeInternetGatewayCompartmentResponse> onSuccess = new SuccessConsumer<ChangeInternetGatewayCompartmentRequest, ChangeInternetGatewayCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeInternetGatewayCompartmentRequest> onError = new ErrorConsumer<ChangeInternetGatewayCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeInternetGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeInternetGatewayCompartmentRequest, ChangeInternetGatewayCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeInternetGatewayCompartmentRequest, ChangeInternetGatewayCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeInternetGatewayCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeInternetGatewayCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeInternetGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeInternetGatewayCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeInternetGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeInternetGatewayCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeLocalPeeringGatewayCompartmentResponse> changeLocalPeeringGatewayCompartment(ChangeLocalPeeringGatewayCompartmentRequest request, AsyncHandler<ChangeLocalPeeringGatewayCompartmentRequest, ChangeLocalPeeringGatewayCompartmentResponse> handler) {
        LOG.trace("Called async changeLocalPeeringGatewayCompartment");
        final ChangeLocalPeeringGatewayCompartmentRequest interceptedRequest = ChangeLocalPeeringGatewayCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeLocalPeeringGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeLocalPeeringGatewayCompartmentResponse> transformer = ChangeLocalPeeringGatewayCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeLocalPeeringGatewayCompartmentRequest, ChangeLocalPeeringGatewayCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeLocalPeeringGatewayCompartmentRequest, ChangeLocalPeeringGatewayCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeLocalPeeringGatewayCompartmentRequest, ChangeLocalPeeringGatewayCompartmentResponse> onSuccess = new SuccessConsumer<ChangeLocalPeeringGatewayCompartmentRequest, ChangeLocalPeeringGatewayCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeLocalPeeringGatewayCompartmentRequest> onError = new ErrorConsumer<ChangeLocalPeeringGatewayCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeLocalPeeringGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeLocalPeeringGatewayCompartmentRequest, ChangeLocalPeeringGatewayCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeLocalPeeringGatewayCompartmentRequest, ChangeLocalPeeringGatewayCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeLocalPeeringGatewayCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeLocalPeeringGatewayCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeLocalPeeringGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeLocalPeeringGatewayCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeLocalPeeringGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeLocalPeeringGatewayCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeNatGatewayCompartmentResponse> changeNatGatewayCompartment(ChangeNatGatewayCompartmentRequest request, AsyncHandler<ChangeNatGatewayCompartmentRequest, ChangeNatGatewayCompartmentResponse> handler) {
        LOG.trace("Called async changeNatGatewayCompartment");
        final ChangeNatGatewayCompartmentRequest interceptedRequest = ChangeNatGatewayCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeNatGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeNatGatewayCompartmentResponse> transformer = ChangeNatGatewayCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeNatGatewayCompartmentRequest, ChangeNatGatewayCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeNatGatewayCompartmentRequest, ChangeNatGatewayCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeNatGatewayCompartmentRequest, ChangeNatGatewayCompartmentResponse> onSuccess = new SuccessConsumer<ChangeNatGatewayCompartmentRequest, ChangeNatGatewayCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeNatGatewayCompartmentRequest> onError = new ErrorConsumer<ChangeNatGatewayCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeNatGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeNatGatewayCompartmentRequest, ChangeNatGatewayCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeNatGatewayCompartmentRequest, ChangeNatGatewayCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeNatGatewayCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeNatGatewayCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeNatGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeNatGatewayCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeNatGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeNatGatewayCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeNetworkSecurityGroupCompartmentResponse> changeNetworkSecurityGroupCompartment(ChangeNetworkSecurityGroupCompartmentRequest request, AsyncHandler<ChangeNetworkSecurityGroupCompartmentRequest, ChangeNetworkSecurityGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeNetworkSecurityGroupCompartment");
        final ChangeNetworkSecurityGroupCompartmentRequest interceptedRequest = ChangeNetworkSecurityGroupCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeNetworkSecurityGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeNetworkSecurityGroupCompartmentResponse> transformer = ChangeNetworkSecurityGroupCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeNetworkSecurityGroupCompartmentRequest, ChangeNetworkSecurityGroupCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeNetworkSecurityGroupCompartmentRequest, ChangeNetworkSecurityGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeNetworkSecurityGroupCompartmentRequest, ChangeNetworkSecurityGroupCompartmentResponse> onSuccess = new SuccessConsumer<ChangeNetworkSecurityGroupCompartmentRequest, ChangeNetworkSecurityGroupCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeNetworkSecurityGroupCompartmentRequest> onError = new ErrorConsumer<ChangeNetworkSecurityGroupCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeNetworkSecurityGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeNetworkSecurityGroupCompartmentRequest, ChangeNetworkSecurityGroupCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeNetworkSecurityGroupCompartmentRequest, ChangeNetworkSecurityGroupCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeNetworkSecurityGroupCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeNetworkSecurityGroupCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeNetworkSecurityGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeNetworkSecurityGroupCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeNetworkSecurityGroupCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeNetworkSecurityGroupCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangePublicIpCompartmentResponse> changePublicIpCompartment(ChangePublicIpCompartmentRequest request, AsyncHandler<ChangePublicIpCompartmentRequest, ChangePublicIpCompartmentResponse> handler) {
        LOG.trace("Called async changePublicIpCompartment");
        final ChangePublicIpCompartmentRequest interceptedRequest = ChangePublicIpCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangePublicIpCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangePublicIpCompartmentResponse> transformer = ChangePublicIpCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangePublicIpCompartmentRequest, ChangePublicIpCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangePublicIpCompartmentRequest, ChangePublicIpCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangePublicIpCompartmentRequest, ChangePublicIpCompartmentResponse> onSuccess = new SuccessConsumer<ChangePublicIpCompartmentRequest, ChangePublicIpCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangePublicIpCompartmentRequest> onError = new ErrorConsumer<ChangePublicIpCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangePublicIpCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangePublicIpCompartmentRequest, ChangePublicIpCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangePublicIpCompartmentRequest, ChangePublicIpCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangePublicIpCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangePublicIpCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangePublicIpCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangePublicIpCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangePublicIpCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangePublicIpCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeRemotePeeringConnectionCompartmentResponse> changeRemotePeeringConnectionCompartment(ChangeRemotePeeringConnectionCompartmentRequest request, AsyncHandler<ChangeRemotePeeringConnectionCompartmentRequest, ChangeRemotePeeringConnectionCompartmentResponse> handler) {
        LOG.trace("Called async changeRemotePeeringConnectionCompartment");
        final ChangeRemotePeeringConnectionCompartmentRequest interceptedRequest = ChangeRemotePeeringConnectionCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeRemotePeeringConnectionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeRemotePeeringConnectionCompartmentResponse> transformer = ChangeRemotePeeringConnectionCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeRemotePeeringConnectionCompartmentRequest, ChangeRemotePeeringConnectionCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeRemotePeeringConnectionCompartmentRequest, ChangeRemotePeeringConnectionCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeRemotePeeringConnectionCompartmentRequest, ChangeRemotePeeringConnectionCompartmentResponse> onSuccess = new SuccessConsumer<ChangeRemotePeeringConnectionCompartmentRequest, ChangeRemotePeeringConnectionCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeRemotePeeringConnectionCompartmentRequest> onError = new ErrorConsumer<ChangeRemotePeeringConnectionCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeRemotePeeringConnectionCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeRemotePeeringConnectionCompartmentRequest, ChangeRemotePeeringConnectionCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeRemotePeeringConnectionCompartmentRequest, ChangeRemotePeeringConnectionCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeRemotePeeringConnectionCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeRemotePeeringConnectionCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeRemotePeeringConnectionCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeRemotePeeringConnectionCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeRemotePeeringConnectionCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeRemotePeeringConnectionCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeRouteTableCompartmentResponse> changeRouteTableCompartment(ChangeRouteTableCompartmentRequest request, AsyncHandler<ChangeRouteTableCompartmentRequest, ChangeRouteTableCompartmentResponse> handler) {
        LOG.trace("Called async changeRouteTableCompartment");
        final ChangeRouteTableCompartmentRequest interceptedRequest = ChangeRouteTableCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeRouteTableCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeRouteTableCompartmentResponse> transformer = ChangeRouteTableCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeRouteTableCompartmentRequest, ChangeRouteTableCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeRouteTableCompartmentRequest, ChangeRouteTableCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeRouteTableCompartmentRequest, ChangeRouteTableCompartmentResponse> onSuccess = new SuccessConsumer<ChangeRouteTableCompartmentRequest, ChangeRouteTableCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeRouteTableCompartmentRequest> onError = new ErrorConsumer<ChangeRouteTableCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeRouteTableCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeRouteTableCompartmentRequest, ChangeRouteTableCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeRouteTableCompartmentRequest, ChangeRouteTableCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeRouteTableCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeRouteTableCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeRouteTableCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeRouteTableCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeRouteTableCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeRouteTableCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeSecurityListCompartmentResponse> changeSecurityListCompartment(ChangeSecurityListCompartmentRequest request, AsyncHandler<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentResponse> handler) {
        LOG.trace("Called async changeSecurityListCompartment");
        final ChangeSecurityListCompartmentRequest interceptedRequest = ChangeSecurityListCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeSecurityListCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeSecurityListCompartmentResponse> transformer = ChangeSecurityListCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentResponse> onSuccess = new SuccessConsumer<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeSecurityListCompartmentRequest> onError = new ErrorConsumer<ChangeSecurityListCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeSecurityListCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeSecurityListCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeSecurityListCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeSecurityListCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeSecurityListCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeSecurityListCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeSecurityListCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeServiceGatewayCompartmentResponse> changeServiceGatewayCompartment(ChangeServiceGatewayCompartmentRequest request, AsyncHandler<ChangeServiceGatewayCompartmentRequest, ChangeServiceGatewayCompartmentResponse> handler) {
        LOG.trace("Called async changeServiceGatewayCompartment");
        final ChangeServiceGatewayCompartmentRequest interceptedRequest = ChangeServiceGatewayCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeServiceGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeServiceGatewayCompartmentResponse> transformer = ChangeServiceGatewayCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeServiceGatewayCompartmentRequest, ChangeServiceGatewayCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeServiceGatewayCompartmentRequest, ChangeServiceGatewayCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeServiceGatewayCompartmentRequest, ChangeServiceGatewayCompartmentResponse> onSuccess = new SuccessConsumer<ChangeServiceGatewayCompartmentRequest, ChangeServiceGatewayCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeServiceGatewayCompartmentRequest> onError = new ErrorConsumer<ChangeServiceGatewayCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeServiceGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeServiceGatewayCompartmentRequest, ChangeServiceGatewayCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeServiceGatewayCompartmentRequest, ChangeServiceGatewayCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeServiceGatewayCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeServiceGatewayCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeServiceGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeServiceGatewayCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeServiceGatewayCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeServiceGatewayCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeSubnetCompartmentResponse> changeSubnetCompartment(ChangeSubnetCompartmentRequest request, AsyncHandler<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> handler) {
        LOG.trace("Called async changeSubnetCompartment");
        final ChangeSubnetCompartmentRequest interceptedRequest = ChangeSubnetCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeSubnetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeSubnetCompartmentResponse> transformer = ChangeSubnetCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> onSuccess = new SuccessConsumer<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeSubnetCompartmentRequest> onError = new ErrorConsumer<ChangeSubnetCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeSubnetCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeSubnetCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeSubnetCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeSubnetCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeSubnetCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeSubnetCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeSubnetCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVcnCompartmentResponse> changeVcnCompartment(ChangeVcnCompartmentRequest request, AsyncHandler<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> handler) {
        LOG.trace("Called async changeVcnCompartment");
        final ChangeVcnCompartmentRequest interceptedRequest = ChangeVcnCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVcnCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVcnCompartmentResponse> transformer = ChangeVcnCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVcnCompartmentRequest> onError = new ErrorConsumer<ChangeVcnCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeVcnCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVcnCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVcnCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVcnCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVcnCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeVcnCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVcnCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVirtualCircuitCompartmentResponse> changeVirtualCircuitCompartment(ChangeVirtualCircuitCompartmentRequest request, AsyncHandler<ChangeVirtualCircuitCompartmentRequest, ChangeVirtualCircuitCompartmentResponse> handler) {
        LOG.trace("Called async changeVirtualCircuitCompartment");
        final ChangeVirtualCircuitCompartmentRequest interceptedRequest = ChangeVirtualCircuitCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVirtualCircuitCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVirtualCircuitCompartmentResponse> transformer = ChangeVirtualCircuitCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVirtualCircuitCompartmentRequest, ChangeVirtualCircuitCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVirtualCircuitCompartmentRequest, ChangeVirtualCircuitCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVirtualCircuitCompartmentRequest, ChangeVirtualCircuitCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVirtualCircuitCompartmentRequest, ChangeVirtualCircuitCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVirtualCircuitCompartmentRequest> onError = new ErrorConsumer<ChangeVirtualCircuitCompartmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeVirtualCircuitCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVirtualCircuitCompartmentRequest, ChangeVirtualCircuitCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVirtualCircuitCompartmentRequest, ChangeVirtualCircuitCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVirtualCircuitCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVirtualCircuitCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVirtualCircuitCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVirtualCircuitCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getChangeVirtualCircuitCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVirtualCircuitCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ConnectLocalPeeringGatewaysResponse> connectLocalPeeringGateways(ConnectLocalPeeringGatewaysRequest request, AsyncHandler<ConnectLocalPeeringGatewaysRequest, ConnectLocalPeeringGatewaysResponse> handler) {
        LOG.trace("Called async connectLocalPeeringGateways");
        final ConnectLocalPeeringGatewaysRequest interceptedRequest = ConnectLocalPeeringGatewaysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ConnectLocalPeeringGatewaysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ConnectLocalPeeringGatewaysResponse> transformer = ConnectLocalPeeringGatewaysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ConnectLocalPeeringGatewaysRequest, ConnectLocalPeeringGatewaysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ConnectLocalPeeringGatewaysRequest, ConnectLocalPeeringGatewaysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ConnectLocalPeeringGatewaysRequest, ConnectLocalPeeringGatewaysResponse> onSuccess = new SuccessConsumer<ConnectLocalPeeringGatewaysRequest, ConnectLocalPeeringGatewaysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ConnectLocalPeeringGatewaysRequest> onError = new ErrorConsumer<ConnectLocalPeeringGatewaysRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getConnectLocalPeeringGatewaysDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ConnectLocalPeeringGatewaysRequest, ConnectLocalPeeringGatewaysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ConnectLocalPeeringGatewaysRequest, ConnectLocalPeeringGatewaysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ConnectLocalPeeringGatewaysRequest> onError = handler == null ? null : new ErrorConsumer<ConnectLocalPeeringGatewaysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getConnectLocalPeeringGatewaysDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ConnectLocalPeeringGatewaysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getConnectLocalPeeringGatewaysDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ConnectLocalPeeringGatewaysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ConnectRemotePeeringConnectionsResponse> connectRemotePeeringConnections(ConnectRemotePeeringConnectionsRequest request, AsyncHandler<ConnectRemotePeeringConnectionsRequest, ConnectRemotePeeringConnectionsResponse> handler) {
        LOG.trace("Called async connectRemotePeeringConnections");
        final ConnectRemotePeeringConnectionsRequest interceptedRequest = ConnectRemotePeeringConnectionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ConnectRemotePeeringConnectionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ConnectRemotePeeringConnectionsResponse> transformer = ConnectRemotePeeringConnectionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ConnectRemotePeeringConnectionsRequest, ConnectRemotePeeringConnectionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ConnectRemotePeeringConnectionsRequest, ConnectRemotePeeringConnectionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ConnectRemotePeeringConnectionsRequest, ConnectRemotePeeringConnectionsResponse> onSuccess = new SuccessConsumer<ConnectRemotePeeringConnectionsRequest, ConnectRemotePeeringConnectionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ConnectRemotePeeringConnectionsRequest> onError = new ErrorConsumer<ConnectRemotePeeringConnectionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getConnectRemotePeeringConnectionsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ConnectRemotePeeringConnectionsRequest, ConnectRemotePeeringConnectionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ConnectRemotePeeringConnectionsRequest, ConnectRemotePeeringConnectionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ConnectRemotePeeringConnectionsRequest> onError = handler == null ? null : new ErrorConsumer<ConnectRemotePeeringConnectionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getConnectRemotePeeringConnectionsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ConnectRemotePeeringConnectionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getConnectRemotePeeringConnectionsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ConnectRemotePeeringConnectionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCpeResponse> createCpe(CreateCpeRequest request, AsyncHandler<CreateCpeRequest, CreateCpeResponse> handler) {
        LOG.trace("Called async createCpe");
        final CreateCpeRequest interceptedRequest = CreateCpeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCpeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCpeResponse> transformer = CreateCpeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCpeRequest, CreateCpeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCpeRequest, CreateCpeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCpeRequest, CreateCpeResponse> onSuccess = new SuccessConsumer<CreateCpeRequest, CreateCpeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCpeRequest> onError = new ErrorConsumer<CreateCpeRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateCpeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCpeRequest, CreateCpeResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCpeRequest, CreateCpeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCpeRequest> onError = handler == null ? null : new ErrorConsumer<CreateCpeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCpeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCpeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateCpeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCpeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCrossConnectResponse> createCrossConnect(CreateCrossConnectRequest request, AsyncHandler<CreateCrossConnectRequest, CreateCrossConnectResponse> handler) {
        LOG.trace("Called async createCrossConnect");
        final CreateCrossConnectRequest interceptedRequest = CreateCrossConnectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCrossConnectResponse> transformer = CreateCrossConnectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCrossConnectRequest, CreateCrossConnectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCrossConnectRequest, CreateCrossConnectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCrossConnectRequest, CreateCrossConnectResponse> onSuccess = new SuccessConsumer<CreateCrossConnectRequest, CreateCrossConnectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCrossConnectRequest> onError = new ErrorConsumer<CreateCrossConnectRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateCrossConnectDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCrossConnectRequest, CreateCrossConnectResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCrossConnectRequest, CreateCrossConnectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCrossConnectRequest> onError = handler == null ? null : new ErrorConsumer<CreateCrossConnectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCrossConnectDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCrossConnectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateCrossConnectDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCrossConnectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateCrossConnectGroupResponse> createCrossConnectGroup(CreateCrossConnectGroupRequest request, AsyncHandler<CreateCrossConnectGroupRequest, CreateCrossConnectGroupResponse> handler) {
        LOG.trace("Called async createCrossConnectGroup");
        final CreateCrossConnectGroupRequest interceptedRequest = CreateCrossConnectGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateCrossConnectGroupResponse> transformer = CreateCrossConnectGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateCrossConnectGroupRequest, CreateCrossConnectGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateCrossConnectGroupRequest, CreateCrossConnectGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateCrossConnectGroupRequest, CreateCrossConnectGroupResponse> onSuccess = new SuccessConsumer<CreateCrossConnectGroupRequest, CreateCrossConnectGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateCrossConnectGroupRequest> onError = new ErrorConsumer<CreateCrossConnectGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateCrossConnectGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateCrossConnectGroupRequest, CreateCrossConnectGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateCrossConnectGroupRequest, CreateCrossConnectGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateCrossConnectGroupRequest> onError = handler == null ? null : new ErrorConsumer<CreateCrossConnectGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateCrossConnectGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateCrossConnectGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateCrossConnectGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateCrossConnectGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateDhcpOptionsResponse> createDhcpOptions(CreateDhcpOptionsRequest request, AsyncHandler<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse> handler) {
        LOG.trace("Called async createDhcpOptions");
        final CreateDhcpOptionsRequest interceptedRequest = CreateDhcpOptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateDhcpOptionsResponse> transformer = CreateDhcpOptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse> onSuccess = new SuccessConsumer<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateDhcpOptionsRequest> onError = new ErrorConsumer<CreateDhcpOptionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateDhcpDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateDhcpOptionsRequest> onError = handler == null ? null : new ErrorConsumer<CreateDhcpOptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateDhcpDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateDhcpOptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateDhcpDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateDhcpOptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateDrgResponse> createDrg(CreateDrgRequest request, AsyncHandler<CreateDrgRequest, CreateDrgResponse> handler) {
        LOG.trace("Called async createDrg");
        final CreateDrgRequest interceptedRequest = CreateDrgConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateDrgConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateDrgResponse> transformer = CreateDrgConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateDrgRequest, CreateDrgResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateDrgRequest, CreateDrgResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateDrgRequest, CreateDrgResponse> onSuccess = new SuccessConsumer<CreateDrgRequest, CreateDrgResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateDrgRequest> onError = new ErrorConsumer<CreateDrgRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateDrgDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateDrgRequest, CreateDrgResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateDrgRequest, CreateDrgResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateDrgRequest> onError = handler == null ? null : new ErrorConsumer<CreateDrgRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateDrgDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateDrgResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateDrgDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateDrgResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateDrgAttachmentResponse> createDrgAttachment(CreateDrgAttachmentRequest request, AsyncHandler<CreateDrgAttachmentRequest, CreateDrgAttachmentResponse> handler) {
        LOG.trace("Called async createDrgAttachment");
        final CreateDrgAttachmentRequest interceptedRequest = CreateDrgAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateDrgAttachmentResponse> transformer = CreateDrgAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateDrgAttachmentRequest, CreateDrgAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateDrgAttachmentRequest, CreateDrgAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateDrgAttachmentRequest, CreateDrgAttachmentResponse> onSuccess = new SuccessConsumer<CreateDrgAttachmentRequest, CreateDrgAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateDrgAttachmentRequest> onError = new ErrorConsumer<CreateDrgAttachmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateDrgAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateDrgAttachmentRequest, CreateDrgAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateDrgAttachmentRequest, CreateDrgAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateDrgAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<CreateDrgAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateDrgAttachmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateDrgAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateDrgAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateDrgAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateIPSecConnectionResponse> createIPSecConnection(CreateIPSecConnectionRequest request, AsyncHandler<CreateIPSecConnectionRequest, CreateIPSecConnectionResponse> handler) {
        LOG.trace("Called async createIPSecConnection");
        final CreateIPSecConnectionRequest interceptedRequest = CreateIPSecConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateIPSecConnectionResponse> transformer = CreateIPSecConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateIPSecConnectionRequest, CreateIPSecConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateIPSecConnectionRequest, CreateIPSecConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateIPSecConnectionRequest, CreateIPSecConnectionResponse> onSuccess = new SuccessConsumer<CreateIPSecConnectionRequest, CreateIPSecConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateIPSecConnectionRequest> onError = new ErrorConsumer<CreateIPSecConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateIPSecConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateIPSecConnectionRequest, CreateIPSecConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateIPSecConnectionRequest, CreateIPSecConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateIPSecConnectionRequest> onError = handler == null ? null : new ErrorConsumer<CreateIPSecConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateIPSecConnectionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateIPSecConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateIPSecConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateIPSecConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateInternetGatewayResponse> createInternetGateway(CreateInternetGatewayRequest request, AsyncHandler<CreateInternetGatewayRequest, CreateInternetGatewayResponse> handler) {
        LOG.trace("Called async createInternetGateway");
        final CreateInternetGatewayRequest interceptedRequest = CreateInternetGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateInternetGatewayResponse> transformer = CreateInternetGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateInternetGatewayRequest, CreateInternetGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateInternetGatewayRequest, CreateInternetGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateInternetGatewayRequest, CreateInternetGatewayResponse> onSuccess = new SuccessConsumer<CreateInternetGatewayRequest, CreateInternetGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateInternetGatewayRequest> onError = new ErrorConsumer<CreateInternetGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateInternetGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateInternetGatewayRequest, CreateInternetGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateInternetGatewayRequest, CreateInternetGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateInternetGatewayRequest> onError = handler == null ? null : new ErrorConsumer<CreateInternetGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateInternetGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateInternetGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateInternetGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateInternetGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateIpv6Response> createIpv6(CreateIpv6Request request, AsyncHandler<CreateIpv6Request, CreateIpv6Response> handler) {
        LOG.trace("Called async createIpv6");
        final CreateIpv6Request interceptedRequest = CreateIpv6Converter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateIpv6Converter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateIpv6Response> transformer = CreateIpv6Converter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateIpv6Request, CreateIpv6Response> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateIpv6Request, CreateIpv6Response>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateIpv6Request, CreateIpv6Response> onSuccess = new SuccessConsumer<CreateIpv6Request, CreateIpv6Response>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateIpv6Request> onError = new ErrorConsumer<CreateIpv6Request>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateIpv6Details(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateIpv6Request, CreateIpv6Response> onSuccess = handler == null ? null : new SuccessConsumer<CreateIpv6Request, CreateIpv6Response>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateIpv6Request> onError = handler == null ? null : new ErrorConsumer<CreateIpv6Request>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateIpv6Details(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateIpv6Response>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateIpv6Details(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateIpv6Response>(responseFuture, transformer);
    }

    @Override
    public Future<CreateLocalPeeringGatewayResponse> createLocalPeeringGateway(CreateLocalPeeringGatewayRequest request, AsyncHandler<CreateLocalPeeringGatewayRequest, CreateLocalPeeringGatewayResponse> handler) {
        LOG.trace("Called async createLocalPeeringGateway");
        final CreateLocalPeeringGatewayRequest interceptedRequest = CreateLocalPeeringGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateLocalPeeringGatewayResponse> transformer = CreateLocalPeeringGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateLocalPeeringGatewayRequest, CreateLocalPeeringGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateLocalPeeringGatewayRequest, CreateLocalPeeringGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateLocalPeeringGatewayRequest, CreateLocalPeeringGatewayResponse> onSuccess = new SuccessConsumer<CreateLocalPeeringGatewayRequest, CreateLocalPeeringGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateLocalPeeringGatewayRequest> onError = new ErrorConsumer<CreateLocalPeeringGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateLocalPeeringGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateLocalPeeringGatewayRequest, CreateLocalPeeringGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateLocalPeeringGatewayRequest, CreateLocalPeeringGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateLocalPeeringGatewayRequest> onError = handler == null ? null : new ErrorConsumer<CreateLocalPeeringGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateLocalPeeringGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateLocalPeeringGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateLocalPeeringGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateLocalPeeringGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateNatGatewayResponse> createNatGateway(CreateNatGatewayRequest request, AsyncHandler<CreateNatGatewayRequest, CreateNatGatewayResponse> handler) {
        LOG.trace("Called async createNatGateway");
        final CreateNatGatewayRequest interceptedRequest = CreateNatGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateNatGatewayResponse> transformer = CreateNatGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateNatGatewayRequest, CreateNatGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateNatGatewayRequest, CreateNatGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateNatGatewayRequest, CreateNatGatewayResponse> onSuccess = new SuccessConsumer<CreateNatGatewayRequest, CreateNatGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateNatGatewayRequest> onError = new ErrorConsumer<CreateNatGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateNatGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateNatGatewayRequest, CreateNatGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateNatGatewayRequest, CreateNatGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateNatGatewayRequest> onError = handler == null ? null : new ErrorConsumer<CreateNatGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateNatGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateNatGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateNatGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateNatGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateNetworkSecurityGroupResponse> createNetworkSecurityGroup(CreateNetworkSecurityGroupRequest request, AsyncHandler<CreateNetworkSecurityGroupRequest, CreateNetworkSecurityGroupResponse> handler) {
        LOG.trace("Called async createNetworkSecurityGroup");
        final CreateNetworkSecurityGroupRequest interceptedRequest = CreateNetworkSecurityGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateNetworkSecurityGroupResponse> transformer = CreateNetworkSecurityGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateNetworkSecurityGroupRequest, CreateNetworkSecurityGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateNetworkSecurityGroupRequest, CreateNetworkSecurityGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateNetworkSecurityGroupRequest, CreateNetworkSecurityGroupResponse> onSuccess = new SuccessConsumer<CreateNetworkSecurityGroupRequest, CreateNetworkSecurityGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateNetworkSecurityGroupRequest> onError = new ErrorConsumer<CreateNetworkSecurityGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateNetworkSecurityGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateNetworkSecurityGroupRequest, CreateNetworkSecurityGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateNetworkSecurityGroupRequest, CreateNetworkSecurityGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateNetworkSecurityGroupRequest> onError = handler == null ? null : new ErrorConsumer<CreateNetworkSecurityGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateNetworkSecurityGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateNetworkSecurityGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateNetworkSecurityGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateNetworkSecurityGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreatePrivateIpResponse> createPrivateIp(CreatePrivateIpRequest request, AsyncHandler<CreatePrivateIpRequest, CreatePrivateIpResponse> handler) {
        LOG.trace("Called async createPrivateIp");
        final CreatePrivateIpRequest interceptedRequest = CreatePrivateIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreatePrivateIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreatePrivateIpResponse> transformer = CreatePrivateIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreatePrivateIpRequest, CreatePrivateIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreatePrivateIpRequest, CreatePrivateIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreatePrivateIpRequest, CreatePrivateIpResponse> onSuccess = new SuccessConsumer<CreatePrivateIpRequest, CreatePrivateIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreatePrivateIpRequest> onError = new ErrorConsumer<CreatePrivateIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreatePrivateIpDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreatePrivateIpRequest, CreatePrivateIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreatePrivateIpRequest, CreatePrivateIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreatePrivateIpRequest> onError = handler == null ? null : new ErrorConsumer<CreatePrivateIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreatePrivateIpDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreatePrivateIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreatePrivateIpDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreatePrivateIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreatePublicIpResponse> createPublicIp(CreatePublicIpRequest request, AsyncHandler<CreatePublicIpRequest, CreatePublicIpResponse> handler) {
        LOG.trace("Called async createPublicIp");
        final CreatePublicIpRequest interceptedRequest = CreatePublicIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreatePublicIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreatePublicIpResponse> transformer = CreatePublicIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreatePublicIpRequest, CreatePublicIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreatePublicIpRequest, CreatePublicIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreatePublicIpRequest, CreatePublicIpResponse> onSuccess = new SuccessConsumer<CreatePublicIpRequest, CreatePublicIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreatePublicIpRequest> onError = new ErrorConsumer<CreatePublicIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreatePublicIpDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreatePublicIpRequest, CreatePublicIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreatePublicIpRequest, CreatePublicIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreatePublicIpRequest> onError = handler == null ? null : new ErrorConsumer<CreatePublicIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreatePublicIpDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreatePublicIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreatePublicIpDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreatePublicIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateRemotePeeringConnectionResponse> createRemotePeeringConnection(CreateRemotePeeringConnectionRequest request, AsyncHandler<CreateRemotePeeringConnectionRequest, CreateRemotePeeringConnectionResponse> handler) {
        LOG.trace("Called async createRemotePeeringConnection");
        final CreateRemotePeeringConnectionRequest interceptedRequest = CreateRemotePeeringConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateRemotePeeringConnectionResponse> transformer = CreateRemotePeeringConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateRemotePeeringConnectionRequest, CreateRemotePeeringConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateRemotePeeringConnectionRequest, CreateRemotePeeringConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateRemotePeeringConnectionRequest, CreateRemotePeeringConnectionResponse> onSuccess = new SuccessConsumer<CreateRemotePeeringConnectionRequest, CreateRemotePeeringConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateRemotePeeringConnectionRequest> onError = new ErrorConsumer<CreateRemotePeeringConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateRemotePeeringConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateRemotePeeringConnectionRequest, CreateRemotePeeringConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateRemotePeeringConnectionRequest, CreateRemotePeeringConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateRemotePeeringConnectionRequest> onError = handler == null ? null : new ErrorConsumer<CreateRemotePeeringConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateRemotePeeringConnectionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateRemotePeeringConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateRemotePeeringConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateRemotePeeringConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateRouteTableResponse> createRouteTable(CreateRouteTableRequest request, AsyncHandler<CreateRouteTableRequest, CreateRouteTableResponse> handler) {
        LOG.trace("Called async createRouteTable");
        final CreateRouteTableRequest interceptedRequest = CreateRouteTableConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateRouteTableConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateRouteTableResponse> transformer = CreateRouteTableConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateRouteTableRequest, CreateRouteTableResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateRouteTableRequest, CreateRouteTableResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateRouteTableRequest, CreateRouteTableResponse> onSuccess = new SuccessConsumer<CreateRouteTableRequest, CreateRouteTableResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateRouteTableRequest> onError = new ErrorConsumer<CreateRouteTableRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateRouteTableDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateRouteTableRequest, CreateRouteTableResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateRouteTableRequest, CreateRouteTableResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateRouteTableRequest> onError = handler == null ? null : new ErrorConsumer<CreateRouteTableRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateRouteTableDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateRouteTableResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateRouteTableDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateRouteTableResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSecurityListResponse> createSecurityList(CreateSecurityListRequest request, AsyncHandler<CreateSecurityListRequest, CreateSecurityListResponse> handler) {
        LOG.trace("Called async createSecurityList");
        final CreateSecurityListRequest interceptedRequest = CreateSecurityListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSecurityListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSecurityListResponse> transformer = CreateSecurityListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSecurityListRequest, CreateSecurityListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSecurityListRequest, CreateSecurityListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSecurityListRequest, CreateSecurityListResponse> onSuccess = new SuccessConsumer<CreateSecurityListRequest, CreateSecurityListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSecurityListRequest> onError = new ErrorConsumer<CreateSecurityListRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateSecurityListDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSecurityListRequest, CreateSecurityListResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSecurityListRequest, CreateSecurityListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSecurityListRequest> onError = handler == null ? null : new ErrorConsumer<CreateSecurityListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSecurityListDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSecurityListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateSecurityListDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSecurityListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateServiceGatewayResponse> createServiceGateway(CreateServiceGatewayRequest request, AsyncHandler<CreateServiceGatewayRequest, CreateServiceGatewayResponse> handler) {
        LOG.trace("Called async createServiceGateway");
        final CreateServiceGatewayRequest interceptedRequest = CreateServiceGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateServiceGatewayResponse> transformer = CreateServiceGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateServiceGatewayRequest, CreateServiceGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateServiceGatewayRequest, CreateServiceGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateServiceGatewayRequest, CreateServiceGatewayResponse> onSuccess = new SuccessConsumer<CreateServiceGatewayRequest, CreateServiceGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateServiceGatewayRequest> onError = new ErrorConsumer<CreateServiceGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateServiceGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateServiceGatewayRequest, CreateServiceGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateServiceGatewayRequest, CreateServiceGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateServiceGatewayRequest> onError = handler == null ? null : new ErrorConsumer<CreateServiceGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateServiceGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateServiceGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateServiceGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateServiceGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSubnetResponse> createSubnet(CreateSubnetRequest request, AsyncHandler<CreateSubnetRequest, CreateSubnetResponse> handler) {
        LOG.trace("Called async createSubnet");
        final CreateSubnetRequest interceptedRequest = CreateSubnetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSubnetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSubnetResponse> transformer = CreateSubnetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSubnetRequest, CreateSubnetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSubnetRequest, CreateSubnetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSubnetRequest, CreateSubnetResponse> onSuccess = new SuccessConsumer<CreateSubnetRequest, CreateSubnetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSubnetRequest> onError = new ErrorConsumer<CreateSubnetRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateSubnetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSubnetRequest, CreateSubnetResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSubnetRequest, CreateSubnetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSubnetRequest> onError = handler == null ? null : new ErrorConsumer<CreateSubnetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSubnetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSubnetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateSubnetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSubnetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVcnResponse> createVcn(CreateVcnRequest request, AsyncHandler<CreateVcnRequest, CreateVcnResponse> handler) {
        LOG.trace("Called async createVcn");
        final CreateVcnRequest interceptedRequest = CreateVcnConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVcnConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVcnResponse> transformer = CreateVcnConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVcnRequest, CreateVcnResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVcnRequest, CreateVcnResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVcnRequest, CreateVcnResponse> onSuccess = new SuccessConsumer<CreateVcnRequest, CreateVcnResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVcnRequest> onError = new ErrorConsumer<CreateVcnRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateVcnDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVcnRequest, CreateVcnResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVcnRequest, CreateVcnResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVcnRequest> onError = handler == null ? null : new ErrorConsumer<CreateVcnRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVcnDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVcnResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateVcnDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVcnResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVirtualCircuitResponse> createVirtualCircuit(CreateVirtualCircuitRequest request, AsyncHandler<CreateVirtualCircuitRequest, CreateVirtualCircuitResponse> handler) {
        LOG.trace("Called async createVirtualCircuit");
        final CreateVirtualCircuitRequest interceptedRequest = CreateVirtualCircuitConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVirtualCircuitResponse> transformer = CreateVirtualCircuitConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVirtualCircuitRequest, CreateVirtualCircuitResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVirtualCircuitRequest, CreateVirtualCircuitResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVirtualCircuitRequest, CreateVirtualCircuitResponse> onSuccess = new SuccessConsumer<CreateVirtualCircuitRequest, CreateVirtualCircuitResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVirtualCircuitRequest> onError = new ErrorConsumer<CreateVirtualCircuitRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateVirtualCircuitDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVirtualCircuitRequest, CreateVirtualCircuitResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVirtualCircuitRequest, CreateVirtualCircuitResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVirtualCircuitRequest> onError = handler == null ? null : new ErrorConsumer<CreateVirtualCircuitRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVirtualCircuitDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVirtualCircuitResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getCreateVirtualCircuitDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVirtualCircuitResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCpeResponse> deleteCpe(DeleteCpeRequest request, AsyncHandler<DeleteCpeRequest, DeleteCpeResponse> handler) {
        LOG.trace("Called async deleteCpe");
        final DeleteCpeRequest interceptedRequest = DeleteCpeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCpeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCpeResponse> transformer = DeleteCpeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCpeRequest, DeleteCpeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCpeRequest, DeleteCpeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCpeRequest, DeleteCpeResponse> onSuccess = new SuccessConsumer<DeleteCpeRequest, DeleteCpeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCpeRequest> onError = new ErrorConsumer<DeleteCpeRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCpeRequest, DeleteCpeResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCpeRequest, DeleteCpeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCpeRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCpeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCpeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCpeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCrossConnectResponse> deleteCrossConnect(DeleteCrossConnectRequest request, AsyncHandler<DeleteCrossConnectRequest, DeleteCrossConnectResponse> handler) {
        LOG.trace("Called async deleteCrossConnect");
        final DeleteCrossConnectRequest interceptedRequest = DeleteCrossConnectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCrossConnectResponse> transformer = DeleteCrossConnectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCrossConnectRequest, DeleteCrossConnectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCrossConnectRequest, DeleteCrossConnectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCrossConnectRequest, DeleteCrossConnectResponse> onSuccess = new SuccessConsumer<DeleteCrossConnectRequest, DeleteCrossConnectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCrossConnectRequest> onError = new ErrorConsumer<DeleteCrossConnectRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCrossConnectRequest, DeleteCrossConnectResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCrossConnectRequest, DeleteCrossConnectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCrossConnectRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCrossConnectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCrossConnectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCrossConnectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteCrossConnectGroupResponse> deleteCrossConnectGroup(DeleteCrossConnectGroupRequest request, AsyncHandler<DeleteCrossConnectGroupRequest, DeleteCrossConnectGroupResponse> handler) {
        LOG.trace("Called async deleteCrossConnectGroup");
        final DeleteCrossConnectGroupRequest interceptedRequest = DeleteCrossConnectGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteCrossConnectGroupResponse> transformer = DeleteCrossConnectGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteCrossConnectGroupRequest, DeleteCrossConnectGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteCrossConnectGroupRequest, DeleteCrossConnectGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteCrossConnectGroupRequest, DeleteCrossConnectGroupResponse> onSuccess = new SuccessConsumer<DeleteCrossConnectGroupRequest, DeleteCrossConnectGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteCrossConnectGroupRequest> onError = new ErrorConsumer<DeleteCrossConnectGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteCrossConnectGroupRequest, DeleteCrossConnectGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteCrossConnectGroupRequest, DeleteCrossConnectGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteCrossConnectGroupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteCrossConnectGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteCrossConnectGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteCrossConnectGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteDhcpOptionsResponse> deleteDhcpOptions(DeleteDhcpOptionsRequest request, AsyncHandler<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse> handler) {
        LOG.trace("Called async deleteDhcpOptions");
        final DeleteDhcpOptionsRequest interceptedRequest = DeleteDhcpOptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteDhcpOptionsResponse> transformer = DeleteDhcpOptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse> onSuccess = new SuccessConsumer<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteDhcpOptionsRequest> onError = new ErrorConsumer<DeleteDhcpOptionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteDhcpOptionsRequest> onError = handler == null ? null : new ErrorConsumer<DeleteDhcpOptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteDhcpOptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteDhcpOptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteDrgResponse> deleteDrg(DeleteDrgRequest request, AsyncHandler<DeleteDrgRequest, DeleteDrgResponse> handler) {
        LOG.trace("Called async deleteDrg");
        final DeleteDrgRequest interceptedRequest = DeleteDrgConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteDrgConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteDrgResponse> transformer = DeleteDrgConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteDrgRequest, DeleteDrgResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteDrgRequest, DeleteDrgResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteDrgRequest, DeleteDrgResponse> onSuccess = new SuccessConsumer<DeleteDrgRequest, DeleteDrgResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteDrgRequest> onError = new ErrorConsumer<DeleteDrgRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteDrgRequest, DeleteDrgResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteDrgRequest, DeleteDrgResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteDrgRequest> onError = handler == null ? null : new ErrorConsumer<DeleteDrgRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteDrgResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteDrgResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteDrgAttachmentResponse> deleteDrgAttachment(DeleteDrgAttachmentRequest request, AsyncHandler<DeleteDrgAttachmentRequest, DeleteDrgAttachmentResponse> handler) {
        LOG.trace("Called async deleteDrgAttachment");
        final DeleteDrgAttachmentRequest interceptedRequest = DeleteDrgAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteDrgAttachmentResponse> transformer = DeleteDrgAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteDrgAttachmentRequest, DeleteDrgAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteDrgAttachmentRequest, DeleteDrgAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteDrgAttachmentRequest, DeleteDrgAttachmentResponse> onSuccess = new SuccessConsumer<DeleteDrgAttachmentRequest, DeleteDrgAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteDrgAttachmentRequest> onError = new ErrorConsumer<DeleteDrgAttachmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteDrgAttachmentRequest, DeleteDrgAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteDrgAttachmentRequest, DeleteDrgAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteDrgAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<DeleteDrgAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteDrgAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteDrgAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteIPSecConnectionResponse> deleteIPSecConnection(DeleteIPSecConnectionRequest request, AsyncHandler<DeleteIPSecConnectionRequest, DeleteIPSecConnectionResponse> handler) {
        LOG.trace("Called async deleteIPSecConnection");
        final DeleteIPSecConnectionRequest interceptedRequest = DeleteIPSecConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteIPSecConnectionResponse> transformer = DeleteIPSecConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteIPSecConnectionRequest, DeleteIPSecConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteIPSecConnectionRequest, DeleteIPSecConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteIPSecConnectionRequest, DeleteIPSecConnectionResponse> onSuccess = new SuccessConsumer<DeleteIPSecConnectionRequest, DeleteIPSecConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteIPSecConnectionRequest> onError = new ErrorConsumer<DeleteIPSecConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteIPSecConnectionRequest, DeleteIPSecConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteIPSecConnectionRequest, DeleteIPSecConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteIPSecConnectionRequest> onError = handler == null ? null : new ErrorConsumer<DeleteIPSecConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteIPSecConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteIPSecConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteInternetGatewayResponse> deleteInternetGateway(DeleteInternetGatewayRequest request, AsyncHandler<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse> handler) {
        LOG.trace("Called async deleteInternetGateway");
        final DeleteInternetGatewayRequest interceptedRequest = DeleteInternetGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteInternetGatewayResponse> transformer = DeleteInternetGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse> onSuccess = new SuccessConsumer<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteInternetGatewayRequest> onError = new ErrorConsumer<DeleteInternetGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteInternetGatewayRequest> onError = handler == null ? null : new ErrorConsumer<DeleteInternetGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteInternetGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteInternetGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteIpv6Response> deleteIpv6(DeleteIpv6Request request, AsyncHandler<DeleteIpv6Request, DeleteIpv6Response> handler) {
        LOG.trace("Called async deleteIpv6");
        final DeleteIpv6Request interceptedRequest = DeleteIpv6Converter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteIpv6Converter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteIpv6Response> transformer = DeleteIpv6Converter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteIpv6Request, DeleteIpv6Response> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteIpv6Request, DeleteIpv6Response>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteIpv6Request, DeleteIpv6Response> onSuccess = new SuccessConsumer<DeleteIpv6Request, DeleteIpv6Response>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteIpv6Request> onError = new ErrorConsumer<DeleteIpv6Request>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteIpv6Request, DeleteIpv6Response> onSuccess = handler == null ? null : new SuccessConsumer<DeleteIpv6Request, DeleteIpv6Response>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteIpv6Request> onError = handler == null ? null : new ErrorConsumer<DeleteIpv6Request>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteIpv6Response>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteIpv6Response>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteLocalPeeringGatewayResponse> deleteLocalPeeringGateway(DeleteLocalPeeringGatewayRequest request, AsyncHandler<DeleteLocalPeeringGatewayRequest, DeleteLocalPeeringGatewayResponse> handler) {
        LOG.trace("Called async deleteLocalPeeringGateway");
        final DeleteLocalPeeringGatewayRequest interceptedRequest = DeleteLocalPeeringGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteLocalPeeringGatewayResponse> transformer = DeleteLocalPeeringGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteLocalPeeringGatewayRequest, DeleteLocalPeeringGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteLocalPeeringGatewayRequest, DeleteLocalPeeringGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteLocalPeeringGatewayRequest, DeleteLocalPeeringGatewayResponse> onSuccess = new SuccessConsumer<DeleteLocalPeeringGatewayRequest, DeleteLocalPeeringGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteLocalPeeringGatewayRequest> onError = new ErrorConsumer<DeleteLocalPeeringGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteLocalPeeringGatewayRequest, DeleteLocalPeeringGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteLocalPeeringGatewayRequest, DeleteLocalPeeringGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteLocalPeeringGatewayRequest> onError = handler == null ? null : new ErrorConsumer<DeleteLocalPeeringGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteLocalPeeringGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteLocalPeeringGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteNatGatewayResponse> deleteNatGateway(DeleteNatGatewayRequest request, AsyncHandler<DeleteNatGatewayRequest, DeleteNatGatewayResponse> handler) {
        LOG.trace("Called async deleteNatGateway");
        final DeleteNatGatewayRequest interceptedRequest = DeleteNatGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteNatGatewayResponse> transformer = DeleteNatGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteNatGatewayRequest, DeleteNatGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteNatGatewayRequest, DeleteNatGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteNatGatewayRequest, DeleteNatGatewayResponse> onSuccess = new SuccessConsumer<DeleteNatGatewayRequest, DeleteNatGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteNatGatewayRequest> onError = new ErrorConsumer<DeleteNatGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteNatGatewayRequest, DeleteNatGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteNatGatewayRequest, DeleteNatGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteNatGatewayRequest> onError = handler == null ? null : new ErrorConsumer<DeleteNatGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteNatGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteNatGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteNetworkSecurityGroupResponse> deleteNetworkSecurityGroup(DeleteNetworkSecurityGroupRequest request, AsyncHandler<DeleteNetworkSecurityGroupRequest, DeleteNetworkSecurityGroupResponse> handler) {
        LOG.trace("Called async deleteNetworkSecurityGroup");
        final DeleteNetworkSecurityGroupRequest interceptedRequest = DeleteNetworkSecurityGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteNetworkSecurityGroupResponse> transformer = DeleteNetworkSecurityGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteNetworkSecurityGroupRequest, DeleteNetworkSecurityGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteNetworkSecurityGroupRequest, DeleteNetworkSecurityGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteNetworkSecurityGroupRequest, DeleteNetworkSecurityGroupResponse> onSuccess = new SuccessConsumer<DeleteNetworkSecurityGroupRequest, DeleteNetworkSecurityGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteNetworkSecurityGroupRequest> onError = new ErrorConsumer<DeleteNetworkSecurityGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteNetworkSecurityGroupRequest, DeleteNetworkSecurityGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteNetworkSecurityGroupRequest, DeleteNetworkSecurityGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteNetworkSecurityGroupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteNetworkSecurityGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteNetworkSecurityGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteNetworkSecurityGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeletePrivateIpResponse> deletePrivateIp(DeletePrivateIpRequest request, AsyncHandler<DeletePrivateIpRequest, DeletePrivateIpResponse> handler) {
        LOG.trace("Called async deletePrivateIp");
        final DeletePrivateIpRequest interceptedRequest = DeletePrivateIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeletePrivateIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeletePrivateIpResponse> transformer = DeletePrivateIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeletePrivateIpRequest, DeletePrivateIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeletePrivateIpRequest, DeletePrivateIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeletePrivateIpRequest, DeletePrivateIpResponse> onSuccess = new SuccessConsumer<DeletePrivateIpRequest, DeletePrivateIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeletePrivateIpRequest> onError = new ErrorConsumer<DeletePrivateIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeletePrivateIpRequest, DeletePrivateIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeletePrivateIpRequest, DeletePrivateIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeletePrivateIpRequest> onError = handler == null ? null : new ErrorConsumer<DeletePrivateIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeletePrivateIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeletePrivateIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeletePublicIpResponse> deletePublicIp(DeletePublicIpRequest request, AsyncHandler<DeletePublicIpRequest, DeletePublicIpResponse> handler) {
        LOG.trace("Called async deletePublicIp");
        final DeletePublicIpRequest interceptedRequest = DeletePublicIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeletePublicIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeletePublicIpResponse> transformer = DeletePublicIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeletePublicIpRequest, DeletePublicIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeletePublicIpRequest, DeletePublicIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeletePublicIpRequest, DeletePublicIpResponse> onSuccess = new SuccessConsumer<DeletePublicIpRequest, DeletePublicIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeletePublicIpRequest> onError = new ErrorConsumer<DeletePublicIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeletePublicIpRequest, DeletePublicIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeletePublicIpRequest, DeletePublicIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeletePublicIpRequest> onError = handler == null ? null : new ErrorConsumer<DeletePublicIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeletePublicIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeletePublicIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteRemotePeeringConnectionResponse> deleteRemotePeeringConnection(DeleteRemotePeeringConnectionRequest request, AsyncHandler<DeleteRemotePeeringConnectionRequest, DeleteRemotePeeringConnectionResponse> handler) {
        LOG.trace("Called async deleteRemotePeeringConnection");
        final DeleteRemotePeeringConnectionRequest interceptedRequest = DeleteRemotePeeringConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteRemotePeeringConnectionResponse> transformer = DeleteRemotePeeringConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteRemotePeeringConnectionRequest, DeleteRemotePeeringConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteRemotePeeringConnectionRequest, DeleteRemotePeeringConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteRemotePeeringConnectionRequest, DeleteRemotePeeringConnectionResponse> onSuccess = new SuccessConsumer<DeleteRemotePeeringConnectionRequest, DeleteRemotePeeringConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteRemotePeeringConnectionRequest> onError = new ErrorConsumer<DeleteRemotePeeringConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteRemotePeeringConnectionRequest, DeleteRemotePeeringConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteRemotePeeringConnectionRequest, DeleteRemotePeeringConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteRemotePeeringConnectionRequest> onError = handler == null ? null : new ErrorConsumer<DeleteRemotePeeringConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteRemotePeeringConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteRemotePeeringConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteRouteTableResponse> deleteRouteTable(DeleteRouteTableRequest request, AsyncHandler<DeleteRouteTableRequest, DeleteRouteTableResponse> handler) {
        LOG.trace("Called async deleteRouteTable");
        final DeleteRouteTableRequest interceptedRequest = DeleteRouteTableConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteRouteTableConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteRouteTableResponse> transformer = DeleteRouteTableConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteRouteTableRequest, DeleteRouteTableResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteRouteTableRequest, DeleteRouteTableResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteRouteTableRequest, DeleteRouteTableResponse> onSuccess = new SuccessConsumer<DeleteRouteTableRequest, DeleteRouteTableResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteRouteTableRequest> onError = new ErrorConsumer<DeleteRouteTableRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteRouteTableRequest, DeleteRouteTableResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteRouteTableRequest, DeleteRouteTableResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteRouteTableRequest> onError = handler == null ? null : new ErrorConsumer<DeleteRouteTableRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteRouteTableResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteRouteTableResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSecurityListResponse> deleteSecurityList(DeleteSecurityListRequest request, AsyncHandler<DeleteSecurityListRequest, DeleteSecurityListResponse> handler) {
        LOG.trace("Called async deleteSecurityList");
        final DeleteSecurityListRequest interceptedRequest = DeleteSecurityListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSecurityListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSecurityListResponse> transformer = DeleteSecurityListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSecurityListRequest, DeleteSecurityListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSecurityListRequest, DeleteSecurityListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSecurityListRequest, DeleteSecurityListResponse> onSuccess = new SuccessConsumer<DeleteSecurityListRequest, DeleteSecurityListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSecurityListRequest> onError = new ErrorConsumer<DeleteSecurityListRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSecurityListRequest, DeleteSecurityListResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSecurityListRequest, DeleteSecurityListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSecurityListRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSecurityListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSecurityListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSecurityListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteServiceGatewayResponse> deleteServiceGateway(DeleteServiceGatewayRequest request, AsyncHandler<DeleteServiceGatewayRequest, DeleteServiceGatewayResponse> handler) {
        LOG.trace("Called async deleteServiceGateway");
        final DeleteServiceGatewayRequest interceptedRequest = DeleteServiceGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteServiceGatewayResponse> transformer = DeleteServiceGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteServiceGatewayRequest, DeleteServiceGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteServiceGatewayRequest, DeleteServiceGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteServiceGatewayRequest, DeleteServiceGatewayResponse> onSuccess = new SuccessConsumer<DeleteServiceGatewayRequest, DeleteServiceGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteServiceGatewayRequest> onError = new ErrorConsumer<DeleteServiceGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteServiceGatewayRequest, DeleteServiceGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteServiceGatewayRequest, DeleteServiceGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteServiceGatewayRequest> onError = handler == null ? null : new ErrorConsumer<DeleteServiceGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteServiceGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteServiceGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSubnetResponse> deleteSubnet(DeleteSubnetRequest request, AsyncHandler<DeleteSubnetRequest, DeleteSubnetResponse> handler) {
        LOG.trace("Called async deleteSubnet");
        final DeleteSubnetRequest interceptedRequest = DeleteSubnetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSubnetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSubnetResponse> transformer = DeleteSubnetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSubnetRequest, DeleteSubnetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSubnetRequest, DeleteSubnetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSubnetRequest, DeleteSubnetResponse> onSuccess = new SuccessConsumer<DeleteSubnetRequest, DeleteSubnetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSubnetRequest> onError = new ErrorConsumer<DeleteSubnetRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSubnetRequest, DeleteSubnetResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSubnetRequest, DeleteSubnetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSubnetRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSubnetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSubnetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSubnetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVcnResponse> deleteVcn(DeleteVcnRequest request, AsyncHandler<DeleteVcnRequest, DeleteVcnResponse> handler) {
        LOG.trace("Called async deleteVcn");
        final DeleteVcnRequest interceptedRequest = DeleteVcnConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVcnConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVcnResponse> transformer = DeleteVcnConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVcnRequest, DeleteVcnResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVcnRequest, DeleteVcnResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVcnRequest, DeleteVcnResponse> onSuccess = new SuccessConsumer<DeleteVcnRequest, DeleteVcnResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVcnRequest> onError = new ErrorConsumer<DeleteVcnRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVcnRequest, DeleteVcnResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVcnRequest, DeleteVcnResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVcnRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVcnRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVcnResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVcnResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVirtualCircuitResponse> deleteVirtualCircuit(DeleteVirtualCircuitRequest request, AsyncHandler<DeleteVirtualCircuitRequest, DeleteVirtualCircuitResponse> handler) {
        LOG.trace("Called async deleteVirtualCircuit");
        final DeleteVirtualCircuitRequest interceptedRequest = DeleteVirtualCircuitConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVirtualCircuitResponse> transformer = DeleteVirtualCircuitConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVirtualCircuitRequest, DeleteVirtualCircuitResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVirtualCircuitRequest, DeleteVirtualCircuitResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVirtualCircuitRequest, DeleteVirtualCircuitResponse> onSuccess = new SuccessConsumer<DeleteVirtualCircuitRequest, DeleteVirtualCircuitResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVirtualCircuitRequest> onError = new ErrorConsumer<DeleteVirtualCircuitRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVirtualCircuitRequest, DeleteVirtualCircuitResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVirtualCircuitRequest, DeleteVirtualCircuitResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVirtualCircuitRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVirtualCircuitRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVirtualCircuitResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVirtualCircuitResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DetachServiceIdResponse> detachServiceId(DetachServiceIdRequest request, AsyncHandler<DetachServiceIdRequest, DetachServiceIdResponse> handler) {
        LOG.trace("Called async detachServiceId");
        final DetachServiceIdRequest interceptedRequest = DetachServiceIdConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DetachServiceIdConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DetachServiceIdResponse> transformer = DetachServiceIdConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DetachServiceIdRequest, DetachServiceIdResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DetachServiceIdRequest, DetachServiceIdResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DetachServiceIdRequest, DetachServiceIdResponse> onSuccess = new SuccessConsumer<DetachServiceIdRequest, DetachServiceIdResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DetachServiceIdRequest> onError = new ErrorConsumer<DetachServiceIdRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getDetachServiceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DetachServiceIdRequest, DetachServiceIdResponse> onSuccess = handler == null ? null : new SuccessConsumer<DetachServiceIdRequest, DetachServiceIdResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DetachServiceIdRequest> onError = handler == null ? null : new ErrorConsumer<DetachServiceIdRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getDetachServiceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DetachServiceIdResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getDetachServiceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DetachServiceIdResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCpeResponse> getCpe(GetCpeRequest request, AsyncHandler<GetCpeRequest, GetCpeResponse> handler) {
        LOG.trace("Called async getCpe");
        final GetCpeRequest interceptedRequest = GetCpeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCpeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCpeResponse> transformer = GetCpeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCpeRequest, GetCpeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCpeRequest, GetCpeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCpeRequest, GetCpeResponse> onSuccess = new SuccessConsumer<GetCpeRequest, GetCpeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCpeRequest> onError = new ErrorConsumer<GetCpeRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCpeRequest, GetCpeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCpeRequest, GetCpeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCpeRequest> onError = handler == null ? null : new ErrorConsumer<GetCpeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCpeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCpeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCrossConnectResponse> getCrossConnect(GetCrossConnectRequest request, AsyncHandler<GetCrossConnectRequest, GetCrossConnectResponse> handler) {
        LOG.trace("Called async getCrossConnect");
        final GetCrossConnectRequest interceptedRequest = GetCrossConnectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCrossConnectResponse> transformer = GetCrossConnectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectRequest, GetCrossConnectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectRequest, GetCrossConnectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCrossConnectRequest, GetCrossConnectResponse> onSuccess = new SuccessConsumer<GetCrossConnectRequest, GetCrossConnectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCrossConnectRequest> onError = new ErrorConsumer<GetCrossConnectRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCrossConnectRequest, GetCrossConnectResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCrossConnectRequest, GetCrossConnectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCrossConnectRequest> onError = handler == null ? null : new ErrorConsumer<GetCrossConnectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCrossConnectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCrossConnectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCrossConnectGroupResponse> getCrossConnectGroup(GetCrossConnectGroupRequest request, AsyncHandler<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> handler) {
        LOG.trace("Called async getCrossConnectGroup");
        final GetCrossConnectGroupRequest interceptedRequest = GetCrossConnectGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCrossConnectGroupResponse> transformer = GetCrossConnectGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> onSuccess = new SuccessConsumer<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCrossConnectGroupRequest> onError = new ErrorConsumer<GetCrossConnectGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCrossConnectGroupRequest> onError = handler == null ? null : new ErrorConsumer<GetCrossConnectGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCrossConnectGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCrossConnectGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCrossConnectLetterOfAuthorityResponse> getCrossConnectLetterOfAuthority(GetCrossConnectLetterOfAuthorityRequest request, AsyncHandler<GetCrossConnectLetterOfAuthorityRequest, GetCrossConnectLetterOfAuthorityResponse> handler) {
        LOG.trace("Called async getCrossConnectLetterOfAuthority");
        final GetCrossConnectLetterOfAuthorityRequest interceptedRequest = GetCrossConnectLetterOfAuthorityConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCrossConnectLetterOfAuthorityConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCrossConnectLetterOfAuthorityResponse> transformer = GetCrossConnectLetterOfAuthorityConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectLetterOfAuthorityRequest, GetCrossConnectLetterOfAuthorityResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectLetterOfAuthorityRequest, GetCrossConnectLetterOfAuthorityResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCrossConnectLetterOfAuthorityRequest, GetCrossConnectLetterOfAuthorityResponse> onSuccess = new SuccessConsumer<GetCrossConnectLetterOfAuthorityRequest, GetCrossConnectLetterOfAuthorityResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCrossConnectLetterOfAuthorityRequest> onError = new ErrorConsumer<GetCrossConnectLetterOfAuthorityRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCrossConnectLetterOfAuthorityRequest, GetCrossConnectLetterOfAuthorityResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCrossConnectLetterOfAuthorityRequest, GetCrossConnectLetterOfAuthorityResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCrossConnectLetterOfAuthorityRequest> onError = handler == null ? null : new ErrorConsumer<GetCrossConnectLetterOfAuthorityRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCrossConnectLetterOfAuthorityResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCrossConnectLetterOfAuthorityResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetCrossConnectStatusResponse> getCrossConnectStatus(GetCrossConnectStatusRequest request, AsyncHandler<GetCrossConnectStatusRequest, GetCrossConnectStatusResponse> handler) {
        LOG.trace("Called async getCrossConnectStatus");
        final GetCrossConnectStatusRequest interceptedRequest = GetCrossConnectStatusConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetCrossConnectStatusConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetCrossConnectStatusResponse> transformer = GetCrossConnectStatusConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectStatusRequest, GetCrossConnectStatusResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetCrossConnectStatusRequest, GetCrossConnectStatusResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetCrossConnectStatusRequest, GetCrossConnectStatusResponse> onSuccess = new SuccessConsumer<GetCrossConnectStatusRequest, GetCrossConnectStatusResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetCrossConnectStatusRequest> onError = new ErrorConsumer<GetCrossConnectStatusRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetCrossConnectStatusRequest, GetCrossConnectStatusResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetCrossConnectStatusRequest, GetCrossConnectStatusResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetCrossConnectStatusRequest> onError = handler == null ? null : new ErrorConsumer<GetCrossConnectStatusRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetCrossConnectStatusResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetCrossConnectStatusResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDhcpOptionsResponse> getDhcpOptions(GetDhcpOptionsRequest request, AsyncHandler<GetDhcpOptionsRequest, GetDhcpOptionsResponse> handler) {
        LOG.trace("Called async getDhcpOptions");
        final GetDhcpOptionsRequest interceptedRequest = GetDhcpOptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDhcpOptionsResponse> transformer = GetDhcpOptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDhcpOptionsRequest, GetDhcpOptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDhcpOptionsRequest, GetDhcpOptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDhcpOptionsRequest, GetDhcpOptionsResponse> onSuccess = new SuccessConsumer<GetDhcpOptionsRequest, GetDhcpOptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDhcpOptionsRequest> onError = new ErrorConsumer<GetDhcpOptionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDhcpOptionsRequest, GetDhcpOptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDhcpOptionsRequest, GetDhcpOptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDhcpOptionsRequest> onError = handler == null ? null : new ErrorConsumer<GetDhcpOptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDhcpOptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDhcpOptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDrgResponse> getDrg(GetDrgRequest request, AsyncHandler<GetDrgRequest, GetDrgResponse> handler) {
        LOG.trace("Called async getDrg");
        final GetDrgRequest interceptedRequest = GetDrgConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDrgConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDrgResponse> transformer = GetDrgConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDrgRequest, GetDrgResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDrgRequest, GetDrgResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDrgRequest, GetDrgResponse> onSuccess = new SuccessConsumer<GetDrgRequest, GetDrgResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDrgRequest> onError = new ErrorConsumer<GetDrgRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDrgRequest, GetDrgResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDrgRequest, GetDrgResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDrgRequest> onError = handler == null ? null : new ErrorConsumer<GetDrgRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDrgResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDrgResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDrgAttachmentResponse> getDrgAttachment(GetDrgAttachmentRequest request, AsyncHandler<GetDrgAttachmentRequest, GetDrgAttachmentResponse> handler) {
        LOG.trace("Called async getDrgAttachment");
        final GetDrgAttachmentRequest interceptedRequest = GetDrgAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDrgAttachmentResponse> transformer = GetDrgAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDrgAttachmentRequest, GetDrgAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDrgAttachmentRequest, GetDrgAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDrgAttachmentRequest, GetDrgAttachmentResponse> onSuccess = new SuccessConsumer<GetDrgAttachmentRequest, GetDrgAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDrgAttachmentRequest> onError = new ErrorConsumer<GetDrgAttachmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDrgAttachmentRequest, GetDrgAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDrgAttachmentRequest, GetDrgAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDrgAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<GetDrgAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDrgAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDrgAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetFastConnectProviderServiceResponse> getFastConnectProviderService(GetFastConnectProviderServiceRequest request, AsyncHandler<GetFastConnectProviderServiceRequest, GetFastConnectProviderServiceResponse> handler) {
        LOG.trace("Called async getFastConnectProviderService");
        final GetFastConnectProviderServiceRequest interceptedRequest = GetFastConnectProviderServiceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetFastConnectProviderServiceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetFastConnectProviderServiceResponse> transformer = GetFastConnectProviderServiceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetFastConnectProviderServiceRequest, GetFastConnectProviderServiceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetFastConnectProviderServiceRequest, GetFastConnectProviderServiceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetFastConnectProviderServiceRequest, GetFastConnectProviderServiceResponse> onSuccess = new SuccessConsumer<GetFastConnectProviderServiceRequest, GetFastConnectProviderServiceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetFastConnectProviderServiceRequest> onError = new ErrorConsumer<GetFastConnectProviderServiceRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetFastConnectProviderServiceRequest, GetFastConnectProviderServiceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetFastConnectProviderServiceRequest, GetFastConnectProviderServiceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetFastConnectProviderServiceRequest> onError = handler == null ? null : new ErrorConsumer<GetFastConnectProviderServiceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetFastConnectProviderServiceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetFastConnectProviderServiceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetFastConnectProviderServiceKeyResponse> getFastConnectProviderServiceKey(GetFastConnectProviderServiceKeyRequest request, AsyncHandler<GetFastConnectProviderServiceKeyRequest, GetFastConnectProviderServiceKeyResponse> handler) {
        LOG.trace("Called async getFastConnectProviderServiceKey");
        final GetFastConnectProviderServiceKeyRequest interceptedRequest = GetFastConnectProviderServiceKeyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetFastConnectProviderServiceKeyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetFastConnectProviderServiceKeyResponse> transformer = GetFastConnectProviderServiceKeyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetFastConnectProviderServiceKeyRequest, GetFastConnectProviderServiceKeyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetFastConnectProviderServiceKeyRequest, GetFastConnectProviderServiceKeyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetFastConnectProviderServiceKeyRequest, GetFastConnectProviderServiceKeyResponse> onSuccess = new SuccessConsumer<GetFastConnectProviderServiceKeyRequest, GetFastConnectProviderServiceKeyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetFastConnectProviderServiceKeyRequest> onError = new ErrorConsumer<GetFastConnectProviderServiceKeyRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetFastConnectProviderServiceKeyRequest, GetFastConnectProviderServiceKeyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetFastConnectProviderServiceKeyRequest, GetFastConnectProviderServiceKeyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetFastConnectProviderServiceKeyRequest> onError = handler == null ? null : new ErrorConsumer<GetFastConnectProviderServiceKeyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetFastConnectProviderServiceKeyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetFastConnectProviderServiceKeyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIPSecConnectionResponse> getIPSecConnection(GetIPSecConnectionRequest request, AsyncHandler<GetIPSecConnectionRequest, GetIPSecConnectionResponse> handler) {
        LOG.trace("Called async getIPSecConnection");
        final GetIPSecConnectionRequest interceptedRequest = GetIPSecConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIPSecConnectionResponse> transformer = GetIPSecConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionRequest, GetIPSecConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionRequest, GetIPSecConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIPSecConnectionRequest, GetIPSecConnectionResponse> onSuccess = new SuccessConsumer<GetIPSecConnectionRequest, GetIPSecConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIPSecConnectionRequest> onError = new ErrorConsumer<GetIPSecConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIPSecConnectionRequest, GetIPSecConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetIPSecConnectionRequest, GetIPSecConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIPSecConnectionRequest> onError = handler == null ? null : new ErrorConsumer<GetIPSecConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIPSecConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIPSecConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIPSecConnectionDeviceConfigResponse> getIPSecConnectionDeviceConfig(GetIPSecConnectionDeviceConfigRequest request, AsyncHandler<GetIPSecConnectionDeviceConfigRequest, GetIPSecConnectionDeviceConfigResponse> handler) {
        LOG.trace("Called async getIPSecConnectionDeviceConfig");
        final GetIPSecConnectionDeviceConfigRequest interceptedRequest = GetIPSecConnectionDeviceConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIPSecConnectionDeviceConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIPSecConnectionDeviceConfigResponse> transformer = GetIPSecConnectionDeviceConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionDeviceConfigRequest, GetIPSecConnectionDeviceConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionDeviceConfigRequest, GetIPSecConnectionDeviceConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIPSecConnectionDeviceConfigRequest, GetIPSecConnectionDeviceConfigResponse> onSuccess = new SuccessConsumer<GetIPSecConnectionDeviceConfigRequest, GetIPSecConnectionDeviceConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIPSecConnectionDeviceConfigRequest> onError = new ErrorConsumer<GetIPSecConnectionDeviceConfigRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIPSecConnectionDeviceConfigRequest, GetIPSecConnectionDeviceConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetIPSecConnectionDeviceConfigRequest, GetIPSecConnectionDeviceConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIPSecConnectionDeviceConfigRequest> onError = handler == null ? null : new ErrorConsumer<GetIPSecConnectionDeviceConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIPSecConnectionDeviceConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIPSecConnectionDeviceConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIPSecConnectionDeviceStatusResponse> getIPSecConnectionDeviceStatus(GetIPSecConnectionDeviceStatusRequest request, AsyncHandler<GetIPSecConnectionDeviceStatusRequest, GetIPSecConnectionDeviceStatusResponse> handler) {
        LOG.trace("Called async getIPSecConnectionDeviceStatus");
        final GetIPSecConnectionDeviceStatusRequest interceptedRequest = GetIPSecConnectionDeviceStatusConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIPSecConnectionDeviceStatusConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIPSecConnectionDeviceStatusResponse> transformer = GetIPSecConnectionDeviceStatusConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionDeviceStatusRequest, GetIPSecConnectionDeviceStatusResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionDeviceStatusRequest, GetIPSecConnectionDeviceStatusResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIPSecConnectionDeviceStatusRequest, GetIPSecConnectionDeviceStatusResponse> onSuccess = new SuccessConsumer<GetIPSecConnectionDeviceStatusRequest, GetIPSecConnectionDeviceStatusResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIPSecConnectionDeviceStatusRequest> onError = new ErrorConsumer<GetIPSecConnectionDeviceStatusRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIPSecConnectionDeviceStatusRequest, GetIPSecConnectionDeviceStatusResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetIPSecConnectionDeviceStatusRequest, GetIPSecConnectionDeviceStatusResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIPSecConnectionDeviceStatusRequest> onError = handler == null ? null : new ErrorConsumer<GetIPSecConnectionDeviceStatusRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIPSecConnectionDeviceStatusResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIPSecConnectionDeviceStatusResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIPSecConnectionTunnelResponse> getIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request, AsyncHandler<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> handler) {
        LOG.trace("Called async getIPSecConnectionTunnel");
        final GetIPSecConnectionTunnelRequest interceptedRequest = GetIPSecConnectionTunnelConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIPSecConnectionTunnelConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIPSecConnectionTunnelResponse> transformer = GetIPSecConnectionTunnelConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> onSuccess = new SuccessConsumer<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIPSecConnectionTunnelRequest> onError = new ErrorConsumer<GetIPSecConnectionTunnelRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIPSecConnectionTunnelRequest> onError = handler == null ? null : new ErrorConsumer<GetIPSecConnectionTunnelRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIPSecConnectionTunnelResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIPSecConnectionTunnelResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIPSecConnectionTunnelSharedSecretResponse> getIPSecConnectionTunnelSharedSecret(GetIPSecConnectionTunnelSharedSecretRequest request, AsyncHandler<GetIPSecConnectionTunnelSharedSecretRequest, GetIPSecConnectionTunnelSharedSecretResponse> handler) {
        LOG.trace("Called async getIPSecConnectionTunnelSharedSecret");
        final GetIPSecConnectionTunnelSharedSecretRequest interceptedRequest = GetIPSecConnectionTunnelSharedSecretConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIPSecConnectionTunnelSharedSecretConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIPSecConnectionTunnelSharedSecretResponse> transformer = GetIPSecConnectionTunnelSharedSecretConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionTunnelSharedSecretRequest, GetIPSecConnectionTunnelSharedSecretResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIPSecConnectionTunnelSharedSecretRequest, GetIPSecConnectionTunnelSharedSecretResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIPSecConnectionTunnelSharedSecretRequest, GetIPSecConnectionTunnelSharedSecretResponse> onSuccess = new SuccessConsumer<GetIPSecConnectionTunnelSharedSecretRequest, GetIPSecConnectionTunnelSharedSecretResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIPSecConnectionTunnelSharedSecretRequest> onError = new ErrorConsumer<GetIPSecConnectionTunnelSharedSecretRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIPSecConnectionTunnelSharedSecretRequest, GetIPSecConnectionTunnelSharedSecretResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetIPSecConnectionTunnelSharedSecretRequest, GetIPSecConnectionTunnelSharedSecretResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIPSecConnectionTunnelSharedSecretRequest> onError = handler == null ? null : new ErrorConsumer<GetIPSecConnectionTunnelSharedSecretRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIPSecConnectionTunnelSharedSecretResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIPSecConnectionTunnelSharedSecretResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetInternetGatewayResponse> getInternetGateway(GetInternetGatewayRequest request, AsyncHandler<GetInternetGatewayRequest, GetInternetGatewayResponse> handler) {
        LOG.trace("Called async getInternetGateway");
        final GetInternetGatewayRequest interceptedRequest = GetInternetGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetInternetGatewayResponse> transformer = GetInternetGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetInternetGatewayRequest, GetInternetGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetInternetGatewayRequest, GetInternetGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetInternetGatewayRequest, GetInternetGatewayResponse> onSuccess = new SuccessConsumer<GetInternetGatewayRequest, GetInternetGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetInternetGatewayRequest> onError = new ErrorConsumer<GetInternetGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetInternetGatewayRequest, GetInternetGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetInternetGatewayRequest, GetInternetGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetInternetGatewayRequest> onError = handler == null ? null : new ErrorConsumer<GetInternetGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetInternetGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetInternetGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetIpv6Response> getIpv6(GetIpv6Request request, AsyncHandler<GetIpv6Request, GetIpv6Response> handler) {
        LOG.trace("Called async getIpv6");
        final GetIpv6Request interceptedRequest = GetIpv6Converter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetIpv6Converter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetIpv6Response> transformer = GetIpv6Converter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetIpv6Request, GetIpv6Response> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetIpv6Request, GetIpv6Response>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetIpv6Request, GetIpv6Response> onSuccess = new SuccessConsumer<GetIpv6Request, GetIpv6Response>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetIpv6Request> onError = new ErrorConsumer<GetIpv6Request>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetIpv6Request, GetIpv6Response> onSuccess = handler == null ? null : new SuccessConsumer<GetIpv6Request, GetIpv6Response>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetIpv6Request> onError = handler == null ? null : new ErrorConsumer<GetIpv6Request>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetIpv6Response>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetIpv6Response>(responseFuture, transformer);
    }

    @Override
    public Future<GetLocalPeeringGatewayResponse> getLocalPeeringGateway(GetLocalPeeringGatewayRequest request, AsyncHandler<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> handler) {
        LOG.trace("Called async getLocalPeeringGateway");
        final GetLocalPeeringGatewayRequest interceptedRequest = GetLocalPeeringGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetLocalPeeringGatewayResponse> transformer = GetLocalPeeringGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> onSuccess = new SuccessConsumer<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetLocalPeeringGatewayRequest> onError = new ErrorConsumer<GetLocalPeeringGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetLocalPeeringGatewayRequest> onError = handler == null ? null : new ErrorConsumer<GetLocalPeeringGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetLocalPeeringGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetLocalPeeringGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetNatGatewayResponse> getNatGateway(GetNatGatewayRequest request, AsyncHandler<GetNatGatewayRequest, GetNatGatewayResponse> handler) {
        LOG.trace("Called async getNatGateway");
        final GetNatGatewayRequest interceptedRequest = GetNatGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetNatGatewayResponse> transformer = GetNatGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetNatGatewayRequest, GetNatGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetNatGatewayRequest, GetNatGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetNatGatewayRequest, GetNatGatewayResponse> onSuccess = new SuccessConsumer<GetNatGatewayRequest, GetNatGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetNatGatewayRequest> onError = new ErrorConsumer<GetNatGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetNatGatewayRequest, GetNatGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetNatGatewayRequest, GetNatGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetNatGatewayRequest> onError = handler == null ? null : new ErrorConsumer<GetNatGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetNatGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetNatGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetNetworkSecurityGroupResponse> getNetworkSecurityGroup(GetNetworkSecurityGroupRequest request, AsyncHandler<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> handler) {
        LOG.trace("Called async getNetworkSecurityGroup");
        final GetNetworkSecurityGroupRequest interceptedRequest = GetNetworkSecurityGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetNetworkSecurityGroupResponse> transformer = GetNetworkSecurityGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> onSuccess = new SuccessConsumer<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetNetworkSecurityGroupRequest> onError = new ErrorConsumer<GetNetworkSecurityGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetNetworkSecurityGroupRequest> onError = handler == null ? null : new ErrorConsumer<GetNetworkSecurityGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetNetworkSecurityGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetNetworkSecurityGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPrivateIpResponse> getPrivateIp(GetPrivateIpRequest request, AsyncHandler<GetPrivateIpRequest, GetPrivateIpResponse> handler) {
        LOG.trace("Called async getPrivateIp");
        final GetPrivateIpRequest interceptedRequest = GetPrivateIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPrivateIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPrivateIpResponse> transformer = GetPrivateIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPrivateIpRequest, GetPrivateIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPrivateIpRequest, GetPrivateIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPrivateIpRequest, GetPrivateIpResponse> onSuccess = new SuccessConsumer<GetPrivateIpRequest, GetPrivateIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPrivateIpRequest> onError = new ErrorConsumer<GetPrivateIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPrivateIpRequest, GetPrivateIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPrivateIpRequest, GetPrivateIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPrivateIpRequest> onError = handler == null ? null : new ErrorConsumer<GetPrivateIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPrivateIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPrivateIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPublicIpResponse> getPublicIp(GetPublicIpRequest request, AsyncHandler<GetPublicIpRequest, GetPublicIpResponse> handler) {
        LOG.trace("Called async getPublicIp");
        final GetPublicIpRequest interceptedRequest = GetPublicIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPublicIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPublicIpResponse> transformer = GetPublicIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPublicIpRequest, GetPublicIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPublicIpRequest, GetPublicIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPublicIpRequest, GetPublicIpResponse> onSuccess = new SuccessConsumer<GetPublicIpRequest, GetPublicIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPublicIpRequest> onError = new ErrorConsumer<GetPublicIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPublicIpRequest, GetPublicIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPublicIpRequest, GetPublicIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPublicIpRequest> onError = handler == null ? null : new ErrorConsumer<GetPublicIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPublicIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPublicIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPublicIpByIpAddressResponse> getPublicIpByIpAddress(GetPublicIpByIpAddressRequest request, AsyncHandler<GetPublicIpByIpAddressRequest, GetPublicIpByIpAddressResponse> handler) {
        LOG.trace("Called async getPublicIpByIpAddress");
        final GetPublicIpByIpAddressRequest interceptedRequest = GetPublicIpByIpAddressConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPublicIpByIpAddressConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPublicIpByIpAddressResponse> transformer = GetPublicIpByIpAddressConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPublicIpByIpAddressRequest, GetPublicIpByIpAddressResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPublicIpByIpAddressRequest, GetPublicIpByIpAddressResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPublicIpByIpAddressRequest, GetPublicIpByIpAddressResponse> onSuccess = new SuccessConsumer<GetPublicIpByIpAddressRequest, GetPublicIpByIpAddressResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPublicIpByIpAddressRequest> onError = new ErrorConsumer<GetPublicIpByIpAddressRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getGetPublicIpByIpAddressDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPublicIpByIpAddressRequest, GetPublicIpByIpAddressResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPublicIpByIpAddressRequest, GetPublicIpByIpAddressResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPublicIpByIpAddressRequest> onError = handler == null ? null : new ErrorConsumer<GetPublicIpByIpAddressRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getGetPublicIpByIpAddressDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPublicIpByIpAddressResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getGetPublicIpByIpAddressDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPublicIpByIpAddressResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPublicIpByPrivateIpIdResponse> getPublicIpByPrivateIpId(GetPublicIpByPrivateIpIdRequest request, AsyncHandler<GetPublicIpByPrivateIpIdRequest, GetPublicIpByPrivateIpIdResponse> handler) {
        LOG.trace("Called async getPublicIpByPrivateIpId");
        final GetPublicIpByPrivateIpIdRequest interceptedRequest = GetPublicIpByPrivateIpIdConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPublicIpByPrivateIpIdConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPublicIpByPrivateIpIdResponse> transformer = GetPublicIpByPrivateIpIdConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPublicIpByPrivateIpIdRequest, GetPublicIpByPrivateIpIdResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPublicIpByPrivateIpIdRequest, GetPublicIpByPrivateIpIdResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPublicIpByPrivateIpIdRequest, GetPublicIpByPrivateIpIdResponse> onSuccess = new SuccessConsumer<GetPublicIpByPrivateIpIdRequest, GetPublicIpByPrivateIpIdResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPublicIpByPrivateIpIdRequest> onError = new ErrorConsumer<GetPublicIpByPrivateIpIdRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getGetPublicIpByPrivateIpIdDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPublicIpByPrivateIpIdRequest, GetPublicIpByPrivateIpIdResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPublicIpByPrivateIpIdRequest, GetPublicIpByPrivateIpIdResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPublicIpByPrivateIpIdRequest> onError = handler == null ? null : new ErrorConsumer<GetPublicIpByPrivateIpIdRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getGetPublicIpByPrivateIpIdDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPublicIpByPrivateIpIdResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getGetPublicIpByPrivateIpIdDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPublicIpByPrivateIpIdResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetRemotePeeringConnectionResponse> getRemotePeeringConnection(GetRemotePeeringConnectionRequest request, AsyncHandler<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> handler) {
        LOG.trace("Called async getRemotePeeringConnection");
        final GetRemotePeeringConnectionRequest interceptedRequest = GetRemotePeeringConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetRemotePeeringConnectionResponse> transformer = GetRemotePeeringConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> onSuccess = new SuccessConsumer<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetRemotePeeringConnectionRequest> onError = new ErrorConsumer<GetRemotePeeringConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetRemotePeeringConnectionRequest> onError = handler == null ? null : new ErrorConsumer<GetRemotePeeringConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetRemotePeeringConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetRemotePeeringConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetRouteTableResponse> getRouteTable(GetRouteTableRequest request, AsyncHandler<GetRouteTableRequest, GetRouteTableResponse> handler) {
        LOG.trace("Called async getRouteTable");
        final GetRouteTableRequest interceptedRequest = GetRouteTableConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetRouteTableConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetRouteTableResponse> transformer = GetRouteTableConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetRouteTableRequest, GetRouteTableResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetRouteTableRequest, GetRouteTableResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetRouteTableRequest, GetRouteTableResponse> onSuccess = new SuccessConsumer<GetRouteTableRequest, GetRouteTableResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetRouteTableRequest> onError = new ErrorConsumer<GetRouteTableRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetRouteTableRequest, GetRouteTableResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetRouteTableRequest, GetRouteTableResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetRouteTableRequest> onError = handler == null ? null : new ErrorConsumer<GetRouteTableRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetRouteTableResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetRouteTableResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSecurityListResponse> getSecurityList(GetSecurityListRequest request, AsyncHandler<GetSecurityListRequest, GetSecurityListResponse> handler) {
        LOG.trace("Called async getSecurityList");
        final GetSecurityListRequest interceptedRequest = GetSecurityListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSecurityListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSecurityListResponse> transformer = GetSecurityListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSecurityListRequest, GetSecurityListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSecurityListRequest, GetSecurityListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSecurityListRequest, GetSecurityListResponse> onSuccess = new SuccessConsumer<GetSecurityListRequest, GetSecurityListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSecurityListRequest> onError = new ErrorConsumer<GetSecurityListRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSecurityListRequest, GetSecurityListResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSecurityListRequest, GetSecurityListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSecurityListRequest> onError = handler == null ? null : new ErrorConsumer<GetSecurityListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSecurityListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSecurityListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetServiceResponse> getService(GetServiceRequest request, AsyncHandler<GetServiceRequest, GetServiceResponse> handler) {
        LOG.trace("Called async getService");
        final GetServiceRequest interceptedRequest = GetServiceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetServiceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetServiceResponse> transformer = GetServiceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetServiceRequest, GetServiceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetServiceRequest, GetServiceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetServiceRequest, GetServiceResponse> onSuccess = new SuccessConsumer<GetServiceRequest, GetServiceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetServiceRequest> onError = new ErrorConsumer<GetServiceRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetServiceRequest, GetServiceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetServiceRequest, GetServiceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetServiceRequest> onError = handler == null ? null : new ErrorConsumer<GetServiceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetServiceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetServiceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetServiceGatewayResponse> getServiceGateway(GetServiceGatewayRequest request, AsyncHandler<GetServiceGatewayRequest, GetServiceGatewayResponse> handler) {
        LOG.trace("Called async getServiceGateway");
        final GetServiceGatewayRequest interceptedRequest = GetServiceGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetServiceGatewayResponse> transformer = GetServiceGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetServiceGatewayRequest, GetServiceGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetServiceGatewayRequest, GetServiceGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetServiceGatewayRequest, GetServiceGatewayResponse> onSuccess = new SuccessConsumer<GetServiceGatewayRequest, GetServiceGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetServiceGatewayRequest> onError = new ErrorConsumer<GetServiceGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetServiceGatewayRequest, GetServiceGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetServiceGatewayRequest, GetServiceGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetServiceGatewayRequest> onError = handler == null ? null : new ErrorConsumer<GetServiceGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetServiceGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetServiceGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSubnetResponse> getSubnet(GetSubnetRequest request, AsyncHandler<GetSubnetRequest, GetSubnetResponse> handler) {
        LOG.trace("Called async getSubnet");
        final GetSubnetRequest interceptedRequest = GetSubnetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSubnetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSubnetResponse> transformer = GetSubnetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSubnetRequest, GetSubnetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSubnetRequest, GetSubnetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSubnetRequest, GetSubnetResponse> onSuccess = new SuccessConsumer<GetSubnetRequest, GetSubnetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSubnetRequest> onError = new ErrorConsumer<GetSubnetRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSubnetRequest, GetSubnetResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSubnetRequest, GetSubnetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSubnetRequest> onError = handler == null ? null : new ErrorConsumer<GetSubnetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSubnetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSubnetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVcnResponse> getVcn(GetVcnRequest request, AsyncHandler<GetVcnRequest, GetVcnResponse> handler) {
        LOG.trace("Called async getVcn");
        final GetVcnRequest interceptedRequest = GetVcnConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVcnConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVcnResponse> transformer = GetVcnConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVcnRequest, GetVcnResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVcnRequest, GetVcnResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVcnRequest, GetVcnResponse> onSuccess = new SuccessConsumer<GetVcnRequest, GetVcnResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVcnRequest> onError = new ErrorConsumer<GetVcnRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVcnRequest, GetVcnResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVcnRequest, GetVcnResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVcnRequest> onError = handler == null ? null : new ErrorConsumer<GetVcnRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVcnResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVcnResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVirtualCircuitResponse> getVirtualCircuit(GetVirtualCircuitRequest request, AsyncHandler<GetVirtualCircuitRequest, GetVirtualCircuitResponse> handler) {
        LOG.trace("Called async getVirtualCircuit");
        final GetVirtualCircuitRequest interceptedRequest = GetVirtualCircuitConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVirtualCircuitResponse> transformer = GetVirtualCircuitConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVirtualCircuitRequest, GetVirtualCircuitResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVirtualCircuitRequest, GetVirtualCircuitResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVirtualCircuitRequest, GetVirtualCircuitResponse> onSuccess = new SuccessConsumer<GetVirtualCircuitRequest, GetVirtualCircuitResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVirtualCircuitRequest> onError = new ErrorConsumer<GetVirtualCircuitRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVirtualCircuitRequest, GetVirtualCircuitResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVirtualCircuitRequest, GetVirtualCircuitResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVirtualCircuitRequest> onError = handler == null ? null : new ErrorConsumer<GetVirtualCircuitRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVirtualCircuitResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVirtualCircuitResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVnicResponse> getVnic(GetVnicRequest request, AsyncHandler<GetVnicRequest, GetVnicResponse> handler) {
        LOG.trace("Called async getVnic");
        final GetVnicRequest interceptedRequest = GetVnicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVnicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVnicResponse> transformer = GetVnicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVnicRequest, GetVnicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVnicRequest, GetVnicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVnicRequest, GetVnicResponse> onSuccess = new SuccessConsumer<GetVnicRequest, GetVnicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVnicRequest> onError = new ErrorConsumer<GetVnicRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVnicRequest, GetVnicResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVnicRequest, GetVnicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVnicRequest> onError = handler == null ? null : new ErrorConsumer<GetVnicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVnicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVnicResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAllowedPeerRegionsForRemotePeeringResponse> listAllowedPeerRegionsForRemotePeering(ListAllowedPeerRegionsForRemotePeeringRequest request, AsyncHandler<ListAllowedPeerRegionsForRemotePeeringRequest, ListAllowedPeerRegionsForRemotePeeringResponse> handler) {
        LOG.trace("Called async listAllowedPeerRegionsForRemotePeering");
        final ListAllowedPeerRegionsForRemotePeeringRequest interceptedRequest = ListAllowedPeerRegionsForRemotePeeringConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAllowedPeerRegionsForRemotePeeringConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAllowedPeerRegionsForRemotePeeringResponse> transformer = ListAllowedPeerRegionsForRemotePeeringConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAllowedPeerRegionsForRemotePeeringRequest, ListAllowedPeerRegionsForRemotePeeringResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAllowedPeerRegionsForRemotePeeringRequest, ListAllowedPeerRegionsForRemotePeeringResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAllowedPeerRegionsForRemotePeeringRequest, ListAllowedPeerRegionsForRemotePeeringResponse> onSuccess = new SuccessConsumer<ListAllowedPeerRegionsForRemotePeeringRequest, ListAllowedPeerRegionsForRemotePeeringResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAllowedPeerRegionsForRemotePeeringRequest> onError = new ErrorConsumer<ListAllowedPeerRegionsForRemotePeeringRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAllowedPeerRegionsForRemotePeeringRequest, ListAllowedPeerRegionsForRemotePeeringResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAllowedPeerRegionsForRemotePeeringRequest, ListAllowedPeerRegionsForRemotePeeringResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAllowedPeerRegionsForRemotePeeringRequest> onError = handler == null ? null : new ErrorConsumer<ListAllowedPeerRegionsForRemotePeeringRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAllowedPeerRegionsForRemotePeeringResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAllowedPeerRegionsForRemotePeeringResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCpesResponse> listCpes(ListCpesRequest request, AsyncHandler<ListCpesRequest, ListCpesResponse> handler) {
        LOG.trace("Called async listCpes");
        final ListCpesRequest interceptedRequest = ListCpesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCpesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCpesResponse> transformer = ListCpesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCpesRequest, ListCpesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCpesRequest, ListCpesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCpesRequest, ListCpesResponse> onSuccess = new SuccessConsumer<ListCpesRequest, ListCpesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCpesRequest> onError = new ErrorConsumer<ListCpesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCpesRequest, ListCpesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCpesRequest, ListCpesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCpesRequest> onError = handler == null ? null : new ErrorConsumer<ListCpesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCpesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCpesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCrossConnectGroupsResponse> listCrossConnectGroups(ListCrossConnectGroupsRequest request, AsyncHandler<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse> handler) {
        LOG.trace("Called async listCrossConnectGroups");
        final ListCrossConnectGroupsRequest interceptedRequest = ListCrossConnectGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCrossConnectGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCrossConnectGroupsResponse> transformer = ListCrossConnectGroupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse> onSuccess = new SuccessConsumer<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCrossConnectGroupsRequest> onError = new ErrorConsumer<ListCrossConnectGroupsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCrossConnectGroupsRequest> onError = handler == null ? null : new ErrorConsumer<ListCrossConnectGroupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCrossConnectGroupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCrossConnectGroupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCrossConnectLocationsResponse> listCrossConnectLocations(ListCrossConnectLocationsRequest request, AsyncHandler<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse> handler) {
        LOG.trace("Called async listCrossConnectLocations");
        final ListCrossConnectLocationsRequest interceptedRequest = ListCrossConnectLocationsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCrossConnectLocationsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCrossConnectLocationsResponse> transformer = ListCrossConnectLocationsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse> onSuccess = new SuccessConsumer<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCrossConnectLocationsRequest> onError = new ErrorConsumer<ListCrossConnectLocationsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCrossConnectLocationsRequest> onError = handler == null ? null : new ErrorConsumer<ListCrossConnectLocationsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCrossConnectLocationsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCrossConnectLocationsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCrossConnectsResponse> listCrossConnects(ListCrossConnectsRequest request, AsyncHandler<ListCrossConnectsRequest, ListCrossConnectsResponse> handler) {
        LOG.trace("Called async listCrossConnects");
        final ListCrossConnectsRequest interceptedRequest = ListCrossConnectsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCrossConnectsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCrossConnectsResponse> transformer = ListCrossConnectsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCrossConnectsRequest, ListCrossConnectsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCrossConnectsRequest, ListCrossConnectsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCrossConnectsRequest, ListCrossConnectsResponse> onSuccess = new SuccessConsumer<ListCrossConnectsRequest, ListCrossConnectsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCrossConnectsRequest> onError = new ErrorConsumer<ListCrossConnectsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCrossConnectsRequest, ListCrossConnectsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCrossConnectsRequest, ListCrossConnectsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCrossConnectsRequest> onError = handler == null ? null : new ErrorConsumer<ListCrossConnectsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCrossConnectsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCrossConnectsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListCrossconnectPortSpeedShapesResponse> listCrossconnectPortSpeedShapes(ListCrossconnectPortSpeedShapesRequest request, AsyncHandler<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse> handler) {
        LOG.trace("Called async listCrossconnectPortSpeedShapes");
        final ListCrossconnectPortSpeedShapesRequest interceptedRequest = ListCrossconnectPortSpeedShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListCrossconnectPortSpeedShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListCrossconnectPortSpeedShapesResponse> transformer = ListCrossconnectPortSpeedShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse> onSuccess = new SuccessConsumer<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListCrossconnectPortSpeedShapesRequest> onError = new ErrorConsumer<ListCrossconnectPortSpeedShapesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListCrossconnectPortSpeedShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListCrossconnectPortSpeedShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListCrossconnectPortSpeedShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListCrossconnectPortSpeedShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDhcpOptionsResponse> listDhcpOptions(ListDhcpOptionsRequest request, AsyncHandler<ListDhcpOptionsRequest, ListDhcpOptionsResponse> handler) {
        LOG.trace("Called async listDhcpOptions");
        final ListDhcpOptionsRequest interceptedRequest = ListDhcpOptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDhcpOptionsResponse> transformer = ListDhcpOptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDhcpOptionsRequest, ListDhcpOptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDhcpOptionsRequest, ListDhcpOptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDhcpOptionsRequest, ListDhcpOptionsResponse> onSuccess = new SuccessConsumer<ListDhcpOptionsRequest, ListDhcpOptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDhcpOptionsRequest> onError = new ErrorConsumer<ListDhcpOptionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDhcpOptionsRequest, ListDhcpOptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDhcpOptionsRequest, ListDhcpOptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDhcpOptionsRequest> onError = handler == null ? null : new ErrorConsumer<ListDhcpOptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDhcpOptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDhcpOptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDrgAttachmentsResponse> listDrgAttachments(ListDrgAttachmentsRequest request, AsyncHandler<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse> handler) {
        LOG.trace("Called async listDrgAttachments");
        final ListDrgAttachmentsRequest interceptedRequest = ListDrgAttachmentsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDrgAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDrgAttachmentsResponse> transformer = ListDrgAttachmentsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse> onSuccess = new SuccessConsumer<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDrgAttachmentsRequest> onError = new ErrorConsumer<ListDrgAttachmentsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDrgAttachmentsRequest> onError = handler == null ? null : new ErrorConsumer<ListDrgAttachmentsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDrgAttachmentsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDrgAttachmentsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDrgsResponse> listDrgs(ListDrgsRequest request, AsyncHandler<ListDrgsRequest, ListDrgsResponse> handler) {
        LOG.trace("Called async listDrgs");
        final ListDrgsRequest interceptedRequest = ListDrgsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDrgsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDrgsResponse> transformer = ListDrgsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDrgsRequest, ListDrgsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDrgsRequest, ListDrgsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDrgsRequest, ListDrgsResponse> onSuccess = new SuccessConsumer<ListDrgsRequest, ListDrgsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDrgsRequest> onError = new ErrorConsumer<ListDrgsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDrgsRequest, ListDrgsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDrgsRequest, ListDrgsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDrgsRequest> onError = handler == null ? null : new ErrorConsumer<ListDrgsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDrgsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDrgsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListFastConnectProviderServicesResponse> listFastConnectProviderServices(ListFastConnectProviderServicesRequest request, AsyncHandler<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse> handler) {
        LOG.trace("Called async listFastConnectProviderServices");
        final ListFastConnectProviderServicesRequest interceptedRequest = ListFastConnectProviderServicesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListFastConnectProviderServicesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListFastConnectProviderServicesResponse> transformer = ListFastConnectProviderServicesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse> onSuccess = new SuccessConsumer<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListFastConnectProviderServicesRequest> onError = new ErrorConsumer<ListFastConnectProviderServicesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListFastConnectProviderServicesRequest> onError = handler == null ? null : new ErrorConsumer<ListFastConnectProviderServicesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListFastConnectProviderServicesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListFastConnectProviderServicesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> listFastConnectProviderVirtualCircuitBandwidthShapes(ListFastConnectProviderVirtualCircuitBandwidthShapesRequest request, AsyncHandler<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> handler) {
        LOG.trace("Called async listFastConnectProviderVirtualCircuitBandwidthShapes");
        final ListFastConnectProviderVirtualCircuitBandwidthShapesRequest interceptedRequest = ListFastConnectProviderVirtualCircuitBandwidthShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListFastConnectProviderVirtualCircuitBandwidthShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> transformer = ListFastConnectProviderVirtualCircuitBandwidthShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> onSuccess = new SuccessConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest> onError = new ErrorConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListIPSecConnectionTunnelsResponse> listIPSecConnectionTunnels(ListIPSecConnectionTunnelsRequest request, AsyncHandler<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse> handler) {
        LOG.trace("Called async listIPSecConnectionTunnels");
        final ListIPSecConnectionTunnelsRequest interceptedRequest = ListIPSecConnectionTunnelsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListIPSecConnectionTunnelsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListIPSecConnectionTunnelsResponse> transformer = ListIPSecConnectionTunnelsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse> onSuccess = new SuccessConsumer<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListIPSecConnectionTunnelsRequest> onError = new ErrorConsumer<ListIPSecConnectionTunnelsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListIPSecConnectionTunnelsRequest> onError = handler == null ? null : new ErrorConsumer<ListIPSecConnectionTunnelsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListIPSecConnectionTunnelsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListIPSecConnectionTunnelsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListIPSecConnectionsResponse> listIPSecConnections(ListIPSecConnectionsRequest request, AsyncHandler<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse> handler) {
        LOG.trace("Called async listIPSecConnections");
        final ListIPSecConnectionsRequest interceptedRequest = ListIPSecConnectionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListIPSecConnectionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListIPSecConnectionsResponse> transformer = ListIPSecConnectionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse> onSuccess = new SuccessConsumer<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListIPSecConnectionsRequest> onError = new ErrorConsumer<ListIPSecConnectionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListIPSecConnectionsRequest> onError = handler == null ? null : new ErrorConsumer<ListIPSecConnectionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListIPSecConnectionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListIPSecConnectionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListInternetGatewaysResponse> listInternetGateways(ListInternetGatewaysRequest request, AsyncHandler<ListInternetGatewaysRequest, ListInternetGatewaysResponse> handler) {
        LOG.trace("Called async listInternetGateways");
        final ListInternetGatewaysRequest interceptedRequest = ListInternetGatewaysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListInternetGatewaysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListInternetGatewaysResponse> transformer = ListInternetGatewaysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListInternetGatewaysRequest, ListInternetGatewaysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListInternetGatewaysRequest, ListInternetGatewaysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListInternetGatewaysRequest, ListInternetGatewaysResponse> onSuccess = new SuccessConsumer<ListInternetGatewaysRequest, ListInternetGatewaysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListInternetGatewaysRequest> onError = new ErrorConsumer<ListInternetGatewaysRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListInternetGatewaysRequest, ListInternetGatewaysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListInternetGatewaysRequest, ListInternetGatewaysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListInternetGatewaysRequest> onError = handler == null ? null : new ErrorConsumer<ListInternetGatewaysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListInternetGatewaysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListInternetGatewaysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListIpv6sResponse> listIpv6s(ListIpv6sRequest request, AsyncHandler<ListIpv6sRequest, ListIpv6sResponse> handler) {
        LOG.trace("Called async listIpv6s");
        final ListIpv6sRequest interceptedRequest = ListIpv6sConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListIpv6sConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListIpv6sResponse> transformer = ListIpv6sConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListIpv6sRequest, ListIpv6sResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListIpv6sRequest, ListIpv6sResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListIpv6sRequest, ListIpv6sResponse> onSuccess = new SuccessConsumer<ListIpv6sRequest, ListIpv6sResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListIpv6sRequest> onError = new ErrorConsumer<ListIpv6sRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListIpv6sRequest, ListIpv6sResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListIpv6sRequest, ListIpv6sResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListIpv6sRequest> onError = handler == null ? null : new ErrorConsumer<ListIpv6sRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListIpv6sResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListIpv6sResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListLocalPeeringGatewaysResponse> listLocalPeeringGateways(ListLocalPeeringGatewaysRequest request, AsyncHandler<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse> handler) {
        LOG.trace("Called async listLocalPeeringGateways");
        final ListLocalPeeringGatewaysRequest interceptedRequest = ListLocalPeeringGatewaysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListLocalPeeringGatewaysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListLocalPeeringGatewaysResponse> transformer = ListLocalPeeringGatewaysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse> onSuccess = new SuccessConsumer<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListLocalPeeringGatewaysRequest> onError = new ErrorConsumer<ListLocalPeeringGatewaysRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListLocalPeeringGatewaysRequest> onError = handler == null ? null : new ErrorConsumer<ListLocalPeeringGatewaysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListLocalPeeringGatewaysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListLocalPeeringGatewaysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListNatGatewaysResponse> listNatGateways(ListNatGatewaysRequest request, AsyncHandler<ListNatGatewaysRequest, ListNatGatewaysResponse> handler) {
        LOG.trace("Called async listNatGateways");
        final ListNatGatewaysRequest interceptedRequest = ListNatGatewaysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListNatGatewaysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListNatGatewaysResponse> transformer = ListNatGatewaysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListNatGatewaysRequest, ListNatGatewaysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListNatGatewaysRequest, ListNatGatewaysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListNatGatewaysRequest, ListNatGatewaysResponse> onSuccess = new SuccessConsumer<ListNatGatewaysRequest, ListNatGatewaysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListNatGatewaysRequest> onError = new ErrorConsumer<ListNatGatewaysRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListNatGatewaysRequest, ListNatGatewaysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListNatGatewaysRequest, ListNatGatewaysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListNatGatewaysRequest> onError = handler == null ? null : new ErrorConsumer<ListNatGatewaysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListNatGatewaysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListNatGatewaysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListNetworkSecurityGroupSecurityRulesResponse> listNetworkSecurityGroupSecurityRules(ListNetworkSecurityGroupSecurityRulesRequest request, AsyncHandler<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse> handler) {
        LOG.trace("Called async listNetworkSecurityGroupSecurityRules");
        final ListNetworkSecurityGroupSecurityRulesRequest interceptedRequest = ListNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListNetworkSecurityGroupSecurityRulesResponse> transformer = ListNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse> onSuccess = new SuccessConsumer<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListNetworkSecurityGroupSecurityRulesRequest> onError = new ErrorConsumer<ListNetworkSecurityGroupSecurityRulesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListNetworkSecurityGroupSecurityRulesRequest> onError = handler == null ? null : new ErrorConsumer<ListNetworkSecurityGroupSecurityRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListNetworkSecurityGroupVnicsResponse> listNetworkSecurityGroupVnics(ListNetworkSecurityGroupVnicsRequest request, AsyncHandler<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse> handler) {
        LOG.trace("Called async listNetworkSecurityGroupVnics");
        final ListNetworkSecurityGroupVnicsRequest interceptedRequest = ListNetworkSecurityGroupVnicsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListNetworkSecurityGroupVnicsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListNetworkSecurityGroupVnicsResponse> transformer = ListNetworkSecurityGroupVnicsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse> onSuccess = new SuccessConsumer<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListNetworkSecurityGroupVnicsRequest> onError = new ErrorConsumer<ListNetworkSecurityGroupVnicsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListNetworkSecurityGroupVnicsRequest> onError = handler == null ? null : new ErrorConsumer<ListNetworkSecurityGroupVnicsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListNetworkSecurityGroupVnicsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListNetworkSecurityGroupVnicsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListNetworkSecurityGroupsResponse> listNetworkSecurityGroups(ListNetworkSecurityGroupsRequest request, AsyncHandler<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse> handler) {
        LOG.trace("Called async listNetworkSecurityGroups");
        final ListNetworkSecurityGroupsRequest interceptedRequest = ListNetworkSecurityGroupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListNetworkSecurityGroupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListNetworkSecurityGroupsResponse> transformer = ListNetworkSecurityGroupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse> onSuccess = new SuccessConsumer<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListNetworkSecurityGroupsRequest> onError = new ErrorConsumer<ListNetworkSecurityGroupsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListNetworkSecurityGroupsRequest> onError = handler == null ? null : new ErrorConsumer<ListNetworkSecurityGroupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListNetworkSecurityGroupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListNetworkSecurityGroupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPrivateIpsResponse> listPrivateIps(ListPrivateIpsRequest request, AsyncHandler<ListPrivateIpsRequest, ListPrivateIpsResponse> handler) {
        LOG.trace("Called async listPrivateIps");
        final ListPrivateIpsRequest interceptedRequest = ListPrivateIpsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPrivateIpsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPrivateIpsResponse> transformer = ListPrivateIpsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPrivateIpsRequest, ListPrivateIpsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPrivateIpsRequest, ListPrivateIpsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPrivateIpsRequest, ListPrivateIpsResponse> onSuccess = new SuccessConsumer<ListPrivateIpsRequest, ListPrivateIpsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPrivateIpsRequest> onError = new ErrorConsumer<ListPrivateIpsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPrivateIpsRequest, ListPrivateIpsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPrivateIpsRequest, ListPrivateIpsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPrivateIpsRequest> onError = handler == null ? null : new ErrorConsumer<ListPrivateIpsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPrivateIpsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPrivateIpsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPublicIpsResponse> listPublicIps(ListPublicIpsRequest request, AsyncHandler<ListPublicIpsRequest, ListPublicIpsResponse> handler) {
        LOG.trace("Called async listPublicIps");
        final ListPublicIpsRequest interceptedRequest = ListPublicIpsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPublicIpsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPublicIpsResponse> transformer = ListPublicIpsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPublicIpsRequest, ListPublicIpsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPublicIpsRequest, ListPublicIpsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPublicIpsRequest, ListPublicIpsResponse> onSuccess = new SuccessConsumer<ListPublicIpsRequest, ListPublicIpsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPublicIpsRequest> onError = new ErrorConsumer<ListPublicIpsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPublicIpsRequest, ListPublicIpsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPublicIpsRequest, ListPublicIpsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPublicIpsRequest> onError = handler == null ? null : new ErrorConsumer<ListPublicIpsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPublicIpsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPublicIpsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListRemotePeeringConnectionsResponse> listRemotePeeringConnections(ListRemotePeeringConnectionsRequest request, AsyncHandler<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse> handler) {
        LOG.trace("Called async listRemotePeeringConnections");
        final ListRemotePeeringConnectionsRequest interceptedRequest = ListRemotePeeringConnectionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListRemotePeeringConnectionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListRemotePeeringConnectionsResponse> transformer = ListRemotePeeringConnectionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse> onSuccess = new SuccessConsumer<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListRemotePeeringConnectionsRequest> onError = new ErrorConsumer<ListRemotePeeringConnectionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListRemotePeeringConnectionsRequest> onError = handler == null ? null : new ErrorConsumer<ListRemotePeeringConnectionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListRemotePeeringConnectionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListRemotePeeringConnectionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListRouteTablesResponse> listRouteTables(ListRouteTablesRequest request, AsyncHandler<ListRouteTablesRequest, ListRouteTablesResponse> handler) {
        LOG.trace("Called async listRouteTables");
        final ListRouteTablesRequest interceptedRequest = ListRouteTablesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListRouteTablesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListRouteTablesResponse> transformer = ListRouteTablesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListRouteTablesRequest, ListRouteTablesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListRouteTablesRequest, ListRouteTablesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListRouteTablesRequest, ListRouteTablesResponse> onSuccess = new SuccessConsumer<ListRouteTablesRequest, ListRouteTablesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListRouteTablesRequest> onError = new ErrorConsumer<ListRouteTablesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListRouteTablesRequest, ListRouteTablesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListRouteTablesRequest, ListRouteTablesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListRouteTablesRequest> onError = handler == null ? null : new ErrorConsumer<ListRouteTablesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListRouteTablesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListRouteTablesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSecurityListsResponse> listSecurityLists(ListSecurityListsRequest request, AsyncHandler<ListSecurityListsRequest, ListSecurityListsResponse> handler) {
        LOG.trace("Called async listSecurityLists");
        final ListSecurityListsRequest interceptedRequest = ListSecurityListsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSecurityListsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSecurityListsResponse> transformer = ListSecurityListsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSecurityListsRequest, ListSecurityListsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSecurityListsRequest, ListSecurityListsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSecurityListsRequest, ListSecurityListsResponse> onSuccess = new SuccessConsumer<ListSecurityListsRequest, ListSecurityListsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSecurityListsRequest> onError = new ErrorConsumer<ListSecurityListsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSecurityListsRequest, ListSecurityListsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSecurityListsRequest, ListSecurityListsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSecurityListsRequest> onError = handler == null ? null : new ErrorConsumer<ListSecurityListsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSecurityListsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSecurityListsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListServiceGatewaysResponse> listServiceGateways(ListServiceGatewaysRequest request, AsyncHandler<ListServiceGatewaysRequest, ListServiceGatewaysResponse> handler) {
        LOG.trace("Called async listServiceGateways");
        final ListServiceGatewaysRequest interceptedRequest = ListServiceGatewaysConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListServiceGatewaysConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListServiceGatewaysResponse> transformer = ListServiceGatewaysConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListServiceGatewaysRequest, ListServiceGatewaysResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListServiceGatewaysRequest, ListServiceGatewaysResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListServiceGatewaysRequest, ListServiceGatewaysResponse> onSuccess = new SuccessConsumer<ListServiceGatewaysRequest, ListServiceGatewaysResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListServiceGatewaysRequest> onError = new ErrorConsumer<ListServiceGatewaysRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListServiceGatewaysRequest, ListServiceGatewaysResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListServiceGatewaysRequest, ListServiceGatewaysResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListServiceGatewaysRequest> onError = handler == null ? null : new ErrorConsumer<ListServiceGatewaysRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListServiceGatewaysResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListServiceGatewaysResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListServicesResponse> listServices(ListServicesRequest request, AsyncHandler<ListServicesRequest, ListServicesResponse> handler) {
        LOG.trace("Called async listServices");
        final ListServicesRequest interceptedRequest = ListServicesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListServicesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListServicesResponse> transformer = ListServicesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListServicesRequest, ListServicesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListServicesRequest, ListServicesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListServicesRequest, ListServicesResponse> onSuccess = new SuccessConsumer<ListServicesRequest, ListServicesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListServicesRequest> onError = new ErrorConsumer<ListServicesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListServicesRequest, ListServicesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListServicesRequest, ListServicesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListServicesRequest> onError = handler == null ? null : new ErrorConsumer<ListServicesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListServicesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListServicesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSubnetsResponse> listSubnets(ListSubnetsRequest request, AsyncHandler<ListSubnetsRequest, ListSubnetsResponse> handler) {
        LOG.trace("Called async listSubnets");
        final ListSubnetsRequest interceptedRequest = ListSubnetsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSubnetsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSubnetsResponse> transformer = ListSubnetsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSubnetsRequest, ListSubnetsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSubnetsRequest, ListSubnetsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSubnetsRequest, ListSubnetsResponse> onSuccess = new SuccessConsumer<ListSubnetsRequest, ListSubnetsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSubnetsRequest> onError = new ErrorConsumer<ListSubnetsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSubnetsRequest, ListSubnetsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSubnetsRequest, ListSubnetsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSubnetsRequest> onError = handler == null ? null : new ErrorConsumer<ListSubnetsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSubnetsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSubnetsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVcnsResponse> listVcns(ListVcnsRequest request, AsyncHandler<ListVcnsRequest, ListVcnsResponse> handler) {
        LOG.trace("Called async listVcns");
        final ListVcnsRequest interceptedRequest = ListVcnsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVcnsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVcnsResponse> transformer = ListVcnsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVcnsRequest, ListVcnsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVcnsRequest, ListVcnsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVcnsRequest, ListVcnsResponse> onSuccess = new SuccessConsumer<ListVcnsRequest, ListVcnsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVcnsRequest> onError = new ErrorConsumer<ListVcnsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVcnsRequest, ListVcnsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVcnsRequest, ListVcnsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVcnsRequest> onError = handler == null ? null : new ErrorConsumer<ListVcnsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVcnsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVcnsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVirtualCircuitBandwidthShapesResponse> listVirtualCircuitBandwidthShapes(ListVirtualCircuitBandwidthShapesRequest request, AsyncHandler<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse> handler) {
        LOG.trace("Called async listVirtualCircuitBandwidthShapes");
        final ListVirtualCircuitBandwidthShapesRequest interceptedRequest = ListVirtualCircuitBandwidthShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVirtualCircuitBandwidthShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVirtualCircuitBandwidthShapesResponse> transformer = ListVirtualCircuitBandwidthShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse> onSuccess = new SuccessConsumer<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVirtualCircuitBandwidthShapesRequest> onError = new ErrorConsumer<ListVirtualCircuitBandwidthShapesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVirtualCircuitBandwidthShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListVirtualCircuitBandwidthShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVirtualCircuitBandwidthShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVirtualCircuitBandwidthShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVirtualCircuitPublicPrefixesResponse> listVirtualCircuitPublicPrefixes(ListVirtualCircuitPublicPrefixesRequest request, AsyncHandler<ListVirtualCircuitPublicPrefixesRequest, ListVirtualCircuitPublicPrefixesResponse> handler) {
        LOG.trace("Called async listVirtualCircuitPublicPrefixes");
        final ListVirtualCircuitPublicPrefixesRequest interceptedRequest = ListVirtualCircuitPublicPrefixesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVirtualCircuitPublicPrefixesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVirtualCircuitPublicPrefixesResponse> transformer = ListVirtualCircuitPublicPrefixesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVirtualCircuitPublicPrefixesRequest, ListVirtualCircuitPublicPrefixesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVirtualCircuitPublicPrefixesRequest, ListVirtualCircuitPublicPrefixesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVirtualCircuitPublicPrefixesRequest, ListVirtualCircuitPublicPrefixesResponse> onSuccess = new SuccessConsumer<ListVirtualCircuitPublicPrefixesRequest, ListVirtualCircuitPublicPrefixesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVirtualCircuitPublicPrefixesRequest> onError = new ErrorConsumer<ListVirtualCircuitPublicPrefixesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVirtualCircuitPublicPrefixesRequest, ListVirtualCircuitPublicPrefixesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVirtualCircuitPublicPrefixesRequest, ListVirtualCircuitPublicPrefixesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVirtualCircuitPublicPrefixesRequest> onError = handler == null ? null : new ErrorConsumer<ListVirtualCircuitPublicPrefixesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVirtualCircuitPublicPrefixesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVirtualCircuitPublicPrefixesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVirtualCircuitsResponse> listVirtualCircuits(ListVirtualCircuitsRequest request, AsyncHandler<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse> handler) {
        LOG.trace("Called async listVirtualCircuits");
        final ListVirtualCircuitsRequest interceptedRequest = ListVirtualCircuitsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVirtualCircuitsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVirtualCircuitsResponse> transformer = ListVirtualCircuitsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse> onSuccess = new SuccessConsumer<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVirtualCircuitsRequest> onError = new ErrorConsumer<ListVirtualCircuitsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVirtualCircuitsRequest> onError = handler == null ? null : new ErrorConsumer<ListVirtualCircuitsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVirtualCircuitsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVirtualCircuitsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RemoveNetworkSecurityGroupSecurityRulesResponse> removeNetworkSecurityGroupSecurityRules(RemoveNetworkSecurityGroupSecurityRulesRequest request, AsyncHandler<RemoveNetworkSecurityGroupSecurityRulesRequest, RemoveNetworkSecurityGroupSecurityRulesResponse> handler) {
        LOG.trace("Called async removeNetworkSecurityGroupSecurityRules");
        final RemoveNetworkSecurityGroupSecurityRulesRequest interceptedRequest = RemoveNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RemoveNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RemoveNetworkSecurityGroupSecurityRulesResponse> transformer = RemoveNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RemoveNetworkSecurityGroupSecurityRulesRequest, RemoveNetworkSecurityGroupSecurityRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RemoveNetworkSecurityGroupSecurityRulesRequest, RemoveNetworkSecurityGroupSecurityRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest, RemoveNetworkSecurityGroupSecurityRulesResponse> onSuccess = new SuccessConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest, RemoveNetworkSecurityGroupSecurityRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest> onError = new ErrorConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getRemoveNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest, RemoveNetworkSecurityGroupSecurityRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest, RemoveNetworkSecurityGroupSecurityRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest> onError = handler == null ? null : new ErrorConsumer<RemoveNetworkSecurityGroupSecurityRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getRemoveNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RemoveNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getRemoveNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RemoveNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCpeResponse> updateCpe(UpdateCpeRequest request, AsyncHandler<UpdateCpeRequest, UpdateCpeResponse> handler) {
        LOG.trace("Called async updateCpe");
        final UpdateCpeRequest interceptedRequest = UpdateCpeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCpeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCpeResponse> transformer = UpdateCpeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCpeRequest, UpdateCpeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCpeRequest, UpdateCpeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCpeRequest, UpdateCpeResponse> onSuccess = new SuccessConsumer<UpdateCpeRequest, UpdateCpeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCpeRequest> onError = new ErrorConsumer<UpdateCpeRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCpeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCpeRequest, UpdateCpeResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCpeRequest, UpdateCpeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCpeRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCpeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCpeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCpeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCpeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCpeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCrossConnectResponse> updateCrossConnect(UpdateCrossConnectRequest request, AsyncHandler<UpdateCrossConnectRequest, UpdateCrossConnectResponse> handler) {
        LOG.trace("Called async updateCrossConnect");
        final UpdateCrossConnectRequest interceptedRequest = UpdateCrossConnectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCrossConnectResponse> transformer = UpdateCrossConnectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCrossConnectRequest, UpdateCrossConnectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCrossConnectRequest, UpdateCrossConnectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCrossConnectRequest, UpdateCrossConnectResponse> onSuccess = new SuccessConsumer<UpdateCrossConnectRequest, UpdateCrossConnectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCrossConnectRequest> onError = new ErrorConsumer<UpdateCrossConnectRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCrossConnectDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCrossConnectRequest, UpdateCrossConnectResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCrossConnectRequest, UpdateCrossConnectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCrossConnectRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCrossConnectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCrossConnectDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCrossConnectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCrossConnectDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCrossConnectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateCrossConnectGroupResponse> updateCrossConnectGroup(UpdateCrossConnectGroupRequest request, AsyncHandler<UpdateCrossConnectGroupRequest, UpdateCrossConnectGroupResponse> handler) {
        LOG.trace("Called async updateCrossConnectGroup");
        final UpdateCrossConnectGroupRequest interceptedRequest = UpdateCrossConnectGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateCrossConnectGroupResponse> transformer = UpdateCrossConnectGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateCrossConnectGroupRequest, UpdateCrossConnectGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateCrossConnectGroupRequest, UpdateCrossConnectGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateCrossConnectGroupRequest, UpdateCrossConnectGroupResponse> onSuccess = new SuccessConsumer<UpdateCrossConnectGroupRequest, UpdateCrossConnectGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateCrossConnectGroupRequest> onError = new ErrorConsumer<UpdateCrossConnectGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCrossConnectGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateCrossConnectGroupRequest, UpdateCrossConnectGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateCrossConnectGroupRequest, UpdateCrossConnectGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateCrossConnectGroupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateCrossConnectGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateCrossConnectGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateCrossConnectGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateCrossConnectGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateCrossConnectGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDhcpOptionsResponse> updateDhcpOptions(UpdateDhcpOptionsRequest request, AsyncHandler<UpdateDhcpOptionsRequest, UpdateDhcpOptionsResponse> handler) {
        LOG.trace("Called async updateDhcpOptions");
        final UpdateDhcpOptionsRequest interceptedRequest = UpdateDhcpOptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDhcpOptionsResponse> transformer = UpdateDhcpOptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDhcpOptionsRequest, UpdateDhcpOptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDhcpOptionsRequest, UpdateDhcpOptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDhcpOptionsRequest, UpdateDhcpOptionsResponse> onSuccess = new SuccessConsumer<UpdateDhcpOptionsRequest, UpdateDhcpOptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDhcpOptionsRequest> onError = new ErrorConsumer<UpdateDhcpOptionsRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDhcpDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDhcpOptionsRequest, UpdateDhcpOptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDhcpOptionsRequest, UpdateDhcpOptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDhcpOptionsRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDhcpOptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDhcpDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDhcpOptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDhcpDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDhcpOptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDrgResponse> updateDrg(UpdateDrgRequest request, AsyncHandler<UpdateDrgRequest, UpdateDrgResponse> handler) {
        LOG.trace("Called async updateDrg");
        final UpdateDrgRequest interceptedRequest = UpdateDrgConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDrgConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDrgResponse> transformer = UpdateDrgConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDrgRequest, UpdateDrgResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDrgRequest, UpdateDrgResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDrgRequest, UpdateDrgResponse> onSuccess = new SuccessConsumer<UpdateDrgRequest, UpdateDrgResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDrgRequest> onError = new ErrorConsumer<UpdateDrgRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDrgDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDrgRequest, UpdateDrgResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDrgRequest, UpdateDrgResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDrgRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDrgRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDrgDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDrgResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDrgDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDrgResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDrgAttachmentResponse> updateDrgAttachment(UpdateDrgAttachmentRequest request, AsyncHandler<UpdateDrgAttachmentRequest, UpdateDrgAttachmentResponse> handler) {
        LOG.trace("Called async updateDrgAttachment");
        final UpdateDrgAttachmentRequest interceptedRequest = UpdateDrgAttachmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDrgAttachmentResponse> transformer = UpdateDrgAttachmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDrgAttachmentRequest, UpdateDrgAttachmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDrgAttachmentRequest, UpdateDrgAttachmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDrgAttachmentRequest, UpdateDrgAttachmentResponse> onSuccess = new SuccessConsumer<UpdateDrgAttachmentRequest, UpdateDrgAttachmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDrgAttachmentRequest> onError = new ErrorConsumer<UpdateDrgAttachmentRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDrgAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDrgAttachmentRequest, UpdateDrgAttachmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDrgAttachmentRequest, UpdateDrgAttachmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDrgAttachmentRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDrgAttachmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDrgAttachmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDrgAttachmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDrgAttachmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDrgAttachmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateIPSecConnectionResponse> updateIPSecConnection(UpdateIPSecConnectionRequest request, AsyncHandler<UpdateIPSecConnectionRequest, UpdateIPSecConnectionResponse> handler) {
        LOG.trace("Called async updateIPSecConnection");
        final UpdateIPSecConnectionRequest interceptedRequest = UpdateIPSecConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateIPSecConnectionResponse> transformer = UpdateIPSecConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateIPSecConnectionRequest, UpdateIPSecConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateIPSecConnectionRequest, UpdateIPSecConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateIPSecConnectionRequest, UpdateIPSecConnectionResponse> onSuccess = new SuccessConsumer<UpdateIPSecConnectionRequest, UpdateIPSecConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateIPSecConnectionRequest> onError = new ErrorConsumer<UpdateIPSecConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateIPSecConnectionRequest, UpdateIPSecConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateIPSecConnectionRequest, UpdateIPSecConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateIPSecConnectionRequest> onError = handler == null ? null : new ErrorConsumer<UpdateIPSecConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateIPSecConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateIPSecConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateIPSecConnectionTunnelResponse> updateIPSecConnectionTunnel(UpdateIPSecConnectionTunnelRequest request, AsyncHandler<UpdateIPSecConnectionTunnelRequest, UpdateIPSecConnectionTunnelResponse> handler) {
        LOG.trace("Called async updateIPSecConnectionTunnel");
        final UpdateIPSecConnectionTunnelRequest interceptedRequest = UpdateIPSecConnectionTunnelConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateIPSecConnectionTunnelConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateIPSecConnectionTunnelResponse> transformer = UpdateIPSecConnectionTunnelConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateIPSecConnectionTunnelRequest, UpdateIPSecConnectionTunnelResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateIPSecConnectionTunnelRequest, UpdateIPSecConnectionTunnelResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateIPSecConnectionTunnelRequest, UpdateIPSecConnectionTunnelResponse> onSuccess = new SuccessConsumer<UpdateIPSecConnectionTunnelRequest, UpdateIPSecConnectionTunnelResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateIPSecConnectionTunnelRequest> onError = new ErrorConsumer<UpdateIPSecConnectionTunnelRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionTunnelDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateIPSecConnectionTunnelRequest, UpdateIPSecConnectionTunnelResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateIPSecConnectionTunnelRequest, UpdateIPSecConnectionTunnelResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateIPSecConnectionTunnelRequest> onError = handler == null ? null : new ErrorConsumer<UpdateIPSecConnectionTunnelRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionTunnelDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateIPSecConnectionTunnelResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionTunnelDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateIPSecConnectionTunnelResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateIPSecConnectionTunnelSharedSecretResponse> updateIPSecConnectionTunnelSharedSecret(UpdateIPSecConnectionTunnelSharedSecretRequest request, AsyncHandler<UpdateIPSecConnectionTunnelSharedSecretRequest, UpdateIPSecConnectionTunnelSharedSecretResponse> handler) {
        LOG.trace("Called async updateIPSecConnectionTunnelSharedSecret");
        final UpdateIPSecConnectionTunnelSharedSecretRequest interceptedRequest = UpdateIPSecConnectionTunnelSharedSecretConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateIPSecConnectionTunnelSharedSecretConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateIPSecConnectionTunnelSharedSecretResponse> transformer = UpdateIPSecConnectionTunnelSharedSecretConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateIPSecConnectionTunnelSharedSecretRequest, UpdateIPSecConnectionTunnelSharedSecretResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateIPSecConnectionTunnelSharedSecretRequest, UpdateIPSecConnectionTunnelSharedSecretResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest, UpdateIPSecConnectionTunnelSharedSecretResponse> onSuccess = new SuccessConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest, UpdateIPSecConnectionTunnelSharedSecretResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest> onError = new ErrorConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionTunnelSharedSecretDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest, UpdateIPSecConnectionTunnelSharedSecretResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest, UpdateIPSecConnectionTunnelSharedSecretResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest> onError = handler == null ? null : new ErrorConsumer<UpdateIPSecConnectionTunnelSharedSecretRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionTunnelSharedSecretDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateIPSecConnectionTunnelSharedSecretResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIPSecConnectionTunnelSharedSecretDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateIPSecConnectionTunnelSharedSecretResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateInternetGatewayResponse> updateInternetGateway(UpdateInternetGatewayRequest request, AsyncHandler<UpdateInternetGatewayRequest, UpdateInternetGatewayResponse> handler) {
        LOG.trace("Called async updateInternetGateway");
        final UpdateInternetGatewayRequest interceptedRequest = UpdateInternetGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateInternetGatewayResponse> transformer = UpdateInternetGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateInternetGatewayRequest, UpdateInternetGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateInternetGatewayRequest, UpdateInternetGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateInternetGatewayRequest, UpdateInternetGatewayResponse> onSuccess = new SuccessConsumer<UpdateInternetGatewayRequest, UpdateInternetGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateInternetGatewayRequest> onError = new ErrorConsumer<UpdateInternetGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInternetGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateInternetGatewayRequest, UpdateInternetGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateInternetGatewayRequest, UpdateInternetGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateInternetGatewayRequest> onError = handler == null ? null : new ErrorConsumer<UpdateInternetGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateInternetGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateInternetGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateInternetGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateInternetGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateIpv6Response> updateIpv6(UpdateIpv6Request request, AsyncHandler<UpdateIpv6Request, UpdateIpv6Response> handler) {
        LOG.trace("Called async updateIpv6");
        final UpdateIpv6Request interceptedRequest = UpdateIpv6Converter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateIpv6Converter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateIpv6Response> transformer = UpdateIpv6Converter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateIpv6Request, UpdateIpv6Response> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateIpv6Request, UpdateIpv6Response>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateIpv6Request, UpdateIpv6Response> onSuccess = new SuccessConsumer<UpdateIpv6Request, UpdateIpv6Response>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateIpv6Request> onError = new ErrorConsumer<UpdateIpv6Request>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIpv6Details(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateIpv6Request, UpdateIpv6Response> onSuccess = handler == null ? null : new SuccessConsumer<UpdateIpv6Request, UpdateIpv6Response>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateIpv6Request> onError = handler == null ? null : new ErrorConsumer<UpdateIpv6Request>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateIpv6Details(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateIpv6Response>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateIpv6Details(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateIpv6Response>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateLocalPeeringGatewayResponse> updateLocalPeeringGateway(UpdateLocalPeeringGatewayRequest request, AsyncHandler<UpdateLocalPeeringGatewayRequest, UpdateLocalPeeringGatewayResponse> handler) {
        LOG.trace("Called async updateLocalPeeringGateway");
        final UpdateLocalPeeringGatewayRequest interceptedRequest = UpdateLocalPeeringGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateLocalPeeringGatewayResponse> transformer = UpdateLocalPeeringGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateLocalPeeringGatewayRequest, UpdateLocalPeeringGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateLocalPeeringGatewayRequest, UpdateLocalPeeringGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateLocalPeeringGatewayRequest, UpdateLocalPeeringGatewayResponse> onSuccess = new SuccessConsumer<UpdateLocalPeeringGatewayRequest, UpdateLocalPeeringGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateLocalPeeringGatewayRequest> onError = new ErrorConsumer<UpdateLocalPeeringGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateLocalPeeringGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateLocalPeeringGatewayRequest, UpdateLocalPeeringGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateLocalPeeringGatewayRequest, UpdateLocalPeeringGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateLocalPeeringGatewayRequest> onError = handler == null ? null : new ErrorConsumer<UpdateLocalPeeringGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateLocalPeeringGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateLocalPeeringGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateLocalPeeringGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateLocalPeeringGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateNatGatewayResponse> updateNatGateway(UpdateNatGatewayRequest request, AsyncHandler<UpdateNatGatewayRequest, UpdateNatGatewayResponse> handler) {
        LOG.trace("Called async updateNatGateway");
        final UpdateNatGatewayRequest interceptedRequest = UpdateNatGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateNatGatewayResponse> transformer = UpdateNatGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateNatGatewayRequest, UpdateNatGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateNatGatewayRequest, UpdateNatGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateNatGatewayRequest, UpdateNatGatewayResponse> onSuccess = new SuccessConsumer<UpdateNatGatewayRequest, UpdateNatGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateNatGatewayRequest> onError = new ErrorConsumer<UpdateNatGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNatGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateNatGatewayRequest, UpdateNatGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateNatGatewayRequest, UpdateNatGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateNatGatewayRequest> onError = handler == null ? null : new ErrorConsumer<UpdateNatGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateNatGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateNatGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNatGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateNatGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateNetworkSecurityGroupResponse> updateNetworkSecurityGroup(UpdateNetworkSecurityGroupRequest request, AsyncHandler<UpdateNetworkSecurityGroupRequest, UpdateNetworkSecurityGroupResponse> handler) {
        LOG.trace("Called async updateNetworkSecurityGroup");
        final UpdateNetworkSecurityGroupRequest interceptedRequest = UpdateNetworkSecurityGroupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateNetworkSecurityGroupResponse> transformer = UpdateNetworkSecurityGroupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateNetworkSecurityGroupRequest, UpdateNetworkSecurityGroupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateNetworkSecurityGroupRequest, UpdateNetworkSecurityGroupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateNetworkSecurityGroupRequest, UpdateNetworkSecurityGroupResponse> onSuccess = new SuccessConsumer<UpdateNetworkSecurityGroupRequest, UpdateNetworkSecurityGroupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateNetworkSecurityGroupRequest> onError = new ErrorConsumer<UpdateNetworkSecurityGroupRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNetworkSecurityGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateNetworkSecurityGroupRequest, UpdateNetworkSecurityGroupResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateNetworkSecurityGroupRequest, UpdateNetworkSecurityGroupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateNetworkSecurityGroupRequest> onError = handler == null ? null : new ErrorConsumer<UpdateNetworkSecurityGroupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateNetworkSecurityGroupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateNetworkSecurityGroupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNetworkSecurityGroupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateNetworkSecurityGroupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateNetworkSecurityGroupSecurityRulesResponse> updateNetworkSecurityGroupSecurityRules(UpdateNetworkSecurityGroupSecurityRulesRequest request, AsyncHandler<UpdateNetworkSecurityGroupSecurityRulesRequest, UpdateNetworkSecurityGroupSecurityRulesResponse> handler) {
        LOG.trace("Called async updateNetworkSecurityGroupSecurityRules");
        final UpdateNetworkSecurityGroupSecurityRulesRequest interceptedRequest = UpdateNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateNetworkSecurityGroupSecurityRulesResponse> transformer = UpdateNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateNetworkSecurityGroupSecurityRulesRequest, UpdateNetworkSecurityGroupSecurityRulesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateNetworkSecurityGroupSecurityRulesRequest, UpdateNetworkSecurityGroupSecurityRulesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest, UpdateNetworkSecurityGroupSecurityRulesResponse> onSuccess = new SuccessConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest, UpdateNetworkSecurityGroupSecurityRulesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest> onError = new ErrorConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getUpdateNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest, UpdateNetworkSecurityGroupSecurityRulesResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest, UpdateNetworkSecurityGroupSecurityRulesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest> onError = handler == null ? null : new ErrorConsumer<UpdateNetworkSecurityGroupSecurityRulesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getUpdateNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.post(ib, interceptedRequest.getUpdateNetworkSecurityGroupSecurityRulesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateNetworkSecurityGroupSecurityRulesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdatePrivateIpResponse> updatePrivateIp(UpdatePrivateIpRequest request, AsyncHandler<UpdatePrivateIpRequest, UpdatePrivateIpResponse> handler) {
        LOG.trace("Called async updatePrivateIp");
        final UpdatePrivateIpRequest interceptedRequest = UpdatePrivateIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdatePrivateIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdatePrivateIpResponse> transformer = UpdatePrivateIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdatePrivateIpRequest, UpdatePrivateIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdatePrivateIpRequest, UpdatePrivateIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdatePrivateIpRequest, UpdatePrivateIpResponse> onSuccess = new SuccessConsumer<UpdatePrivateIpRequest, UpdatePrivateIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdatePrivateIpRequest> onError = new ErrorConsumer<UpdatePrivateIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePrivateIpDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdatePrivateIpRequest, UpdatePrivateIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdatePrivateIpRequest, UpdatePrivateIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdatePrivateIpRequest> onError = handler == null ? null : new ErrorConsumer<UpdatePrivateIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdatePrivateIpDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdatePrivateIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePrivateIpDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdatePrivateIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdatePublicIpResponse> updatePublicIp(UpdatePublicIpRequest request, AsyncHandler<UpdatePublicIpRequest, UpdatePublicIpResponse> handler) {
        LOG.trace("Called async updatePublicIp");
        final UpdatePublicIpRequest interceptedRequest = UpdatePublicIpConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdatePublicIpConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdatePublicIpResponse> transformer = UpdatePublicIpConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdatePublicIpRequest, UpdatePublicIpResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdatePublicIpRequest, UpdatePublicIpResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdatePublicIpRequest, UpdatePublicIpResponse> onSuccess = new SuccessConsumer<UpdatePublicIpRequest, UpdatePublicIpResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdatePublicIpRequest> onError = new ErrorConsumer<UpdatePublicIpRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePublicIpDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdatePublicIpRequest, UpdatePublicIpResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdatePublicIpRequest, UpdatePublicIpResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdatePublicIpRequest> onError = handler == null ? null : new ErrorConsumer<UpdatePublicIpRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdatePublicIpDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdatePublicIpResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdatePublicIpDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdatePublicIpResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateRemotePeeringConnectionResponse> updateRemotePeeringConnection(UpdateRemotePeeringConnectionRequest request, AsyncHandler<UpdateRemotePeeringConnectionRequest, UpdateRemotePeeringConnectionResponse> handler) {
        LOG.trace("Called async updateRemotePeeringConnection");
        final UpdateRemotePeeringConnectionRequest interceptedRequest = UpdateRemotePeeringConnectionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateRemotePeeringConnectionResponse> transformer = UpdateRemotePeeringConnectionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateRemotePeeringConnectionRequest, UpdateRemotePeeringConnectionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateRemotePeeringConnectionRequest, UpdateRemotePeeringConnectionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateRemotePeeringConnectionRequest, UpdateRemotePeeringConnectionResponse> onSuccess = new SuccessConsumer<UpdateRemotePeeringConnectionRequest, UpdateRemotePeeringConnectionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateRemotePeeringConnectionRequest> onError = new ErrorConsumer<UpdateRemotePeeringConnectionRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRemotePeeringConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateRemotePeeringConnectionRequest, UpdateRemotePeeringConnectionResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateRemotePeeringConnectionRequest, UpdateRemotePeeringConnectionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateRemotePeeringConnectionRequest> onError = handler == null ? null : new ErrorConsumer<UpdateRemotePeeringConnectionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateRemotePeeringConnectionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateRemotePeeringConnectionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRemotePeeringConnectionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateRemotePeeringConnectionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateRouteTableResponse> updateRouteTable(UpdateRouteTableRequest request, AsyncHandler<UpdateRouteTableRequest, UpdateRouteTableResponse> handler) {
        LOG.trace("Called async updateRouteTable");
        final UpdateRouteTableRequest interceptedRequest = UpdateRouteTableConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateRouteTableConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateRouteTableResponse> transformer = UpdateRouteTableConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateRouteTableRequest, UpdateRouteTableResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateRouteTableRequest, UpdateRouteTableResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateRouteTableRequest, UpdateRouteTableResponse> onSuccess = new SuccessConsumer<UpdateRouteTableRequest, UpdateRouteTableResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateRouteTableRequest> onError = new ErrorConsumer<UpdateRouteTableRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRouteTableDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateRouteTableRequest, UpdateRouteTableResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateRouteTableRequest, UpdateRouteTableResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateRouteTableRequest> onError = handler == null ? null : new ErrorConsumer<UpdateRouteTableRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateRouteTableDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateRouteTableResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateRouteTableDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateRouteTableResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSecurityListResponse> updateSecurityList(UpdateSecurityListRequest request, AsyncHandler<UpdateSecurityListRequest, UpdateSecurityListResponse> handler) {
        LOG.trace("Called async updateSecurityList");
        final UpdateSecurityListRequest interceptedRequest = UpdateSecurityListConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSecurityListConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSecurityListResponse> transformer = UpdateSecurityListConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSecurityListRequest, UpdateSecurityListResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSecurityListRequest, UpdateSecurityListResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSecurityListRequest, UpdateSecurityListResponse> onSuccess = new SuccessConsumer<UpdateSecurityListRequest, UpdateSecurityListResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSecurityListRequest> onError = new ErrorConsumer<UpdateSecurityListRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSecurityListDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSecurityListRequest, UpdateSecurityListResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSecurityListRequest, UpdateSecurityListResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSecurityListRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSecurityListRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSecurityListDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSecurityListResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSecurityListDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSecurityListResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateServiceGatewayResponse> updateServiceGateway(UpdateServiceGatewayRequest request, AsyncHandler<UpdateServiceGatewayRequest, UpdateServiceGatewayResponse> handler) {
        LOG.trace("Called async updateServiceGateway");
        final UpdateServiceGatewayRequest interceptedRequest = UpdateServiceGatewayConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateServiceGatewayResponse> transformer = UpdateServiceGatewayConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateServiceGatewayRequest, UpdateServiceGatewayResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateServiceGatewayRequest, UpdateServiceGatewayResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateServiceGatewayRequest, UpdateServiceGatewayResponse> onSuccess = new SuccessConsumer<UpdateServiceGatewayRequest, UpdateServiceGatewayResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateServiceGatewayRequest> onError = new ErrorConsumer<UpdateServiceGatewayRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateServiceGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateServiceGatewayRequest, UpdateServiceGatewayResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateServiceGatewayRequest, UpdateServiceGatewayResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateServiceGatewayRequest> onError = handler == null ? null : new ErrorConsumer<UpdateServiceGatewayRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateServiceGatewayDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateServiceGatewayResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateServiceGatewayDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateServiceGatewayResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSubnetResponse> updateSubnet(UpdateSubnetRequest request, AsyncHandler<UpdateSubnetRequest, UpdateSubnetResponse> handler) {
        LOG.trace("Called async updateSubnet");
        final UpdateSubnetRequest interceptedRequest = UpdateSubnetConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSubnetConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSubnetResponse> transformer = UpdateSubnetConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSubnetRequest, UpdateSubnetResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSubnetRequest, UpdateSubnetResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSubnetRequest, UpdateSubnetResponse> onSuccess = new SuccessConsumer<UpdateSubnetRequest, UpdateSubnetResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSubnetRequest> onError = new ErrorConsumer<UpdateSubnetRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSubnetDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSubnetRequest, UpdateSubnetResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSubnetRequest, UpdateSubnetResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSubnetRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSubnetRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSubnetDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSubnetResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSubnetDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSubnetResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVcnResponse> updateVcn(UpdateVcnRequest request, AsyncHandler<UpdateVcnRequest, UpdateVcnResponse> handler) {
        LOG.trace("Called async updateVcn");
        final UpdateVcnRequest interceptedRequest = UpdateVcnConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVcnConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVcnResponse> transformer = UpdateVcnConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVcnRequest, UpdateVcnResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVcnRequest, UpdateVcnResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVcnRequest, UpdateVcnResponse> onSuccess = new SuccessConsumer<UpdateVcnRequest, UpdateVcnResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVcnRequest> onError = new ErrorConsumer<UpdateVcnRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVcnDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVcnRequest, UpdateVcnResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVcnRequest, UpdateVcnResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVcnRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVcnRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVcnDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVcnResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVcnDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVcnResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVirtualCircuitResponse> updateVirtualCircuit(UpdateVirtualCircuitRequest request, AsyncHandler<UpdateVirtualCircuitRequest, UpdateVirtualCircuitResponse> handler) {
        LOG.trace("Called async updateVirtualCircuit");
        final UpdateVirtualCircuitRequest interceptedRequest = UpdateVirtualCircuitConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVirtualCircuitResponse> transformer = UpdateVirtualCircuitConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVirtualCircuitRequest, UpdateVirtualCircuitResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVirtualCircuitRequest, UpdateVirtualCircuitResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVirtualCircuitRequest, UpdateVirtualCircuitResponse> onSuccess = new SuccessConsumer<UpdateVirtualCircuitRequest, UpdateVirtualCircuitResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVirtualCircuitRequest> onError = new ErrorConsumer<UpdateVirtualCircuitRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVirtualCircuitDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVirtualCircuitRequest, UpdateVirtualCircuitResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVirtualCircuitRequest, UpdateVirtualCircuitResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVirtualCircuitRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVirtualCircuitRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVirtualCircuitDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVirtualCircuitResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVirtualCircuitDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVirtualCircuitResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVnicResponse> updateVnic(UpdateVnicRequest request, AsyncHandler<UpdateVnicRequest, UpdateVnicResponse> handler) {
        LOG.trace("Called async updateVnic");
        final UpdateVnicRequest interceptedRequest = UpdateVnicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVnicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVnicResponse> transformer = UpdateVnicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVnicRequest, UpdateVnicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVnicRequest, UpdateVnicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVnicRequest, UpdateVnicResponse> onSuccess = new SuccessConsumer<UpdateVnicRequest, UpdateVnicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVnicRequest> onError = new ErrorConsumer<UpdateVnicRequest>(this, interceptedRequest);
                    VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVnicDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVnicRequest, UpdateVnicResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVnicRequest, UpdateVnicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVnicRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVnicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVnicDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVnicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return VirtualNetworkAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVnicDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVnicResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VirtualNetworkAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public VirtualNetworkAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new VirtualNetworkAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

