/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.VirtualNetwork;
import com.oracle.bmc.core.VirtualNetworkPaginators;
import com.oracle.bmc.core.VirtualNetworkWaiters;
import com.oracle.bmc.core.internal.http.AddNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.AttachServiceIdConverter;
import com.oracle.bmc.core.internal.http.BulkAddVirtualCircuitPublicPrefixesConverter;
import com.oracle.bmc.core.internal.http.BulkDeleteVirtualCircuitPublicPrefixesConverter;
import com.oracle.bmc.core.internal.http.ChangeCpeCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeCrossConnectCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeCrossConnectGroupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeDhcpOptionsCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeDrgCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeIPSecConnectionCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeInternetGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeLocalPeeringGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeNatGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeNetworkSecurityGroupCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangePublicIpCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeRemotePeeringConnectionCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeRouteTableCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeSecurityListCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeServiceGatewayCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeSubnetCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVcnCompartmentConverter;
import com.oracle.bmc.core.internal.http.ChangeVirtualCircuitCompartmentConverter;
import com.oracle.bmc.core.internal.http.ConnectLocalPeeringGatewaysConverter;
import com.oracle.bmc.core.internal.http.ConnectRemotePeeringConnectionsConverter;
import com.oracle.bmc.core.internal.http.CreateCpeConverter;
import com.oracle.bmc.core.internal.http.CreateCrossConnectConverter;
import com.oracle.bmc.core.internal.http.CreateCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.CreateDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.CreateDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.CreateDrgConverter;
import com.oracle.bmc.core.internal.http.CreateIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.CreateInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateIpv6Converter;
import com.oracle.bmc.core.internal.http.CreateLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateNatGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.CreatePrivateIpConverter;
import com.oracle.bmc.core.internal.http.CreatePublicIpConverter;
import com.oracle.bmc.core.internal.http.CreateRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.CreateRouteTableConverter;
import com.oracle.bmc.core.internal.http.CreateSecurityListConverter;
import com.oracle.bmc.core.internal.http.CreateServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.CreateSubnetConverter;
import com.oracle.bmc.core.internal.http.CreateVcnConverter;
import com.oracle.bmc.core.internal.http.CreateVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.DeleteCpeConverter;
import com.oracle.bmc.core.internal.http.DeleteCrossConnectConverter;
import com.oracle.bmc.core.internal.http.DeleteCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.DeleteDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.DeleteDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.DeleteDrgConverter;
import com.oracle.bmc.core.internal.http.DeleteIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.DeleteInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteIpv6Converter;
import com.oracle.bmc.core.internal.http.DeleteLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteNatGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.DeletePrivateIpConverter;
import com.oracle.bmc.core.internal.http.DeletePublicIpConverter;
import com.oracle.bmc.core.internal.http.DeleteRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.DeleteRouteTableConverter;
import com.oracle.bmc.core.internal.http.DeleteSecurityListConverter;
import com.oracle.bmc.core.internal.http.DeleteServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.DeleteSubnetConverter;
import com.oracle.bmc.core.internal.http.DeleteVcnConverter;
import com.oracle.bmc.core.internal.http.DeleteVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.DetachServiceIdConverter;
import com.oracle.bmc.core.internal.http.GetCpeConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectLetterOfAuthorityConverter;
import com.oracle.bmc.core.internal.http.GetCrossConnectStatusConverter;
import com.oracle.bmc.core.internal.http.GetDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.GetDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.GetDrgConverter;
import com.oracle.bmc.core.internal.http.GetFastConnectProviderServiceConverter;
import com.oracle.bmc.core.internal.http.GetFastConnectProviderServiceKeyConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionDeviceConfigConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionDeviceStatusConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionTunnelConverter;
import com.oracle.bmc.core.internal.http.GetIPSecConnectionTunnelSharedSecretConverter;
import com.oracle.bmc.core.internal.http.GetInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.GetIpv6Converter;
import com.oracle.bmc.core.internal.http.GetLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.GetNatGatewayConverter;
import com.oracle.bmc.core.internal.http.GetNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.GetPrivateIpConverter;
import com.oracle.bmc.core.internal.http.GetPublicIpByIpAddressConverter;
import com.oracle.bmc.core.internal.http.GetPublicIpByPrivateIpIdConverter;
import com.oracle.bmc.core.internal.http.GetPublicIpConverter;
import com.oracle.bmc.core.internal.http.GetRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.GetRouteTableConverter;
import com.oracle.bmc.core.internal.http.GetSecurityListConverter;
import com.oracle.bmc.core.internal.http.GetServiceConverter;
import com.oracle.bmc.core.internal.http.GetServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.GetSubnetConverter;
import com.oracle.bmc.core.internal.http.GetVcnConverter;
import com.oracle.bmc.core.internal.http.GetVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.GetVnicConverter;
import com.oracle.bmc.core.internal.http.ListAllowedPeerRegionsForRemotePeeringConverter;
import com.oracle.bmc.core.internal.http.ListCpesConverter;
import com.oracle.bmc.core.internal.http.ListCrossConnectGroupsConverter;
import com.oracle.bmc.core.internal.http.ListCrossConnectLocationsConverter;
import com.oracle.bmc.core.internal.http.ListCrossConnectsConverter;
import com.oracle.bmc.core.internal.http.ListCrossconnectPortSpeedShapesConverter;
import com.oracle.bmc.core.internal.http.ListDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.ListDrgAttachmentsConverter;
import com.oracle.bmc.core.internal.http.ListDrgsConverter;
import com.oracle.bmc.core.internal.http.ListFastConnectProviderServicesConverter;
import com.oracle.bmc.core.internal.http.ListFastConnectProviderVirtualCircuitBandwidthShapesConverter;
import com.oracle.bmc.core.internal.http.ListIPSecConnectionTunnelsConverter;
import com.oracle.bmc.core.internal.http.ListIPSecConnectionsConverter;
import com.oracle.bmc.core.internal.http.ListInternetGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListIpv6sConverter;
import com.oracle.bmc.core.internal.http.ListLocalPeeringGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListNatGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.ListNetworkSecurityGroupVnicsConverter;
import com.oracle.bmc.core.internal.http.ListNetworkSecurityGroupsConverter;
import com.oracle.bmc.core.internal.http.ListPrivateIpsConverter;
import com.oracle.bmc.core.internal.http.ListPublicIpsConverter;
import com.oracle.bmc.core.internal.http.ListRemotePeeringConnectionsConverter;
import com.oracle.bmc.core.internal.http.ListRouteTablesConverter;
import com.oracle.bmc.core.internal.http.ListSecurityListsConverter;
import com.oracle.bmc.core.internal.http.ListServiceGatewaysConverter;
import com.oracle.bmc.core.internal.http.ListServicesConverter;
import com.oracle.bmc.core.internal.http.ListSubnetsConverter;
import com.oracle.bmc.core.internal.http.ListVcnsConverter;
import com.oracle.bmc.core.internal.http.ListVirtualCircuitBandwidthShapesConverter;
import com.oracle.bmc.core.internal.http.ListVirtualCircuitPublicPrefixesConverter;
import com.oracle.bmc.core.internal.http.ListVirtualCircuitsConverter;
import com.oracle.bmc.core.internal.http.RemoveNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.UpdateCpeConverter;
import com.oracle.bmc.core.internal.http.UpdateCrossConnectConverter;
import com.oracle.bmc.core.internal.http.UpdateCrossConnectGroupConverter;
import com.oracle.bmc.core.internal.http.UpdateDhcpOptionsConverter;
import com.oracle.bmc.core.internal.http.UpdateDrgAttachmentConverter;
import com.oracle.bmc.core.internal.http.UpdateDrgConverter;
import com.oracle.bmc.core.internal.http.UpdateIPSecConnectionConverter;
import com.oracle.bmc.core.internal.http.UpdateIPSecConnectionTunnelConverter;
import com.oracle.bmc.core.internal.http.UpdateIPSecConnectionTunnelSharedSecretConverter;
import com.oracle.bmc.core.internal.http.UpdateInternetGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateIpv6Converter;
import com.oracle.bmc.core.internal.http.UpdateLocalPeeringGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateNatGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateNetworkSecurityGroupConverter;
import com.oracle.bmc.core.internal.http.UpdateNetworkSecurityGroupSecurityRulesConverter;
import com.oracle.bmc.core.internal.http.UpdatePrivateIpConverter;
import com.oracle.bmc.core.internal.http.UpdatePublicIpConverter;
import com.oracle.bmc.core.internal.http.UpdateRemotePeeringConnectionConverter;
import com.oracle.bmc.core.internal.http.UpdateRouteTableConverter;
import com.oracle.bmc.core.internal.http.UpdateSecurityListConverter;
import com.oracle.bmc.core.internal.http.UpdateServiceGatewayConverter;
import com.oracle.bmc.core.internal.http.UpdateSubnetConverter;
import com.oracle.bmc.core.internal.http.UpdateVcnConverter;
import com.oracle.bmc.core.internal.http.UpdateVirtualCircuitConverter;
import com.oracle.bmc.core.internal.http.UpdateVnicConverter;
import com.oracle.bmc.core.requests.AddNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.AttachServiceIdRequest;
import com.oracle.bmc.core.requests.BulkAddVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.BulkDeleteVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.ChangeCpeCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCrossConnectCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeCrossConnectGroupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDhcpOptionsCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDrgCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeIPSecConnectionCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInternetGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeLocalPeeringGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeNatGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeNetworkSecurityGroupCompartmentRequest;
import com.oracle.bmc.core.requests.ChangePublicIpCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeRemotePeeringConnectionCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeRouteTableCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSecurityListCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeServiceGatewayCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSubnetCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVcnCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVirtualCircuitCompartmentRequest;
import com.oracle.bmc.core.requests.ConnectLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.requests.ConnectRemotePeeringConnectionsRequest;
import com.oracle.bmc.core.requests.CreateCpeRequest;
import com.oracle.bmc.core.requests.CreateCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.CreateCrossConnectRequest;
import com.oracle.bmc.core.requests.CreateDhcpOptionsRequest;
import com.oracle.bmc.core.requests.CreateDrgAttachmentRequest;
import com.oracle.bmc.core.requests.CreateDrgRequest;
import com.oracle.bmc.core.requests.CreateIPSecConnectionRequest;
import com.oracle.bmc.core.requests.CreateInternetGatewayRequest;
import com.oracle.bmc.core.requests.CreateIpv6Request;
import com.oracle.bmc.core.requests.CreateLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.CreateNatGatewayRequest;
import com.oracle.bmc.core.requests.CreateNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.CreatePrivateIpRequest;
import com.oracle.bmc.core.requests.CreatePublicIpRequest;
import com.oracle.bmc.core.requests.CreateRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.CreateRouteTableRequest;
import com.oracle.bmc.core.requests.CreateSecurityListRequest;
import com.oracle.bmc.core.requests.CreateServiceGatewayRequest;
import com.oracle.bmc.core.requests.CreateSubnetRequest;
import com.oracle.bmc.core.requests.CreateVcnRequest;
import com.oracle.bmc.core.requests.CreateVirtualCircuitRequest;
import com.oracle.bmc.core.requests.DeleteCpeRequest;
import com.oracle.bmc.core.requests.DeleteCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.DeleteCrossConnectRequest;
import com.oracle.bmc.core.requests.DeleteDhcpOptionsRequest;
import com.oracle.bmc.core.requests.DeleteDrgAttachmentRequest;
import com.oracle.bmc.core.requests.DeleteDrgRequest;
import com.oracle.bmc.core.requests.DeleteIPSecConnectionRequest;
import com.oracle.bmc.core.requests.DeleteInternetGatewayRequest;
import com.oracle.bmc.core.requests.DeleteIpv6Request;
import com.oracle.bmc.core.requests.DeleteLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.DeleteNatGatewayRequest;
import com.oracle.bmc.core.requests.DeleteNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.DeletePrivateIpRequest;
import com.oracle.bmc.core.requests.DeletePublicIpRequest;
import com.oracle.bmc.core.requests.DeleteRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.DeleteRouteTableRequest;
import com.oracle.bmc.core.requests.DeleteSecurityListRequest;
import com.oracle.bmc.core.requests.DeleteServiceGatewayRequest;
import com.oracle.bmc.core.requests.DeleteSubnetRequest;
import com.oracle.bmc.core.requests.DeleteVcnRequest;
import com.oracle.bmc.core.requests.DeleteVirtualCircuitRequest;
import com.oracle.bmc.core.requests.DetachServiceIdRequest;
import com.oracle.bmc.core.requests.GetCpeRequest;
import com.oracle.bmc.core.requests.GetCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.GetCrossConnectLetterOfAuthorityRequest;
import com.oracle.bmc.core.requests.GetCrossConnectRequest;
import com.oracle.bmc.core.requests.GetCrossConnectStatusRequest;
import com.oracle.bmc.core.requests.GetDhcpOptionsRequest;
import com.oracle.bmc.core.requests.GetDrgAttachmentRequest;
import com.oracle.bmc.core.requests.GetDrgRequest;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceKeyRequest;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionDeviceConfigRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionDeviceStatusRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelSharedSecretRequest;
import com.oracle.bmc.core.requests.GetInternetGatewayRequest;
import com.oracle.bmc.core.requests.GetIpv6Request;
import com.oracle.bmc.core.requests.GetLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.GetNatGatewayRequest;
import com.oracle.bmc.core.requests.GetNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.GetPrivateIpRequest;
import com.oracle.bmc.core.requests.GetPublicIpByIpAddressRequest;
import com.oracle.bmc.core.requests.GetPublicIpByPrivateIpIdRequest;
import com.oracle.bmc.core.requests.GetPublicIpRequest;
import com.oracle.bmc.core.requests.GetRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.GetRouteTableRequest;
import com.oracle.bmc.core.requests.GetSecurityListRequest;
import com.oracle.bmc.core.requests.GetServiceGatewayRequest;
import com.oracle.bmc.core.requests.GetServiceRequest;
import com.oracle.bmc.core.requests.GetSubnetRequest;
import com.oracle.bmc.core.requests.GetVcnRequest;
import com.oracle.bmc.core.requests.GetVirtualCircuitRequest;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.requests.ListAllowedPeerRegionsForRemotePeeringRequest;
import com.oracle.bmc.core.requests.ListCpesRequest;
import com.oracle.bmc.core.requests.ListCrossConnectGroupsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectLocationsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectsRequest;
import com.oracle.bmc.core.requests.ListCrossconnectPortSpeedShapesRequest;
import com.oracle.bmc.core.requests.ListDhcpOptionsRequest;
import com.oracle.bmc.core.requests.ListDrgAttachmentsRequest;
import com.oracle.bmc.core.requests.ListDrgsRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderServicesRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionTunnelsRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionsRequest;
import com.oracle.bmc.core.requests.ListInternetGatewaysRequest;
import com.oracle.bmc.core.requests.ListIpv6sRequest;
import com.oracle.bmc.core.requests.ListLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.requests.ListNatGatewaysRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupVnicsRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupsRequest;
import com.oracle.bmc.core.requests.ListPrivateIpsRequest;
import com.oracle.bmc.core.requests.ListPublicIpsRequest;
import com.oracle.bmc.core.requests.ListRemotePeeringConnectionsRequest;
import com.oracle.bmc.core.requests.ListRouteTablesRequest;
import com.oracle.bmc.core.requests.ListSecurityListsRequest;
import com.oracle.bmc.core.requests.ListServiceGatewaysRequest;
import com.oracle.bmc.core.requests.ListServicesRequest;
import com.oracle.bmc.core.requests.ListSubnetsRequest;
import com.oracle.bmc.core.requests.ListVcnsRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitsRequest;
import com.oracle.bmc.core.requests.RemoveNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.UpdateCpeRequest;
import com.oracle.bmc.core.requests.UpdateCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.UpdateCrossConnectRequest;
import com.oracle.bmc.core.requests.UpdateDhcpOptionsRequest;
import com.oracle.bmc.core.requests.UpdateDrgAttachmentRequest;
import com.oracle.bmc.core.requests.UpdateDrgRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionTunnelSharedSecretRequest;
import com.oracle.bmc.core.requests.UpdateInternetGatewayRequest;
import com.oracle.bmc.core.requests.UpdateIpv6Request;
import com.oracle.bmc.core.requests.UpdateLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.UpdateNatGatewayRequest;
import com.oracle.bmc.core.requests.UpdateNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.UpdateNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.UpdatePrivateIpRequest;
import com.oracle.bmc.core.requests.UpdatePublicIpRequest;
import com.oracle.bmc.core.requests.UpdateRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.UpdateRouteTableRequest;
import com.oracle.bmc.core.requests.UpdateSecurityListRequest;
import com.oracle.bmc.core.requests.UpdateServiceGatewayRequest;
import com.oracle.bmc.core.requests.UpdateSubnetRequest;
import com.oracle.bmc.core.requests.UpdateVcnRequest;
import com.oracle.bmc.core.requests.UpdateVirtualCircuitRequest;
import com.oracle.bmc.core.requests.UpdateVnicRequest;
import com.oracle.bmc.core.responses.AddNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.AttachServiceIdResponse;
import com.oracle.bmc.core.responses.BulkAddVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.BulkDeleteVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.ChangeCpeCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCrossConnectCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeCrossConnectGroupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDhcpOptionsCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDrgCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeIPSecConnectionCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInternetGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeLocalPeeringGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeNatGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeNetworkSecurityGroupCompartmentResponse;
import com.oracle.bmc.core.responses.ChangePublicIpCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeRemotePeeringConnectionCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeRouteTableCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSecurityListCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeServiceGatewayCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSubnetCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVcnCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVirtualCircuitCompartmentResponse;
import com.oracle.bmc.core.responses.ConnectLocalPeeringGatewaysResponse;
import com.oracle.bmc.core.responses.ConnectRemotePeeringConnectionsResponse;
import com.oracle.bmc.core.responses.CreateCpeResponse;
import com.oracle.bmc.core.responses.CreateCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.CreateCrossConnectResponse;
import com.oracle.bmc.core.responses.CreateDhcpOptionsResponse;
import com.oracle.bmc.core.responses.CreateDrgAttachmentResponse;
import com.oracle.bmc.core.responses.CreateDrgResponse;
import com.oracle.bmc.core.responses.CreateIPSecConnectionResponse;
import com.oracle.bmc.core.responses.CreateInternetGatewayResponse;
import com.oracle.bmc.core.responses.CreateIpv6Response;
import com.oracle.bmc.core.responses.CreateLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.CreateNatGatewayResponse;
import com.oracle.bmc.core.responses.CreateNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.CreatePrivateIpResponse;
import com.oracle.bmc.core.responses.CreatePublicIpResponse;
import com.oracle.bmc.core.responses.CreateRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.CreateRouteTableResponse;
import com.oracle.bmc.core.responses.CreateSecurityListResponse;
import com.oracle.bmc.core.responses.CreateServiceGatewayResponse;
import com.oracle.bmc.core.responses.CreateSubnetResponse;
import com.oracle.bmc.core.responses.CreateVcnResponse;
import com.oracle.bmc.core.responses.CreateVirtualCircuitResponse;
import com.oracle.bmc.core.responses.DeleteCpeResponse;
import com.oracle.bmc.core.responses.DeleteCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.DeleteCrossConnectResponse;
import com.oracle.bmc.core.responses.DeleteDhcpOptionsResponse;
import com.oracle.bmc.core.responses.DeleteDrgAttachmentResponse;
import com.oracle.bmc.core.responses.DeleteDrgResponse;
import com.oracle.bmc.core.responses.DeleteIPSecConnectionResponse;
import com.oracle.bmc.core.responses.DeleteInternetGatewayResponse;
import com.oracle.bmc.core.responses.DeleteIpv6Response;
import com.oracle.bmc.core.responses.DeleteLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.DeleteNatGatewayResponse;
import com.oracle.bmc.core.responses.DeleteNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.DeletePrivateIpResponse;
import com.oracle.bmc.core.responses.DeletePublicIpResponse;
import com.oracle.bmc.core.responses.DeleteRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.DeleteRouteTableResponse;
import com.oracle.bmc.core.responses.DeleteSecurityListResponse;
import com.oracle.bmc.core.responses.DeleteServiceGatewayResponse;
import com.oracle.bmc.core.responses.DeleteSubnetResponse;
import com.oracle.bmc.core.responses.DeleteVcnResponse;
import com.oracle.bmc.core.responses.DeleteVirtualCircuitResponse;
import com.oracle.bmc.core.responses.DetachServiceIdResponse;
import com.oracle.bmc.core.responses.GetCpeResponse;
import com.oracle.bmc.core.responses.GetCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.GetCrossConnectLetterOfAuthorityResponse;
import com.oracle.bmc.core.responses.GetCrossConnectResponse;
import com.oracle.bmc.core.responses.GetCrossConnectStatusResponse;
import com.oracle.bmc.core.responses.GetDhcpOptionsResponse;
import com.oracle.bmc.core.responses.GetDrgAttachmentResponse;
import com.oracle.bmc.core.responses.GetDrgResponse;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceKeyResponse;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionDeviceConfigResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionDeviceStatusResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelSharedSecretResponse;
import com.oracle.bmc.core.responses.GetInternetGatewayResponse;
import com.oracle.bmc.core.responses.GetIpv6Response;
import com.oracle.bmc.core.responses.GetLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.GetNatGatewayResponse;
import com.oracle.bmc.core.responses.GetNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.GetPrivateIpResponse;
import com.oracle.bmc.core.responses.GetPublicIpByIpAddressResponse;
import com.oracle.bmc.core.responses.GetPublicIpByPrivateIpIdResponse;
import com.oracle.bmc.core.responses.GetPublicIpResponse;
import com.oracle.bmc.core.responses.GetRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.GetRouteTableResponse;
import com.oracle.bmc.core.responses.GetSecurityListResponse;
import com.oracle.bmc.core.responses.GetServiceGatewayResponse;
import com.oracle.bmc.core.responses.GetServiceResponse;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import com.oracle.bmc.core.responses.GetVcnResponse;
import com.oracle.bmc.core.responses.GetVirtualCircuitResponse;
import com.oracle.bmc.core.responses.GetVnicResponse;
import com.oracle.bmc.core.responses.ListAllowedPeerRegionsForRemotePeeringResponse;
import com.oracle.bmc.core.responses.ListCpesResponse;
import com.oracle.bmc.core.responses.ListCrossConnectGroupsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectLocationsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectsResponse;
import com.oracle.bmc.core.responses.ListCrossconnectPortSpeedShapesResponse;
import com.oracle.bmc.core.responses.ListDhcpOptionsResponse;
import com.oracle.bmc.core.responses.ListDrgAttachmentsResponse;
import com.oracle.bmc.core.responses.ListDrgsResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderServicesResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionTunnelsResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionsResponse;
import com.oracle.bmc.core.responses.ListInternetGatewaysResponse;
import com.oracle.bmc.core.responses.ListIpv6sResponse;
import com.oracle.bmc.core.responses.ListLocalPeeringGatewaysResponse;
import com.oracle.bmc.core.responses.ListNatGatewaysResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupVnicsResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupsResponse;
import com.oracle.bmc.core.responses.ListPrivateIpsResponse;
import com.oracle.bmc.core.responses.ListPublicIpsResponse;
import com.oracle.bmc.core.responses.ListRemotePeeringConnectionsResponse;
import com.oracle.bmc.core.responses.ListRouteTablesResponse;
import com.oracle.bmc.core.responses.ListSecurityListsResponse;
import com.oracle.bmc.core.responses.ListServiceGatewaysResponse;
import com.oracle.bmc.core.responses.ListServicesResponse;
import com.oracle.bmc.core.responses.ListSubnetsResponse;
import com.oracle.bmc.core.responses.ListVcnsResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitsResponse;
import com.oracle.bmc.core.responses.RemoveNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.UpdateCpeResponse;
import com.oracle.bmc.core.responses.UpdateCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.UpdateCrossConnectResponse;
import com.oracle.bmc.core.responses.UpdateDhcpOptionsResponse;
import com.oracle.bmc.core.responses.UpdateDrgAttachmentResponse;
import com.oracle.bmc.core.responses.UpdateDrgResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionTunnelSharedSecretResponse;
import com.oracle.bmc.core.responses.UpdateInternetGatewayResponse;
import com.oracle.bmc.core.responses.UpdateIpv6Response;
import com.oracle.bmc.core.responses.UpdateLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.UpdateNatGatewayResponse;
import com.oracle.bmc.core.responses.UpdateNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.UpdateNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.UpdatePrivateIpResponse;
import com.oracle.bmc.core.responses.UpdatePublicIpResponse;
import com.oracle.bmc.core.responses.UpdateRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.UpdateRouteTableResponse;
import com.oracle.bmc.core.responses.UpdateSecurityListResponse;
import com.oracle.bmc.core.responses.UpdateServiceGatewayResponse;
import com.oracle.bmc.core.responses.UpdateSubnetResponse;
import com.oracle.bmc.core.responses.UpdateVcnResponse;
import com.oracle.bmc.core.responses.UpdateVirtualCircuitResponse;
import com.oracle.bmc.core.responses.UpdateVnicResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.workrequests.WorkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkClient
implements VirtualNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualNetworkClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VIRTUALNETWORK").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final VirtualNetworkWaiters waiters;
    private final VirtualNetworkPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ExecutorService executorService;
    private final RetryConfiguration retryConfiguration;

    public VirtualNetworkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public VirtualNetworkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public VirtualNetworkClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public VirtualNetworkClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("VirtualNetwork-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new VirtualNetworkWaiters(executorService, this);
        this.paginators = new VirtualNetworkPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddNetworkSecurityGroupSecurityRulesResponse addNetworkSecurityGroupSecurityRules(AddNetworkSecurityGroupSecurityRulesRequest request) {
        LOG.trace("Called addNetworkSecurityGroupSecurityRules");
        AddNetworkSecurityGroupSecurityRulesRequest interceptedRequest = AddNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddNetworkSecurityGroupSecurityRulesResponse> transformer = AddNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getAddNetworkSecurityGroupSecurityRulesDetails(), retriedRequest);
                return (AddNetworkSecurityGroupSecurityRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AttachServiceIdResponse attachServiceId(AttachServiceIdRequest request) {
        LOG.trace("Called attachServiceId");
        AttachServiceIdRequest interceptedRequest = AttachServiceIdConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachServiceIdConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachServiceIdResponse> transformer = AttachServiceIdConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getAttachServiceDetails(), retriedRequest);
                return (AttachServiceIdResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BulkAddVirtualCircuitPublicPrefixesResponse bulkAddVirtualCircuitPublicPrefixes(BulkAddVirtualCircuitPublicPrefixesRequest request) {
        LOG.trace("Called bulkAddVirtualCircuitPublicPrefixes");
        BulkAddVirtualCircuitPublicPrefixesRequest interceptedRequest = BulkAddVirtualCircuitPublicPrefixesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkAddVirtualCircuitPublicPrefixesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkAddVirtualCircuitPublicPrefixesResponse> transformer = BulkAddVirtualCircuitPublicPrefixesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getBulkAddVirtualCircuitPublicPrefixesDetails(), retriedRequest);
                return (BulkAddVirtualCircuitPublicPrefixesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BulkDeleteVirtualCircuitPublicPrefixesResponse bulkDeleteVirtualCircuitPublicPrefixes(BulkDeleteVirtualCircuitPublicPrefixesRequest request) {
        LOG.trace("Called bulkDeleteVirtualCircuitPublicPrefixes");
        BulkDeleteVirtualCircuitPublicPrefixesRequest interceptedRequest = BulkDeleteVirtualCircuitPublicPrefixesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BulkDeleteVirtualCircuitPublicPrefixesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BulkDeleteVirtualCircuitPublicPrefixesResponse> transformer = BulkDeleteVirtualCircuitPublicPrefixesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getBulkDeleteVirtualCircuitPublicPrefixesDetails(), retriedRequest);
                return (BulkDeleteVirtualCircuitPublicPrefixesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCpeCompartmentResponse changeCpeCompartment(ChangeCpeCompartmentRequest request) {
        LOG.trace("Called changeCpeCompartment");
        ChangeCpeCompartmentRequest interceptedRequest = ChangeCpeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCpeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCpeCompartmentResponse> transformer = ChangeCpeCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCpeCompartmentDetails(), retriedRequest);
                return (ChangeCpeCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCrossConnectCompartmentResponse changeCrossConnectCompartment(ChangeCrossConnectCompartmentRequest request) {
        LOG.trace("Called changeCrossConnectCompartment");
        ChangeCrossConnectCompartmentRequest interceptedRequest = ChangeCrossConnectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCrossConnectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCrossConnectCompartmentResponse> transformer = ChangeCrossConnectCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCrossConnectCompartmentDetails(), retriedRequest);
                return (ChangeCrossConnectCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCrossConnectGroupCompartmentResponse changeCrossConnectGroupCompartment(ChangeCrossConnectGroupCompartmentRequest request) {
        LOG.trace("Called changeCrossConnectGroupCompartment");
        ChangeCrossConnectGroupCompartmentRequest interceptedRequest = ChangeCrossConnectGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCrossConnectGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCrossConnectGroupCompartmentResponse> transformer = ChangeCrossConnectGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCrossConnectGroupCompartmentDetails(), retriedRequest);
                return (ChangeCrossConnectGroupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeDhcpOptionsCompartmentResponse changeDhcpOptionsCompartment(ChangeDhcpOptionsCompartmentRequest request) {
        LOG.trace("Called changeDhcpOptionsCompartment");
        ChangeDhcpOptionsCompartmentRequest interceptedRequest = ChangeDhcpOptionsCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDhcpOptionsCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDhcpOptionsCompartmentResponse> transformer = ChangeDhcpOptionsCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeDhcpOptionsCompartmentDetails(), retriedRequest);
                return (ChangeDhcpOptionsCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeDrgCompartmentResponse changeDrgCompartment(ChangeDrgCompartmentRequest request) {
        LOG.trace("Called changeDrgCompartment");
        ChangeDrgCompartmentRequest interceptedRequest = ChangeDrgCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDrgCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDrgCompartmentResponse> transformer = ChangeDrgCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeDrgCompartmentDetails(), retriedRequest);
                return (ChangeDrgCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeIPSecConnectionCompartmentResponse changeIPSecConnectionCompartment(ChangeIPSecConnectionCompartmentRequest request) {
        LOG.trace("Called changeIPSecConnectionCompartment");
        ChangeIPSecConnectionCompartmentRequest interceptedRequest = ChangeIPSecConnectionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeIPSecConnectionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeIPSecConnectionCompartmentResponse> transformer = ChangeIPSecConnectionCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeIPSecConnectionCompartmentDetails(), retriedRequest);
                return (ChangeIPSecConnectionCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeInternetGatewayCompartmentResponse changeInternetGatewayCompartment(ChangeInternetGatewayCompartmentRequest request) {
        LOG.trace("Called changeInternetGatewayCompartment");
        ChangeInternetGatewayCompartmentRequest interceptedRequest = ChangeInternetGatewayCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeInternetGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeInternetGatewayCompartmentResponse> transformer = ChangeInternetGatewayCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeInternetGatewayCompartmentDetails(), retriedRequest);
                return (ChangeInternetGatewayCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeLocalPeeringGatewayCompartmentResponse changeLocalPeeringGatewayCompartment(ChangeLocalPeeringGatewayCompartmentRequest request) {
        LOG.trace("Called changeLocalPeeringGatewayCompartment");
        ChangeLocalPeeringGatewayCompartmentRequest interceptedRequest = ChangeLocalPeeringGatewayCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLocalPeeringGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLocalPeeringGatewayCompartmentResponse> transformer = ChangeLocalPeeringGatewayCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeLocalPeeringGatewayCompartmentDetails(), retriedRequest);
                return (ChangeLocalPeeringGatewayCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeNatGatewayCompartmentResponse changeNatGatewayCompartment(ChangeNatGatewayCompartmentRequest request) {
        LOG.trace("Called changeNatGatewayCompartment");
        ChangeNatGatewayCompartmentRequest interceptedRequest = ChangeNatGatewayCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNatGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeNatGatewayCompartmentResponse> transformer = ChangeNatGatewayCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeNatGatewayCompartmentDetails(), retriedRequest);
                return (ChangeNatGatewayCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeNetworkSecurityGroupCompartmentResponse changeNetworkSecurityGroupCompartment(ChangeNetworkSecurityGroupCompartmentRequest request) {
        LOG.trace("Called changeNetworkSecurityGroupCompartment");
        ChangeNetworkSecurityGroupCompartmentRequest interceptedRequest = ChangeNetworkSecurityGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNetworkSecurityGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeNetworkSecurityGroupCompartmentResponse> transformer = ChangeNetworkSecurityGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeNetworkSecurityGroupCompartmentDetails(), retriedRequest);
                return (ChangeNetworkSecurityGroupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangePublicIpCompartmentResponse changePublicIpCompartment(ChangePublicIpCompartmentRequest request) {
        LOG.trace("Called changePublicIpCompartment");
        ChangePublicIpCompartmentRequest interceptedRequest = ChangePublicIpCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangePublicIpCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangePublicIpCompartmentResponse> transformer = ChangePublicIpCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangePublicIpCompartmentDetails(), retriedRequest);
                return (ChangePublicIpCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeRemotePeeringConnectionCompartmentResponse changeRemotePeeringConnectionCompartment(ChangeRemotePeeringConnectionCompartmentRequest request) {
        LOG.trace("Called changeRemotePeeringConnectionCompartment");
        ChangeRemotePeeringConnectionCompartmentRequest interceptedRequest = ChangeRemotePeeringConnectionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRemotePeeringConnectionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRemotePeeringConnectionCompartmentResponse> transformer = ChangeRemotePeeringConnectionCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeRemotePeeringConnectionCompartmentDetails(), retriedRequest);
                return (ChangeRemotePeeringConnectionCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeRouteTableCompartmentResponse changeRouteTableCompartment(ChangeRouteTableCompartmentRequest request) {
        LOG.trace("Called changeRouteTableCompartment");
        ChangeRouteTableCompartmentRequest interceptedRequest = ChangeRouteTableCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRouteTableCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRouteTableCompartmentResponse> transformer = ChangeRouteTableCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeRouteTableCompartmentDetails(), retriedRequest);
                return (ChangeRouteTableCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeSecurityListCompartmentResponse changeSecurityListCompartment(ChangeSecurityListCompartmentRequest request) {
        LOG.trace("Called changeSecurityListCompartment");
        ChangeSecurityListCompartmentRequest interceptedRequest = ChangeSecurityListCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSecurityListCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSecurityListCompartmentResponse> transformer = ChangeSecurityListCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeSecurityListCompartmentDetails(), retriedRequest);
                return (ChangeSecurityListCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeServiceGatewayCompartmentResponse changeServiceGatewayCompartment(ChangeServiceGatewayCompartmentRequest request) {
        LOG.trace("Called changeServiceGatewayCompartment");
        ChangeServiceGatewayCompartmentRequest interceptedRequest = ChangeServiceGatewayCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeServiceGatewayCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeServiceGatewayCompartmentResponse> transformer = ChangeServiceGatewayCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeServiceGatewayCompartmentDetails(), retriedRequest);
                return (ChangeServiceGatewayCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeSubnetCompartmentResponse changeSubnetCompartment(ChangeSubnetCompartmentRequest request) {
        LOG.trace("Called changeSubnetCompartment");
        ChangeSubnetCompartmentRequest interceptedRequest = ChangeSubnetCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSubnetCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSubnetCompartmentResponse> transformer = ChangeSubnetCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeSubnetCompartmentDetails(), retriedRequest);
                return (ChangeSubnetCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVcnCompartmentResponse changeVcnCompartment(ChangeVcnCompartmentRequest request) {
        LOG.trace("Called changeVcnCompartment");
        ChangeVcnCompartmentRequest interceptedRequest = ChangeVcnCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVcnCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVcnCompartmentResponse> transformer = ChangeVcnCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVcnCompartmentDetails(), retriedRequest);
                return (ChangeVcnCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVirtualCircuitCompartmentResponse changeVirtualCircuitCompartment(ChangeVirtualCircuitCompartmentRequest request) {
        LOG.trace("Called changeVirtualCircuitCompartment");
        ChangeVirtualCircuitCompartmentRequest interceptedRequest = ChangeVirtualCircuitCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVirtualCircuitCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVirtualCircuitCompartmentResponse> transformer = ChangeVirtualCircuitCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVirtualCircuitCompartmentDetails(), retriedRequest);
                return (ChangeVirtualCircuitCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ConnectLocalPeeringGatewaysResponse connectLocalPeeringGateways(ConnectLocalPeeringGatewaysRequest request) {
        LOG.trace("Called connectLocalPeeringGateways");
        ConnectLocalPeeringGatewaysRequest interceptedRequest = ConnectLocalPeeringGatewaysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ConnectLocalPeeringGatewaysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ConnectLocalPeeringGatewaysResponse> transformer = ConnectLocalPeeringGatewaysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getConnectLocalPeeringGatewaysDetails(), retriedRequest);
                return (ConnectLocalPeeringGatewaysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ConnectRemotePeeringConnectionsResponse connectRemotePeeringConnections(ConnectRemotePeeringConnectionsRequest request) {
        LOG.trace("Called connectRemotePeeringConnections");
        ConnectRemotePeeringConnectionsRequest interceptedRequest = ConnectRemotePeeringConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ConnectRemotePeeringConnectionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ConnectRemotePeeringConnectionsResponse> transformer = ConnectRemotePeeringConnectionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getConnectRemotePeeringConnectionsDetails(), retriedRequest);
                return (ConnectRemotePeeringConnectionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCpeResponse createCpe(CreateCpeRequest request) {
        LOG.trace("Called createCpe");
        CreateCpeRequest interceptedRequest = CreateCpeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCpeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCpeResponse> transformer = CreateCpeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateCpeDetails(), retriedRequest);
                return (CreateCpeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCrossConnectResponse createCrossConnect(CreateCrossConnectRequest request) {
        LOG.trace("Called createCrossConnect");
        CreateCrossConnectRequest interceptedRequest = CreateCrossConnectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCrossConnectResponse> transformer = CreateCrossConnectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateCrossConnectDetails(), retriedRequest);
                return (CreateCrossConnectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCrossConnectGroupResponse createCrossConnectGroup(CreateCrossConnectGroupRequest request) {
        LOG.trace("Called createCrossConnectGroup");
        CreateCrossConnectGroupRequest interceptedRequest = CreateCrossConnectGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCrossConnectGroupResponse> transformer = CreateCrossConnectGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateCrossConnectGroupDetails(), retriedRequest);
                return (CreateCrossConnectGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDhcpOptionsResponse createDhcpOptions(CreateDhcpOptionsRequest request) {
        LOG.trace("Called createDhcpOptions");
        CreateDhcpOptionsRequest interceptedRequest = CreateDhcpOptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDhcpOptionsResponse> transformer = CreateDhcpOptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateDhcpDetails(), retriedRequest);
                return (CreateDhcpOptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDrgResponse createDrg(CreateDrgRequest request) {
        LOG.trace("Called createDrg");
        CreateDrgRequest interceptedRequest = CreateDrgConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDrgConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDrgResponse> transformer = CreateDrgConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateDrgDetails(), retriedRequest);
                return (CreateDrgResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDrgAttachmentResponse createDrgAttachment(CreateDrgAttachmentRequest request) {
        LOG.trace("Called createDrgAttachment");
        CreateDrgAttachmentRequest interceptedRequest = CreateDrgAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDrgAttachmentResponse> transformer = CreateDrgAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateDrgAttachmentDetails(), retriedRequest);
                return (CreateDrgAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateIPSecConnectionResponse createIPSecConnection(CreateIPSecConnectionRequest request) {
        LOG.trace("Called createIPSecConnection");
        CreateIPSecConnectionRequest interceptedRequest = CreateIPSecConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateIPSecConnectionResponse> transformer = CreateIPSecConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateIPSecConnectionDetails(), retriedRequest);
                return (CreateIPSecConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateInternetGatewayResponse createInternetGateway(CreateInternetGatewayRequest request) {
        LOG.trace("Called createInternetGateway");
        CreateInternetGatewayRequest interceptedRequest = CreateInternetGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateInternetGatewayResponse> transformer = CreateInternetGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateInternetGatewayDetails(), retriedRequest);
                return (CreateInternetGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateIpv6Response createIpv6(CreateIpv6Request request) {
        LOG.trace("Called createIpv6");
        CreateIpv6Request interceptedRequest = CreateIpv6Converter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateIpv6Converter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateIpv6Response> transformer = CreateIpv6Converter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateIpv6Details(), retriedRequest);
                return (CreateIpv6Response)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateLocalPeeringGatewayResponse createLocalPeeringGateway(CreateLocalPeeringGatewayRequest request) {
        LOG.trace("Called createLocalPeeringGateway");
        CreateLocalPeeringGatewayRequest interceptedRequest = CreateLocalPeeringGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLocalPeeringGatewayResponse> transformer = CreateLocalPeeringGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateLocalPeeringGatewayDetails(), retriedRequest);
                return (CreateLocalPeeringGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateNatGatewayResponse createNatGateway(CreateNatGatewayRequest request) {
        LOG.trace("Called createNatGateway");
        CreateNatGatewayRequest interceptedRequest = CreateNatGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNatGatewayResponse> transformer = CreateNatGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateNatGatewayDetails(), retriedRequest);
                return (CreateNatGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateNetworkSecurityGroupResponse createNetworkSecurityGroup(CreateNetworkSecurityGroupRequest request) {
        LOG.trace("Called createNetworkSecurityGroup");
        CreateNetworkSecurityGroupRequest interceptedRequest = CreateNetworkSecurityGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNetworkSecurityGroupResponse> transformer = CreateNetworkSecurityGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateNetworkSecurityGroupDetails(), retriedRequest);
                return (CreateNetworkSecurityGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePrivateIpResponse createPrivateIp(CreatePrivateIpRequest request) {
        LOG.trace("Called createPrivateIp");
        CreatePrivateIpRequest interceptedRequest = CreatePrivateIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePrivateIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePrivateIpResponse> transformer = CreatePrivateIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreatePrivateIpDetails(), retriedRequest);
                return (CreatePrivateIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePublicIpResponse createPublicIp(CreatePublicIpRequest request) {
        LOG.trace("Called createPublicIp");
        CreatePublicIpRequest interceptedRequest = CreatePublicIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePublicIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePublicIpResponse> transformer = CreatePublicIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreatePublicIpDetails(), retriedRequest);
                return (CreatePublicIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRemotePeeringConnectionResponse createRemotePeeringConnection(CreateRemotePeeringConnectionRequest request) {
        LOG.trace("Called createRemotePeeringConnection");
        CreateRemotePeeringConnectionRequest interceptedRequest = CreateRemotePeeringConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRemotePeeringConnectionResponse> transformer = CreateRemotePeeringConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateRemotePeeringConnectionDetails(), retriedRequest);
                return (CreateRemotePeeringConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRouteTableResponse createRouteTable(CreateRouteTableRequest request) {
        LOG.trace("Called createRouteTable");
        CreateRouteTableRequest interceptedRequest = CreateRouteTableConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRouteTableConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRouteTableResponse> transformer = CreateRouteTableConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateRouteTableDetails(), retriedRequest);
                return (CreateRouteTableResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSecurityListResponse createSecurityList(CreateSecurityListRequest request) {
        LOG.trace("Called createSecurityList");
        CreateSecurityListRequest interceptedRequest = CreateSecurityListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSecurityListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSecurityListResponse> transformer = CreateSecurityListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateSecurityListDetails(), retriedRequest);
                return (CreateSecurityListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateServiceGatewayResponse createServiceGateway(CreateServiceGatewayRequest request) {
        LOG.trace("Called createServiceGateway");
        CreateServiceGatewayRequest interceptedRequest = CreateServiceGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateServiceGatewayResponse> transformer = CreateServiceGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateServiceGatewayDetails(), retriedRequest);
                return (CreateServiceGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSubnetResponse createSubnet(CreateSubnetRequest request) {
        LOG.trace("Called createSubnet");
        CreateSubnetRequest interceptedRequest = CreateSubnetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSubnetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSubnetResponse> transformer = CreateSubnetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateSubnetDetails(), retriedRequest);
                return (CreateSubnetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVcnResponse createVcn(CreateVcnRequest request) {
        LOG.trace("Called createVcn");
        CreateVcnRequest interceptedRequest = CreateVcnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVcnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVcnResponse> transformer = CreateVcnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVcnDetails(), retriedRequest);
                return (CreateVcnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVirtualCircuitResponse createVirtualCircuit(CreateVirtualCircuitRequest request) {
        LOG.trace("Called createVirtualCircuit");
        CreateVirtualCircuitRequest interceptedRequest = CreateVirtualCircuitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVirtualCircuitResponse> transformer = CreateVirtualCircuitConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVirtualCircuitDetails(), retriedRequest);
                return (CreateVirtualCircuitResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCpeResponse deleteCpe(DeleteCpeRequest request) {
        LOG.trace("Called deleteCpe");
        DeleteCpeRequest interceptedRequest = DeleteCpeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCpeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCpeResponse> transformer = DeleteCpeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteCpeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCrossConnectResponse deleteCrossConnect(DeleteCrossConnectRequest request) {
        LOG.trace("Called deleteCrossConnect");
        DeleteCrossConnectRequest interceptedRequest = DeleteCrossConnectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCrossConnectResponse> transformer = DeleteCrossConnectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteCrossConnectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCrossConnectGroupResponse deleteCrossConnectGroup(DeleteCrossConnectGroupRequest request) {
        LOG.trace("Called deleteCrossConnectGroup");
        DeleteCrossConnectGroupRequest interceptedRequest = DeleteCrossConnectGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCrossConnectGroupResponse> transformer = DeleteCrossConnectGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteCrossConnectGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDhcpOptionsResponse deleteDhcpOptions(DeleteDhcpOptionsRequest request) {
        LOG.trace("Called deleteDhcpOptions");
        DeleteDhcpOptionsRequest interceptedRequest = DeleteDhcpOptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDhcpOptionsResponse> transformer = DeleteDhcpOptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteDhcpOptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDrgResponse deleteDrg(DeleteDrgRequest request) {
        LOG.trace("Called deleteDrg");
        DeleteDrgRequest interceptedRequest = DeleteDrgConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDrgConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDrgResponse> transformer = DeleteDrgConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteDrgResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDrgAttachmentResponse deleteDrgAttachment(DeleteDrgAttachmentRequest request) {
        LOG.trace("Called deleteDrgAttachment");
        DeleteDrgAttachmentRequest interceptedRequest = DeleteDrgAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDrgAttachmentResponse> transformer = DeleteDrgAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteDrgAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteIPSecConnectionResponse deleteIPSecConnection(DeleteIPSecConnectionRequest request) {
        LOG.trace("Called deleteIPSecConnection");
        DeleteIPSecConnectionRequest interceptedRequest = DeleteIPSecConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteIPSecConnectionResponse> transformer = DeleteIPSecConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteIPSecConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteInternetGatewayResponse deleteInternetGateway(DeleteInternetGatewayRequest request) {
        LOG.trace("Called deleteInternetGateway");
        DeleteInternetGatewayRequest interceptedRequest = DeleteInternetGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteInternetGatewayResponse> transformer = DeleteInternetGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteInternetGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteIpv6Response deleteIpv6(DeleteIpv6Request request) {
        LOG.trace("Called deleteIpv6");
        DeleteIpv6Request interceptedRequest = DeleteIpv6Converter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteIpv6Converter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteIpv6Response> transformer = DeleteIpv6Converter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteIpv6Response)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteLocalPeeringGatewayResponse deleteLocalPeeringGateway(DeleteLocalPeeringGatewayRequest request) {
        LOG.trace("Called deleteLocalPeeringGateway");
        DeleteLocalPeeringGatewayRequest interceptedRequest = DeleteLocalPeeringGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLocalPeeringGatewayResponse> transformer = DeleteLocalPeeringGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteLocalPeeringGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteNatGatewayResponse deleteNatGateway(DeleteNatGatewayRequest request) {
        LOG.trace("Called deleteNatGateway");
        DeleteNatGatewayRequest interceptedRequest = DeleteNatGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNatGatewayResponse> transformer = DeleteNatGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteNatGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteNetworkSecurityGroupResponse deleteNetworkSecurityGroup(DeleteNetworkSecurityGroupRequest request) {
        LOG.trace("Called deleteNetworkSecurityGroup");
        DeleteNetworkSecurityGroupRequest interceptedRequest = DeleteNetworkSecurityGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNetworkSecurityGroupResponse> transformer = DeleteNetworkSecurityGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteNetworkSecurityGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePrivateIpResponse deletePrivateIp(DeletePrivateIpRequest request) {
        LOG.trace("Called deletePrivateIp");
        DeletePrivateIpRequest interceptedRequest = DeletePrivateIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePrivateIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePrivateIpResponse> transformer = DeletePrivateIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeletePrivateIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePublicIpResponse deletePublicIp(DeletePublicIpRequest request) {
        LOG.trace("Called deletePublicIp");
        DeletePublicIpRequest interceptedRequest = DeletePublicIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePublicIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePublicIpResponse> transformer = DeletePublicIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeletePublicIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRemotePeeringConnectionResponse deleteRemotePeeringConnection(DeleteRemotePeeringConnectionRequest request) {
        LOG.trace("Called deleteRemotePeeringConnection");
        DeleteRemotePeeringConnectionRequest interceptedRequest = DeleteRemotePeeringConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRemotePeeringConnectionResponse> transformer = DeleteRemotePeeringConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteRemotePeeringConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRouteTableResponse deleteRouteTable(DeleteRouteTableRequest request) {
        LOG.trace("Called deleteRouteTable");
        DeleteRouteTableRequest interceptedRequest = DeleteRouteTableConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRouteTableConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRouteTableResponse> transformer = DeleteRouteTableConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteRouteTableResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSecurityListResponse deleteSecurityList(DeleteSecurityListRequest request) {
        LOG.trace("Called deleteSecurityList");
        DeleteSecurityListRequest interceptedRequest = DeleteSecurityListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSecurityListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSecurityListResponse> transformer = DeleteSecurityListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteSecurityListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteServiceGatewayResponse deleteServiceGateway(DeleteServiceGatewayRequest request) {
        LOG.trace("Called deleteServiceGateway");
        DeleteServiceGatewayRequest interceptedRequest = DeleteServiceGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteServiceGatewayResponse> transformer = DeleteServiceGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteServiceGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSubnetResponse deleteSubnet(DeleteSubnetRequest request) {
        LOG.trace("Called deleteSubnet");
        DeleteSubnetRequest interceptedRequest = DeleteSubnetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSubnetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSubnetResponse> transformer = DeleteSubnetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteSubnetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVcnResponse deleteVcn(DeleteVcnRequest request) {
        LOG.trace("Called deleteVcn");
        DeleteVcnRequest interceptedRequest = DeleteVcnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVcnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVcnResponse> transformer = DeleteVcnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVcnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVirtualCircuitResponse deleteVirtualCircuit(DeleteVirtualCircuitRequest request) {
        LOG.trace("Called deleteVirtualCircuit");
        DeleteVirtualCircuitRequest interceptedRequest = DeleteVirtualCircuitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVirtualCircuitResponse> transformer = DeleteVirtualCircuitConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVirtualCircuitResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetachServiceIdResponse detachServiceId(DetachServiceIdRequest request) {
        LOG.trace("Called detachServiceId");
        DetachServiceIdRequest interceptedRequest = DetachServiceIdConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachServiceIdConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachServiceIdResponse> transformer = DetachServiceIdConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getDetachServiceDetails(), retriedRequest);
                return (DetachServiceIdResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCpeResponse getCpe(GetCpeRequest request) {
        LOG.trace("Called getCpe");
        GetCpeRequest interceptedRequest = GetCpeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCpeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCpeResponse> transformer = GetCpeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetCpeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCrossConnectResponse getCrossConnect(GetCrossConnectRequest request) {
        LOG.trace("Called getCrossConnect");
        GetCrossConnectRequest interceptedRequest = GetCrossConnectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCrossConnectResponse> transformer = GetCrossConnectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetCrossConnectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCrossConnectGroupResponse getCrossConnectGroup(GetCrossConnectGroupRequest request) {
        LOG.trace("Called getCrossConnectGroup");
        GetCrossConnectGroupRequest interceptedRequest = GetCrossConnectGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCrossConnectGroupResponse> transformer = GetCrossConnectGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetCrossConnectGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCrossConnectLetterOfAuthorityResponse getCrossConnectLetterOfAuthority(GetCrossConnectLetterOfAuthorityRequest request) {
        LOG.trace("Called getCrossConnectLetterOfAuthority");
        GetCrossConnectLetterOfAuthorityRequest interceptedRequest = GetCrossConnectLetterOfAuthorityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCrossConnectLetterOfAuthorityConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCrossConnectLetterOfAuthorityResponse> transformer = GetCrossConnectLetterOfAuthorityConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetCrossConnectLetterOfAuthorityResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCrossConnectStatusResponse getCrossConnectStatus(GetCrossConnectStatusRequest request) {
        LOG.trace("Called getCrossConnectStatus");
        GetCrossConnectStatusRequest interceptedRequest = GetCrossConnectStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCrossConnectStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCrossConnectStatusResponse> transformer = GetCrossConnectStatusConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetCrossConnectStatusResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDhcpOptionsResponse getDhcpOptions(GetDhcpOptionsRequest request) {
        LOG.trace("Called getDhcpOptions");
        GetDhcpOptionsRequest interceptedRequest = GetDhcpOptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDhcpOptionsResponse> transformer = GetDhcpOptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDhcpOptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDrgResponse getDrg(GetDrgRequest request) {
        LOG.trace("Called getDrg");
        GetDrgRequest interceptedRequest = GetDrgConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDrgConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDrgResponse> transformer = GetDrgConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDrgResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDrgAttachmentResponse getDrgAttachment(GetDrgAttachmentRequest request) {
        LOG.trace("Called getDrgAttachment");
        GetDrgAttachmentRequest interceptedRequest = GetDrgAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDrgAttachmentResponse> transformer = GetDrgAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDrgAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFastConnectProviderServiceResponse getFastConnectProviderService(GetFastConnectProviderServiceRequest request) {
        LOG.trace("Called getFastConnectProviderService");
        GetFastConnectProviderServiceRequest interceptedRequest = GetFastConnectProviderServiceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFastConnectProviderServiceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFastConnectProviderServiceResponse> transformer = GetFastConnectProviderServiceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetFastConnectProviderServiceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetFastConnectProviderServiceKeyResponse getFastConnectProviderServiceKey(GetFastConnectProviderServiceKeyRequest request) {
        LOG.trace("Called getFastConnectProviderServiceKey");
        GetFastConnectProviderServiceKeyRequest interceptedRequest = GetFastConnectProviderServiceKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFastConnectProviderServiceKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetFastConnectProviderServiceKeyResponse> transformer = GetFastConnectProviderServiceKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetFastConnectProviderServiceKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIPSecConnectionResponse getIPSecConnection(GetIPSecConnectionRequest request) {
        LOG.trace("Called getIPSecConnection");
        GetIPSecConnectionRequest interceptedRequest = GetIPSecConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIPSecConnectionResponse> transformer = GetIPSecConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetIPSecConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIPSecConnectionDeviceConfigResponse getIPSecConnectionDeviceConfig(GetIPSecConnectionDeviceConfigRequest request) {
        LOG.trace("Called getIPSecConnectionDeviceConfig");
        GetIPSecConnectionDeviceConfigRequest interceptedRequest = GetIPSecConnectionDeviceConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIPSecConnectionDeviceConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIPSecConnectionDeviceConfigResponse> transformer = GetIPSecConnectionDeviceConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetIPSecConnectionDeviceConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIPSecConnectionDeviceStatusResponse getIPSecConnectionDeviceStatus(GetIPSecConnectionDeviceStatusRequest request) {
        LOG.trace("Called getIPSecConnectionDeviceStatus");
        GetIPSecConnectionDeviceStatusRequest interceptedRequest = GetIPSecConnectionDeviceStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIPSecConnectionDeviceStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIPSecConnectionDeviceStatusResponse> transformer = GetIPSecConnectionDeviceStatusConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetIPSecConnectionDeviceStatusResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIPSecConnectionTunnelResponse getIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request) {
        LOG.trace("Called getIPSecConnectionTunnel");
        GetIPSecConnectionTunnelRequest interceptedRequest = GetIPSecConnectionTunnelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIPSecConnectionTunnelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIPSecConnectionTunnelResponse> transformer = GetIPSecConnectionTunnelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetIPSecConnectionTunnelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIPSecConnectionTunnelSharedSecretResponse getIPSecConnectionTunnelSharedSecret(GetIPSecConnectionTunnelSharedSecretRequest request) {
        LOG.trace("Called getIPSecConnectionTunnelSharedSecret");
        GetIPSecConnectionTunnelSharedSecretRequest interceptedRequest = GetIPSecConnectionTunnelSharedSecretConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIPSecConnectionTunnelSharedSecretConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIPSecConnectionTunnelSharedSecretResponse> transformer = GetIPSecConnectionTunnelSharedSecretConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetIPSecConnectionTunnelSharedSecretResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetInternetGatewayResponse getInternetGateway(GetInternetGatewayRequest request) {
        LOG.trace("Called getInternetGateway");
        GetInternetGatewayRequest interceptedRequest = GetInternetGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetInternetGatewayResponse> transformer = GetInternetGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetInternetGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetIpv6Response getIpv6(GetIpv6Request request) {
        LOG.trace("Called getIpv6");
        GetIpv6Request interceptedRequest = GetIpv6Converter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetIpv6Converter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetIpv6Response> transformer = GetIpv6Converter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetIpv6Response)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetLocalPeeringGatewayResponse getLocalPeeringGateway(GetLocalPeeringGatewayRequest request) {
        LOG.trace("Called getLocalPeeringGateway");
        GetLocalPeeringGatewayRequest interceptedRequest = GetLocalPeeringGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLocalPeeringGatewayResponse> transformer = GetLocalPeeringGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetLocalPeeringGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNatGatewayResponse getNatGateway(GetNatGatewayRequest request) {
        LOG.trace("Called getNatGateway");
        GetNatGatewayRequest interceptedRequest = GetNatGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNatGatewayResponse> transformer = GetNatGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetNatGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNetworkSecurityGroupResponse getNetworkSecurityGroup(GetNetworkSecurityGroupRequest request) {
        LOG.trace("Called getNetworkSecurityGroup");
        GetNetworkSecurityGroupRequest interceptedRequest = GetNetworkSecurityGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNetworkSecurityGroupResponse> transformer = GetNetworkSecurityGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetNetworkSecurityGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPrivateIpResponse getPrivateIp(GetPrivateIpRequest request) {
        LOG.trace("Called getPrivateIp");
        GetPrivateIpRequest interceptedRequest = GetPrivateIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPrivateIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPrivateIpResponse> transformer = GetPrivateIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetPrivateIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPublicIpResponse getPublicIp(GetPublicIpRequest request) {
        LOG.trace("Called getPublicIp");
        GetPublicIpRequest interceptedRequest = GetPublicIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublicIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublicIpResponse> transformer = GetPublicIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetPublicIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPublicIpByIpAddressResponse getPublicIpByIpAddress(GetPublicIpByIpAddressRequest request) {
        LOG.trace("Called getPublicIpByIpAddress");
        GetPublicIpByIpAddressRequest interceptedRequest = GetPublicIpByIpAddressConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublicIpByIpAddressConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublicIpByIpAddressResponse> transformer = GetPublicIpByIpAddressConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getGetPublicIpByIpAddressDetails(), retriedRequest);
                return (GetPublicIpByIpAddressResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPublicIpByPrivateIpIdResponse getPublicIpByPrivateIpId(GetPublicIpByPrivateIpIdRequest request) {
        LOG.trace("Called getPublicIpByPrivateIpId");
        GetPublicIpByPrivateIpIdRequest interceptedRequest = GetPublicIpByPrivateIpIdConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublicIpByPrivateIpIdConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPublicIpByPrivateIpIdResponse> transformer = GetPublicIpByPrivateIpIdConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getGetPublicIpByPrivateIpIdDetails(), retriedRequest);
                return (GetPublicIpByPrivateIpIdResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRemotePeeringConnectionResponse getRemotePeeringConnection(GetRemotePeeringConnectionRequest request) {
        LOG.trace("Called getRemotePeeringConnection");
        GetRemotePeeringConnectionRequest interceptedRequest = GetRemotePeeringConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRemotePeeringConnectionResponse> transformer = GetRemotePeeringConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetRemotePeeringConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRouteTableResponse getRouteTable(GetRouteTableRequest request) {
        LOG.trace("Called getRouteTable");
        GetRouteTableRequest interceptedRequest = GetRouteTableConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRouteTableConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRouteTableResponse> transformer = GetRouteTableConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetRouteTableResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSecurityListResponse getSecurityList(GetSecurityListRequest request) {
        LOG.trace("Called getSecurityList");
        GetSecurityListRequest interceptedRequest = GetSecurityListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSecurityListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSecurityListResponse> transformer = GetSecurityListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetSecurityListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetServiceResponse getService(GetServiceRequest request) {
        LOG.trace("Called getService");
        GetServiceRequest interceptedRequest = GetServiceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetServiceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetServiceResponse> transformer = GetServiceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetServiceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetServiceGatewayResponse getServiceGateway(GetServiceGatewayRequest request) {
        LOG.trace("Called getServiceGateway");
        GetServiceGatewayRequest interceptedRequest = GetServiceGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetServiceGatewayResponse> transformer = GetServiceGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetServiceGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSubnetResponse getSubnet(GetSubnetRequest request) {
        LOG.trace("Called getSubnet");
        GetSubnetRequest interceptedRequest = GetSubnetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSubnetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSubnetResponse> transformer = GetSubnetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetSubnetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVcnResponse getVcn(GetVcnRequest request) {
        LOG.trace("Called getVcn");
        GetVcnRequest interceptedRequest = GetVcnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVcnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVcnResponse> transformer = GetVcnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVcnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVirtualCircuitResponse getVirtualCircuit(GetVirtualCircuitRequest request) {
        LOG.trace("Called getVirtualCircuit");
        GetVirtualCircuitRequest interceptedRequest = GetVirtualCircuitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVirtualCircuitResponse> transformer = GetVirtualCircuitConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVirtualCircuitResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVnicResponse getVnic(GetVnicRequest request) {
        LOG.trace("Called getVnic");
        GetVnicRequest interceptedRequest = GetVnicConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVnicConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVnicResponse> transformer = GetVnicConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVnicResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAllowedPeerRegionsForRemotePeeringResponse listAllowedPeerRegionsForRemotePeering(ListAllowedPeerRegionsForRemotePeeringRequest request) {
        LOG.trace("Called listAllowedPeerRegionsForRemotePeering");
        ListAllowedPeerRegionsForRemotePeeringRequest interceptedRequest = ListAllowedPeerRegionsForRemotePeeringConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAllowedPeerRegionsForRemotePeeringConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAllowedPeerRegionsForRemotePeeringResponse> transformer = ListAllowedPeerRegionsForRemotePeeringConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAllowedPeerRegionsForRemotePeeringResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCpesResponse listCpes(ListCpesRequest request) {
        LOG.trace("Called listCpes");
        ListCpesRequest interceptedRequest = ListCpesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCpesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCpesResponse> transformer = ListCpesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListCpesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCrossConnectGroupsResponse listCrossConnectGroups(ListCrossConnectGroupsRequest request) {
        LOG.trace("Called listCrossConnectGroups");
        ListCrossConnectGroupsRequest interceptedRequest = ListCrossConnectGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCrossConnectGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCrossConnectGroupsResponse> transformer = ListCrossConnectGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListCrossConnectGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCrossConnectLocationsResponse listCrossConnectLocations(ListCrossConnectLocationsRequest request) {
        LOG.trace("Called listCrossConnectLocations");
        ListCrossConnectLocationsRequest interceptedRequest = ListCrossConnectLocationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCrossConnectLocationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCrossConnectLocationsResponse> transformer = ListCrossConnectLocationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListCrossConnectLocationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCrossConnectsResponse listCrossConnects(ListCrossConnectsRequest request) {
        LOG.trace("Called listCrossConnects");
        ListCrossConnectsRequest interceptedRequest = ListCrossConnectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCrossConnectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCrossConnectsResponse> transformer = ListCrossConnectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListCrossConnectsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCrossconnectPortSpeedShapesResponse listCrossconnectPortSpeedShapes(ListCrossconnectPortSpeedShapesRequest request) {
        LOG.trace("Called listCrossconnectPortSpeedShapes");
        ListCrossconnectPortSpeedShapesRequest interceptedRequest = ListCrossconnectPortSpeedShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCrossconnectPortSpeedShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCrossconnectPortSpeedShapesResponse> transformer = ListCrossconnectPortSpeedShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListCrossconnectPortSpeedShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDhcpOptionsResponse listDhcpOptions(ListDhcpOptionsRequest request) {
        LOG.trace("Called listDhcpOptions");
        ListDhcpOptionsRequest interceptedRequest = ListDhcpOptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDhcpOptionsResponse> transformer = ListDhcpOptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDhcpOptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDrgAttachmentsResponse listDrgAttachments(ListDrgAttachmentsRequest request) {
        LOG.trace("Called listDrgAttachments");
        ListDrgAttachmentsRequest interceptedRequest = ListDrgAttachmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDrgAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDrgAttachmentsResponse> transformer = ListDrgAttachmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDrgAttachmentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDrgsResponse listDrgs(ListDrgsRequest request) {
        LOG.trace("Called listDrgs");
        ListDrgsRequest interceptedRequest = ListDrgsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDrgsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDrgsResponse> transformer = ListDrgsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDrgsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFastConnectProviderServicesResponse listFastConnectProviderServices(ListFastConnectProviderServicesRequest request) {
        LOG.trace("Called listFastConnectProviderServices");
        ListFastConnectProviderServicesRequest interceptedRequest = ListFastConnectProviderServicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFastConnectProviderServicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFastConnectProviderServicesResponse> transformer = ListFastConnectProviderServicesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListFastConnectProviderServicesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListFastConnectProviderVirtualCircuitBandwidthShapesResponse listFastConnectProviderVirtualCircuitBandwidthShapes(ListFastConnectProviderVirtualCircuitBandwidthShapesRequest request) {
        LOG.trace("Called listFastConnectProviderVirtualCircuitBandwidthShapes");
        ListFastConnectProviderVirtualCircuitBandwidthShapesRequest interceptedRequest = ListFastConnectProviderVirtualCircuitBandwidthShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFastConnectProviderVirtualCircuitBandwidthShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> transformer = ListFastConnectProviderVirtualCircuitBandwidthShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListFastConnectProviderVirtualCircuitBandwidthShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListIPSecConnectionTunnelsResponse listIPSecConnectionTunnels(ListIPSecConnectionTunnelsRequest request) {
        LOG.trace("Called listIPSecConnectionTunnels");
        ListIPSecConnectionTunnelsRequest interceptedRequest = ListIPSecConnectionTunnelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIPSecConnectionTunnelsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIPSecConnectionTunnelsResponse> transformer = ListIPSecConnectionTunnelsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListIPSecConnectionTunnelsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListIPSecConnectionsResponse listIPSecConnections(ListIPSecConnectionsRequest request) {
        LOG.trace("Called listIPSecConnections");
        ListIPSecConnectionsRequest interceptedRequest = ListIPSecConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIPSecConnectionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIPSecConnectionsResponse> transformer = ListIPSecConnectionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListIPSecConnectionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListInternetGatewaysResponse listInternetGateways(ListInternetGatewaysRequest request) {
        LOG.trace("Called listInternetGateways");
        ListInternetGatewaysRequest interceptedRequest = ListInternetGatewaysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListInternetGatewaysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListInternetGatewaysResponse> transformer = ListInternetGatewaysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListInternetGatewaysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListIpv6sResponse listIpv6s(ListIpv6sRequest request) {
        LOG.trace("Called listIpv6s");
        ListIpv6sRequest interceptedRequest = ListIpv6sConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListIpv6sConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListIpv6sResponse> transformer = ListIpv6sConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListIpv6sResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListLocalPeeringGatewaysResponse listLocalPeeringGateways(ListLocalPeeringGatewaysRequest request) {
        LOG.trace("Called listLocalPeeringGateways");
        ListLocalPeeringGatewaysRequest interceptedRequest = ListLocalPeeringGatewaysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLocalPeeringGatewaysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLocalPeeringGatewaysResponse> transformer = ListLocalPeeringGatewaysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListLocalPeeringGatewaysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNatGatewaysResponse listNatGateways(ListNatGatewaysRequest request) {
        LOG.trace("Called listNatGateways");
        ListNatGatewaysRequest interceptedRequest = ListNatGatewaysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNatGatewaysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNatGatewaysResponse> transformer = ListNatGatewaysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListNatGatewaysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkSecurityGroupSecurityRulesResponse listNetworkSecurityGroupSecurityRules(ListNetworkSecurityGroupSecurityRulesRequest request) {
        LOG.trace("Called listNetworkSecurityGroupSecurityRules");
        ListNetworkSecurityGroupSecurityRulesRequest interceptedRequest = ListNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkSecurityGroupSecurityRulesResponse> transformer = ListNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListNetworkSecurityGroupSecurityRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkSecurityGroupVnicsResponse listNetworkSecurityGroupVnics(ListNetworkSecurityGroupVnicsRequest request) {
        LOG.trace("Called listNetworkSecurityGroupVnics");
        ListNetworkSecurityGroupVnicsRequest interceptedRequest = ListNetworkSecurityGroupVnicsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkSecurityGroupVnicsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkSecurityGroupVnicsResponse> transformer = ListNetworkSecurityGroupVnicsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListNetworkSecurityGroupVnicsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListNetworkSecurityGroupsResponse listNetworkSecurityGroups(ListNetworkSecurityGroupsRequest request) {
        LOG.trace("Called listNetworkSecurityGroups");
        ListNetworkSecurityGroupsRequest interceptedRequest = ListNetworkSecurityGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkSecurityGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkSecurityGroupsResponse> transformer = ListNetworkSecurityGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListNetworkSecurityGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPrivateIpsResponse listPrivateIps(ListPrivateIpsRequest request) {
        LOG.trace("Called listPrivateIps");
        ListPrivateIpsRequest interceptedRequest = ListPrivateIpsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPrivateIpsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPrivateIpsResponse> transformer = ListPrivateIpsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListPrivateIpsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPublicIpsResponse listPublicIps(ListPublicIpsRequest request) {
        LOG.trace("Called listPublicIps");
        ListPublicIpsRequest interceptedRequest = ListPublicIpsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublicIpsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPublicIpsResponse> transformer = ListPublicIpsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListPublicIpsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRemotePeeringConnectionsResponse listRemotePeeringConnections(ListRemotePeeringConnectionsRequest request) {
        LOG.trace("Called listRemotePeeringConnections");
        ListRemotePeeringConnectionsRequest interceptedRequest = ListRemotePeeringConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRemotePeeringConnectionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRemotePeeringConnectionsResponse> transformer = ListRemotePeeringConnectionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListRemotePeeringConnectionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRouteTablesResponse listRouteTables(ListRouteTablesRequest request) {
        LOG.trace("Called listRouteTables");
        ListRouteTablesRequest interceptedRequest = ListRouteTablesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRouteTablesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRouteTablesResponse> transformer = ListRouteTablesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListRouteTablesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSecurityListsResponse listSecurityLists(ListSecurityListsRequest request) {
        LOG.trace("Called listSecurityLists");
        ListSecurityListsRequest interceptedRequest = ListSecurityListsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSecurityListsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSecurityListsResponse> transformer = ListSecurityListsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListSecurityListsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListServiceGatewaysResponse listServiceGateways(ListServiceGatewaysRequest request) {
        LOG.trace("Called listServiceGateways");
        ListServiceGatewaysRequest interceptedRequest = ListServiceGatewaysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListServiceGatewaysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListServiceGatewaysResponse> transformer = ListServiceGatewaysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListServiceGatewaysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListServicesResponse listServices(ListServicesRequest request) {
        LOG.trace("Called listServices");
        ListServicesRequest interceptedRequest = ListServicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListServicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListServicesResponse> transformer = ListServicesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListServicesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSubnetsResponse listSubnets(ListSubnetsRequest request) {
        LOG.trace("Called listSubnets");
        ListSubnetsRequest interceptedRequest = ListSubnetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSubnetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSubnetsResponse> transformer = ListSubnetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListSubnetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVcnsResponse listVcns(ListVcnsRequest request) {
        LOG.trace("Called listVcns");
        ListVcnsRequest interceptedRequest = ListVcnsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVcnsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVcnsResponse> transformer = ListVcnsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVcnsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVirtualCircuitBandwidthShapesResponse listVirtualCircuitBandwidthShapes(ListVirtualCircuitBandwidthShapesRequest request) {
        LOG.trace("Called listVirtualCircuitBandwidthShapes");
        ListVirtualCircuitBandwidthShapesRequest interceptedRequest = ListVirtualCircuitBandwidthShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVirtualCircuitBandwidthShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVirtualCircuitBandwidthShapesResponse> transformer = ListVirtualCircuitBandwidthShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVirtualCircuitBandwidthShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVirtualCircuitPublicPrefixesResponse listVirtualCircuitPublicPrefixes(ListVirtualCircuitPublicPrefixesRequest request) {
        LOG.trace("Called listVirtualCircuitPublicPrefixes");
        ListVirtualCircuitPublicPrefixesRequest interceptedRequest = ListVirtualCircuitPublicPrefixesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVirtualCircuitPublicPrefixesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVirtualCircuitPublicPrefixesResponse> transformer = ListVirtualCircuitPublicPrefixesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVirtualCircuitPublicPrefixesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVirtualCircuitsResponse listVirtualCircuits(ListVirtualCircuitsRequest request) {
        LOG.trace("Called listVirtualCircuits");
        ListVirtualCircuitsRequest interceptedRequest = ListVirtualCircuitsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVirtualCircuitsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVirtualCircuitsResponse> transformer = ListVirtualCircuitsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVirtualCircuitsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveNetworkSecurityGroupSecurityRulesResponse removeNetworkSecurityGroupSecurityRules(RemoveNetworkSecurityGroupSecurityRulesRequest request) {
        LOG.trace("Called removeNetworkSecurityGroupSecurityRules");
        RemoveNetworkSecurityGroupSecurityRulesRequest interceptedRequest = RemoveNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveNetworkSecurityGroupSecurityRulesResponse> transformer = RemoveNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getRemoveNetworkSecurityGroupSecurityRulesDetails(), retriedRequest);
                return (RemoveNetworkSecurityGroupSecurityRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCpeResponse updateCpe(UpdateCpeRequest request) {
        LOG.trace("Called updateCpe");
        UpdateCpeRequest interceptedRequest = UpdateCpeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCpeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCpeResponse> transformer = UpdateCpeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateCpeDetails(), retriedRequest);
                return (UpdateCpeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCrossConnectResponse updateCrossConnect(UpdateCrossConnectRequest request) {
        LOG.trace("Called updateCrossConnect");
        UpdateCrossConnectRequest interceptedRequest = UpdateCrossConnectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCrossConnectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCrossConnectResponse> transformer = UpdateCrossConnectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateCrossConnectDetails(), retriedRequest);
                return (UpdateCrossConnectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCrossConnectGroupResponse updateCrossConnectGroup(UpdateCrossConnectGroupRequest request) {
        LOG.trace("Called updateCrossConnectGroup");
        UpdateCrossConnectGroupRequest interceptedRequest = UpdateCrossConnectGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCrossConnectGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCrossConnectGroupResponse> transformer = UpdateCrossConnectGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateCrossConnectGroupDetails(), retriedRequest);
                return (UpdateCrossConnectGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDhcpOptionsResponse updateDhcpOptions(UpdateDhcpOptionsRequest request) {
        LOG.trace("Called updateDhcpOptions");
        UpdateDhcpOptionsRequest interceptedRequest = UpdateDhcpOptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDhcpOptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDhcpOptionsResponse> transformer = UpdateDhcpOptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateDhcpDetails(), retriedRequest);
                return (UpdateDhcpOptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDrgResponse updateDrg(UpdateDrgRequest request) {
        LOG.trace("Called updateDrg");
        UpdateDrgRequest interceptedRequest = UpdateDrgConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDrgConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDrgResponse> transformer = UpdateDrgConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateDrgDetails(), retriedRequest);
                return (UpdateDrgResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDrgAttachmentResponse updateDrgAttachment(UpdateDrgAttachmentRequest request) {
        LOG.trace("Called updateDrgAttachment");
        UpdateDrgAttachmentRequest interceptedRequest = UpdateDrgAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDrgAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDrgAttachmentResponse> transformer = UpdateDrgAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateDrgAttachmentDetails(), retriedRequest);
                return (UpdateDrgAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateIPSecConnectionResponse updateIPSecConnection(UpdateIPSecConnectionRequest request) {
        LOG.trace("Called updateIPSecConnection");
        UpdateIPSecConnectionRequest interceptedRequest = UpdateIPSecConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIPSecConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateIPSecConnectionResponse> transformer = UpdateIPSecConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateIPSecConnectionDetails(), retriedRequest);
                return (UpdateIPSecConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateIPSecConnectionTunnelResponse updateIPSecConnectionTunnel(UpdateIPSecConnectionTunnelRequest request) {
        LOG.trace("Called updateIPSecConnectionTunnel");
        UpdateIPSecConnectionTunnelRequest interceptedRequest = UpdateIPSecConnectionTunnelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIPSecConnectionTunnelConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateIPSecConnectionTunnelResponse> transformer = UpdateIPSecConnectionTunnelConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateIPSecConnectionTunnelDetails(), retriedRequest);
                return (UpdateIPSecConnectionTunnelResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateIPSecConnectionTunnelSharedSecretResponse updateIPSecConnectionTunnelSharedSecret(UpdateIPSecConnectionTunnelSharedSecretRequest request) {
        LOG.trace("Called updateIPSecConnectionTunnelSharedSecret");
        UpdateIPSecConnectionTunnelSharedSecretRequest interceptedRequest = UpdateIPSecConnectionTunnelSharedSecretConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIPSecConnectionTunnelSharedSecretConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateIPSecConnectionTunnelSharedSecretResponse> transformer = UpdateIPSecConnectionTunnelSharedSecretConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateIPSecConnectionTunnelSharedSecretDetails(), retriedRequest);
                return (UpdateIPSecConnectionTunnelSharedSecretResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateInternetGatewayResponse updateInternetGateway(UpdateInternetGatewayRequest request) {
        LOG.trace("Called updateInternetGateway");
        UpdateInternetGatewayRequest interceptedRequest = UpdateInternetGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateInternetGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateInternetGatewayResponse> transformer = UpdateInternetGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateInternetGatewayDetails(), retriedRequest);
                return (UpdateInternetGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateIpv6Response updateIpv6(UpdateIpv6Request request) {
        LOG.trace("Called updateIpv6");
        UpdateIpv6Request interceptedRequest = UpdateIpv6Converter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateIpv6Converter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateIpv6Response> transformer = UpdateIpv6Converter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateIpv6Details(), retriedRequest);
                return (UpdateIpv6Response)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateLocalPeeringGatewayResponse updateLocalPeeringGateway(UpdateLocalPeeringGatewayRequest request) {
        LOG.trace("Called updateLocalPeeringGateway");
        UpdateLocalPeeringGatewayRequest interceptedRequest = UpdateLocalPeeringGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLocalPeeringGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLocalPeeringGatewayResponse> transformer = UpdateLocalPeeringGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateLocalPeeringGatewayDetails(), retriedRequest);
                return (UpdateLocalPeeringGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNatGatewayResponse updateNatGateway(UpdateNatGatewayRequest request) {
        LOG.trace("Called updateNatGateway");
        UpdateNatGatewayRequest interceptedRequest = UpdateNatGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNatGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNatGatewayResponse> transformer = UpdateNatGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateNatGatewayDetails(), retriedRequest);
                return (UpdateNatGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNetworkSecurityGroupResponse updateNetworkSecurityGroup(UpdateNetworkSecurityGroupRequest request) {
        LOG.trace("Called updateNetworkSecurityGroup");
        UpdateNetworkSecurityGroupRequest interceptedRequest = UpdateNetworkSecurityGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkSecurityGroupResponse> transformer = UpdateNetworkSecurityGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateNetworkSecurityGroupDetails(), retriedRequest);
                return (UpdateNetworkSecurityGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNetworkSecurityGroupSecurityRulesResponse updateNetworkSecurityGroupSecurityRules(UpdateNetworkSecurityGroupSecurityRulesRequest request) {
        LOG.trace("Called updateNetworkSecurityGroupSecurityRules");
        UpdateNetworkSecurityGroupSecurityRulesRequest interceptedRequest = UpdateNetworkSecurityGroupSecurityRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupSecurityRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkSecurityGroupSecurityRulesResponse> transformer = UpdateNetworkSecurityGroupSecurityRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getUpdateNetworkSecurityGroupSecurityRulesDetails(), retriedRequest);
                return (UpdateNetworkSecurityGroupSecurityRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePrivateIpResponse updatePrivateIp(UpdatePrivateIpRequest request) {
        LOG.trace("Called updatePrivateIp");
        UpdatePrivateIpRequest interceptedRequest = UpdatePrivateIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePrivateIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePrivateIpResponse> transformer = UpdatePrivateIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdatePrivateIpDetails(), retriedRequest);
                return (UpdatePrivateIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePublicIpResponse updatePublicIp(UpdatePublicIpRequest request) {
        LOG.trace("Called updatePublicIp");
        UpdatePublicIpRequest interceptedRequest = UpdatePublicIpConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePublicIpConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePublicIpResponse> transformer = UpdatePublicIpConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdatePublicIpDetails(), retriedRequest);
                return (UpdatePublicIpResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRemotePeeringConnectionResponse updateRemotePeeringConnection(UpdateRemotePeeringConnectionRequest request) {
        LOG.trace("Called updateRemotePeeringConnection");
        UpdateRemotePeeringConnectionRequest interceptedRequest = UpdateRemotePeeringConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRemotePeeringConnectionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRemotePeeringConnectionResponse> transformer = UpdateRemotePeeringConnectionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateRemotePeeringConnectionDetails(), retriedRequest);
                return (UpdateRemotePeeringConnectionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRouteTableResponse updateRouteTable(UpdateRouteTableRequest request) {
        LOG.trace("Called updateRouteTable");
        UpdateRouteTableRequest interceptedRequest = UpdateRouteTableConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRouteTableConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRouteTableResponse> transformer = UpdateRouteTableConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateRouteTableDetails(), retriedRequest);
                return (UpdateRouteTableResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSecurityListResponse updateSecurityList(UpdateSecurityListRequest request) {
        LOG.trace("Called updateSecurityList");
        UpdateSecurityListRequest interceptedRequest = UpdateSecurityListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSecurityListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSecurityListResponse> transformer = UpdateSecurityListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateSecurityListDetails(), retriedRequest);
                return (UpdateSecurityListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateServiceGatewayResponse updateServiceGateway(UpdateServiceGatewayRequest request) {
        LOG.trace("Called updateServiceGateway");
        UpdateServiceGatewayRequest interceptedRequest = UpdateServiceGatewayConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateServiceGatewayConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateServiceGatewayResponse> transformer = UpdateServiceGatewayConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateServiceGatewayDetails(), retriedRequest);
                return (UpdateServiceGatewayResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSubnetResponse updateSubnet(UpdateSubnetRequest request) {
        LOG.trace("Called updateSubnet");
        UpdateSubnetRequest interceptedRequest = UpdateSubnetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSubnetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSubnetResponse> transformer = UpdateSubnetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateSubnetDetails(), retriedRequest);
                return (UpdateSubnetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVcnResponse updateVcn(UpdateVcnRequest request) {
        LOG.trace("Called updateVcn");
        UpdateVcnRequest interceptedRequest = UpdateVcnConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVcnConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVcnResponse> transformer = UpdateVcnConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVcnDetails(), retriedRequest);
                return (UpdateVcnResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVirtualCircuitResponse updateVirtualCircuit(UpdateVirtualCircuitRequest request) {
        LOG.trace("Called updateVirtualCircuit");
        UpdateVirtualCircuitRequest interceptedRequest = UpdateVirtualCircuitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVirtualCircuitConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVirtualCircuitResponse> transformer = UpdateVirtualCircuitConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVirtualCircuitDetails(), retriedRequest);
                return (UpdateVirtualCircuitResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVnicResponse updateVnic(UpdateVnicRequest request) {
        LOG.trace("Called updateVnic");
        UpdateVnicRequest interceptedRequest = UpdateVnicConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVnicConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVnicResponse> transformer = UpdateVnicConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVnicDetails(), retriedRequest);
                return (UpdateVnicResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public VirtualNetworkWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public VirtualNetworkWaiters newWaiters(WorkRequest workRequestClient) {
        return new VirtualNetworkWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public VirtualNetworkPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VirtualNetworkClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public VirtualNetworkClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new VirtualNetworkClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

