/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.core.VirtualNetwork;
import com.oracle.bmc.core.model.Cpe;
import com.oracle.bmc.core.model.CrossConnect;
import com.oracle.bmc.core.model.CrossConnectGroup;
import com.oracle.bmc.core.model.CrossConnectLocation;
import com.oracle.bmc.core.model.CrossConnectPortSpeedShape;
import com.oracle.bmc.core.model.DhcpOptions;
import com.oracle.bmc.core.model.Drg;
import com.oracle.bmc.core.model.DrgAttachment;
import com.oracle.bmc.core.model.FastConnectProviderService;
import com.oracle.bmc.core.model.IPSecConnection;
import com.oracle.bmc.core.model.IPSecConnectionTunnel;
import com.oracle.bmc.core.model.InternetGateway;
import com.oracle.bmc.core.model.Ipv6;
import com.oracle.bmc.core.model.LocalPeeringGateway;
import com.oracle.bmc.core.model.NatGateway;
import com.oracle.bmc.core.model.NetworkSecurityGroup;
import com.oracle.bmc.core.model.NetworkSecurityGroupVnic;
import com.oracle.bmc.core.model.PrivateIp;
import com.oracle.bmc.core.model.PublicIp;
import com.oracle.bmc.core.model.RemotePeeringConnection;
import com.oracle.bmc.core.model.RouteTable;
import com.oracle.bmc.core.model.SecurityList;
import com.oracle.bmc.core.model.SecurityRule;
import com.oracle.bmc.core.model.Service;
import com.oracle.bmc.core.model.ServiceGateway;
import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.core.model.Vcn;
import com.oracle.bmc.core.model.VirtualCircuit;
import com.oracle.bmc.core.model.VirtualCircuitBandwidthShape;
import com.oracle.bmc.core.requests.ListCpesRequest;
import com.oracle.bmc.core.requests.ListCrossConnectGroupsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectLocationsRequest;
import com.oracle.bmc.core.requests.ListCrossConnectsRequest;
import com.oracle.bmc.core.requests.ListCrossconnectPortSpeedShapesRequest;
import com.oracle.bmc.core.requests.ListDhcpOptionsRequest;
import com.oracle.bmc.core.requests.ListDrgAttachmentsRequest;
import com.oracle.bmc.core.requests.ListDrgsRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderServicesRequest;
import com.oracle.bmc.core.requests.ListFastConnectProviderVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionTunnelsRequest;
import com.oracle.bmc.core.requests.ListIPSecConnectionsRequest;
import com.oracle.bmc.core.requests.ListInternetGatewaysRequest;
import com.oracle.bmc.core.requests.ListIpv6sRequest;
import com.oracle.bmc.core.requests.ListLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.requests.ListNatGatewaysRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupVnicsRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupsRequest;
import com.oracle.bmc.core.requests.ListPrivateIpsRequest;
import com.oracle.bmc.core.requests.ListPublicIpsRequest;
import com.oracle.bmc.core.requests.ListRemotePeeringConnectionsRequest;
import com.oracle.bmc.core.requests.ListRouteTablesRequest;
import com.oracle.bmc.core.requests.ListSecurityListsRequest;
import com.oracle.bmc.core.requests.ListServiceGatewaysRequest;
import com.oracle.bmc.core.requests.ListServicesRequest;
import com.oracle.bmc.core.requests.ListSubnetsRequest;
import com.oracle.bmc.core.requests.ListVcnsRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitBandwidthShapesRequest;
import com.oracle.bmc.core.requests.ListVirtualCircuitsRequest;
import com.oracle.bmc.core.responses.ListCpesResponse;
import com.oracle.bmc.core.responses.ListCrossConnectGroupsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectLocationsResponse;
import com.oracle.bmc.core.responses.ListCrossConnectsResponse;
import com.oracle.bmc.core.responses.ListCrossconnectPortSpeedShapesResponse;
import com.oracle.bmc.core.responses.ListDhcpOptionsResponse;
import com.oracle.bmc.core.responses.ListDrgAttachmentsResponse;
import com.oracle.bmc.core.responses.ListDrgsResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderServicesResponse;
import com.oracle.bmc.core.responses.ListFastConnectProviderVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionTunnelsResponse;
import com.oracle.bmc.core.responses.ListIPSecConnectionsResponse;
import com.oracle.bmc.core.responses.ListInternetGatewaysResponse;
import com.oracle.bmc.core.responses.ListIpv6sResponse;
import com.oracle.bmc.core.responses.ListLocalPeeringGatewaysResponse;
import com.oracle.bmc.core.responses.ListNatGatewaysResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupVnicsResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupsResponse;
import com.oracle.bmc.core.responses.ListPrivateIpsResponse;
import com.oracle.bmc.core.responses.ListPublicIpsResponse;
import com.oracle.bmc.core.responses.ListRemotePeeringConnectionsResponse;
import com.oracle.bmc.core.responses.ListRouteTablesResponse;
import com.oracle.bmc.core.responses.ListSecurityListsResponse;
import com.oracle.bmc.core.responses.ListServiceGatewaysResponse;
import com.oracle.bmc.core.responses.ListServicesResponse;
import com.oracle.bmc.core.responses.ListSubnetsResponse;
import com.oracle.bmc.core.responses.ListVcnsResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitBandwidthShapesResponse;
import com.oracle.bmc.core.responses.ListVirtualCircuitsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class VirtualNetworkPaginators {
    private final VirtualNetwork client;

    public Iterable<ListCpesResponse> listCpesResponseIterator(final ListCpesRequest request) {
        return new ResponseIterable<ListCpesRequest.Builder, ListCpesRequest, ListCpesResponse>(new Supplier<ListCpesRequest.Builder>(){

            public ListCpesRequest.Builder get() {
                return ListCpesRequest.builder().copy(request);
            }
        }, new Function<ListCpesResponse, String>(){

            public String apply(ListCpesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCpesRequest.Builder>, ListCpesRequest>(){

            public ListCpesRequest apply(RequestBuilderAndToken<ListCpesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCpesRequest, ListCpesResponse>(){

            public ListCpesResponse apply(ListCpesRequest request) {
                return VirtualNetworkPaginators.this.client.listCpes(request);
            }
        });
    }

    public Iterable<Cpe> listCpesRecordIterator(final ListCpesRequest request) {
        return new ResponseRecordIterable<ListCpesRequest.Builder, ListCpesRequest, ListCpesResponse, Cpe>(new Supplier<ListCpesRequest.Builder>(){

            public ListCpesRequest.Builder get() {
                return ListCpesRequest.builder().copy(request);
            }
        }, new Function<ListCpesResponse, String>(){

            public String apply(ListCpesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCpesRequest.Builder>, ListCpesRequest>(){

            public ListCpesRequest apply(RequestBuilderAndToken<ListCpesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCpesRequest, ListCpesResponse>(){

            public ListCpesResponse apply(ListCpesRequest request) {
                return VirtualNetworkPaginators.this.client.listCpes(request);
            }
        }, new Function<ListCpesResponse, List<Cpe>>(){

            public List<Cpe> apply(ListCpesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCrossConnectGroupsResponse> listCrossConnectGroupsResponseIterator(final ListCrossConnectGroupsRequest request) {
        return new ResponseIterable<ListCrossConnectGroupsRequest.Builder, ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse>(new Supplier<ListCrossConnectGroupsRequest.Builder>(){

            public ListCrossConnectGroupsRequest.Builder get() {
                return ListCrossConnectGroupsRequest.builder().copy(request);
            }
        }, new Function<ListCrossConnectGroupsResponse, String>(){

            public String apply(ListCrossConnectGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossConnectGroupsRequest.Builder>, ListCrossConnectGroupsRequest>(){

            public ListCrossConnectGroupsRequest apply(RequestBuilderAndToken<ListCrossConnectGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse>(){

            public ListCrossConnectGroupsResponse apply(ListCrossConnectGroupsRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossConnectGroups(request);
            }
        });
    }

    public Iterable<CrossConnectGroup> listCrossConnectGroupsRecordIterator(final ListCrossConnectGroupsRequest request) {
        return new ResponseRecordIterable<ListCrossConnectGroupsRequest.Builder, ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse, CrossConnectGroup>(new Supplier<ListCrossConnectGroupsRequest.Builder>(){

            public ListCrossConnectGroupsRequest.Builder get() {
                return ListCrossConnectGroupsRequest.builder().copy(request);
            }
        }, new Function<ListCrossConnectGroupsResponse, String>(){

            public String apply(ListCrossConnectGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossConnectGroupsRequest.Builder>, ListCrossConnectGroupsRequest>(){

            public ListCrossConnectGroupsRequest apply(RequestBuilderAndToken<ListCrossConnectGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossConnectGroupsRequest, ListCrossConnectGroupsResponse>(){

            public ListCrossConnectGroupsResponse apply(ListCrossConnectGroupsRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossConnectGroups(request);
            }
        }, new Function<ListCrossConnectGroupsResponse, List<CrossConnectGroup>>(){

            public List<CrossConnectGroup> apply(ListCrossConnectGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCrossConnectLocationsResponse> listCrossConnectLocationsResponseIterator(final ListCrossConnectLocationsRequest request) {
        return new ResponseIterable<ListCrossConnectLocationsRequest.Builder, ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse>(new Supplier<ListCrossConnectLocationsRequest.Builder>(){

            public ListCrossConnectLocationsRequest.Builder get() {
                return ListCrossConnectLocationsRequest.builder().copy(request);
            }
        }, new Function<ListCrossConnectLocationsResponse, String>(){

            public String apply(ListCrossConnectLocationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossConnectLocationsRequest.Builder>, ListCrossConnectLocationsRequest>(){

            public ListCrossConnectLocationsRequest apply(RequestBuilderAndToken<ListCrossConnectLocationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse>(){

            public ListCrossConnectLocationsResponse apply(ListCrossConnectLocationsRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossConnectLocations(request);
            }
        });
    }

    public Iterable<CrossConnectLocation> listCrossConnectLocationsRecordIterator(final ListCrossConnectLocationsRequest request) {
        return new ResponseRecordIterable<ListCrossConnectLocationsRequest.Builder, ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse, CrossConnectLocation>(new Supplier<ListCrossConnectLocationsRequest.Builder>(){

            public ListCrossConnectLocationsRequest.Builder get() {
                return ListCrossConnectLocationsRequest.builder().copy(request);
            }
        }, new Function<ListCrossConnectLocationsResponse, String>(){

            public String apply(ListCrossConnectLocationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossConnectLocationsRequest.Builder>, ListCrossConnectLocationsRequest>(){

            public ListCrossConnectLocationsRequest apply(RequestBuilderAndToken<ListCrossConnectLocationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossConnectLocationsRequest, ListCrossConnectLocationsResponse>(){

            public ListCrossConnectLocationsResponse apply(ListCrossConnectLocationsRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossConnectLocations(request);
            }
        }, new Function<ListCrossConnectLocationsResponse, List<CrossConnectLocation>>(){

            public List<CrossConnectLocation> apply(ListCrossConnectLocationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCrossConnectsResponse> listCrossConnectsResponseIterator(final ListCrossConnectsRequest request) {
        return new ResponseIterable<ListCrossConnectsRequest.Builder, ListCrossConnectsRequest, ListCrossConnectsResponse>(new Supplier<ListCrossConnectsRequest.Builder>(){

            public ListCrossConnectsRequest.Builder get() {
                return ListCrossConnectsRequest.builder().copy(request);
            }
        }, new Function<ListCrossConnectsResponse, String>(){

            public String apply(ListCrossConnectsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossConnectsRequest.Builder>, ListCrossConnectsRequest>(){

            public ListCrossConnectsRequest apply(RequestBuilderAndToken<ListCrossConnectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossConnectsRequest, ListCrossConnectsResponse>(){

            public ListCrossConnectsResponse apply(ListCrossConnectsRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossConnects(request);
            }
        });
    }

    public Iterable<CrossConnect> listCrossConnectsRecordIterator(final ListCrossConnectsRequest request) {
        return new ResponseRecordIterable<ListCrossConnectsRequest.Builder, ListCrossConnectsRequest, ListCrossConnectsResponse, CrossConnect>(new Supplier<ListCrossConnectsRequest.Builder>(){

            public ListCrossConnectsRequest.Builder get() {
                return ListCrossConnectsRequest.builder().copy(request);
            }
        }, new Function<ListCrossConnectsResponse, String>(){

            public String apply(ListCrossConnectsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossConnectsRequest.Builder>, ListCrossConnectsRequest>(){

            public ListCrossConnectsRequest apply(RequestBuilderAndToken<ListCrossConnectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossConnectsRequest, ListCrossConnectsResponse>(){

            public ListCrossConnectsResponse apply(ListCrossConnectsRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossConnects(request);
            }
        }, new Function<ListCrossConnectsResponse, List<CrossConnect>>(){

            public List<CrossConnect> apply(ListCrossConnectsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListCrossconnectPortSpeedShapesResponse> listCrossconnectPortSpeedShapesResponseIterator(final ListCrossconnectPortSpeedShapesRequest request) {
        return new ResponseIterable<ListCrossconnectPortSpeedShapesRequest.Builder, ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse>(new Supplier<ListCrossconnectPortSpeedShapesRequest.Builder>(){

            public ListCrossconnectPortSpeedShapesRequest.Builder get() {
                return ListCrossconnectPortSpeedShapesRequest.builder().copy(request);
            }
        }, new Function<ListCrossconnectPortSpeedShapesResponse, String>(){

            public String apply(ListCrossconnectPortSpeedShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossconnectPortSpeedShapesRequest.Builder>, ListCrossconnectPortSpeedShapesRequest>(){

            public ListCrossconnectPortSpeedShapesRequest apply(RequestBuilderAndToken<ListCrossconnectPortSpeedShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse>(){

            public ListCrossconnectPortSpeedShapesResponse apply(ListCrossconnectPortSpeedShapesRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossconnectPortSpeedShapes(request);
            }
        });
    }

    public Iterable<CrossConnectPortSpeedShape> listCrossconnectPortSpeedShapesRecordIterator(final ListCrossconnectPortSpeedShapesRequest request) {
        return new ResponseRecordIterable<ListCrossconnectPortSpeedShapesRequest.Builder, ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse, CrossConnectPortSpeedShape>(new Supplier<ListCrossconnectPortSpeedShapesRequest.Builder>(){

            public ListCrossconnectPortSpeedShapesRequest.Builder get() {
                return ListCrossconnectPortSpeedShapesRequest.builder().copy(request);
            }
        }, new Function<ListCrossconnectPortSpeedShapesResponse, String>(){

            public String apply(ListCrossconnectPortSpeedShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListCrossconnectPortSpeedShapesRequest.Builder>, ListCrossconnectPortSpeedShapesRequest>(){

            public ListCrossconnectPortSpeedShapesRequest apply(RequestBuilderAndToken<ListCrossconnectPortSpeedShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListCrossconnectPortSpeedShapesRequest, ListCrossconnectPortSpeedShapesResponse>(){

            public ListCrossconnectPortSpeedShapesResponse apply(ListCrossconnectPortSpeedShapesRequest request) {
                return VirtualNetworkPaginators.this.client.listCrossconnectPortSpeedShapes(request);
            }
        }, new Function<ListCrossconnectPortSpeedShapesResponse, List<CrossConnectPortSpeedShape>>(){

            public List<CrossConnectPortSpeedShape> apply(ListCrossconnectPortSpeedShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDhcpOptionsResponse> listDhcpOptionsResponseIterator(final ListDhcpOptionsRequest request) {
        return new ResponseIterable<ListDhcpOptionsRequest.Builder, ListDhcpOptionsRequest, ListDhcpOptionsResponse>(new Supplier<ListDhcpOptionsRequest.Builder>(){

            public ListDhcpOptionsRequest.Builder get() {
                return ListDhcpOptionsRequest.builder().copy(request);
            }
        }, new Function<ListDhcpOptionsResponse, String>(){

            public String apply(ListDhcpOptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDhcpOptionsRequest.Builder>, ListDhcpOptionsRequest>(){

            public ListDhcpOptionsRequest apply(RequestBuilderAndToken<ListDhcpOptionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDhcpOptionsRequest, ListDhcpOptionsResponse>(){

            public ListDhcpOptionsResponse apply(ListDhcpOptionsRequest request) {
                return VirtualNetworkPaginators.this.client.listDhcpOptions(request);
            }
        });
    }

    public Iterable<DhcpOptions> listDhcpOptionsRecordIterator(final ListDhcpOptionsRequest request) {
        return new ResponseRecordIterable<ListDhcpOptionsRequest.Builder, ListDhcpOptionsRequest, ListDhcpOptionsResponse, DhcpOptions>(new Supplier<ListDhcpOptionsRequest.Builder>(){

            public ListDhcpOptionsRequest.Builder get() {
                return ListDhcpOptionsRequest.builder().copy(request);
            }
        }, new Function<ListDhcpOptionsResponse, String>(){

            public String apply(ListDhcpOptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDhcpOptionsRequest.Builder>, ListDhcpOptionsRequest>(){

            public ListDhcpOptionsRequest apply(RequestBuilderAndToken<ListDhcpOptionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDhcpOptionsRequest, ListDhcpOptionsResponse>(){

            public ListDhcpOptionsResponse apply(ListDhcpOptionsRequest request) {
                return VirtualNetworkPaginators.this.client.listDhcpOptions(request);
            }
        }, new Function<ListDhcpOptionsResponse, List<DhcpOptions>>(){

            public List<DhcpOptions> apply(ListDhcpOptionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDrgAttachmentsResponse> listDrgAttachmentsResponseIterator(final ListDrgAttachmentsRequest request) {
        return new ResponseIterable<ListDrgAttachmentsRequest.Builder, ListDrgAttachmentsRequest, ListDrgAttachmentsResponse>(new Supplier<ListDrgAttachmentsRequest.Builder>(){

            public ListDrgAttachmentsRequest.Builder get() {
                return ListDrgAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListDrgAttachmentsResponse, String>(){

            public String apply(ListDrgAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDrgAttachmentsRequest.Builder>, ListDrgAttachmentsRequest>(){

            public ListDrgAttachmentsRequest apply(RequestBuilderAndToken<ListDrgAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse>(){

            public ListDrgAttachmentsResponse apply(ListDrgAttachmentsRequest request) {
                return VirtualNetworkPaginators.this.client.listDrgAttachments(request);
            }
        });
    }

    public Iterable<DrgAttachment> listDrgAttachmentsRecordIterator(final ListDrgAttachmentsRequest request) {
        return new ResponseRecordIterable<ListDrgAttachmentsRequest.Builder, ListDrgAttachmentsRequest, ListDrgAttachmentsResponse, DrgAttachment>(new Supplier<ListDrgAttachmentsRequest.Builder>(){

            public ListDrgAttachmentsRequest.Builder get() {
                return ListDrgAttachmentsRequest.builder().copy(request);
            }
        }, new Function<ListDrgAttachmentsResponse, String>(){

            public String apply(ListDrgAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDrgAttachmentsRequest.Builder>, ListDrgAttachmentsRequest>(){

            public ListDrgAttachmentsRequest apply(RequestBuilderAndToken<ListDrgAttachmentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDrgAttachmentsRequest, ListDrgAttachmentsResponse>(){

            public ListDrgAttachmentsResponse apply(ListDrgAttachmentsRequest request) {
                return VirtualNetworkPaginators.this.client.listDrgAttachments(request);
            }
        }, new Function<ListDrgAttachmentsResponse, List<DrgAttachment>>(){

            public List<DrgAttachment> apply(ListDrgAttachmentsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDrgsResponse> listDrgsResponseIterator(final ListDrgsRequest request) {
        return new ResponseIterable<ListDrgsRequest.Builder, ListDrgsRequest, ListDrgsResponse>(new Supplier<ListDrgsRequest.Builder>(){

            public ListDrgsRequest.Builder get() {
                return ListDrgsRequest.builder().copy(request);
            }
        }, new Function<ListDrgsResponse, String>(){

            public String apply(ListDrgsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDrgsRequest.Builder>, ListDrgsRequest>(){

            public ListDrgsRequest apply(RequestBuilderAndToken<ListDrgsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDrgsRequest, ListDrgsResponse>(){

            public ListDrgsResponse apply(ListDrgsRequest request) {
                return VirtualNetworkPaginators.this.client.listDrgs(request);
            }
        });
    }

    public Iterable<Drg> listDrgsRecordIterator(final ListDrgsRequest request) {
        return new ResponseRecordIterable<ListDrgsRequest.Builder, ListDrgsRequest, ListDrgsResponse, Drg>(new Supplier<ListDrgsRequest.Builder>(){

            public ListDrgsRequest.Builder get() {
                return ListDrgsRequest.builder().copy(request);
            }
        }, new Function<ListDrgsResponse, String>(){

            public String apply(ListDrgsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDrgsRequest.Builder>, ListDrgsRequest>(){

            public ListDrgsRequest apply(RequestBuilderAndToken<ListDrgsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDrgsRequest, ListDrgsResponse>(){

            public ListDrgsResponse apply(ListDrgsRequest request) {
                return VirtualNetworkPaginators.this.client.listDrgs(request);
            }
        }, new Function<ListDrgsResponse, List<Drg>>(){

            public List<Drg> apply(ListDrgsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListFastConnectProviderServicesResponse> listFastConnectProviderServicesResponseIterator(final ListFastConnectProviderServicesRequest request) {
        return new ResponseIterable<ListFastConnectProviderServicesRequest.Builder, ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse>(new Supplier<ListFastConnectProviderServicesRequest.Builder>(){

            public ListFastConnectProviderServicesRequest.Builder get() {
                return ListFastConnectProviderServicesRequest.builder().copy(request);
            }
        }, new Function<ListFastConnectProviderServicesResponse, String>(){

            public String apply(ListFastConnectProviderServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListFastConnectProviderServicesRequest.Builder>, ListFastConnectProviderServicesRequest>(){

            public ListFastConnectProviderServicesRequest apply(RequestBuilderAndToken<ListFastConnectProviderServicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse>(){

            public ListFastConnectProviderServicesResponse apply(ListFastConnectProviderServicesRequest request) {
                return VirtualNetworkPaginators.this.client.listFastConnectProviderServices(request);
            }
        });
    }

    public Iterable<FastConnectProviderService> listFastConnectProviderServicesRecordIterator(final ListFastConnectProviderServicesRequest request) {
        return new ResponseRecordIterable<ListFastConnectProviderServicesRequest.Builder, ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse, FastConnectProviderService>(new Supplier<ListFastConnectProviderServicesRequest.Builder>(){

            public ListFastConnectProviderServicesRequest.Builder get() {
                return ListFastConnectProviderServicesRequest.builder().copy(request);
            }
        }, new Function<ListFastConnectProviderServicesResponse, String>(){

            public String apply(ListFastConnectProviderServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListFastConnectProviderServicesRequest.Builder>, ListFastConnectProviderServicesRequest>(){

            public ListFastConnectProviderServicesRequest apply(RequestBuilderAndToken<ListFastConnectProviderServicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListFastConnectProviderServicesRequest, ListFastConnectProviderServicesResponse>(){

            public ListFastConnectProviderServicesResponse apply(ListFastConnectProviderServicesRequest request) {
                return VirtualNetworkPaginators.this.client.listFastConnectProviderServices(request);
            }
        }, new Function<ListFastConnectProviderServicesResponse, List<FastConnectProviderService>>(){

            public List<FastConnectProviderService> apply(ListFastConnectProviderServicesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListFastConnectProviderVirtualCircuitBandwidthShapesResponse> listFastConnectProviderVirtualCircuitBandwidthShapesResponseIterator(final ListFastConnectProviderVirtualCircuitBandwidthShapesRequest request) {
        return new ResponseIterable<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder, ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>(new Supplier<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder>(){

            public ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder get() {
                return ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.builder().copy(request);
            }
        }, new Function<ListFastConnectProviderVirtualCircuitBandwidthShapesResponse, String>(){

            public String apply(ListFastConnectProviderVirtualCircuitBandwidthShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder>, ListFastConnectProviderVirtualCircuitBandwidthShapesRequest>(){

            public ListFastConnectProviderVirtualCircuitBandwidthShapesRequest apply(RequestBuilderAndToken<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>(){

            public ListFastConnectProviderVirtualCircuitBandwidthShapesResponse apply(ListFastConnectProviderVirtualCircuitBandwidthShapesRequest request) {
                return VirtualNetworkPaginators.this.client.listFastConnectProviderVirtualCircuitBandwidthShapes(request);
            }
        });
    }

    public Iterable<VirtualCircuitBandwidthShape> listFastConnectProviderVirtualCircuitBandwidthShapesRecordIterator(final ListFastConnectProviderVirtualCircuitBandwidthShapesRequest request) {
        return new ResponseRecordIterable<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder, ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse, VirtualCircuitBandwidthShape>(new Supplier<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder>(){

            public ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder get() {
                return ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.builder().copy(request);
            }
        }, new Function<ListFastConnectProviderVirtualCircuitBandwidthShapesResponse, String>(){

            public String apply(ListFastConnectProviderVirtualCircuitBandwidthShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder>, ListFastConnectProviderVirtualCircuitBandwidthShapesRequest>(){

            public ListFastConnectProviderVirtualCircuitBandwidthShapesRequest apply(RequestBuilderAndToken<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListFastConnectProviderVirtualCircuitBandwidthShapesRequest, ListFastConnectProviderVirtualCircuitBandwidthShapesResponse>(){

            public ListFastConnectProviderVirtualCircuitBandwidthShapesResponse apply(ListFastConnectProviderVirtualCircuitBandwidthShapesRequest request) {
                return VirtualNetworkPaginators.this.client.listFastConnectProviderVirtualCircuitBandwidthShapes(request);
            }
        }, new Function<ListFastConnectProviderVirtualCircuitBandwidthShapesResponse, List<VirtualCircuitBandwidthShape>>(){

            public List<VirtualCircuitBandwidthShape> apply(ListFastConnectProviderVirtualCircuitBandwidthShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIPSecConnectionTunnelsResponse> listIPSecConnectionTunnelsResponseIterator(final ListIPSecConnectionTunnelsRequest request) {
        return new ResponseIterable<ListIPSecConnectionTunnelsRequest.Builder, ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse>(new Supplier<ListIPSecConnectionTunnelsRequest.Builder>(){

            public ListIPSecConnectionTunnelsRequest.Builder get() {
                return ListIPSecConnectionTunnelsRequest.builder().copy(request);
            }
        }, new Function<ListIPSecConnectionTunnelsResponse, String>(){

            public String apply(ListIPSecConnectionTunnelsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIPSecConnectionTunnelsRequest.Builder>, ListIPSecConnectionTunnelsRequest>(){

            public ListIPSecConnectionTunnelsRequest apply(RequestBuilderAndToken<ListIPSecConnectionTunnelsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse>(){

            public ListIPSecConnectionTunnelsResponse apply(ListIPSecConnectionTunnelsRequest request) {
                return VirtualNetworkPaginators.this.client.listIPSecConnectionTunnels(request);
            }
        });
    }

    public Iterable<IPSecConnectionTunnel> listIPSecConnectionTunnelsRecordIterator(final ListIPSecConnectionTunnelsRequest request) {
        return new ResponseRecordIterable<ListIPSecConnectionTunnelsRequest.Builder, ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse, IPSecConnectionTunnel>(new Supplier<ListIPSecConnectionTunnelsRequest.Builder>(){

            public ListIPSecConnectionTunnelsRequest.Builder get() {
                return ListIPSecConnectionTunnelsRequest.builder().copy(request);
            }
        }, new Function<ListIPSecConnectionTunnelsResponse, String>(){

            public String apply(ListIPSecConnectionTunnelsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIPSecConnectionTunnelsRequest.Builder>, ListIPSecConnectionTunnelsRequest>(){

            public ListIPSecConnectionTunnelsRequest apply(RequestBuilderAndToken<ListIPSecConnectionTunnelsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIPSecConnectionTunnelsRequest, ListIPSecConnectionTunnelsResponse>(){

            public ListIPSecConnectionTunnelsResponse apply(ListIPSecConnectionTunnelsRequest request) {
                return VirtualNetworkPaginators.this.client.listIPSecConnectionTunnels(request);
            }
        }, new Function<ListIPSecConnectionTunnelsResponse, List<IPSecConnectionTunnel>>(){

            public List<IPSecConnectionTunnel> apply(ListIPSecConnectionTunnelsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIPSecConnectionsResponse> listIPSecConnectionsResponseIterator(final ListIPSecConnectionsRequest request) {
        return new ResponseIterable<ListIPSecConnectionsRequest.Builder, ListIPSecConnectionsRequest, ListIPSecConnectionsResponse>(new Supplier<ListIPSecConnectionsRequest.Builder>(){

            public ListIPSecConnectionsRequest.Builder get() {
                return ListIPSecConnectionsRequest.builder().copy(request);
            }
        }, new Function<ListIPSecConnectionsResponse, String>(){

            public String apply(ListIPSecConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIPSecConnectionsRequest.Builder>, ListIPSecConnectionsRequest>(){

            public ListIPSecConnectionsRequest apply(RequestBuilderAndToken<ListIPSecConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse>(){

            public ListIPSecConnectionsResponse apply(ListIPSecConnectionsRequest request) {
                return VirtualNetworkPaginators.this.client.listIPSecConnections(request);
            }
        });
    }

    public Iterable<IPSecConnection> listIPSecConnectionsRecordIterator(final ListIPSecConnectionsRequest request) {
        return new ResponseRecordIterable<ListIPSecConnectionsRequest.Builder, ListIPSecConnectionsRequest, ListIPSecConnectionsResponse, IPSecConnection>(new Supplier<ListIPSecConnectionsRequest.Builder>(){

            public ListIPSecConnectionsRequest.Builder get() {
                return ListIPSecConnectionsRequest.builder().copy(request);
            }
        }, new Function<ListIPSecConnectionsResponse, String>(){

            public String apply(ListIPSecConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIPSecConnectionsRequest.Builder>, ListIPSecConnectionsRequest>(){

            public ListIPSecConnectionsRequest apply(RequestBuilderAndToken<ListIPSecConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIPSecConnectionsRequest, ListIPSecConnectionsResponse>(){

            public ListIPSecConnectionsResponse apply(ListIPSecConnectionsRequest request) {
                return VirtualNetworkPaginators.this.client.listIPSecConnections(request);
            }
        }, new Function<ListIPSecConnectionsResponse, List<IPSecConnection>>(){

            public List<IPSecConnection> apply(ListIPSecConnectionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListInternetGatewaysResponse> listInternetGatewaysResponseIterator(final ListInternetGatewaysRequest request) {
        return new ResponseIterable<ListInternetGatewaysRequest.Builder, ListInternetGatewaysRequest, ListInternetGatewaysResponse>(new Supplier<ListInternetGatewaysRequest.Builder>(){

            public ListInternetGatewaysRequest.Builder get() {
                return ListInternetGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListInternetGatewaysResponse, String>(){

            public String apply(ListInternetGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInternetGatewaysRequest.Builder>, ListInternetGatewaysRequest>(){

            public ListInternetGatewaysRequest apply(RequestBuilderAndToken<ListInternetGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInternetGatewaysRequest, ListInternetGatewaysResponse>(){

            public ListInternetGatewaysResponse apply(ListInternetGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listInternetGateways(request);
            }
        });
    }

    public Iterable<InternetGateway> listInternetGatewaysRecordIterator(final ListInternetGatewaysRequest request) {
        return new ResponseRecordIterable<ListInternetGatewaysRequest.Builder, ListInternetGatewaysRequest, ListInternetGatewaysResponse, InternetGateway>(new Supplier<ListInternetGatewaysRequest.Builder>(){

            public ListInternetGatewaysRequest.Builder get() {
                return ListInternetGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListInternetGatewaysResponse, String>(){

            public String apply(ListInternetGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListInternetGatewaysRequest.Builder>, ListInternetGatewaysRequest>(){

            public ListInternetGatewaysRequest apply(RequestBuilderAndToken<ListInternetGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListInternetGatewaysRequest, ListInternetGatewaysResponse>(){

            public ListInternetGatewaysResponse apply(ListInternetGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listInternetGateways(request);
            }
        }, new Function<ListInternetGatewaysResponse, List<InternetGateway>>(){

            public List<InternetGateway> apply(ListInternetGatewaysResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListIpv6sResponse> listIpv6sResponseIterator(final ListIpv6sRequest request) {
        return new ResponseIterable<ListIpv6sRequest.Builder, ListIpv6sRequest, ListIpv6sResponse>(new Supplier<ListIpv6sRequest.Builder>(){

            public ListIpv6sRequest.Builder get() {
                return ListIpv6sRequest.builder().copy(request);
            }
        }, new Function<ListIpv6sResponse, String>(){

            public String apply(ListIpv6sResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIpv6sRequest.Builder>, ListIpv6sRequest>(){

            public ListIpv6sRequest apply(RequestBuilderAndToken<ListIpv6sRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIpv6sRequest, ListIpv6sResponse>(){

            public ListIpv6sResponse apply(ListIpv6sRequest request) {
                return VirtualNetworkPaginators.this.client.listIpv6s(request);
            }
        });
    }

    public Iterable<Ipv6> listIpv6sRecordIterator(final ListIpv6sRequest request) {
        return new ResponseRecordIterable<ListIpv6sRequest.Builder, ListIpv6sRequest, ListIpv6sResponse, Ipv6>(new Supplier<ListIpv6sRequest.Builder>(){

            public ListIpv6sRequest.Builder get() {
                return ListIpv6sRequest.builder().copy(request);
            }
        }, new Function<ListIpv6sResponse, String>(){

            public String apply(ListIpv6sResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListIpv6sRequest.Builder>, ListIpv6sRequest>(){

            public ListIpv6sRequest apply(RequestBuilderAndToken<ListIpv6sRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListIpv6sRequest, ListIpv6sResponse>(){

            public ListIpv6sResponse apply(ListIpv6sRequest request) {
                return VirtualNetworkPaginators.this.client.listIpv6s(request);
            }
        }, new Function<ListIpv6sResponse, List<Ipv6>>(){

            public List<Ipv6> apply(ListIpv6sResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListLocalPeeringGatewaysResponse> listLocalPeeringGatewaysResponseIterator(final ListLocalPeeringGatewaysRequest request) {
        return new ResponseIterable<ListLocalPeeringGatewaysRequest.Builder, ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse>(new Supplier<ListLocalPeeringGatewaysRequest.Builder>(){

            public ListLocalPeeringGatewaysRequest.Builder get() {
                return ListLocalPeeringGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListLocalPeeringGatewaysResponse, String>(){

            public String apply(ListLocalPeeringGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListLocalPeeringGatewaysRequest.Builder>, ListLocalPeeringGatewaysRequest>(){

            public ListLocalPeeringGatewaysRequest apply(RequestBuilderAndToken<ListLocalPeeringGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse>(){

            public ListLocalPeeringGatewaysResponse apply(ListLocalPeeringGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listLocalPeeringGateways(request);
            }
        });
    }

    public Iterable<LocalPeeringGateway> listLocalPeeringGatewaysRecordIterator(final ListLocalPeeringGatewaysRequest request) {
        return new ResponseRecordIterable<ListLocalPeeringGatewaysRequest.Builder, ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse, LocalPeeringGateway>(new Supplier<ListLocalPeeringGatewaysRequest.Builder>(){

            public ListLocalPeeringGatewaysRequest.Builder get() {
                return ListLocalPeeringGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListLocalPeeringGatewaysResponse, String>(){

            public String apply(ListLocalPeeringGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListLocalPeeringGatewaysRequest.Builder>, ListLocalPeeringGatewaysRequest>(){

            public ListLocalPeeringGatewaysRequest apply(RequestBuilderAndToken<ListLocalPeeringGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListLocalPeeringGatewaysRequest, ListLocalPeeringGatewaysResponse>(){

            public ListLocalPeeringGatewaysResponse apply(ListLocalPeeringGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listLocalPeeringGateways(request);
            }
        }, new Function<ListLocalPeeringGatewaysResponse, List<LocalPeeringGateway>>(){

            public List<LocalPeeringGateway> apply(ListLocalPeeringGatewaysResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNatGatewaysResponse> listNatGatewaysResponseIterator(final ListNatGatewaysRequest request) {
        return new ResponseIterable<ListNatGatewaysRequest.Builder, ListNatGatewaysRequest, ListNatGatewaysResponse>(new Supplier<ListNatGatewaysRequest.Builder>(){

            public ListNatGatewaysRequest.Builder get() {
                return ListNatGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListNatGatewaysResponse, String>(){

            public String apply(ListNatGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNatGatewaysRequest.Builder>, ListNatGatewaysRequest>(){

            public ListNatGatewaysRequest apply(RequestBuilderAndToken<ListNatGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNatGatewaysRequest, ListNatGatewaysResponse>(){

            public ListNatGatewaysResponse apply(ListNatGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listNatGateways(request);
            }
        });
    }

    public Iterable<NatGateway> listNatGatewaysRecordIterator(final ListNatGatewaysRequest request) {
        return new ResponseRecordIterable<ListNatGatewaysRequest.Builder, ListNatGatewaysRequest, ListNatGatewaysResponse, NatGateway>(new Supplier<ListNatGatewaysRequest.Builder>(){

            public ListNatGatewaysRequest.Builder get() {
                return ListNatGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListNatGatewaysResponse, String>(){

            public String apply(ListNatGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNatGatewaysRequest.Builder>, ListNatGatewaysRequest>(){

            public ListNatGatewaysRequest apply(RequestBuilderAndToken<ListNatGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNatGatewaysRequest, ListNatGatewaysResponse>(){

            public ListNatGatewaysResponse apply(ListNatGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listNatGateways(request);
            }
        }, new Function<ListNatGatewaysResponse, List<NatGateway>>(){

            public List<NatGateway> apply(ListNatGatewaysResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNetworkSecurityGroupSecurityRulesResponse> listNetworkSecurityGroupSecurityRulesResponseIterator(final ListNetworkSecurityGroupSecurityRulesRequest request) {
        return new ResponseIterable<ListNetworkSecurityGroupSecurityRulesRequest.Builder, ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse>(new Supplier<ListNetworkSecurityGroupSecurityRulesRequest.Builder>(){

            public ListNetworkSecurityGroupSecurityRulesRequest.Builder get() {
                return ListNetworkSecurityGroupSecurityRulesRequest.builder().copy(request);
            }
        }, new Function<ListNetworkSecurityGroupSecurityRulesResponse, String>(){

            public String apply(ListNetworkSecurityGroupSecurityRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNetworkSecurityGroupSecurityRulesRequest.Builder>, ListNetworkSecurityGroupSecurityRulesRequest>(){

            public ListNetworkSecurityGroupSecurityRulesRequest apply(RequestBuilderAndToken<ListNetworkSecurityGroupSecurityRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse>(){

            public ListNetworkSecurityGroupSecurityRulesResponse apply(ListNetworkSecurityGroupSecurityRulesRequest request) {
                return VirtualNetworkPaginators.this.client.listNetworkSecurityGroupSecurityRules(request);
            }
        });
    }

    public Iterable<SecurityRule> listNetworkSecurityGroupSecurityRulesRecordIterator(final ListNetworkSecurityGroupSecurityRulesRequest request) {
        return new ResponseRecordIterable<ListNetworkSecurityGroupSecurityRulesRequest.Builder, ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse, SecurityRule>(new Supplier<ListNetworkSecurityGroupSecurityRulesRequest.Builder>(){

            public ListNetworkSecurityGroupSecurityRulesRequest.Builder get() {
                return ListNetworkSecurityGroupSecurityRulesRequest.builder().copy(request);
            }
        }, new Function<ListNetworkSecurityGroupSecurityRulesResponse, String>(){

            public String apply(ListNetworkSecurityGroupSecurityRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNetworkSecurityGroupSecurityRulesRequest.Builder>, ListNetworkSecurityGroupSecurityRulesRequest>(){

            public ListNetworkSecurityGroupSecurityRulesRequest apply(RequestBuilderAndToken<ListNetworkSecurityGroupSecurityRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNetworkSecurityGroupSecurityRulesRequest, ListNetworkSecurityGroupSecurityRulesResponse>(){

            public ListNetworkSecurityGroupSecurityRulesResponse apply(ListNetworkSecurityGroupSecurityRulesRequest request) {
                return VirtualNetworkPaginators.this.client.listNetworkSecurityGroupSecurityRules(request);
            }
        }, new Function<ListNetworkSecurityGroupSecurityRulesResponse, List<SecurityRule>>(){

            public List<SecurityRule> apply(ListNetworkSecurityGroupSecurityRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNetworkSecurityGroupVnicsResponse> listNetworkSecurityGroupVnicsResponseIterator(final ListNetworkSecurityGroupVnicsRequest request) {
        return new ResponseIterable<ListNetworkSecurityGroupVnicsRequest.Builder, ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse>(new Supplier<ListNetworkSecurityGroupVnicsRequest.Builder>(){

            public ListNetworkSecurityGroupVnicsRequest.Builder get() {
                return ListNetworkSecurityGroupVnicsRequest.builder().copy(request);
            }
        }, new Function<ListNetworkSecurityGroupVnicsResponse, String>(){

            public String apply(ListNetworkSecurityGroupVnicsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNetworkSecurityGroupVnicsRequest.Builder>, ListNetworkSecurityGroupVnicsRequest>(){

            public ListNetworkSecurityGroupVnicsRequest apply(RequestBuilderAndToken<ListNetworkSecurityGroupVnicsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse>(){

            public ListNetworkSecurityGroupVnicsResponse apply(ListNetworkSecurityGroupVnicsRequest request) {
                return VirtualNetworkPaginators.this.client.listNetworkSecurityGroupVnics(request);
            }
        });
    }

    public Iterable<NetworkSecurityGroupVnic> listNetworkSecurityGroupVnicsRecordIterator(final ListNetworkSecurityGroupVnicsRequest request) {
        return new ResponseRecordIterable<ListNetworkSecurityGroupVnicsRequest.Builder, ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse, NetworkSecurityGroupVnic>(new Supplier<ListNetworkSecurityGroupVnicsRequest.Builder>(){

            public ListNetworkSecurityGroupVnicsRequest.Builder get() {
                return ListNetworkSecurityGroupVnicsRequest.builder().copy(request);
            }
        }, new Function<ListNetworkSecurityGroupVnicsResponse, String>(){

            public String apply(ListNetworkSecurityGroupVnicsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNetworkSecurityGroupVnicsRequest.Builder>, ListNetworkSecurityGroupVnicsRequest>(){

            public ListNetworkSecurityGroupVnicsRequest apply(RequestBuilderAndToken<ListNetworkSecurityGroupVnicsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNetworkSecurityGroupVnicsRequest, ListNetworkSecurityGroupVnicsResponse>(){

            public ListNetworkSecurityGroupVnicsResponse apply(ListNetworkSecurityGroupVnicsRequest request) {
                return VirtualNetworkPaginators.this.client.listNetworkSecurityGroupVnics(request);
            }
        }, new Function<ListNetworkSecurityGroupVnicsResponse, List<NetworkSecurityGroupVnic>>(){

            public List<NetworkSecurityGroupVnic> apply(ListNetworkSecurityGroupVnicsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListNetworkSecurityGroupsResponse> listNetworkSecurityGroupsResponseIterator(final ListNetworkSecurityGroupsRequest request) {
        return new ResponseIterable<ListNetworkSecurityGroupsRequest.Builder, ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse>(new Supplier<ListNetworkSecurityGroupsRequest.Builder>(){

            public ListNetworkSecurityGroupsRequest.Builder get() {
                return ListNetworkSecurityGroupsRequest.builder().copy(request);
            }
        }, new Function<ListNetworkSecurityGroupsResponse, String>(){

            public String apply(ListNetworkSecurityGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNetworkSecurityGroupsRequest.Builder>, ListNetworkSecurityGroupsRequest>(){

            public ListNetworkSecurityGroupsRequest apply(RequestBuilderAndToken<ListNetworkSecurityGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse>(){

            public ListNetworkSecurityGroupsResponse apply(ListNetworkSecurityGroupsRequest request) {
                return VirtualNetworkPaginators.this.client.listNetworkSecurityGroups(request);
            }
        });
    }

    public Iterable<NetworkSecurityGroup> listNetworkSecurityGroupsRecordIterator(final ListNetworkSecurityGroupsRequest request) {
        return new ResponseRecordIterable<ListNetworkSecurityGroupsRequest.Builder, ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse, NetworkSecurityGroup>(new Supplier<ListNetworkSecurityGroupsRequest.Builder>(){

            public ListNetworkSecurityGroupsRequest.Builder get() {
                return ListNetworkSecurityGroupsRequest.builder().copy(request);
            }
        }, new Function<ListNetworkSecurityGroupsResponse, String>(){

            public String apply(ListNetworkSecurityGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListNetworkSecurityGroupsRequest.Builder>, ListNetworkSecurityGroupsRequest>(){

            public ListNetworkSecurityGroupsRequest apply(RequestBuilderAndToken<ListNetworkSecurityGroupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListNetworkSecurityGroupsRequest, ListNetworkSecurityGroupsResponse>(){

            public ListNetworkSecurityGroupsResponse apply(ListNetworkSecurityGroupsRequest request) {
                return VirtualNetworkPaginators.this.client.listNetworkSecurityGroups(request);
            }
        }, new Function<ListNetworkSecurityGroupsResponse, List<NetworkSecurityGroup>>(){

            public List<NetworkSecurityGroup> apply(ListNetworkSecurityGroupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPrivateIpsResponse> listPrivateIpsResponseIterator(final ListPrivateIpsRequest request) {
        return new ResponseIterable<ListPrivateIpsRequest.Builder, ListPrivateIpsRequest, ListPrivateIpsResponse>(new Supplier<ListPrivateIpsRequest.Builder>(){

            public ListPrivateIpsRequest.Builder get() {
                return ListPrivateIpsRequest.builder().copy(request);
            }
        }, new Function<ListPrivateIpsResponse, String>(){

            public String apply(ListPrivateIpsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPrivateIpsRequest.Builder>, ListPrivateIpsRequest>(){

            public ListPrivateIpsRequest apply(RequestBuilderAndToken<ListPrivateIpsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPrivateIpsRequest, ListPrivateIpsResponse>(){

            public ListPrivateIpsResponse apply(ListPrivateIpsRequest request) {
                return VirtualNetworkPaginators.this.client.listPrivateIps(request);
            }
        });
    }

    public Iterable<PrivateIp> listPrivateIpsRecordIterator(final ListPrivateIpsRequest request) {
        return new ResponseRecordIterable<ListPrivateIpsRequest.Builder, ListPrivateIpsRequest, ListPrivateIpsResponse, PrivateIp>(new Supplier<ListPrivateIpsRequest.Builder>(){

            public ListPrivateIpsRequest.Builder get() {
                return ListPrivateIpsRequest.builder().copy(request);
            }
        }, new Function<ListPrivateIpsResponse, String>(){

            public String apply(ListPrivateIpsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPrivateIpsRequest.Builder>, ListPrivateIpsRequest>(){

            public ListPrivateIpsRequest apply(RequestBuilderAndToken<ListPrivateIpsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPrivateIpsRequest, ListPrivateIpsResponse>(){

            public ListPrivateIpsResponse apply(ListPrivateIpsRequest request) {
                return VirtualNetworkPaginators.this.client.listPrivateIps(request);
            }
        }, new Function<ListPrivateIpsResponse, List<PrivateIp>>(){

            public List<PrivateIp> apply(ListPrivateIpsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPublicIpsResponse> listPublicIpsResponseIterator(final ListPublicIpsRequest request) {
        return new ResponseIterable<ListPublicIpsRequest.Builder, ListPublicIpsRequest, ListPublicIpsResponse>(new Supplier<ListPublicIpsRequest.Builder>(){

            public ListPublicIpsRequest.Builder get() {
                return ListPublicIpsRequest.builder().copy(request);
            }
        }, new Function<ListPublicIpsResponse, String>(){

            public String apply(ListPublicIpsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPublicIpsRequest.Builder>, ListPublicIpsRequest>(){

            public ListPublicIpsRequest apply(RequestBuilderAndToken<ListPublicIpsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPublicIpsRequest, ListPublicIpsResponse>(){

            public ListPublicIpsResponse apply(ListPublicIpsRequest request) {
                return VirtualNetworkPaginators.this.client.listPublicIps(request);
            }
        });
    }

    public Iterable<PublicIp> listPublicIpsRecordIterator(final ListPublicIpsRequest request) {
        return new ResponseRecordIterable<ListPublicIpsRequest.Builder, ListPublicIpsRequest, ListPublicIpsResponse, PublicIp>(new Supplier<ListPublicIpsRequest.Builder>(){

            public ListPublicIpsRequest.Builder get() {
                return ListPublicIpsRequest.builder().copy(request);
            }
        }, new Function<ListPublicIpsResponse, String>(){

            public String apply(ListPublicIpsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPublicIpsRequest.Builder>, ListPublicIpsRequest>(){

            public ListPublicIpsRequest apply(RequestBuilderAndToken<ListPublicIpsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPublicIpsRequest, ListPublicIpsResponse>(){

            public ListPublicIpsResponse apply(ListPublicIpsRequest request) {
                return VirtualNetworkPaginators.this.client.listPublicIps(request);
            }
        }, new Function<ListPublicIpsResponse, List<PublicIp>>(){

            public List<PublicIp> apply(ListPublicIpsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRemotePeeringConnectionsResponse> listRemotePeeringConnectionsResponseIterator(final ListRemotePeeringConnectionsRequest request) {
        return new ResponseIterable<ListRemotePeeringConnectionsRequest.Builder, ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse>(new Supplier<ListRemotePeeringConnectionsRequest.Builder>(){

            public ListRemotePeeringConnectionsRequest.Builder get() {
                return ListRemotePeeringConnectionsRequest.builder().copy(request);
            }
        }, new Function<ListRemotePeeringConnectionsResponse, String>(){

            public String apply(ListRemotePeeringConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRemotePeeringConnectionsRequest.Builder>, ListRemotePeeringConnectionsRequest>(){

            public ListRemotePeeringConnectionsRequest apply(RequestBuilderAndToken<ListRemotePeeringConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse>(){

            public ListRemotePeeringConnectionsResponse apply(ListRemotePeeringConnectionsRequest request) {
                return VirtualNetworkPaginators.this.client.listRemotePeeringConnections(request);
            }
        });
    }

    public Iterable<RemotePeeringConnection> listRemotePeeringConnectionsRecordIterator(final ListRemotePeeringConnectionsRequest request) {
        return new ResponseRecordIterable<ListRemotePeeringConnectionsRequest.Builder, ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse, RemotePeeringConnection>(new Supplier<ListRemotePeeringConnectionsRequest.Builder>(){

            public ListRemotePeeringConnectionsRequest.Builder get() {
                return ListRemotePeeringConnectionsRequest.builder().copy(request);
            }
        }, new Function<ListRemotePeeringConnectionsResponse, String>(){

            public String apply(ListRemotePeeringConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRemotePeeringConnectionsRequest.Builder>, ListRemotePeeringConnectionsRequest>(){

            public ListRemotePeeringConnectionsRequest apply(RequestBuilderAndToken<ListRemotePeeringConnectionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRemotePeeringConnectionsRequest, ListRemotePeeringConnectionsResponse>(){

            public ListRemotePeeringConnectionsResponse apply(ListRemotePeeringConnectionsRequest request) {
                return VirtualNetworkPaginators.this.client.listRemotePeeringConnections(request);
            }
        }, new Function<ListRemotePeeringConnectionsResponse, List<RemotePeeringConnection>>(){

            public List<RemotePeeringConnection> apply(ListRemotePeeringConnectionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRouteTablesResponse> listRouteTablesResponseIterator(final ListRouteTablesRequest request) {
        return new ResponseIterable<ListRouteTablesRequest.Builder, ListRouteTablesRequest, ListRouteTablesResponse>(new Supplier<ListRouteTablesRequest.Builder>(){

            public ListRouteTablesRequest.Builder get() {
                return ListRouteTablesRequest.builder().copy(request);
            }
        }, new Function<ListRouteTablesResponse, String>(){

            public String apply(ListRouteTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRouteTablesRequest.Builder>, ListRouteTablesRequest>(){

            public ListRouteTablesRequest apply(RequestBuilderAndToken<ListRouteTablesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRouteTablesRequest, ListRouteTablesResponse>(){

            public ListRouteTablesResponse apply(ListRouteTablesRequest request) {
                return VirtualNetworkPaginators.this.client.listRouteTables(request);
            }
        });
    }

    public Iterable<RouteTable> listRouteTablesRecordIterator(final ListRouteTablesRequest request) {
        return new ResponseRecordIterable<ListRouteTablesRequest.Builder, ListRouteTablesRequest, ListRouteTablesResponse, RouteTable>(new Supplier<ListRouteTablesRequest.Builder>(){

            public ListRouteTablesRequest.Builder get() {
                return ListRouteTablesRequest.builder().copy(request);
            }
        }, new Function<ListRouteTablesResponse, String>(){

            public String apply(ListRouteTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListRouteTablesRequest.Builder>, ListRouteTablesRequest>(){

            public ListRouteTablesRequest apply(RequestBuilderAndToken<ListRouteTablesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListRouteTablesRequest, ListRouteTablesResponse>(){

            public ListRouteTablesResponse apply(ListRouteTablesRequest request) {
                return VirtualNetworkPaginators.this.client.listRouteTables(request);
            }
        }, new Function<ListRouteTablesResponse, List<RouteTable>>(){

            public List<RouteTable> apply(ListRouteTablesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSecurityListsResponse> listSecurityListsResponseIterator(final ListSecurityListsRequest request) {
        return new ResponseIterable<ListSecurityListsRequest.Builder, ListSecurityListsRequest, ListSecurityListsResponse>(new Supplier<ListSecurityListsRequest.Builder>(){

            public ListSecurityListsRequest.Builder get() {
                return ListSecurityListsRequest.builder().copy(request);
            }
        }, new Function<ListSecurityListsResponse, String>(){

            public String apply(ListSecurityListsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSecurityListsRequest.Builder>, ListSecurityListsRequest>(){

            public ListSecurityListsRequest apply(RequestBuilderAndToken<ListSecurityListsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSecurityListsRequest, ListSecurityListsResponse>(){

            public ListSecurityListsResponse apply(ListSecurityListsRequest request) {
                return VirtualNetworkPaginators.this.client.listSecurityLists(request);
            }
        });
    }

    public Iterable<SecurityList> listSecurityListsRecordIterator(final ListSecurityListsRequest request) {
        return new ResponseRecordIterable<ListSecurityListsRequest.Builder, ListSecurityListsRequest, ListSecurityListsResponse, SecurityList>(new Supplier<ListSecurityListsRequest.Builder>(){

            public ListSecurityListsRequest.Builder get() {
                return ListSecurityListsRequest.builder().copy(request);
            }
        }, new Function<ListSecurityListsResponse, String>(){

            public String apply(ListSecurityListsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSecurityListsRequest.Builder>, ListSecurityListsRequest>(){

            public ListSecurityListsRequest apply(RequestBuilderAndToken<ListSecurityListsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSecurityListsRequest, ListSecurityListsResponse>(){

            public ListSecurityListsResponse apply(ListSecurityListsRequest request) {
                return VirtualNetworkPaginators.this.client.listSecurityLists(request);
            }
        }, new Function<ListSecurityListsResponse, List<SecurityList>>(){

            public List<SecurityList> apply(ListSecurityListsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListServiceGatewaysResponse> listServiceGatewaysResponseIterator(final ListServiceGatewaysRequest request) {
        return new ResponseIterable<ListServiceGatewaysRequest.Builder, ListServiceGatewaysRequest, ListServiceGatewaysResponse>(new Supplier<ListServiceGatewaysRequest.Builder>(){

            public ListServiceGatewaysRequest.Builder get() {
                return ListServiceGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListServiceGatewaysResponse, String>(){

            public String apply(ListServiceGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListServiceGatewaysRequest.Builder>, ListServiceGatewaysRequest>(){

            public ListServiceGatewaysRequest apply(RequestBuilderAndToken<ListServiceGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListServiceGatewaysRequest, ListServiceGatewaysResponse>(){

            public ListServiceGatewaysResponse apply(ListServiceGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listServiceGateways(request);
            }
        });
    }

    public Iterable<ServiceGateway> listServiceGatewaysRecordIterator(final ListServiceGatewaysRequest request) {
        return new ResponseRecordIterable<ListServiceGatewaysRequest.Builder, ListServiceGatewaysRequest, ListServiceGatewaysResponse, ServiceGateway>(new Supplier<ListServiceGatewaysRequest.Builder>(){

            public ListServiceGatewaysRequest.Builder get() {
                return ListServiceGatewaysRequest.builder().copy(request);
            }
        }, new Function<ListServiceGatewaysResponse, String>(){

            public String apply(ListServiceGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListServiceGatewaysRequest.Builder>, ListServiceGatewaysRequest>(){

            public ListServiceGatewaysRequest apply(RequestBuilderAndToken<ListServiceGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListServiceGatewaysRequest, ListServiceGatewaysResponse>(){

            public ListServiceGatewaysResponse apply(ListServiceGatewaysRequest request) {
                return VirtualNetworkPaginators.this.client.listServiceGateways(request);
            }
        }, new Function<ListServiceGatewaysResponse, List<ServiceGateway>>(){

            public List<ServiceGateway> apply(ListServiceGatewaysResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListServicesResponse> listServicesResponseIterator(final ListServicesRequest request) {
        return new ResponseIterable<ListServicesRequest.Builder, ListServicesRequest, ListServicesResponse>(new Supplier<ListServicesRequest.Builder>(){

            public ListServicesRequest.Builder get() {
                return ListServicesRequest.builder().copy(request);
            }
        }, new Function<ListServicesResponse, String>(){

            public String apply(ListServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListServicesRequest.Builder>, ListServicesRequest>(){

            public ListServicesRequest apply(RequestBuilderAndToken<ListServicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListServicesRequest, ListServicesResponse>(){

            public ListServicesResponse apply(ListServicesRequest request) {
                return VirtualNetworkPaginators.this.client.listServices(request);
            }
        });
    }

    public Iterable<Service> listServicesRecordIterator(final ListServicesRequest request) {
        return new ResponseRecordIterable<ListServicesRequest.Builder, ListServicesRequest, ListServicesResponse, Service>(new Supplier<ListServicesRequest.Builder>(){

            public ListServicesRequest.Builder get() {
                return ListServicesRequest.builder().copy(request);
            }
        }, new Function<ListServicesResponse, String>(){

            public String apply(ListServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListServicesRequest.Builder>, ListServicesRequest>(){

            public ListServicesRequest apply(RequestBuilderAndToken<ListServicesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListServicesRequest, ListServicesResponse>(){

            public ListServicesResponse apply(ListServicesRequest request) {
                return VirtualNetworkPaginators.this.client.listServices(request);
            }
        }, new Function<ListServicesResponse, List<Service>>(){

            public List<Service> apply(ListServicesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSubnetsResponse> listSubnetsResponseIterator(final ListSubnetsRequest request) {
        return new ResponseIterable<ListSubnetsRequest.Builder, ListSubnetsRequest, ListSubnetsResponse>(new Supplier<ListSubnetsRequest.Builder>(){

            public ListSubnetsRequest.Builder get() {
                return ListSubnetsRequest.builder().copy(request);
            }
        }, new Function<ListSubnetsResponse, String>(){

            public String apply(ListSubnetsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSubnetsRequest.Builder>, ListSubnetsRequest>(){

            public ListSubnetsRequest apply(RequestBuilderAndToken<ListSubnetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSubnetsRequest, ListSubnetsResponse>(){

            public ListSubnetsResponse apply(ListSubnetsRequest request) {
                return VirtualNetworkPaginators.this.client.listSubnets(request);
            }
        });
    }

    public Iterable<Subnet> listSubnetsRecordIterator(final ListSubnetsRequest request) {
        return new ResponseRecordIterable<ListSubnetsRequest.Builder, ListSubnetsRequest, ListSubnetsResponse, Subnet>(new Supplier<ListSubnetsRequest.Builder>(){

            public ListSubnetsRequest.Builder get() {
                return ListSubnetsRequest.builder().copy(request);
            }
        }, new Function<ListSubnetsResponse, String>(){

            public String apply(ListSubnetsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListSubnetsRequest.Builder>, ListSubnetsRequest>(){

            public ListSubnetsRequest apply(RequestBuilderAndToken<ListSubnetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListSubnetsRequest, ListSubnetsResponse>(){

            public ListSubnetsResponse apply(ListSubnetsRequest request) {
                return VirtualNetworkPaginators.this.client.listSubnets(request);
            }
        }, new Function<ListSubnetsResponse, List<Subnet>>(){

            public List<Subnet> apply(ListSubnetsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVcnsResponse> listVcnsResponseIterator(final ListVcnsRequest request) {
        return new ResponseIterable<ListVcnsRequest.Builder, ListVcnsRequest, ListVcnsResponse>(new Supplier<ListVcnsRequest.Builder>(){

            public ListVcnsRequest.Builder get() {
                return ListVcnsRequest.builder().copy(request);
            }
        }, new Function<ListVcnsResponse, String>(){

            public String apply(ListVcnsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVcnsRequest.Builder>, ListVcnsRequest>(){

            public ListVcnsRequest apply(RequestBuilderAndToken<ListVcnsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVcnsRequest, ListVcnsResponse>(){

            public ListVcnsResponse apply(ListVcnsRequest request) {
                return VirtualNetworkPaginators.this.client.listVcns(request);
            }
        });
    }

    public Iterable<Vcn> listVcnsRecordIterator(final ListVcnsRequest request) {
        return new ResponseRecordIterable<ListVcnsRequest.Builder, ListVcnsRequest, ListVcnsResponse, Vcn>(new Supplier<ListVcnsRequest.Builder>(){

            public ListVcnsRequest.Builder get() {
                return ListVcnsRequest.builder().copy(request);
            }
        }, new Function<ListVcnsResponse, String>(){

            public String apply(ListVcnsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVcnsRequest.Builder>, ListVcnsRequest>(){

            public ListVcnsRequest apply(RequestBuilderAndToken<ListVcnsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVcnsRequest, ListVcnsResponse>(){

            public ListVcnsResponse apply(ListVcnsRequest request) {
                return VirtualNetworkPaginators.this.client.listVcns(request);
            }
        }, new Function<ListVcnsResponse, List<Vcn>>(){

            public List<Vcn> apply(ListVcnsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVirtualCircuitBandwidthShapesResponse> listVirtualCircuitBandwidthShapesResponseIterator(final ListVirtualCircuitBandwidthShapesRequest request) {
        return new ResponseIterable<ListVirtualCircuitBandwidthShapesRequest.Builder, ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse>(new Supplier<ListVirtualCircuitBandwidthShapesRequest.Builder>(){

            public ListVirtualCircuitBandwidthShapesRequest.Builder get() {
                return ListVirtualCircuitBandwidthShapesRequest.builder().copy(request);
            }
        }, new Function<ListVirtualCircuitBandwidthShapesResponse, String>(){

            public String apply(ListVirtualCircuitBandwidthShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVirtualCircuitBandwidthShapesRequest.Builder>, ListVirtualCircuitBandwidthShapesRequest>(){

            public ListVirtualCircuitBandwidthShapesRequest apply(RequestBuilderAndToken<ListVirtualCircuitBandwidthShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse>(){

            public ListVirtualCircuitBandwidthShapesResponse apply(ListVirtualCircuitBandwidthShapesRequest request) {
                return VirtualNetworkPaginators.this.client.listVirtualCircuitBandwidthShapes(request);
            }
        });
    }

    public Iterable<VirtualCircuitBandwidthShape> listVirtualCircuitBandwidthShapesRecordIterator(final ListVirtualCircuitBandwidthShapesRequest request) {
        return new ResponseRecordIterable<ListVirtualCircuitBandwidthShapesRequest.Builder, ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse, VirtualCircuitBandwidthShape>(new Supplier<ListVirtualCircuitBandwidthShapesRequest.Builder>(){

            public ListVirtualCircuitBandwidthShapesRequest.Builder get() {
                return ListVirtualCircuitBandwidthShapesRequest.builder().copy(request);
            }
        }, new Function<ListVirtualCircuitBandwidthShapesResponse, String>(){

            public String apply(ListVirtualCircuitBandwidthShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVirtualCircuitBandwidthShapesRequest.Builder>, ListVirtualCircuitBandwidthShapesRequest>(){

            public ListVirtualCircuitBandwidthShapesRequest apply(RequestBuilderAndToken<ListVirtualCircuitBandwidthShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVirtualCircuitBandwidthShapesRequest, ListVirtualCircuitBandwidthShapesResponse>(){

            public ListVirtualCircuitBandwidthShapesResponse apply(ListVirtualCircuitBandwidthShapesRequest request) {
                return VirtualNetworkPaginators.this.client.listVirtualCircuitBandwidthShapes(request);
            }
        }, new Function<ListVirtualCircuitBandwidthShapesResponse, List<VirtualCircuitBandwidthShape>>(){

            public List<VirtualCircuitBandwidthShape> apply(ListVirtualCircuitBandwidthShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVirtualCircuitsResponse> listVirtualCircuitsResponseIterator(final ListVirtualCircuitsRequest request) {
        return new ResponseIterable<ListVirtualCircuitsRequest.Builder, ListVirtualCircuitsRequest, ListVirtualCircuitsResponse>(new Supplier<ListVirtualCircuitsRequest.Builder>(){

            public ListVirtualCircuitsRequest.Builder get() {
                return ListVirtualCircuitsRequest.builder().copy(request);
            }
        }, new Function<ListVirtualCircuitsResponse, String>(){

            public String apply(ListVirtualCircuitsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVirtualCircuitsRequest.Builder>, ListVirtualCircuitsRequest>(){

            public ListVirtualCircuitsRequest apply(RequestBuilderAndToken<ListVirtualCircuitsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse>(){

            public ListVirtualCircuitsResponse apply(ListVirtualCircuitsRequest request) {
                return VirtualNetworkPaginators.this.client.listVirtualCircuits(request);
            }
        });
    }

    public Iterable<VirtualCircuit> listVirtualCircuitsRecordIterator(final ListVirtualCircuitsRequest request) {
        return new ResponseRecordIterable<ListVirtualCircuitsRequest.Builder, ListVirtualCircuitsRequest, ListVirtualCircuitsResponse, VirtualCircuit>(new Supplier<ListVirtualCircuitsRequest.Builder>(){

            public ListVirtualCircuitsRequest.Builder get() {
                return ListVirtualCircuitsRequest.builder().copy(request);
            }
        }, new Function<ListVirtualCircuitsResponse, String>(){

            public String apply(ListVirtualCircuitsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVirtualCircuitsRequest.Builder>, ListVirtualCircuitsRequest>(){

            public ListVirtualCircuitsRequest apply(RequestBuilderAndToken<ListVirtualCircuitsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVirtualCircuitsRequest, ListVirtualCircuitsResponse>(){

            public ListVirtualCircuitsResponse apply(ListVirtualCircuitsRequest request) {
                return VirtualNetworkPaginators.this.client.listVirtualCircuits(request);
            }
        }, new Function<ListVirtualCircuitsResponse, List<VirtualCircuit>>(){

            public List<VirtualCircuit> apply(ListVirtualCircuitsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public VirtualNetworkPaginators(VirtualNetwork client) {
        this.client = client;
    }
}

