/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.core.VirtualNetwork;
import com.oracle.bmc.core.model.CrossConnect;
import com.oracle.bmc.core.model.CrossConnectGroup;
import com.oracle.bmc.core.model.DhcpOptions;
import com.oracle.bmc.core.model.Drg;
import com.oracle.bmc.core.model.DrgAttachment;
import com.oracle.bmc.core.model.IPSecConnection;
import com.oracle.bmc.core.model.IPSecConnectionTunnel;
import com.oracle.bmc.core.model.InternetGateway;
import com.oracle.bmc.core.model.Ipv6;
import com.oracle.bmc.core.model.LocalPeeringGateway;
import com.oracle.bmc.core.model.NatGateway;
import com.oracle.bmc.core.model.NetworkSecurityGroup;
import com.oracle.bmc.core.model.PublicIp;
import com.oracle.bmc.core.model.RemotePeeringConnection;
import com.oracle.bmc.core.model.RouteTable;
import com.oracle.bmc.core.model.SecurityList;
import com.oracle.bmc.core.model.ServiceGateway;
import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.core.model.Vcn;
import com.oracle.bmc.core.model.VirtualCircuit;
import com.oracle.bmc.core.model.Vnic;
import com.oracle.bmc.core.requests.ChangeDrgCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSubnetCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVcnCompartmentRequest;
import com.oracle.bmc.core.requests.GetCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.GetCrossConnectRequest;
import com.oracle.bmc.core.requests.GetDhcpOptionsRequest;
import com.oracle.bmc.core.requests.GetDrgAttachmentRequest;
import com.oracle.bmc.core.requests.GetDrgRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.GetInternetGatewayRequest;
import com.oracle.bmc.core.requests.GetIpv6Request;
import com.oracle.bmc.core.requests.GetLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.GetNatGatewayRequest;
import com.oracle.bmc.core.requests.GetNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.GetPublicIpRequest;
import com.oracle.bmc.core.requests.GetRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.GetRouteTableRequest;
import com.oracle.bmc.core.requests.GetSecurityListRequest;
import com.oracle.bmc.core.requests.GetServiceGatewayRequest;
import com.oracle.bmc.core.requests.GetSubnetRequest;
import com.oracle.bmc.core.requests.GetVcnRequest;
import com.oracle.bmc.core.requests.GetVirtualCircuitRequest;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.responses.ChangeDrgCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSubnetCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVcnCompartmentResponse;
import com.oracle.bmc.core.responses.GetCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.GetCrossConnectResponse;
import com.oracle.bmc.core.responses.GetDhcpOptionsResponse;
import com.oracle.bmc.core.responses.GetDrgAttachmentResponse;
import com.oracle.bmc.core.responses.GetDrgResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.GetInternetGatewayResponse;
import com.oracle.bmc.core.responses.GetIpv6Response;
import com.oracle.bmc.core.responses.GetLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.GetNatGatewayResponse;
import com.oracle.bmc.core.responses.GetNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.GetPublicIpResponse;
import com.oracle.bmc.core.responses.GetRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.GetRouteTableResponse;
import com.oracle.bmc.core.responses.GetSecurityListResponse;
import com.oracle.bmc.core.responses.GetServiceGatewayResponse;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import com.oracle.bmc.core.responses.GetVcnResponse;
import com.oracle.bmc.core.responses.GetVirtualCircuitResponse;
import com.oracle.bmc.core.responses.GetVnicResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class VirtualNetworkWaiters {
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final VirtualNetwork client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public VirtualNetworkWaiters(@NonNull ExecutorService executorService, @NonNull VirtualNetwork client) {
        this(executorService, client, null);
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
    }

    public VirtualNetworkWaiters(@NonNull ExecutorService executorService, @NonNull VirtualNetwork client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> forChangeDrgCompartment(ChangeDrgCompartmentRequest request) {
        return this.forChangeDrgCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> forChangeDrgCompartment(final ChangeDrgCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse>(this.executorService, new Callable<ChangeDrgCompartmentResponse>(){

            @Override
            public ChangeDrgCompartmentResponse call() throws Exception {
                ChangeDrgCompartmentResponse response = VirtualNetworkWaiters.this.client.changeDrgCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> forChangeSubnetCompartment(ChangeSubnetCompartmentRequest request) {
        return this.forChangeSubnetCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> forChangeSubnetCompartment(final ChangeSubnetCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse>(this.executorService, new Callable<ChangeSubnetCompartmentResponse>(){

            @Override
            public ChangeSubnetCompartmentResponse call() throws Exception {
                ChangeSubnetCompartmentResponse response = VirtualNetworkWaiters.this.client.changeSubnetCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> forChangeVcnCompartment(ChangeVcnCompartmentRequest request) {
        return this.forChangeVcnCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> forChangeVcnCompartment(final ChangeVcnCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse>(this.executorService, new Callable<ChangeVcnCompartmentResponse>(){

            @Override
            public ChangeVcnCompartmentResponse call() throws Exception {
                ChangeVcnCompartmentResponse response = VirtualNetworkWaiters.this.client.changeVcnCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(GetCrossConnectRequest request, CrossConnect.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCrossConnect(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(GetCrossConnectRequest request, CrossConnect.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCrossConnect(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(GetCrossConnectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CrossConnect.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCrossConnect(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(BmcGenericWaiter waiter, GetCrossConnectRequest request, CrossConnect.LifecycleState ... targetStates) {
        final HashSet<CrossConnect.LifecycleState> targetStatesSet = new HashSet<CrossConnect.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetCrossConnectRequest, GetCrossConnectResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetCrossConnectRequest, GetCrossConnectResponse>(){

            public GetCrossConnectResponse apply(GetCrossConnectRequest request) {
                return VirtualNetworkWaiters.this.client.getCrossConnect(request);
            }
        }, new Predicate<GetCrossConnectResponse>(){

            public boolean apply(GetCrossConnectResponse response) {
                return targetStatesSet.contains((Object)response.getCrossConnect().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CrossConnect.LifecycleState.Terminated)), request);
    }

    public Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(GetCrossConnectGroupRequest request, CrossConnectGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCrossConnectGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(GetCrossConnectGroupRequest request, CrossConnectGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCrossConnectGroup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(GetCrossConnectGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CrossConnectGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCrossConnectGroup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(BmcGenericWaiter waiter, GetCrossConnectGroupRequest request, CrossConnectGroup.LifecycleState ... targetStates) {
        final HashSet<CrossConnectGroup.LifecycleState> targetStatesSet = new HashSet<CrossConnectGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse>(){

            public GetCrossConnectGroupResponse apply(GetCrossConnectGroupRequest request) {
                return VirtualNetworkWaiters.this.client.getCrossConnectGroup(request);
            }
        }, new Predicate<GetCrossConnectGroupResponse>(){

            public boolean apply(GetCrossConnectGroupResponse response) {
                return targetStatesSet.contains((Object)response.getCrossConnectGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CrossConnectGroup.LifecycleState.Terminated)), request);
    }

    public Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(GetDhcpOptionsRequest request, DhcpOptions.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDhcpOptions(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(GetDhcpOptionsRequest request, DhcpOptions.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDhcpOptions(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(GetDhcpOptionsRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DhcpOptions.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDhcpOptions(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(BmcGenericWaiter waiter, GetDhcpOptionsRequest request, DhcpOptions.LifecycleState ... targetStates) {
        final HashSet<DhcpOptions.LifecycleState> targetStatesSet = new HashSet<DhcpOptions.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDhcpOptionsRequest, GetDhcpOptionsResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDhcpOptionsRequest, GetDhcpOptionsResponse>(){

            public GetDhcpOptionsResponse apply(GetDhcpOptionsRequest request) {
                return VirtualNetworkWaiters.this.client.getDhcpOptions(request);
            }
        }, new Predicate<GetDhcpOptionsResponse>(){

            public boolean apply(GetDhcpOptionsResponse response) {
                return targetStatesSet.contains((Object)response.getDhcpOptions().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DhcpOptions.LifecycleState.Terminated)), request);
    }

    public Waiter<GetDrgRequest, GetDrgResponse> forDrg(GetDrgRequest request, Drg.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrg(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrgRequest, GetDrgResponse> forDrg(GetDrgRequest request, Drg.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrg(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDrgRequest, GetDrgResponse> forDrg(GetDrgRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Drg.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDrg(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDrgRequest, GetDrgResponse> forDrg(BmcGenericWaiter waiter, GetDrgRequest request, Drg.LifecycleState ... targetStates) {
        final HashSet<Drg.LifecycleState> targetStatesSet = new HashSet<Drg.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDrgRequest, GetDrgResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDrgRequest, GetDrgResponse>(){

            public GetDrgResponse apply(GetDrgRequest request) {
                return VirtualNetworkWaiters.this.client.getDrg(request);
            }
        }, new Predicate<GetDrgResponse>(){

            public boolean apply(GetDrgResponse response) {
                return targetStatesSet.contains((Object)response.getDrg().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Drg.LifecycleState.Terminated)), request);
    }

    public Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(GetDrgAttachmentRequest request, DrgAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrgAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(GetDrgAttachmentRequest request, DrgAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrgAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(GetDrgAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DrgAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDrgAttachment(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(BmcGenericWaiter waiter, GetDrgAttachmentRequest request, DrgAttachment.LifecycleState ... targetStates) {
        final HashSet<DrgAttachment.LifecycleState> targetStatesSet = new HashSet<DrgAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDrgAttachmentRequest, GetDrgAttachmentResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDrgAttachmentRequest, GetDrgAttachmentResponse>(){

            public GetDrgAttachmentResponse apply(GetDrgAttachmentRequest request) {
                return VirtualNetworkWaiters.this.client.getDrgAttachment(request);
            }
        }, new Predicate<GetDrgAttachmentResponse>(){

            public boolean apply(GetDrgAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getDrgAttachment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DrgAttachment.LifecycleState.Detached)), request);
    }

    public Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(GetIPSecConnectionRequest request, IPSecConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(GetIPSecConnectionRequest request, IPSecConnection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIPSecConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(GetIPSecConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IPSecConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(BmcGenericWaiter waiter, GetIPSecConnectionRequest request, IPSecConnection.LifecycleState ... targetStates) {
        final HashSet<IPSecConnection.LifecycleState> targetStatesSet = new HashSet<IPSecConnection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetIPSecConnectionRequest, GetIPSecConnectionResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetIPSecConnectionRequest, GetIPSecConnectionResponse>(){

            public GetIPSecConnectionResponse apply(GetIPSecConnectionRequest request) {
                return VirtualNetworkWaiters.this.client.getIPSecConnection(request);
            }
        }, new Predicate<GetIPSecConnectionResponse>(){

            public boolean apply(GetIPSecConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getIPSecConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IPSecConnection.LifecycleState.Terminated)), request);
    }

    public Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request, IPSecConnectionTunnel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnectionTunnel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request, IPSecConnectionTunnel.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIPSecConnectionTunnel(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IPSecConnectionTunnel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnectionTunnel(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(BmcGenericWaiter waiter, GetIPSecConnectionTunnelRequest request, IPSecConnectionTunnel.LifecycleState ... targetStates) {
        final HashSet<IPSecConnectionTunnel.LifecycleState> targetStatesSet = new HashSet<IPSecConnectionTunnel.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse>(){

            public GetIPSecConnectionTunnelResponse apply(GetIPSecConnectionTunnelRequest request) {
                return VirtualNetworkWaiters.this.client.getIPSecConnectionTunnel(request);
            }
        }, new Predicate<GetIPSecConnectionTunnelResponse>(){

            public boolean apply(GetIPSecConnectionTunnelResponse response) {
                return targetStatesSet.contains((Object)response.getIPSecConnectionTunnel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IPSecConnectionTunnel.LifecycleState.Terminated)), request);
    }

    public Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(GetInternetGatewayRequest request, InternetGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInternetGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(GetInternetGatewayRequest request, InternetGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInternetGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(GetInternetGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InternetGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInternetGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(BmcGenericWaiter waiter, GetInternetGatewayRequest request, InternetGateway.LifecycleState ... targetStates) {
        final HashSet<InternetGateway.LifecycleState> targetStatesSet = new HashSet<InternetGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetInternetGatewayRequest, GetInternetGatewayResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetInternetGatewayRequest, GetInternetGatewayResponse>(){

            public GetInternetGatewayResponse apply(GetInternetGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getInternetGateway(request);
            }
        }, new Predicate<GetInternetGatewayResponse>(){

            public boolean apply(GetInternetGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getInternetGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InternetGateway.LifecycleState.Terminated)), request);
    }

    public Waiter<GetIpv6Request, GetIpv6Response> forIpv6(GetIpv6Request request, Ipv6.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIpv6(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIpv6Request, GetIpv6Response> forIpv6(GetIpv6Request request, Ipv6.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIpv6(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetIpv6Request, GetIpv6Response> forIpv6(GetIpv6Request request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Ipv6.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIpv6(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetIpv6Request, GetIpv6Response> forIpv6(BmcGenericWaiter waiter, GetIpv6Request request, Ipv6.LifecycleState ... targetStates) {
        final HashSet<Ipv6.LifecycleState> targetStatesSet = new HashSet<Ipv6.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetIpv6Request, GetIpv6Response>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetIpv6Request, GetIpv6Response>(){

            public GetIpv6Response apply(GetIpv6Request request) {
                return VirtualNetworkWaiters.this.client.getIpv6(request);
            }
        }, new Predicate<GetIpv6Response>(){

            public boolean apply(GetIpv6Response response) {
                return targetStatesSet.contains((Object)response.getIpv6().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Ipv6.LifecycleState.Terminated)), request);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LocalPeeringGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(BmcGenericWaiter waiter, GetLocalPeeringGatewayRequest request, LocalPeeringGateway.LifecycleState ... targetStates) {
        final HashSet<LocalPeeringGateway.LifecycleState> targetStatesSet = new HashSet<LocalPeeringGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(){

            public GetLocalPeeringGatewayResponse apply(GetLocalPeeringGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getLocalPeeringGateway(request);
            }
        }, new Predicate<GetLocalPeeringGatewayResponse>(){

            public boolean apply(GetLocalPeeringGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getLocalPeeringGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LocalPeeringGateway.LifecycleState.Terminated)), request);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.PeeringStatus targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LocalPeeringGateway.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(BmcGenericWaiter waiter, GetLocalPeeringGatewayRequest request, LocalPeeringGateway.PeeringStatus ... targetStates) {
        final HashSet<LocalPeeringGateway.PeeringStatus> targetStatesSet = new HashSet<LocalPeeringGateway.PeeringStatus>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(){

            public GetLocalPeeringGatewayResponse apply(GetLocalPeeringGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getLocalPeeringGateway(request);
            }
        }, new Predicate<GetLocalPeeringGatewayResponse>(){

            public boolean apply(GetLocalPeeringGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getLocalPeeringGateway().getPeeringStatus());
            }
        }, targetStatesSet.contains((Object)LocalPeeringGateway.PeeringStatus.Revoked)), request);
    }

    public Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(GetNatGatewayRequest request, NatGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNatGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(GetNatGatewayRequest request, NatGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNatGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(GetNatGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NatGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNatGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(BmcGenericWaiter waiter, GetNatGatewayRequest request, NatGateway.LifecycleState ... targetStates) {
        final HashSet<NatGateway.LifecycleState> targetStatesSet = new HashSet<NatGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetNatGatewayRequest, GetNatGatewayResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetNatGatewayRequest, GetNatGatewayResponse>(){

            public GetNatGatewayResponse apply(GetNatGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getNatGateway(request);
            }
        }, new Predicate<GetNatGatewayResponse>(){

            public boolean apply(GetNatGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getNatGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NatGateway.LifecycleState.Terminated)), request);
    }

    public Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(GetNetworkSecurityGroupRequest request, NetworkSecurityGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkSecurityGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(GetNetworkSecurityGroupRequest request, NetworkSecurityGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNetworkSecurityGroup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(GetNetworkSecurityGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NetworkSecurityGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNetworkSecurityGroup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(BmcGenericWaiter waiter, GetNetworkSecurityGroupRequest request, NetworkSecurityGroup.LifecycleState ... targetStates) {
        final HashSet<NetworkSecurityGroup.LifecycleState> targetStatesSet = new HashSet<NetworkSecurityGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse>(){

            public GetNetworkSecurityGroupResponse apply(GetNetworkSecurityGroupRequest request) {
                return VirtualNetworkWaiters.this.client.getNetworkSecurityGroup(request);
            }
        }, new Predicate<GetNetworkSecurityGroupResponse>(){

            public boolean apply(GetNetworkSecurityGroupResponse response) {
                return targetStatesSet.contains((Object)response.getNetworkSecurityGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NetworkSecurityGroup.LifecycleState.Terminated)), request);
    }

    public Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(GetPublicIpRequest request, PublicIp.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPublicIp(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(GetPublicIpRequest request, PublicIp.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPublicIp(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(GetPublicIpRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PublicIp.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPublicIp(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(BmcGenericWaiter waiter, GetPublicIpRequest request, PublicIp.LifecycleState ... targetStates) {
        final HashSet<PublicIp.LifecycleState> targetStatesSet = new HashSet<PublicIp.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetPublicIpRequest, GetPublicIpResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetPublicIpRequest, GetPublicIpResponse>(){

            public GetPublicIpResponse apply(GetPublicIpRequest request) {
                return VirtualNetworkWaiters.this.client.getPublicIp(request);
            }
        }, new Predicate<GetPublicIpResponse>(){

            public boolean apply(GetPublicIpResponse response) {
                return targetStatesSet.contains((Object)response.getPublicIp().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PublicIp.LifecycleState.Terminated)), request);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.PeeringStatus targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RemotePeeringConnection.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(BmcGenericWaiter waiter, GetRemotePeeringConnectionRequest request, RemotePeeringConnection.PeeringStatus ... targetStates) {
        final HashSet<RemotePeeringConnection.PeeringStatus> targetStatesSet = new HashSet<RemotePeeringConnection.PeeringStatus>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(){

            public GetRemotePeeringConnectionResponse apply(GetRemotePeeringConnectionRequest request) {
                return VirtualNetworkWaiters.this.client.getRemotePeeringConnection(request);
            }
        }, new Predicate<GetRemotePeeringConnectionResponse>(){

            public boolean apply(GetRemotePeeringConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getRemotePeeringConnection().getPeeringStatus());
            }
        }, targetStatesSet.contains((Object)RemotePeeringConnection.PeeringStatus.Revoked)), request);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RemotePeeringConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(BmcGenericWaiter waiter, GetRemotePeeringConnectionRequest request, RemotePeeringConnection.LifecycleState ... targetStates) {
        final HashSet<RemotePeeringConnection.LifecycleState> targetStatesSet = new HashSet<RemotePeeringConnection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(){

            public GetRemotePeeringConnectionResponse apply(GetRemotePeeringConnectionRequest request) {
                return VirtualNetworkWaiters.this.client.getRemotePeeringConnection(request);
            }
        }, new Predicate<GetRemotePeeringConnectionResponse>(){

            public boolean apply(GetRemotePeeringConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getRemotePeeringConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)RemotePeeringConnection.LifecycleState.Terminated)), request);
    }

    public Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(GetRouteTableRequest request, RouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRouteTable(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(GetRouteTableRequest request, RouteTable.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRouteTable(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(GetRouteTableRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRouteTable(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(BmcGenericWaiter waiter, GetRouteTableRequest request, RouteTable.LifecycleState ... targetStates) {
        final HashSet<RouteTable.LifecycleState> targetStatesSet = new HashSet<RouteTable.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetRouteTableRequest, GetRouteTableResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetRouteTableRequest, GetRouteTableResponse>(){

            public GetRouteTableResponse apply(GetRouteTableRequest request) {
                return VirtualNetworkWaiters.this.client.getRouteTable(request);
            }
        }, new Predicate<GetRouteTableResponse>(){

            public boolean apply(GetRouteTableResponse response) {
                return targetStatesSet.contains((Object)response.getRouteTable().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)RouteTable.LifecycleState.Terminated)), request);
    }

    public Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(GetSecurityListRequest request, SecurityList.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityList(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(GetSecurityListRequest request, SecurityList.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityList(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(GetSecurityListRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityList.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSecurityList(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(BmcGenericWaiter waiter, GetSecurityListRequest request, SecurityList.LifecycleState ... targetStates) {
        final HashSet<SecurityList.LifecycleState> targetStatesSet = new HashSet<SecurityList.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetSecurityListRequest, GetSecurityListResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetSecurityListRequest, GetSecurityListResponse>(){

            public GetSecurityListResponse apply(GetSecurityListRequest request) {
                return VirtualNetworkWaiters.this.client.getSecurityList(request);
            }
        }, new Predicate<GetSecurityListResponse>(){

            public boolean apply(GetSecurityListResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityList().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityList.LifecycleState.Terminated)), request);
    }

    public Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(GetServiceGatewayRequest request, ServiceGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forServiceGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(GetServiceGatewayRequest request, ServiceGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forServiceGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(GetServiceGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ServiceGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forServiceGateway(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(BmcGenericWaiter waiter, GetServiceGatewayRequest request, ServiceGateway.LifecycleState ... targetStates) {
        final HashSet<ServiceGateway.LifecycleState> targetStatesSet = new HashSet<ServiceGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetServiceGatewayRequest, GetServiceGatewayResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetServiceGatewayRequest, GetServiceGatewayResponse>(){

            public GetServiceGatewayResponse apply(GetServiceGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getServiceGateway(request);
            }
        }, new Predicate<GetServiceGatewayResponse>(){

            public boolean apply(GetServiceGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getServiceGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ServiceGateway.LifecycleState.Terminated)), request);
    }

    public Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(GetSubnetRequest request, Subnet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSubnet(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(GetSubnetRequest request, Subnet.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSubnet(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(GetSubnetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Subnet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSubnet(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(BmcGenericWaiter waiter, GetSubnetRequest request, Subnet.LifecycleState ... targetStates) {
        final HashSet<Subnet.LifecycleState> targetStatesSet = new HashSet<Subnet.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetSubnetRequest, GetSubnetResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetSubnetRequest, GetSubnetResponse>(){

            public GetSubnetResponse apply(GetSubnetRequest request) {
                return VirtualNetworkWaiters.this.client.getSubnet(request);
            }
        }, new Predicate<GetSubnetResponse>(){

            public boolean apply(GetSubnetResponse response) {
                return targetStatesSet.contains((Object)response.getSubnet().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Subnet.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVcnRequest, GetVcnResponse> forVcn(GetVcnRequest request, Vcn.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVcn(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVcnRequest, GetVcnResponse> forVcn(GetVcnRequest request, Vcn.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVcn(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVcnRequest, GetVcnResponse> forVcn(GetVcnRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Vcn.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVcn(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVcnRequest, GetVcnResponse> forVcn(BmcGenericWaiter waiter, GetVcnRequest request, Vcn.LifecycleState ... targetStates) {
        final HashSet<Vcn.LifecycleState> targetStatesSet = new HashSet<Vcn.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVcnRequest, GetVcnResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVcnRequest, GetVcnResponse>(){

            public GetVcnResponse apply(GetVcnRequest request) {
                return VirtualNetworkWaiters.this.client.getVcn(request);
            }
        }, new Predicate<GetVcnResponse>(){

            public boolean apply(GetVcnResponse response) {
                return targetStatesSet.contains((Object)response.getVcn().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Vcn.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(GetVirtualCircuitRequest request, VirtualCircuit.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualCircuit(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(GetVirtualCircuitRequest request, VirtualCircuit.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVirtualCircuit(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(GetVirtualCircuitRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VirtualCircuit.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVirtualCircuit(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(BmcGenericWaiter waiter, GetVirtualCircuitRequest request, VirtualCircuit.LifecycleState ... targetStates) {
        final HashSet<VirtualCircuit.LifecycleState> targetStatesSet = new HashSet<VirtualCircuit.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVirtualCircuitRequest, GetVirtualCircuitResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVirtualCircuitRequest, GetVirtualCircuitResponse>(){

            public GetVirtualCircuitResponse apply(GetVirtualCircuitRequest request) {
                return VirtualNetworkWaiters.this.client.getVirtualCircuit(request);
            }
        }, new Predicate<GetVirtualCircuitResponse>(){

            public boolean apply(GetVirtualCircuitResponse response) {
                return targetStatesSet.contains((Object)response.getVirtualCircuit().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VirtualCircuit.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVnicRequest, GetVnicResponse> forVnic(GetVnicRequest request, Vnic.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVnic(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVnicRequest, GetVnicResponse> forVnic(GetVnicRequest request, Vnic.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVnic(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVnicRequest, GetVnicResponse> forVnic(GetVnicRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Vnic.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVnic(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVnicRequest, GetVnicResponse> forVnic(BmcGenericWaiter waiter, GetVnicRequest request, Vnic.LifecycleState ... targetStates) {
        final HashSet<Vnic.LifecycleState> targetStatesSet = new HashSet<Vnic.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVnicRequest, GetVnicResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVnicRequest, GetVnicResponse>(){

            public GetVnicResponse apply(GetVnicRequest request) {
                return VirtualNetworkWaiters.this.client.getVnic(request);
            }
        }, new Predicate<GetVnicResponse>(){

            public boolean apply(GetVnicResponse response) {
                return targetStatesSet.contains((Object)response.getVnic().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Vnic.LifecycleState.Terminated)), request);
    }
}

