/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.AddedNetworkSecurityGroupSecurityRules;
import com.oracle.bmc.core.requests.AddNetworkSecurityGroupSecurityRulesRequest;
import com.oracle.bmc.core.responses.AddNetworkSecurityGroupSecurityRulesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNetworkSecurityGroupSecurityRulesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AddNetworkSecurityGroupSecurityRulesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static AddNetworkSecurityGroupSecurityRulesRequest interceptRequest(AddNetworkSecurityGroupSecurityRulesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, AddNetworkSecurityGroupSecurityRulesRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNetworkSecurityGroupId(), (String)"networkSecurityGroupId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getAddNetworkSecurityGroupSecurityRulesDetails(), (String)"addNetworkSecurityGroupSecurityRulesDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("networkSecurityGroups").path(HttpUtils.encodePathSegment(request.getNetworkSecurityGroupId())).path("actions").path("addSecurityRules");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, AddNetworkSecurityGroupSecurityRulesResponse> fromResponse() {
        Function<Response, AddNetworkSecurityGroupSecurityRulesResponse> transformer = new Function<Response, AddNetworkSecurityGroupSecurityRulesResponse>(){

            public AddNetworkSecurityGroupSecurityRulesResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for AddNetworkSecurityGroupSecurityRulesResponse");
                Function<Response, WithHeaders<AddedNetworkSecurityGroupSecurityRules>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AddedNetworkSecurityGroupSecurityRules.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                AddNetworkSecurityGroupSecurityRulesResponse.Builder builder = AddNetworkSecurityGroupSecurityRulesResponse.builder();
                builder.addedNetworkSecurityGroupSecurityRules((AddedNetworkSecurityGroupSecurityRules)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                AddNetworkSecurityGroupSecurityRulesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

