/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.ServiceGateway;
import com.oracle.bmc.core.requests.AttachServiceIdRequest;
import com.oracle.bmc.core.responses.AttachServiceIdResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachServiceIdConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AttachServiceIdConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static AttachServiceIdRequest interceptRequest(AttachServiceIdRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, AttachServiceIdRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getServiceGatewayId(), (String)"serviceGatewayId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getAttachServiceDetails(), (String)"attachServiceDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("serviceGateways").path(HttpUtils.encodePathSegment(request.getServiceGatewayId())).path("actions").path("attachService");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, AttachServiceIdResponse> fromResponse() {
        Function<Response, AttachServiceIdResponse> transformer = new Function<Response, AttachServiceIdResponse>(){

            public AttachServiceIdResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for AttachServiceIdResponse");
                Function<Response, WithHeaders<ServiceGateway>> responseFn = RESPONSE_CONVERSION_FACTORY.create(ServiceGateway.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                AttachServiceIdResponse.Builder builder = AttachServiceIdResponse.builder();
                builder.serviceGateway((ServiceGateway)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                AttachServiceIdResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

