/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.oracle.bmc.core.requests.BulkAddVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.responses.BulkAddVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkAddVirtualCircuitPublicPrefixesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(BulkAddVirtualCircuitPublicPrefixesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static BulkAddVirtualCircuitPublicPrefixesRequest interceptRequest(BulkAddVirtualCircuitPublicPrefixesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, BulkAddVirtualCircuitPublicPrefixesRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getBulkAddVirtualCircuitPublicPrefixesDetails(), (String)"bulkAddVirtualCircuitPublicPrefixesDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("virtualCircuits").path(HttpUtils.encodePathSegment(request.getVirtualCircuitId())).path("actions").path("bulkAddPublicPrefixes");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, BulkAddVirtualCircuitPublicPrefixesResponse> fromResponse() {
        Function<Response, BulkAddVirtualCircuitPublicPrefixesResponse> transformer = new Function<Response, BulkAddVirtualCircuitPublicPrefixesResponse>(){

            public BulkAddVirtualCircuitPublicPrefixesResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for BulkAddVirtualCircuitPublicPrefixesResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                BulkAddVirtualCircuitPublicPrefixesResponse.Builder builder = BulkAddVirtualCircuitPublicPrefixesResponse.builder();
                BulkAddVirtualCircuitPublicPrefixesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

