/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.ConsoleHistory;
import com.oracle.bmc.core.requests.CaptureConsoleHistoryRequest;
import com.oracle.bmc.core.responses.CaptureConsoleHistoryResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureConsoleHistoryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CaptureConsoleHistoryConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CaptureConsoleHistoryRequest interceptRequest(CaptureConsoleHistoryRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CaptureConsoleHistoryRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCaptureConsoleHistoryDetails(), (String)"captureConsoleHistoryDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("instanceConsoleHistories");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CaptureConsoleHistoryResponse> fromResponse() {
        Function<Response, CaptureConsoleHistoryResponse> transformer = new Function<Response, CaptureConsoleHistoryResponse>(){

            public CaptureConsoleHistoryResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for CaptureConsoleHistoryResponse");
                Function<Response, WithHeaders<ConsoleHistory>> responseFn = RESPONSE_CONVERSION_FACTORY.create(ConsoleHistory.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CaptureConsoleHistoryResponse.Builder builder = CaptureConsoleHistoryResponse.builder();
                builder.consoleHistory((ConsoleHistory)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                CaptureConsoleHistoryResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

