/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.requests.ChangeClusterNetworkCompartmentRequest;
import com.oracle.bmc.core.responses.ChangeClusterNetworkCompartmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeClusterNetworkCompartmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeClusterNetworkCompartmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ChangeClusterNetworkCompartmentRequest interceptRequest(ChangeClusterNetworkCompartmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ChangeClusterNetworkCompartmentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getClusterNetworkId(), (String)"clusterNetworkId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getChangeClusterNetworkCompartmentDetails(), (String)"changeClusterNetworkCompartmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("clusterNetworks").path(HttpUtils.encodePathSegment(request.getClusterNetworkId())).path("actions").path("changeCompartment");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ChangeClusterNetworkCompartmentResponse> fromResponse() {
        Function<Response, ChangeClusterNetworkCompartmentResponse> transformer = new Function<Response, ChangeClusterNetworkCompartmentResponse>(){

            public ChangeClusterNetworkCompartmentResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ChangeClusterNetworkCompartmentResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ChangeClusterNetworkCompartmentResponse.Builder builder = ChangeClusterNetworkCompartmentResponse.builder();
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ChangeClusterNetworkCompartmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

