/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.requests.ChangeDrgCompartmentRequest;
import com.oracle.bmc.core.responses.ChangeDrgCompartmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDrgCompartmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeDrgCompartmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ChangeDrgCompartmentRequest interceptRequest(ChangeDrgCompartmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ChangeDrgCompartmentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDrgId(), (String)"drgId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getChangeDrgCompartmentDetails(), (String)"changeDrgCompartmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("drgs").path(HttpUtils.encodePathSegment(request.getDrgId())).path("actions").path("changeCompartment");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, ChangeDrgCompartmentResponse> fromResponse() {
        Function<Response, ChangeDrgCompartmentResponse> transformer = new Function<Response, ChangeDrgCompartmentResponse>(){

            public ChangeDrgCompartmentResponse apply(Response rawResponse) {
                Optional<List<String>> opcWorkRequestIdHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ChangeDrgCompartmentResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ChangeDrgCompartmentResponse.Builder builder = ChangeDrgCompartmentResponse.builder();
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get(headers, "opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId(HeaderUtils.toValue("opc-work-request-id", (String)((List)opcWorkRequestIdHeader.get()).get(0), String.class));
                }
                ChangeDrgCompartmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

