/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.requests.ConnectLocalPeeringGatewaysRequest;
import com.oracle.bmc.core.responses.ConnectLocalPeeringGatewaysResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectLocalPeeringGatewaysConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectLocalPeeringGatewaysConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ConnectLocalPeeringGatewaysRequest interceptRequest(ConnectLocalPeeringGatewaysRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ConnectLocalPeeringGatewaysRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLocalPeeringGatewayId(), (String)"localPeeringGatewayId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getConnectLocalPeeringGatewaysDetails(), (String)"connectLocalPeeringGatewaysDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("localPeeringGateways").path(HttpUtils.encodePathSegment(request.getLocalPeeringGatewayId())).path("actions").path("connect");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ConnectLocalPeeringGatewaysResponse> fromResponse() {
        Function<Response, ConnectLocalPeeringGatewaysResponse> transformer = new Function<Response, ConnectLocalPeeringGatewaysResponse>(){

            public ConnectLocalPeeringGatewaysResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ConnectLocalPeeringGatewaysResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ConnectLocalPeeringGatewaysResponse.Builder builder = ConnectLocalPeeringGatewaysResponse.builder();
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ConnectLocalPeeringGatewaysResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

