/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.ClusterNetwork;
import com.oracle.bmc.core.requests.CreateClusterNetworkRequest;
import com.oracle.bmc.core.responses.CreateClusterNetworkResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateClusterNetworkConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateClusterNetworkConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateClusterNetworkRequest interceptRequest(CreateClusterNetworkRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateClusterNetworkRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateClusterNetworkDetails(), (String)"createClusterNetworkDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("clusterNetworks");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateClusterNetworkResponse> fromResponse() {
        Function<Response, CreateClusterNetworkResponse> transformer = new Function<Response, CreateClusterNetworkResponse>(){

            public CreateClusterNetworkResponse apply(Response rawResponse) {
                Optional<List<String>> opcWorkRequestIdHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for CreateClusterNetworkResponse");
                Function<Response, WithHeaders<ClusterNetwork>> responseFn = RESPONSE_CONVERSION_FACTORY.create(ClusterNetwork.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateClusterNetworkResponse.Builder builder = CreateClusterNetworkResponse.builder();
                builder.clusterNetwork((ClusterNetwork)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get(headers, "opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId(HeaderUtils.toValue("opc-work-request-id", (String)((List)opcWorkRequestIdHeader.get()).get(0), String.class));
                }
                CreateClusterNetworkResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

