/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.Ipv6;
import com.oracle.bmc.core.requests.CreateIpv6Request;
import com.oracle.bmc.core.responses.CreateIpv6Response;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIpv6Converter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateIpv6Converter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateIpv6Request interceptRequest(CreateIpv6Request request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateIpv6Request request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateIpv6Details(), (String)"createIpv6Details is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("ipv6");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateIpv6Response> fromResponse() {
        Function<Response, CreateIpv6Response> transformer = new Function<Response, CreateIpv6Response>(){

            public CreateIpv6Response apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for CreateIpv6Response");
                Function<Response, WithHeaders<Ipv6>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Ipv6.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateIpv6Response.Builder builder = CreateIpv6Response.builder();
                builder.ipv6((Ipv6)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                CreateIpv6Response responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

