/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.requests.DeleteVolumeBackupPolicyAssignmentRequest;
import com.oracle.bmc.core.responses.DeleteVolumeBackupPolicyAssignmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteVolumeBackupPolicyAssignmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteVolumeBackupPolicyAssignmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteVolumeBackupPolicyAssignmentRequest interceptRequest(DeleteVolumeBackupPolicyAssignmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteVolumeBackupPolicyAssignmentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPolicyAssignmentId(), (String)"policyAssignmentId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("volumeBackupPolicyAssignments").path(HttpUtils.encodePathSegment(request.getPolicyAssignmentId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, DeleteVolumeBackupPolicyAssignmentResponse> fromResponse() {
        Function<Response, DeleteVolumeBackupPolicyAssignmentResponse> transformer = new Function<Response, DeleteVolumeBackupPolicyAssignmentResponse>(){

            public DeleteVolumeBackupPolicyAssignmentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for DeleteVolumeBackupPolicyAssignmentResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                DeleteVolumeBackupPolicyAssignmentResponse.Builder builder = DeleteVolumeBackupPolicyAssignmentResponse.builder();
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                DeleteVolumeBackupPolicyAssignmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

