/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.requests.DetachBootVolumeRequest;
import com.oracle.bmc.core.responses.DetachBootVolumeResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetachBootVolumeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DetachBootVolumeConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DetachBootVolumeRequest interceptRequest(DetachBootVolumeRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DetachBootVolumeRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBootVolumeAttachmentId(), (String)"bootVolumeAttachmentId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("bootVolumeAttachments").path(HttpUtils.encodePathSegment(request.getBootVolumeAttachmentId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, DetachBootVolumeResponse> fromResponse() {
        Function<Response, DetachBootVolumeResponse> transformer = new Function<Response, DetachBootVolumeResponse>(){

            public DetachBootVolumeResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for DetachBootVolumeResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                DetachBootVolumeResponse.Builder builder = DetachBootVolumeResponse.builder();
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                DetachBootVolumeResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

