/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.requests.ExportImageRequest;
import com.oracle.bmc.core.responses.ExportImageResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportImageConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ExportImageConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ExportImageRequest interceptRequest(ExportImageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ExportImageRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getExportImageDetails(), (String)"exportImageDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("images").path(HttpUtils.encodePathSegment(request.getImageId())).path("actions").path("export");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, ExportImageResponse> fromResponse() {
        Function<Response, ExportImageResponse> transformer = new Function<Response, ExportImageResponse>(){

            public ExportImageResponse apply(Response rawResponse) {
                Optional<List<String>> opcWorkRequestIdHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ExportImageResponse");
                Function<Response, WithHeaders<Image>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Image.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ExportImageResponse.Builder builder = ExportImageResponse.builder();
                builder.image((Image)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get(headers, "opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId(HeaderUtils.toValue("opc-work-request-id", (String)((List)opcWorkRequestIdHeader.get()).get(0), String.class));
                }
                ExportImageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

