/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersionAgreements;
import com.oracle.bmc.core.requests.GetAppCatalogListingAgreementsRequest;
import com.oracle.bmc.core.responses.GetAppCatalogListingAgreementsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAppCatalogListingAgreementsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAppCatalogListingAgreementsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAppCatalogListingAgreementsRequest interceptRequest(GetAppCatalogListingAgreementsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAppCatalogListingAgreementsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getResourceVersion(), (String)"resourceVersion must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("appCatalogListings").path(HttpUtils.encodePathSegment(request.getListingId())).path("resourceVersions").path(HttpUtils.encodePathSegment(request.getResourceVersion())).path("agreements");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetAppCatalogListingAgreementsResponse> fromResponse() {
        Function<Response, GetAppCatalogListingAgreementsResponse> transformer = new Function<Response, GetAppCatalogListingAgreementsResponse>(){

            public GetAppCatalogListingAgreementsResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetAppCatalogListingAgreementsResponse");
                Function<Response, WithHeaders<AppCatalogListingResourceVersionAgreements>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AppCatalogListingResourceVersionAgreements.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetAppCatalogListingAgreementsResponse.Builder builder = GetAppCatalogListingAgreementsResponse.builder();
                builder.appCatalogListingResourceVersionAgreements((AppCatalogListingResourceVersionAgreements)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetAppCatalogListingAgreementsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

