/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.requests.GetConsoleHistoryContentRequest;
import com.oracle.bmc.core.responses.GetConsoleHistoryContentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetConsoleHistoryContentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetConsoleHistoryContentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetConsoleHistoryContentRequest interceptRequest(GetConsoleHistoryContentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetConsoleHistoryContentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("instanceConsoleHistories").path(HttpUtils.encodePathSegment(request.getInstanceConsoleHistoryId())).path("data");
        if (request.getOffset() != null) {
            target = target.queryParam("offset", HttpUtils.attemptEncodeQueryParam(request.getOffset()));
        }
        if (request.getLength() != null) {
            target = target.queryParam("length", HttpUtils.attemptEncodeQueryParam(request.getLength()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetConsoleHistoryContentResponse> fromResponse() {
        Function<Response, GetConsoleHistoryContentResponse> transformer = new Function<Response, GetConsoleHistoryContentResponse>(){

            public GetConsoleHistoryContentResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetConsoleHistoryContentResponse");
                Function<Response, WithHeaders<String>> responseFn = RESPONSE_CONVERSION_FACTORY.create(String.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetConsoleHistoryContentResponse.Builder builder = GetConsoleHistoryContentResponse.builder();
                builder.value((String)response.getItem());
                Optional<List<String>> opcBytesRemainingHeader = HeaderUtils.get(headers, "opc-bytes-remaining");
                if (opcBytesRemainingHeader.isPresent()) {
                    builder.opcBytesRemaining(HeaderUtils.toValue("opc-bytes-remaining", (String)((List)opcBytesRemainingHeader.get()).get(0), Integer.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetConsoleHistoryContentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

