/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.LetterOfAuthority;
import com.oracle.bmc.core.requests.GetCrossConnectLetterOfAuthorityRequest;
import com.oracle.bmc.core.responses.GetCrossConnectLetterOfAuthorityResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCrossConnectLetterOfAuthorityConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetCrossConnectLetterOfAuthorityConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetCrossConnectLetterOfAuthorityRequest interceptRequest(GetCrossConnectLetterOfAuthorityRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetCrossConnectLetterOfAuthorityRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("crossConnects").path(HttpUtils.encodePathSegment(request.getCrossConnectId())).path("letterOfAuthority");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetCrossConnectLetterOfAuthorityResponse> fromResponse() {
        Function<Response, GetCrossConnectLetterOfAuthorityResponse> transformer = new Function<Response, GetCrossConnectLetterOfAuthorityResponse>(){

            public GetCrossConnectLetterOfAuthorityResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetCrossConnectLetterOfAuthorityResponse");
                Function<Response, WithHeaders<LetterOfAuthority>> responseFn = RESPONSE_CONVERSION_FACTORY.create(LetterOfAuthority.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetCrossConnectLetterOfAuthorityResponse.Builder builder = GetCrossConnectLetterOfAuthorityResponse.builder();
                builder.letterOfAuthority((LetterOfAuthority)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetCrossConnectLetterOfAuthorityResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

