/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.CrossConnectStatus;
import com.oracle.bmc.core.requests.GetCrossConnectStatusRequest;
import com.oracle.bmc.core.responses.GetCrossConnectStatusResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCrossConnectStatusConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetCrossConnectStatusConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetCrossConnectStatusRequest interceptRequest(GetCrossConnectStatusRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetCrossConnectStatusRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCrossConnectId(), (String)"crossConnectId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("crossConnects").path(HttpUtils.encodePathSegment(request.getCrossConnectId())).path("status");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetCrossConnectStatusResponse> fromResponse() {
        Function<Response, GetCrossConnectStatusResponse> transformer = new Function<Response, GetCrossConnectStatusResponse>(){

            public GetCrossConnectStatusResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetCrossConnectStatusResponse");
                Function<Response, WithHeaders<CrossConnectStatus>> responseFn = RESPONSE_CONVERSION_FACTORY.create(CrossConnectStatus.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetCrossConnectStatusResponse.Builder builder = GetCrossConnectStatusResponse.builder();
                builder.crossConnectStatus((CrossConnectStatus)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetCrossConnectStatusResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

