/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.FastConnectProviderService;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceRequest;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFastConnectProviderServiceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetFastConnectProviderServiceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetFastConnectProviderServiceRequest interceptRequest(GetFastConnectProviderServiceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetFastConnectProviderServiceRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getProviderServiceId(), (String)"providerServiceId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("fastConnectProviderServices").path(HttpUtils.encodePathSegment(request.getProviderServiceId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetFastConnectProviderServiceResponse> fromResponse() {
        Function<Response, GetFastConnectProviderServiceResponse> transformer = new Function<Response, GetFastConnectProviderServiceResponse>(){

            public GetFastConnectProviderServiceResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetFastConnectProviderServiceResponse");
                Function<Response, WithHeaders<FastConnectProviderService>> responseFn = RESPONSE_CONVERSION_FACTORY.create(FastConnectProviderService.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetFastConnectProviderServiceResponse.Builder builder = GetFastConnectProviderServiceResponse.builder();
                builder.fastConnectProviderService((FastConnectProviderService)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetFastConnectProviderServiceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

