/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.FastConnectProviderServiceKey;
import com.oracle.bmc.core.requests.GetFastConnectProviderServiceKeyRequest;
import com.oracle.bmc.core.responses.GetFastConnectProviderServiceKeyResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFastConnectProviderServiceKeyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetFastConnectProviderServiceKeyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetFastConnectProviderServiceKeyRequest interceptRequest(GetFastConnectProviderServiceKeyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetFastConnectProviderServiceKeyRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getProviderServiceId(), (String)"providerServiceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getProviderServiceKeyName(), (String)"providerServiceKeyName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("fastConnectProviderServices").path(HttpUtils.encodePathSegment(request.getProviderServiceId())).path("providerServiceKeys").path(HttpUtils.encodePathSegment(request.getProviderServiceKeyName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetFastConnectProviderServiceKeyResponse> fromResponse() {
        Function<Response, GetFastConnectProviderServiceKeyResponse> transformer = new Function<Response, GetFastConnectProviderServiceKeyResponse>(){

            public GetFastConnectProviderServiceKeyResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetFastConnectProviderServiceKeyResponse");
                Function<Response, WithHeaders<FastConnectProviderServiceKey>> responseFn = RESPONSE_CONVERSION_FACTORY.create(FastConnectProviderServiceKey.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetFastConnectProviderServiceKeyResponse.Builder builder = GetFastConnectProviderServiceKeyResponse.builder();
                builder.fastConnectProviderServiceKey((FastConnectProviderServiceKey)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetFastConnectProviderServiceKeyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

