/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.InstanceConsoleConnection;
import com.oracle.bmc.core.requests.GetInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.responses.GetInstanceConsoleConnectionResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInstanceConsoleConnectionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetInstanceConsoleConnectionConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetInstanceConsoleConnectionRequest interceptRequest(GetInstanceConsoleConnectionRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetInstanceConsoleConnectionRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getInstanceConsoleConnectionId(), (String)"instanceConsoleConnectionId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("instanceConsoleConnections").path(HttpUtils.encodePathSegment(request.getInstanceConsoleConnectionId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetInstanceConsoleConnectionResponse> fromResponse() {
        Function<Response, GetInstanceConsoleConnectionResponse> transformer = new Function<Response, GetInstanceConsoleConnectionResponse>(){

            public GetInstanceConsoleConnectionResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetInstanceConsoleConnectionResponse");
                Function<Response, WithHeaders<InstanceConsoleConnection>> responseFn = RESPONSE_CONVERSION_FACTORY.create(InstanceConsoleConnection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetInstanceConsoleConnectionResponse.Builder builder = GetInstanceConsoleConnectionResponse.builder();
                builder.instanceConsoleConnection((InstanceConsoleConnection)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetInstanceConsoleConnectionResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

