/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.PublicIp;
import com.oracle.bmc.core.requests.GetPublicIpByPrivateIpIdRequest;
import com.oracle.bmc.core.responses.GetPublicIpByPrivateIpIdResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPublicIpByPrivateIpIdConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetPublicIpByPrivateIpIdConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetPublicIpByPrivateIpIdRequest interceptRequest(GetPublicIpByPrivateIpIdRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetPublicIpByPrivateIpIdRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getGetPublicIpByPrivateIpIdDetails(), (String)"getPublicIpByPrivateIpIdDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("publicIps").path("actions").path("getByPrivateIpId");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetPublicIpByPrivateIpIdResponse> fromResponse() {
        Function<Response, GetPublicIpByPrivateIpIdResponse> transformer = new Function<Response, GetPublicIpByPrivateIpIdResponse>(){

            public GetPublicIpByPrivateIpIdResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetPublicIpByPrivateIpIdResponse");
                Function<Response, WithHeaders<PublicIp>> responseFn = RESPONSE_CONVERSION_FACTORY.create(PublicIp.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetPublicIpByPrivateIpIdResponse.Builder builder = GetPublicIpByPrivateIpIdResponse.builder();
                builder.publicIp((PublicIp)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetPublicIpByPrivateIpIdResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

