/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.VolumeBackupPolicyAssignment;
import com.oracle.bmc.core.requests.GetVolumeBackupPolicyAssetAssignmentRequest;
import com.oracle.bmc.core.responses.GetVolumeBackupPolicyAssetAssignmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetVolumeBackupPolicyAssetAssignmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetVolumeBackupPolicyAssetAssignmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetVolumeBackupPolicyAssetAssignmentRequest interceptRequest(GetVolumeBackupPolicyAssetAssignmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetVolumeBackupPolicyAssetAssignmentRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getAssetId(), (String)"assetId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("volumeBackupPolicyAssignments");
        target = target.queryParam("assetId", HttpUtils.attemptEncodeQueryParam(request.getAssetId()));
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetVolumeBackupPolicyAssetAssignmentResponse> fromResponse() {
        Function<Response, GetVolumeBackupPolicyAssetAssignmentResponse> transformer = new Function<Response, GetVolumeBackupPolicyAssetAssignmentResponse>(){

            public GetVolumeBackupPolicyAssetAssignmentResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetVolumeBackupPolicyAssetAssignmentResponse");
                Function<Response, WithHeaders<List<VolumeBackupPolicyAssignment>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<VolumeBackupPolicyAssignment>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetVolumeBackupPolicyAssetAssignmentResponse.Builder builder = GetVolumeBackupPolicyAssetAssignmentResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetVolumeBackupPolicyAssetAssignmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

