/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.PeerRegionForRemotePeering;
import com.oracle.bmc.core.requests.ListAllowedPeerRegionsForRemotePeeringRequest;
import com.oracle.bmc.core.responses.ListAllowedPeerRegionsForRemotePeeringResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListAllowedPeerRegionsForRemotePeeringConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListAllowedPeerRegionsForRemotePeeringConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListAllowedPeerRegionsForRemotePeeringRequest interceptRequest(ListAllowedPeerRegionsForRemotePeeringRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListAllowedPeerRegionsForRemotePeeringRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("allowedPeerRegionsForRemotePeering");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListAllowedPeerRegionsForRemotePeeringResponse> fromResponse() {
        Function<Response, ListAllowedPeerRegionsForRemotePeeringResponse> transformer = new Function<Response, ListAllowedPeerRegionsForRemotePeeringResponse>(){

            public ListAllowedPeerRegionsForRemotePeeringResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ListAllowedPeerRegionsForRemotePeeringResponse");
                Function<Response, WithHeaders<List<PeerRegionForRemotePeering>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<PeerRegionForRemotePeering>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListAllowedPeerRegionsForRemotePeeringResponse.Builder builder = ListAllowedPeerRegionsForRemotePeeringResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListAllowedPeerRegionsForRemotePeeringResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

