/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.InstanceSummary;
import com.oracle.bmc.core.requests.ListInstancePoolInstancesRequest;
import com.oracle.bmc.core.responses.ListInstancePoolInstancesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListInstancePoolInstancesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListInstancePoolInstancesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListInstancePoolInstancesRequest interceptRequest(ListInstancePoolInstancesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListInstancePoolInstancesRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("instancePools").path(HttpUtils.encodePathSegment(request.getInstancePoolId())).path("instances");
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", HttpUtils.attemptEncodeQueryParam(request.getDisplayName()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListInstancePoolInstancesResponse> fromResponse() {
        Function<Response, ListInstancePoolInstancesResponse> transformer = new Function<Response, ListInstancePoolInstancesResponse>(){

            public ListInstancePoolInstancesResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ListInstancePoolInstancesResponse");
                Function<Response, WithHeaders<List<InstanceSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<InstanceSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListInstancePoolInstancesResponse.Builder builder = ListInstancePoolInstancesResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListInstancePoolInstancesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

