/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.VirtualCircuitPublicPrefix;
import com.oracle.bmc.core.requests.ListVirtualCircuitPublicPrefixesRequest;
import com.oracle.bmc.core.responses.ListVirtualCircuitPublicPrefixesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListVirtualCircuitPublicPrefixesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListVirtualCircuitPublicPrefixesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListVirtualCircuitPublicPrefixesRequest interceptRequest(ListVirtualCircuitPublicPrefixesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListVirtualCircuitPublicPrefixesRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVirtualCircuitId(), (String)"virtualCircuitId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("virtualCircuits").path(HttpUtils.encodePathSegment(request.getVirtualCircuitId())).path("publicPrefixes");
        if (request.getVerificationState() != null) {
            target = target.queryParam("verificationState", HttpUtils.attemptEncodeQueryParam(request.getVerificationState().getValue()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListVirtualCircuitPublicPrefixesResponse> fromResponse() {
        Function<Response, ListVirtualCircuitPublicPrefixesResponse> transformer = new Function<Response, ListVirtualCircuitPublicPrefixesResponse>(){

            public ListVirtualCircuitPublicPrefixesResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for ListVirtualCircuitPublicPrefixesResponse");
                Function<Response, WithHeaders<List<VirtualCircuitPublicPrefix>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<VirtualCircuitPublicPrefix>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListVirtualCircuitPublicPrefixesResponse.Builder builder = ListVirtualCircuitPublicPrefixesResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListVirtualCircuitPublicPrefixesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

