/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.VolumeAttachment;
import com.oracle.bmc.core.requests.ListVolumeAttachmentsRequest;
import com.oracle.bmc.core.responses.ListVolumeAttachmentsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListVolumeAttachmentsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListVolumeAttachmentsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListVolumeAttachmentsRequest interceptRequest(ListVolumeAttachmentsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListVolumeAttachmentsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("volumeAttachments");
        if (request.getAvailabilityDomain() != null) {
            target = target.queryParam("availabilityDomain", HttpUtils.attemptEncodeQueryParam(request.getAvailabilityDomain()));
        }
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getInstanceId() != null) {
            target = target.queryParam("instanceId", HttpUtils.attemptEncodeQueryParam(request.getInstanceId()));
        }
        if (request.getVolumeId() != null) {
            target = target.queryParam("volumeId", HttpUtils.attemptEncodeQueryParam(request.getVolumeId()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, ListVolumeAttachmentsResponse> fromResponse() {
        Function<Response, ListVolumeAttachmentsResponse> transformer = new Function<Response, ListVolumeAttachmentsResponse>(){

            public ListVolumeAttachmentsResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ListVolumeAttachmentsResponse");
                Function<Response, WithHeaders<List<VolumeAttachment>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<VolumeAttachment>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListVolumeAttachmentsResponse.Builder builder = ListVolumeAttachmentsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListVolumeAttachmentsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

