/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.IPSecConnectionTunnel;
import com.oracle.bmc.core.requests.UpdateIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.responses.UpdateIPSecConnectionTunnelResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateIPSecConnectionTunnelConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateIPSecConnectionTunnelConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateIPSecConnectionTunnelRequest interceptRequest(UpdateIPSecConnectionTunnelRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateIPSecConnectionTunnelRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getIpscId(), (String)"ipscId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTunnelId(), (String)"tunnelId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateIPSecConnectionTunnelDetails(), (String)"updateIPSecConnectionTunnelDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("ipsecConnections").path(HttpUtils.encodePathSegment(request.getIpscId())).path("tunnels").path(HttpUtils.encodePathSegment(request.getTunnelId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateIPSecConnectionTunnelResponse> fromResponse() {
        Function<Response, UpdateIPSecConnectionTunnelResponse> transformer = new Function<Response, UpdateIPSecConnectionTunnelResponse>(){

            public UpdateIPSecConnectionTunnelResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateIPSecConnectionTunnelResponse");
                Function<Response, WithHeaders<IPSecConnectionTunnel>> responseFn = RESPONSE_CONVERSION_FACTORY.create(IPSecConnectionTunnel.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateIPSecConnectionTunnelResponse.Builder builder = UpdateIPSecConnectionTunnelResponse.builder();
                builder.iPSecConnectionTunnel((IPSecConnectionTunnel)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                UpdateIPSecConnectionTunnelResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

