/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.SecurityList;
import com.oracle.bmc.core.requests.UpdateSecurityListRequest;
import com.oracle.bmc.core.responses.UpdateSecurityListResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSecurityListConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateSecurityListConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateSecurityListRequest interceptRequest(UpdateSecurityListRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateSecurityListRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSecurityListId(), (String)"securityListId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateSecurityListDetails(), (String)"updateSecurityListDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("securityLists").path(HttpUtils.encodePathSegment(request.getSecurityListId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateSecurityListResponse> fromResponse() {
        Function<Response, UpdateSecurityListResponse> transformer = new Function<Response, UpdateSecurityListResponse>(){

            public UpdateSecurityListResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateSecurityListResponse");
                Function<Response, WithHeaders<SecurityList>> responseFn = RESPONSE_CONVERSION_FACTORY.create(SecurityList.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateSecurityListResponse.Builder builder = UpdateSecurityListResponse.builder();
                builder.securityList((SecurityList)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                UpdateSecurityListResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

