/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.VolumeGroupBackup;
import com.oracle.bmc.core.requests.UpdateVolumeGroupBackupRequest;
import com.oracle.bmc.core.responses.UpdateVolumeGroupBackupResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateVolumeGroupBackupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateVolumeGroupBackupConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateVolumeGroupBackupRequest interceptRequest(UpdateVolumeGroupBackupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateVolumeGroupBackupRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVolumeGroupBackupId(), (String)"volumeGroupBackupId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateVolumeGroupBackupDetails(), (String)"updateVolumeGroupBackupDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("volumeGroupBackups").path(HttpUtils.encodePathSegment(request.getVolumeGroupBackupId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateVolumeGroupBackupResponse> fromResponse() {
        Function<Response, UpdateVolumeGroupBackupResponse> transformer = new Function<Response, UpdateVolumeGroupBackupResponse>(){

            public UpdateVolumeGroupBackupResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for UpdateVolumeGroupBackupResponse");
                Function<Response, WithHeaders<VolumeGroupBackup>> responseFn = RESPONSE_CONVERSION_FACTORY.create(VolumeGroupBackup.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateVolumeGroupBackupResponse.Builder builder = UpdateVolumeGroupBackupResponse.builder();
                builder.volumeGroupBackup((VolumeGroupBackup)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                UpdateVolumeGroupBackupResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

