/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.core.model.VolumeKmsKey;
import com.oracle.bmc.core.requests.UpdateVolumeKmsKeyRequest;
import com.oracle.bmc.core.responses.UpdateVolumeKmsKeyResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateVolumeKmsKeyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateVolumeKmsKeyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateVolumeKmsKeyRequest interceptRequest(UpdateVolumeKmsKeyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateVolumeKmsKeyRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVolumeId(), (String)"volumeId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateVolumeKmsKeyDetails(), (String)"updateVolumeKmsKeyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("volumes").path(HttpUtils.encodePathSegment(request.getVolumeId())).path("kmsKey");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateVolumeKmsKeyResponse> fromResponse() {
        Function<Response, UpdateVolumeKmsKeyResponse> transformer = new Function<Response, UpdateVolumeKmsKeyResponse>(){

            public UpdateVolumeKmsKeyResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateVolumeKmsKeyResponse");
                Function<Response, WithHeaders<VolumeKmsKey>> responseFn = RESPONSE_CONVERSION_FACTORY.create(VolumeKmsKey.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateVolumeKmsKeyResponse.Builder builder = UpdateVolumeKmsKeyResponse.builder();
                builder.volumeKmsKey((VolumeKmsKey)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                UpdateVolumeKmsKeyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

