/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CrossConnectStatus {
    @JsonProperty(value="crossConnectId")
    private final String crossConnectId;
    @JsonProperty(value="interfaceState")
    private final InterfaceState interfaceState;
    @JsonProperty(value="lightLevelIndBm")
    private final Float lightLevelIndBm;
    @JsonProperty(value="lightLevelIndicator")
    private final LightLevelIndicator lightLevelIndicator;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public InterfaceState getInterfaceState() {
        return this.interfaceState;
    }

    public Float getLightLevelIndBm() {
        return this.lightLevelIndBm;
    }

    public LightLevelIndicator getLightLevelIndicator() {
        return this.lightLevelIndicator;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrossConnectStatus)) {
            return false;
        }
        CrossConnectStatus other = (CrossConnectStatus)o;
        String this$crossConnectId = this.getCrossConnectId();
        String other$crossConnectId = other.getCrossConnectId();
        if (this$crossConnectId == null ? other$crossConnectId != null : !this$crossConnectId.equals(other$crossConnectId)) {
            return false;
        }
        InterfaceState this$interfaceState = this.getInterfaceState();
        InterfaceState other$interfaceState = other.getInterfaceState();
        if (this$interfaceState == null ? other$interfaceState != null : !((Object)((Object)this$interfaceState)).equals((Object)other$interfaceState)) {
            return false;
        }
        Float this$lightLevelIndBm = this.getLightLevelIndBm();
        Float other$lightLevelIndBm = other.getLightLevelIndBm();
        if (this$lightLevelIndBm == null ? other$lightLevelIndBm != null : !((Object)this$lightLevelIndBm).equals(other$lightLevelIndBm)) {
            return false;
        }
        LightLevelIndicator this$lightLevelIndicator = this.getLightLevelIndicator();
        LightLevelIndicator other$lightLevelIndicator = other.getLightLevelIndicator();
        if (this$lightLevelIndicator == null ? other$lightLevelIndicator != null : !((Object)((Object)this$lightLevelIndicator)).equals((Object)other$lightLevelIndicator)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $crossConnectId = this.getCrossConnectId();
        result = result * 59 + ($crossConnectId == null ? 43 : $crossConnectId.hashCode());
        InterfaceState $interfaceState = this.getInterfaceState();
        result = result * 59 + ($interfaceState == null ? 43 : ((Object)((Object)$interfaceState)).hashCode());
        Float $lightLevelIndBm = this.getLightLevelIndBm();
        result = result * 59 + ($lightLevelIndBm == null ? 43 : ((Object)$lightLevelIndBm).hashCode());
        LightLevelIndicator $lightLevelIndicator = this.getLightLevelIndicator();
        result = result * 59 + ($lightLevelIndicator == null ? 43 : ((Object)((Object)$lightLevelIndicator)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "CrossConnectStatus(crossConnectId=" + this.getCrossConnectId() + ", interfaceState=" + (Object)((Object)this.getInterfaceState()) + ", lightLevelIndBm=" + this.getLightLevelIndBm() + ", lightLevelIndicator=" + (Object)((Object)this.getLightLevelIndicator()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"crossConnectId", "interfaceState", "lightLevelIndBm", "lightLevelIndicator"})
    @Deprecated
    public CrossConnectStatus(String crossConnectId, InterfaceState interfaceState, Float lightLevelIndBm, LightLevelIndicator lightLevelIndicator) {
        this.crossConnectId = crossConnectId;
        this.interfaceState = interfaceState;
        this.lightLevelIndBm = lightLevelIndBm;
        this.lightLevelIndicator = lightLevelIndicator;
    }

    public static enum LightLevelIndicator {
        NoLight("NO_LIGHT"),
        LowWarn("LOW_WARN"),
        HighWarn("HIGH_WARN"),
        Bad("BAD"),
        Good("GOOD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LightLevelIndicator> map;

        private LightLevelIndicator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LightLevelIndicator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LightLevelIndicator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LightLevelIndicator.class);
            map = new HashMap<String, LightLevelIndicator>();
            for (LightLevelIndicator v : LightLevelIndicator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum InterfaceState {
        Up("UP"),
        Down("DOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InterfaceState> map;

        private InterfaceState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InterfaceState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InterfaceState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InterfaceState.class);
            map = new HashMap<String, InterfaceState>();
            for (InterfaceState v : InterfaceState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="crossConnectId")
        private String crossConnectId;
        @JsonProperty(value="interfaceState")
        private InterfaceState interfaceState;
        @JsonProperty(value="lightLevelIndBm")
        private Float lightLevelIndBm;
        @JsonProperty(value="lightLevelIndicator")
        private LightLevelIndicator lightLevelIndicator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            this.__explicitlySet__.add("crossConnectId");
            return this;
        }

        public Builder interfaceState(InterfaceState interfaceState) {
            this.interfaceState = interfaceState;
            this.__explicitlySet__.add("interfaceState");
            return this;
        }

        public Builder lightLevelIndBm(Float lightLevelIndBm) {
            this.lightLevelIndBm = lightLevelIndBm;
            this.__explicitlySet__.add("lightLevelIndBm");
            return this;
        }

        public Builder lightLevelIndicator(LightLevelIndicator lightLevelIndicator) {
            this.lightLevelIndicator = lightLevelIndicator;
            this.__explicitlySet__.add("lightLevelIndicator");
            return this;
        }

        public CrossConnectStatus build() {
            CrossConnectStatus __instance__ = new CrossConnectStatus(this.crossConnectId, this.interfaceState, this.lightLevelIndBm, this.lightLevelIndicator);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CrossConnectStatus o) {
            Builder copiedBuilder = this.crossConnectId(o.getCrossConnectId()).interfaceState(o.getInterfaceState()).lightLevelIndBm(o.getLightLevelIndBm()).lightLevelIndicator(o.getLightLevelIndicator());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

