/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.DhcpOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class DhcpDnsOption
extends DhcpOption {
    @JsonProperty(value="customDnsServers")
    private final List<String> customDnsServers;
    @JsonProperty(value="serverType")
    private final ServerType serverType;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public DhcpDnsOption(List<String> customDnsServers, ServerType serverType) {
        this.customDnsServers = customDnsServers;
        this.serverType = serverType;
    }

    public List<String> getCustomDnsServers() {
        return this.customDnsServers;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "DhcpDnsOption(super=" + super.toString() + ", customDnsServers=" + this.getCustomDnsServers() + ", serverType=" + (Object)((Object)this.getServerType()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DhcpDnsOption)) {
            return false;
        }
        DhcpDnsOption other = (DhcpDnsOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$customDnsServers = this.getCustomDnsServers();
        List<String> other$customDnsServers = other.getCustomDnsServers();
        if (this$customDnsServers == null ? other$customDnsServers != null : !((Object)this$customDnsServers).equals(other$customDnsServers)) {
            return false;
        }
        ServerType this$serverType = this.getServerType();
        ServerType other$serverType = other.getServerType();
        if (this$serverType == null ? other$serverType != null : !((Object)((Object)this$serverType)).equals((Object)other$serverType)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DhcpDnsOption;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $customDnsServers = this.getCustomDnsServers();
        result = result * 59 + ($customDnsServers == null ? 43 : ((Object)$customDnsServers).hashCode());
        ServerType $serverType = this.getServerType();
        result = result * 59 + ($serverType == null ? 43 : ((Object)((Object)$serverType)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum ServerType {
        VcnLocal("VcnLocal"),
        VcnLocalPlusInternet("VcnLocalPlusInternet"),
        CustomDnsServer("CustomDnsServer"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ServerType> map;

        private ServerType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServerType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ServerType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ServerType.class);
            map = new HashMap<String, ServerType>();
            for (ServerType v : ServerType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="customDnsServers")
        private List<String> customDnsServers;
        @JsonProperty(value="serverType")
        private ServerType serverType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder customDnsServers(List<String> customDnsServers) {
            this.customDnsServers = customDnsServers;
            this.__explicitlySet__.add("customDnsServers");
            return this;
        }

        public Builder serverType(ServerType serverType) {
            this.serverType = serverType;
            this.__explicitlySet__.add("serverType");
            return this;
        }

        public DhcpDnsOption build() {
            DhcpDnsOption __instance__ = new DhcpDnsOption(this.customDnsServers, this.serverType);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(DhcpDnsOption o) {
            Builder copiedBuilder = this.customDnsServers(o.getCustomDnsServers()).serverType(o.getServerType());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

