/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.IcmpOptions;
import com.oracle.bmc.core.model.TcpOptions;
import com.oracle.bmc.core.model.UdpOptions;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EgressSecurityRule {
    @JsonProperty(value="destination")
    private final String destination;
    @JsonProperty(value="destinationType")
    private final DestinationType destinationType;
    @JsonProperty(value="icmpOptions")
    private final IcmpOptions icmpOptions;
    @JsonProperty(value="isStateless")
    private final Boolean isStateless;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="tcpOptions")
    private final TcpOptions tcpOptions;
    @JsonProperty(value="udpOptions")
    private final UdpOptions udpOptions;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getDestination() {
        return this.destination;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public IcmpOptions getIcmpOptions() {
        return this.icmpOptions;
    }

    public Boolean getIsStateless() {
        return this.isStateless;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public TcpOptions getTcpOptions() {
        return this.tcpOptions;
    }

    public UdpOptions getUdpOptions() {
        return this.udpOptions;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EgressSecurityRule)) {
            return false;
        }
        EgressSecurityRule other = (EgressSecurityRule)o;
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        DestinationType this$destinationType = this.getDestinationType();
        DestinationType other$destinationType = other.getDestinationType();
        if (this$destinationType == null ? other$destinationType != null : !((Object)((Object)this$destinationType)).equals((Object)other$destinationType)) {
            return false;
        }
        IcmpOptions this$icmpOptions = this.getIcmpOptions();
        IcmpOptions other$icmpOptions = other.getIcmpOptions();
        if (this$icmpOptions == null ? other$icmpOptions != null : !((Object)this$icmpOptions).equals(other$icmpOptions)) {
            return false;
        }
        Boolean this$isStateless = this.getIsStateless();
        Boolean other$isStateless = other.getIsStateless();
        if (this$isStateless == null ? other$isStateless != null : !((Object)this$isStateless).equals(other$isStateless)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        TcpOptions this$tcpOptions = this.getTcpOptions();
        TcpOptions other$tcpOptions = other.getTcpOptions();
        if (this$tcpOptions == null ? other$tcpOptions != null : !((Object)this$tcpOptions).equals(other$tcpOptions)) {
            return false;
        }
        UdpOptions this$udpOptions = this.getUdpOptions();
        UdpOptions other$udpOptions = other.getUdpOptions();
        if (this$udpOptions == null ? other$udpOptions != null : !((Object)this$udpOptions).equals(other$udpOptions)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        DestinationType $destinationType = this.getDestinationType();
        result = result * 59 + ($destinationType == null ? 43 : ((Object)((Object)$destinationType)).hashCode());
        IcmpOptions $icmpOptions = this.getIcmpOptions();
        result = result * 59 + ($icmpOptions == null ? 43 : ((Object)$icmpOptions).hashCode());
        Boolean $isStateless = this.getIsStateless();
        result = result * 59 + ($isStateless == null ? 43 : ((Object)$isStateless).hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        TcpOptions $tcpOptions = this.getTcpOptions();
        result = result * 59 + ($tcpOptions == null ? 43 : ((Object)$tcpOptions).hashCode());
        UdpOptions $udpOptions = this.getUdpOptions();
        result = result * 59 + ($udpOptions == null ? 43 : ((Object)$udpOptions).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "EgressSecurityRule(destination=" + this.getDestination() + ", destinationType=" + (Object)((Object)this.getDestinationType()) + ", icmpOptions=" + this.getIcmpOptions() + ", isStateless=" + this.getIsStateless() + ", protocol=" + this.getProtocol() + ", tcpOptions=" + this.getTcpOptions() + ", udpOptions=" + this.getUdpOptions() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"destination", "destinationType", "icmpOptions", "isStateless", "protocol", "tcpOptions", "udpOptions"})
    @Deprecated
    public EgressSecurityRule(String destination, DestinationType destinationType, IcmpOptions icmpOptions, Boolean isStateless, String protocol, TcpOptions tcpOptions, UdpOptions udpOptions) {
        this.destination = destination;
        this.destinationType = destinationType;
        this.icmpOptions = icmpOptions;
        this.isStateless = isStateless;
        this.protocol = protocol;
        this.tcpOptions = tcpOptions;
        this.udpOptions = udpOptions;
    }

    public static enum DestinationType {
        CidrBlock("CIDR_BLOCK"),
        ServiceCidrBlock("SERVICE_CIDR_BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DestinationType> map;

        private DestinationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DestinationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DestinationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DestinationType.class);
            map = new HashMap<String, DestinationType>();
            for (DestinationType v : DestinationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="destination")
        private String destination;
        @JsonProperty(value="destinationType")
        private DestinationType destinationType;
        @JsonProperty(value="icmpOptions")
        private IcmpOptions icmpOptions;
        @JsonProperty(value="isStateless")
        private Boolean isStateless;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="tcpOptions")
        private TcpOptions tcpOptions;
        @JsonProperty(value="udpOptions")
        private UdpOptions udpOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder destination(String destination) {
            this.destination = destination;
            this.__explicitlySet__.add("destination");
            return this;
        }

        public Builder destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            this.__explicitlySet__.add("destinationType");
            return this;
        }

        public Builder icmpOptions(IcmpOptions icmpOptions) {
            this.icmpOptions = icmpOptions;
            this.__explicitlySet__.add("icmpOptions");
            return this;
        }

        public Builder isStateless(Boolean isStateless) {
            this.isStateless = isStateless;
            this.__explicitlySet__.add("isStateless");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder tcpOptions(TcpOptions tcpOptions) {
            this.tcpOptions = tcpOptions;
            this.__explicitlySet__.add("tcpOptions");
            return this;
        }

        public Builder udpOptions(UdpOptions udpOptions) {
            this.udpOptions = udpOptions;
            this.__explicitlySet__.add("udpOptions");
            return this;
        }

        public EgressSecurityRule build() {
            EgressSecurityRule __instance__ = new EgressSecurityRule(this.destination, this.destinationType, this.icmpOptions, this.isStateless, this.protocol, this.tcpOptions, this.udpOptions);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(EgressSecurityRule o) {
            Builder copiedBuilder = this.destination(o.getDestination()).destinationType(o.getDestinationType()).icmpOptions(o.getIcmpOptions()).isStateless(o.getIsStateless()).protocol(o.getProtocol()).tcpOptions(o.getTcpOptions()).udpOptions(o.getUdpOptions());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

