/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.core.model.ImageSourceViaObjectStorageTupleDetails;
import com.oracle.bmc.core.model.ImageSourceViaObjectStorageUriDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType", defaultImpl=ImageSourceDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ImageSourceViaObjectStorageTupleDetails.class, name="objectStorageTuple"), @JsonSubTypes.Type(value=ImageSourceViaObjectStorageUriDetails.class, name="objectStorageUri")})
@JsonFilter(value="explicitlySetFilter")
public class ImageSourceDetails {
    @JsonProperty(value="operatingSystem")
    private final String operatingSystem;
    @JsonProperty(value="operatingSystemVersion")
    private final String operatingSystemVersion;
    @JsonProperty(value="sourceImageType")
    private final SourceImageType sourceImageType;

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public SourceImageType getSourceImageType() {
        return this.sourceImageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageSourceDetails)) {
            return false;
        }
        ImageSourceDetails other = (ImageSourceDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$operatingSystem = this.getOperatingSystem();
        String other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !this$operatingSystem.equals(other$operatingSystem)) {
            return false;
        }
        String this$operatingSystemVersion = this.getOperatingSystemVersion();
        String other$operatingSystemVersion = other.getOperatingSystemVersion();
        if (this$operatingSystemVersion == null ? other$operatingSystemVersion != null : !this$operatingSystemVersion.equals(other$operatingSystemVersion)) {
            return false;
        }
        SourceImageType this$sourceImageType = this.getSourceImageType();
        SourceImageType other$sourceImageType = other.getSourceImageType();
        return !(this$sourceImageType == null ? other$sourceImageType != null : !((Object)((Object)this$sourceImageType)).equals((Object)other$sourceImageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageSourceDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : $operatingSystem.hashCode());
        String $operatingSystemVersion = this.getOperatingSystemVersion();
        result = result * 59 + ($operatingSystemVersion == null ? 43 : $operatingSystemVersion.hashCode());
        SourceImageType $sourceImageType = this.getSourceImageType();
        result = result * 59 + ($sourceImageType == null ? 43 : ((Object)((Object)$sourceImageType)).hashCode());
        return result;
    }

    public String toString() {
        return "ImageSourceDetails(operatingSystem=" + this.getOperatingSystem() + ", operatingSystemVersion=" + this.getOperatingSystemVersion() + ", sourceImageType=" + (Object)((Object)this.getSourceImageType()) + ")";
    }

    @ConstructorProperties(value={"operatingSystem", "operatingSystemVersion", "sourceImageType"})
    @Deprecated
    protected ImageSourceDetails(String operatingSystem, String operatingSystemVersion, SourceImageType sourceImageType) {
        this.operatingSystem = operatingSystem;
        this.operatingSystemVersion = operatingSystemVersion;
        this.sourceImageType = sourceImageType;
    }

    public static enum SourceImageType {
        Qcow2("QCOW2"),
        Vmdk("VMDK");

        private final String value;
        private static Map<String, SourceImageType> map;

        private SourceImageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceImageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SourceImageType: " + key);
        }

        static {
            map = new HashMap<String, SourceImageType>();
            for (SourceImageType v : SourceImageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

