/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.IcmpOptions;
import com.oracle.bmc.core.model.TcpOptions;
import com.oracle.bmc.core.model.UdpOptions;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IngressSecurityRule {
    @JsonProperty(value="icmpOptions")
    private final IcmpOptions icmpOptions;
    @JsonProperty(value="isStateless")
    private final Boolean isStateless;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="sourceType")
    private final SourceType sourceType;
    @JsonProperty(value="tcpOptions")
    private final TcpOptions tcpOptions;
    @JsonProperty(value="udpOptions")
    private final UdpOptions udpOptions;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public IcmpOptions getIcmpOptions() {
        return this.icmpOptions;
    }

    public Boolean getIsStateless() {
        return this.isStateless;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSource() {
        return this.source;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public TcpOptions getTcpOptions() {
        return this.tcpOptions;
    }

    public UdpOptions getUdpOptions() {
        return this.udpOptions;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IngressSecurityRule)) {
            return false;
        }
        IngressSecurityRule other = (IngressSecurityRule)o;
        IcmpOptions this$icmpOptions = this.getIcmpOptions();
        IcmpOptions other$icmpOptions = other.getIcmpOptions();
        if (this$icmpOptions == null ? other$icmpOptions != null : !((Object)this$icmpOptions).equals(other$icmpOptions)) {
            return false;
        }
        Boolean this$isStateless = this.getIsStateless();
        Boolean other$isStateless = other.getIsStateless();
        if (this$isStateless == null ? other$isStateless != null : !((Object)this$isStateless).equals(other$isStateless)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        SourceType this$sourceType = this.getSourceType();
        SourceType other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !((Object)((Object)this$sourceType)).equals((Object)other$sourceType)) {
            return false;
        }
        TcpOptions this$tcpOptions = this.getTcpOptions();
        TcpOptions other$tcpOptions = other.getTcpOptions();
        if (this$tcpOptions == null ? other$tcpOptions != null : !((Object)this$tcpOptions).equals(other$tcpOptions)) {
            return false;
        }
        UdpOptions this$udpOptions = this.getUdpOptions();
        UdpOptions other$udpOptions = other.getUdpOptions();
        if (this$udpOptions == null ? other$udpOptions != null : !((Object)this$udpOptions).equals(other$udpOptions)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IcmpOptions $icmpOptions = this.getIcmpOptions();
        result = result * 59 + ($icmpOptions == null ? 43 : ((Object)$icmpOptions).hashCode());
        Boolean $isStateless = this.getIsStateless();
        result = result * 59 + ($isStateless == null ? 43 : ((Object)$isStateless).hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        SourceType $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : ((Object)((Object)$sourceType)).hashCode());
        TcpOptions $tcpOptions = this.getTcpOptions();
        result = result * 59 + ($tcpOptions == null ? 43 : ((Object)$tcpOptions).hashCode());
        UdpOptions $udpOptions = this.getUdpOptions();
        result = result * 59 + ($udpOptions == null ? 43 : ((Object)$udpOptions).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "IngressSecurityRule(icmpOptions=" + this.getIcmpOptions() + ", isStateless=" + this.getIsStateless() + ", protocol=" + this.getProtocol() + ", source=" + this.getSource() + ", sourceType=" + (Object)((Object)this.getSourceType()) + ", tcpOptions=" + this.getTcpOptions() + ", udpOptions=" + this.getUdpOptions() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"icmpOptions", "isStateless", "protocol", "source", "sourceType", "tcpOptions", "udpOptions"})
    @Deprecated
    public IngressSecurityRule(IcmpOptions icmpOptions, Boolean isStateless, String protocol, String source, SourceType sourceType, TcpOptions tcpOptions, UdpOptions udpOptions) {
        this.icmpOptions = icmpOptions;
        this.isStateless = isStateless;
        this.protocol = protocol;
        this.source = source;
        this.sourceType = sourceType;
        this.tcpOptions = tcpOptions;
        this.udpOptions = udpOptions;
    }

    public static enum SourceType {
        CidrBlock("CIDR_BLOCK"),
        ServiceCidrBlock("SERVICE_CIDR_BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SourceType> map;

        private SourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SourceType.class);
            map = new HashMap<String, SourceType>();
            for (SourceType v : SourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="icmpOptions")
        private IcmpOptions icmpOptions;
        @JsonProperty(value="isStateless")
        private Boolean isStateless;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="sourceType")
        private SourceType sourceType;
        @JsonProperty(value="tcpOptions")
        private TcpOptions tcpOptions;
        @JsonProperty(value="udpOptions")
        private UdpOptions udpOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder icmpOptions(IcmpOptions icmpOptions) {
            this.icmpOptions = icmpOptions;
            this.__explicitlySet__.add("icmpOptions");
            return this;
        }

        public Builder isStateless(Boolean isStateless) {
            this.isStateless = isStateless;
            this.__explicitlySet__.add("isStateless");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            this.__explicitlySet__.add("sourceType");
            return this;
        }

        public Builder tcpOptions(TcpOptions tcpOptions) {
            this.tcpOptions = tcpOptions;
            this.__explicitlySet__.add("tcpOptions");
            return this;
        }

        public Builder udpOptions(UdpOptions udpOptions) {
            this.udpOptions = udpOptions;
            this.__explicitlySet__.add("udpOptions");
            return this;
        }

        public IngressSecurityRule build() {
            IngressSecurityRule __instance__ = new IngressSecurityRule(this.icmpOptions, this.isStateless, this.protocol, this.source, this.sourceType, this.tcpOptions, this.udpOptions);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(IngressSecurityRule o) {
            Builder copiedBuilder = this.icmpOptions(o.getIcmpOptions()).isStateless(o.getIsStateless()).protocol(o.getProtocol()).source(o.getSource()).sourceType(o.getSourceType()).tcpOptions(o.getTcpOptions()).udpOptions(o.getUdpOptions());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

