/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.AttachLoadBalancerDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AttachLoadBalancerRequest
extends BmcRequest {
    private String instancePoolId;
    private AttachLoadBalancerDetails attachLoadBalancerDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"instancePoolId", "attachLoadBalancerDetails", "opcRetryToken", "ifMatch"})
    AttachLoadBalancerRequest(String instancePoolId, AttachLoadBalancerDetails attachLoadBalancerDetails, String opcRetryToken, String ifMatch) {
        this.instancePoolId = instancePoolId;
        this.attachLoadBalancerDetails = attachLoadBalancerDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public AttachLoadBalancerDetails getAttachLoadBalancerDetails() {
        return this.attachLoadBalancerDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instancePoolId;
        private AttachLoadBalancerDetails attachLoadBalancerDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachLoadBalancerRequest o) {
            this.instancePoolId(o.getInstancePoolId());
            this.attachLoadBalancerDetails(o.getAttachLoadBalancerDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachLoadBalancerRequest build() {
            AttachLoadBalancerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder attachLoadBalancerDetails(AttachLoadBalancerDetails attachLoadBalancerDetails) {
            this.attachLoadBalancerDetails = attachLoadBalancerDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public AttachLoadBalancerRequest buildWithoutInvocationCallback() {
            return new AttachLoadBalancerRequest(this.instancePoolId, this.attachLoadBalancerDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "AttachLoadBalancerRequest.Builder(instancePoolId=" + this.instancePoolId + ", attachLoadBalancerDetails=" + this.attachLoadBalancerDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

