/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.ServiceIdRequestDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AttachServiceIdRequest
extends BmcRequest {
    private String serviceGatewayId;
    private ServiceIdRequestDetails attachServiceDetails;
    private String ifMatch;

    @ConstructorProperties(value={"serviceGatewayId", "attachServiceDetails", "ifMatch"})
    AttachServiceIdRequest(String serviceGatewayId, ServiceIdRequestDetails attachServiceDetails, String ifMatch) {
        this.serviceGatewayId = serviceGatewayId;
        this.attachServiceDetails = attachServiceDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceGatewayId() {
        return this.serviceGatewayId;
    }

    public ServiceIdRequestDetails getAttachServiceDetails() {
        return this.attachServiceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String serviceGatewayId;
        private ServiceIdRequestDetails attachServiceDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachServiceIdRequest o) {
            this.serviceGatewayId(o.getServiceGatewayId());
            this.attachServiceDetails(o.getAttachServiceDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachServiceIdRequest build() {
            AttachServiceIdRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceGatewayId(String serviceGatewayId) {
            this.serviceGatewayId = serviceGatewayId;
            return this;
        }

        public Builder attachServiceDetails(ServiceIdRequestDetails attachServiceDetails) {
            this.attachServiceDetails = attachServiceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public AttachServiceIdRequest buildWithoutInvocationCallback() {
            return new AttachServiceIdRequest(this.serviceGatewayId, this.attachServiceDetails, this.ifMatch);
        }

        public String toString() {
            return "AttachServiceIdRequest.Builder(serviceGatewayId=" + this.serviceGatewayId + ", attachServiceDetails=" + this.attachServiceDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

