/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.AttachVnicDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AttachVnicRequest
extends BmcRequest {
    private AttachVnicDetails attachVnicDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"attachVnicDetails", "opcRetryToken"})
    AttachVnicRequest(AttachVnicDetails attachVnicDetails, String opcRetryToken) {
        this.attachVnicDetails = attachVnicDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AttachVnicDetails getAttachVnicDetails() {
        return this.attachVnicDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private AttachVnicDetails attachVnicDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachVnicRequest o) {
            this.attachVnicDetails(o.getAttachVnicDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachVnicRequest build() {
            AttachVnicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder attachVnicDetails(AttachVnicDetails attachVnicDetails) {
            this.attachVnicDetails = attachVnicDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public AttachVnicRequest buildWithoutInvocationCallback() {
            return new AttachVnicRequest(this.attachVnicDetails, this.opcRetryToken);
        }

        public String toString() {
            return "AttachVnicRequest.Builder(attachVnicDetails=" + this.attachVnicDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

