/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.AttachVolumeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AttachVolumeRequest
extends BmcRequest {
    private AttachVolumeDetails attachVolumeDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"attachVolumeDetails", "opcRetryToken"})
    AttachVolumeRequest(AttachVolumeDetails attachVolumeDetails, String opcRetryToken) {
        this.attachVolumeDetails = attachVolumeDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AttachVolumeDetails getAttachVolumeDetails() {
        return this.attachVolumeDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private AttachVolumeDetails attachVolumeDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachVolumeRequest o) {
            this.attachVolumeDetails(o.getAttachVolumeDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachVolumeRequest build() {
            AttachVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder attachVolumeDetails(AttachVolumeDetails attachVolumeDetails) {
            this.attachVolumeDetails = attachVolumeDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public AttachVolumeRequest buildWithoutInvocationCallback() {
            return new AttachVolumeRequest(this.attachVolumeDetails, this.opcRetryToken);
        }

        public String toString() {
            return "AttachVolumeRequest.Builder(attachVolumeDetails=" + this.attachVolumeDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

