/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.CaptureConsoleHistoryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CaptureConsoleHistoryRequest
extends BmcRequest {
    private CaptureConsoleHistoryDetails captureConsoleHistoryDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"captureConsoleHistoryDetails", "opcRetryToken"})
    CaptureConsoleHistoryRequest(CaptureConsoleHistoryDetails captureConsoleHistoryDetails, String opcRetryToken) {
        this.captureConsoleHistoryDetails = captureConsoleHistoryDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CaptureConsoleHistoryDetails getCaptureConsoleHistoryDetails() {
        return this.captureConsoleHistoryDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CaptureConsoleHistoryDetails captureConsoleHistoryDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CaptureConsoleHistoryRequest o) {
            this.captureConsoleHistoryDetails(o.getCaptureConsoleHistoryDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CaptureConsoleHistoryRequest build() {
            CaptureConsoleHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder captureConsoleHistoryDetails(CaptureConsoleHistoryDetails captureConsoleHistoryDetails) {
            this.captureConsoleHistoryDetails = captureConsoleHistoryDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CaptureConsoleHistoryRequest buildWithoutInvocationCallback() {
            return new CaptureConsoleHistoryRequest(this.captureConsoleHistoryDetails, this.opcRetryToken);
        }

        public String toString() {
            return "CaptureConsoleHistoryRequest.Builder(captureConsoleHistoryDetails=" + this.captureConsoleHistoryDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

